/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import common.Log;
import common.PassParams;
import common.Spacecraft;
import decoder.Decoder;
import decoder.SourceIQ;
import gui.MainWindow;
import gui.SourceTab;
import measure.PassMeasurement;
import measure.SatPc32DDE;
import predict.PositionCalcException;
import uk.me.g4dpz.satellite.SatPos;

public class PassManager
implements Runnable {
    SourceTab inputTab;
    boolean running = true;
    boolean done = false;
    PassMeasurement passMeasurement;
    PassParams pp1 = new PassParams();
    PassParams pp2 = new PassParams();
    public static final int INIT = 0;
    public static final int SCAN = 1;
    public static final int ANALYZE = 2;
    public static final int START_PASS = 3;
    public static final int DECODE = 4;
    public static final int FADED = 5;
    public static final int END_PASS = 6;
    public static final int EXIT = 7;
    static final String[] stateName = new String[]{"Scanning", "Scanning", "Analyze", "Scanning", "Decode", "Faded", "Scanning", "Scanning"};
    int lastReset;
    long lastUptime;
    final int SCAN_PERIOD = 250;
    final int ANALYZE_PERIOD = 450;
    final int SNR_PERIOD = 1800;
    final int DECODE_PERIOD = 2000;
    final int FADE_PERIOD = 125000;
    final int PSK_FADE_PERIOD = 2000;
    private int state = 0;
    private boolean newPass = false;
    private boolean faded = false;
    private boolean pendingTCA = false;
    static final int MIN_FREQ_READINGS_FOR_TCA = 10;
    boolean satPC32Connected = false;

    public void setDecoder1(Decoder d, SourceIQ iq, SourceTab in) {
        this.pp1.foxDecoder = d;
        this.pp1.iqSource = iq;
        this.inputTab = in;
    }

    public void setDecoder2(Decoder d, SourceIQ iq, SourceTab in) {
        this.pp2.foxDecoder = d;
        this.pp2.iqSource = iq;
        this.inputTab = in;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isNewPass() {
        return this.newPass;
    }

    public boolean isFaded() {
        return this.faded;
    }

    public boolean hasTCA() {
        return this.pendingTCA;
    }

    public void sentTCA() {
        this.pendingTCA = false;
    }

    public PassMeasurement getPassMeasurement() {
        return this.passMeasurement;
    }

    public String getStateName() {
        return stateName[this.state];
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public boolean inPass() {
        if (this.state == 4) {
            return true;
        }
        return this.state == 5;
    }

    public void setStartResetUptime(int id, int reset, long uptime) {
        this.passMeasurement.setStartResetUptime(reset, uptime);
        this.newPass = false;
    }

    public void incCrcFailure() {
        if (this.passMeasurement != null) {
            long crc = this.passMeasurement.getRawValue("CRC_FAILURES");
            this.passMeasurement.setRawValue("CRC_FAILURES", crc + 1L);
        }
    }

    public void setLastResetUptime(int id, int reset, long uptime) {
        this.lastReset = reset;
        this.lastUptime = uptime;
    }

    private void stateMachine(Spacecraft spacecraft) {
        this.state = 0;
        while (this.state != 7) {
            this.nextState(spacecraft);
        }
    }

    private void nextState(Spacecraft spacecraft) {
        int nextState = this.state;
        int currentState = this.state;
        switch (this.state) {
            case 0: {
                nextState = this.init(spacecraft);
                break;
            }
            case 1: {
                nextState = this.scan(spacecraft);
                break;
            }
            case 2: {
                nextState = this.analyzeSNR(spacecraft);
                break;
            }
            case 3: {
                nextState = this.startPass(spacecraft);
                break;
            }
            case 4: {
                nextState = this.decode(spacecraft);
                break;
            }
            case 5: {
                nextState = this.faded(spacecraft);
                break;
            }
            case 6: {
                nextState = this.endPass(spacecraft);
                break;
            }
            case 7: {
                nextState = this.exit(spacecraft);
                break;
            }
        }
        if (this.state == currentState) {
            this.state = nextState;
        }
    }

    private void setFreqRangeBins(Spacecraft spacecraft, PassParams pp) {
        if (pp.foxDecoder != null && pp.iqSource != null) {
            Config.toBin = pp.iqSource.getBinFromFreqHz((long)(spacecraft.user_maxFreqBoundkHz * 1000.0));
            Config.fromBin = pp.iqSource.getBinFromFreqHz((long)(spacecraft.user_minFreqBoundkHz * 1000.0));
        }
    }

    private void initParams(PassParams pp) {
        if (pp.foxDecoder != null && pp.iqSource != null) {
            if (Config.debugSignalFinder) {
                Log.println("Initialized Pass Params for: " + pp.foxDecoder.name);
            }
            pp.rfData = pp.iqSource.getRfData();
            if (pp.rfData != null) {
                pp.rfData.reset();
            }
            pp.resetEyeData();
        }
    }

    private int init(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.foxId) + " Entering INIT state");
        }
        this.faded = false;
        if (this.pp1.foxDecoder != null) {
            this.setFreqRangeBins(spacecraft, this.pp1);
            this.initParams(this.pp1);
            if (this.pp2.foxDecoder != null) {
                this.initParams(this.pp2);
            }
            return 1;
        }
        return 7;
    }

    private int scan(Spacecraft sat) {
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(sat.foxId) + " Entering SCAN state");
        }
        if (this.pp1.iqSource != null) {
            if (Config.debugSignalFinder) {
                Log.println("Scanning..");
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.pp1.rfData != null) {
                int n;
                boolean spansDcSpike = false;
                if (Config.toBin < Config.fromBin) {
                    spansDcSpike = true;
                }
                if (Config.fromBin < (n = this.pp1.rfData.getBinOfStrongestSignalInSatBand()) && n < Config.toBin || spansDcSpike && Config.fromBin < n && n < SourceIQ.FFT_SAMPLES - 2 || spansDcSpike && n >= 0 && n < Config.toBin) {
                    if (Config.debugSignalFinder) {
                        Log.println(String.valueOf(sat.getIdString()) + " STRONG SIG:" + this.pp1.rfData.rfStrongestSigSNRInSatBand);
                    }
                    if (this.pp1.rfData != null && this.pp1.rfData.rfStrongestSigSNRInSatBand > Config.SCAN_SIGNAL_THRESHOLD) {
                        return 2;
                    }
                }
            }
        }
        return 7;
    }

    private int analyzeSNR(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.foxId) + " Entering ANALYZE state");
        }
        MainWindow.inputTab.fftPanel.setFox(spacecraft);
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.foxId) + " Setting Bin to: " + this.pp1.rfData.getBinOfStrongestSignalInSatBand());
        }
        if (this.pp1.rfData != null) {
            int bin = this.pp1.rfData.getBinOfStrongestSignalInSatBand();
            if (this.pp1.iqSource != null) {
                this.pp1.iqSource.setSelectedBin(bin);
            }
            if (this.pp2 != null && this.pp2.iqSource != null) {
                this.pp2.iqSource.setSelectedBin(bin);
            }
            this.pp1.rfData.reset();
        }
        if (this.pp1.rfData != null) {
            try {
                Thread.sleep(450L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.foundRfSignal(spacecraft, this.pp1)) {
                return 3;
            }
        }
        return 7;
    }

    private boolean foundRfSignal(Spacecraft spacecraft, PassParams pp) {
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.getIdString()) + " CHECK SNR:" + this.pp1.rfData.rfSNRInFilterWidth);
        }
        if (pp.rfData != null && pp.rfData.rfSNRInFilterWidth > Config.ANALYZE_SNR_THRESHOLD) {
            if (Config.debugSignalFinder) {
                Log.println("Found Candiate Signal from " + spacecraft.getIdString());
            }
            return true;
        }
        return false;
    }

    private int startPass(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        if (this.pp1.foxDecoder != null) {
            try {
                Thread.sleep(1800L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.foundFoxSignal(spacecraft, this.pp1)) {
                this.lockSignal(spacecraft, this.pp1);
                return 4;
            }
            if (this.pp2 != null && this.foundFoxSignal(spacecraft, this.pp2)) {
                this.lockSignal(spacecraft, this.pp2);
                return 4;
            }
        }
        return 7;
    }

    private void lockSignal(Spacecraft spacecraft, PassParams pp) {
        this.passMeasurement = new PassMeasurement(spacecraft.foxId, -2);
        if (Config.useDDEforAzEl) {
            if (Config.satPC != null && Config.satPC.getSatellite() != null && this.passMeasurement != null) {
                this.passMeasurement.setRawValue("START_AZIMUTH", (long)Config.satPC.getAzimuth());
            }
        } else if (Config.foxTelemCalcsPosition && this.passMeasurement != null) {
            try {
                this.passMeasurement.setRawValue("START_AZIMUTH", (long)spacecraft.getCurrentPosition().getAzimuth());
            }
            catch (PositionCalcException e) {
                this.passMeasurement.setRawValue("START_AZIMUTH", 0L);
                e.printStackTrace(Log.getWriter());
            }
        }
        if (this.passMeasurement != null && pp != null && pp.foxDecoder != null && Config.debugSignalFinder) {
            Log.println("AOS for Fox-" + spacecraft.foxId + " at " + this.passMeasurement.getRawValue("AOS") + " with " + pp.foxDecoder.name + " decoder freq:" + Config.selectedFrequency);
        }
        this.newPass = true;
    }

    private int decode(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        if (!this.trackSpacecraft(spacecraft)) {
            return 7;
        }
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.foxId) + " Entering DECODE state");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setFreqRangeBins(spacecraft, this.pp1);
        if (this.foundFoxSignal(spacecraft, this.pp1)) {
            this.inputTab.setViewDecoder1();
            return 4;
        }
        if (this.pp2 != null && this.foundFoxSignal(spacecraft, this.pp2)) {
            this.inputTab.setViewDecoder2();
            return 4;
        }
        return 5;
    }

    private boolean foundFoxSignal(Spacecraft spacecraft, PassParams pp) {
        if (Config.findSignal && pp.rfData != null && pp.foxDecoder != null && pp.eyeData != null) {
            pp.eyeData = pp.foxDecoder.eyeData;
            if (Config.debugSignalFinder) {
                Log.println(String.valueOf(spacecraft.getIdString()) + " BIT SNR:" + pp.eyeData.bitSNR);
            }
            if (pp.eyeData != null && pp.eyeData.bitSNR > Config.BIT_SNR_THRESHOLD) {
                return true;
            }
            if (pp.foxDecoder.decodedFrame != null) {
                if (pp.lastFrame != null && pp.lastFrame.getHeader().uptime - pp.foxDecoder.decodedFrame.getHeader().uptime > 11L) {
                    return false;
                }
                pp.lastFrame = pp.foxDecoder.decodedFrame;
                return true;
            }
        }
        return false;
    }

    private void logEndOfPass(Spacecraft spacecraft) {
        if (this.passMeasurement != null) {
            this.passMeasurement.setLOS();
            if (Config.useDDEforAzEl) {
                if (Config.satPC != null && Config.satPC.getSatellite() != null) {
                    this.passMeasurement.setRawValue("END_AZIMUTH", (long)Config.satPC.getAzimuth());
                }
            } else if (Config.foxTelemCalcsPosition && this.passMeasurement != null) {
                try {
                    this.passMeasurement.setRawValue("END_AZIMUTH", (long)spacecraft.getCurrentPosition().getAzimuth());
                }
                catch (PositionCalcException e) {
                    this.passMeasurement.setRawValue("END_AZIMUTH", 0L);
                    e.printStackTrace(Log.getWriter());
                }
            }
            if (Config.debugSignalFinder) {
                Log.println(String.valueOf(spacecraft.foxId) + " Cached LOS as " + this.passMeasurement.getRawValue("LOS"));
            }
        }
    }

    private int faded(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        this.logEndOfPass(spacecraft);
        this.faded = true;
        long startTime = System.nanoTime() / 1000000L;
        long fadeTime = 0L;
        int fade_period = 125000;
        if (this.pp1 != null && this.pp1.iqSource != null && this.pp1.iqSource.getFormat().isBPSK()) {
            fade_period = 2000;
        }
        while (fadeTime < (long)fade_period && this.state == 5) {
            try {
                Thread.sleep(1800L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setFreqRangeBins(spacecraft, this.pp1);
            if (Config.findSignal && this.pp1.foxDecoder != null) {
                if (this.foundFoxSignal(spacecraft, this.pp1)) {
                    this.faded = false;
                    this.inputTab.setViewDecoder1();
                    return 4;
                }
                if (this.pp2 != null && this.foundFoxSignal(spacecraft, this.pp2)) {
                    this.faded = false;
                    this.inputTab.setViewDecoder2();
                    return 4;
                }
            } else {
                return 6;
            }
            long now = System.nanoTime() / 1000000L;
            fadeTime = now - startTime;
        }
        this.faded = false;
        return 6;
    }

    private int endPass(Spacecraft spacecraft) {
        if (!Config.findSignal) {
            return 7;
        }
        this.logEndPassMeasurement(spacecraft);
        return 7;
    }

    private void logEndPassMeasurement(Spacecraft spacecraft) {
        if (this.passMeasurement != null) {
            this.calculateTCA(spacecraft);
            this.calculateMaxEl(spacecraft);
            if (Config.debugSignalFinder) {
                Log.println(String.valueOf(spacecraft.foxId) + " LOS at " + this.passMeasurement.getRawValue("LOS"));
            }
            Config.payloadStore.add(spacecraft.foxId, this.passMeasurement);
        }
    }

    private void calculateMaxEl(Spacecraft spacecraft) {
        double[][] graphData = null;
        int MAX_QUANTITY = 999;
        if (this.passMeasurement.getReset() == 0 && this.passMeasurement.getUptime() == 0L) {
            this.passMeasurement.setRawValue("MAX_ELEVATION", 0L);
        } else {
            long maxEl = -180L;
            graphData = Config.payloadStore.getMeasurementGraphData("EL", MAX_QUANTITY, spacecraft, this.passMeasurement.getReset(), this.passMeasurement.getUptime(), false);
            int i = 1;
            while (i < graphData[0].length) {
                long value = (long)graphData[0][i];
                if (value > maxEl) {
                    maxEl = value;
                }
                ++i;
            }
            this.passMeasurement.setRawValue("MAX_ELEVATION", maxEl);
        }
    }

    private void calculateTCA(Spacecraft spacecraft) {
        double[][] graphData = null;
        int MAX_QUANTITY = 999;
        if (this.passMeasurement.getReset() == 0 && this.passMeasurement.getUptime() == 0L) {
            this.passMeasurement.setRawValue("TOTAL_PAYLOADS", 0L);
            this.passMeasurement.setEndResetUptime(0, 0L);
        } else {
            graphData = Config.payloadStore.getMeasurementGraphData("CARRIER_FREQ", MAX_QUANTITY, spacecraft, this.passMeasurement.getReset(), this.passMeasurement.getUptime(), false);
            if (graphData[0].length > 10) {
                double[] firstDifference = new double[graphData[0].length];
                int i = 1;
                while (i < graphData[0].length) {
                    double value = graphData[0][i];
                    double value2 = graphData[0][i - 1];
                    firstDifference[i] = 5.0 * ((value - value2) / (graphData[1][i] - graphData[1][i - 1]));
                    ++i;
                }
                int max = 0;
                double maxDeriv = 0.0;
                int i2 = 1;
                while (i2 < graphData[0].length) {
                    if (firstDifference[i2] < maxDeriv) {
                        maxDeriv = firstDifference[i2];
                        max = i2;
                    }
                    ++i2;
                }
                if (max != 0 && max != graphData[0].length) {
                    long up = (long)(graphData[1][max] + graphData[1][max - 1]) / 2L;
                    long date = (long)(graphData[3][max] + graphData[3][max - 1]) / 2L;
                    long tca = (long)this.linearInterpolation(up, graphData[1][max], graphData[1][max - 1], graphData[0][max], graphData[0][max - 1]);
                    this.pendingTCA = true;
                    this.passMeasurement.setTCA(date);
                    this.passMeasurement.setRawValue("TCA_FREQ", tca);
                    if (Config.debugSignalFinder) {
                        Log.println("TCA calculated as " + this.passMeasurement.getRawValue("TCA") + " with Uptime " + up + " and frequency: " + Long.toString(tca));
                    }
                }
            } else if (Config.debugSignalFinder) {
                Log.println("Can't calculate TCA, not enough readings");
            }
            this.passMeasurement.setRawValue("TOTAL_PAYLOADS", graphData[0].length);
            this.passMeasurement.setEndResetUptime(this.lastReset, this.lastUptime);
        }
    }

    private double linearInterpolation(double x, double x0, double x1, double y0, double y1) {
        double y = y0 + (y1 - y0) * ((x - x0) / (x1 - x0));
        return y;
    }

    private int exit(Spacecraft spacecraft) {
        if (Config.debugSignalFinder) {
            Log.println(String.valueOf(spacecraft.foxId) + " Entering EXIT state");
        }
        this.passMeasurement = null;
        return 7;
    }

    public void stopProcessing() {
        this.running = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        this.done = false;
        this.newPass = false;
        int currentSatId = 0;
        while (this.running) {
            try {
                if (Config.foxTelemCalcsDoppler) {
                    Thread.sleep(1000L);
                }
                if (Config.iq) {
                    Thread.sleep(100L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Config.useDDEforAzEl || Config.useDDEforFreq) {
                if (Config.satPC == null) {
                    Config.satPC = new SatPc32DDE();
                }
                if (Config.satPC != null) {
                    this.satPC32Connected = Config.satPC.request();
                    if (MainWindow.inputTab == null || !MainWindow.inputTab.isStarted()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            boolean atLeastOneTracked = false;
            boolean oneSatUp = false;
            int s = 0;
            while (s < Config.satManager.spacecraftList.size()) {
                block31: {
                    Spacecraft sat = Config.satManager.spacecraftList.get(s);
                    if (sat.user_track) {
                        atLeastOneTracked = true;
                    }
                    if (MainWindow.inputTab != null) {
                        if (this.trackSpacecraft(sat)) {
                            oneSatUp = true;
                            MainWindow.inputTab.startDecoding();
                            if (Config.iq) {
                                if (((Config.foxTelemCalcsPosition || Config.useDDEforAzEl) && !Config.findSignal || Config.whenAboveHorizon) && Config.retuneCenterFrequency) {
                                    if (Config.iq) {
                                        this.retunedCenterFreqIfNeeded(sat);
                                    }
                                    this.switchedFormatIfNeeded(sat);
                                }
                                if (Config.findSignal) {
                                    this.stateMachine(sat);
                                    if (Config.whenAboveHorizon) {
                                        break;
                                    }
                                    break block31;
                                } else {
                                    if (Config.foxTelemCalcsPosition && Config.foxTelemCalcsDoppler) {
                                        if (sat.foxId != currentSatId) {
                                            this.lockSignal(sat, this.pp1);
                                        }
                                        double dopplerShiftedFreq = 0.0;
                                        if (sat != null && sat.satPos != null) {
                                            dopplerShiftedFreq = sat.user_telemetryDownlinkFreqkHz * 1000.0 + sat.satPos.getDopplerFrequency(sat.user_telemetryDownlinkFreqkHz * 1000.0);
                                        }
                                        if (dopplerShiftedFreq == 0.0) break;
                                        this.setFreqRangeBins(sat, this.pp1);
                                        if (this.pp1 != null && this.pp1.iqSource != null) {
                                            this.pp1.iqSource.setTunedFrequency(dopplerShiftedFreq);
                                        }
                                        if (this.pp2 == null || this.pp2.iqSource == null) break;
                                        this.pp2.iqSource.setTunedFrequency(dopplerShiftedFreq);
                                        break;
                                    }
                                    Config.fromBin = 0;
                                    Config.toBin = SourceIQ.FFT_SAMPLES;
                                    break;
                                }
                            }
                            if (this.satIsUp(sat)) {
                                if ((!Config.foxTelemCalcsPosition && !Config.useDDEforAzEl || Config.findSignal) && !Config.whenAboveHorizon || !Config.retuneCenterFrequency) break;
                                this.switchedFormatIfNeeded(sat);
                                break;
                            }
                        } else if (currentSatId == sat.foxId) {
                            this.logEndOfPass(sat);
                            currentSatId = 0;
                        }
                    }
                }
                ++s;
            }
            if (MainWindow.inputTab != null && !oneSatUp) {
                MainWindow.inputTab.stopDecoding();
            }
            if (!Config.whenAboveHorizon || atLeastOneTracked || MainWindow.inputTab == null) continue;
            MainWindow.inputTab.rdbtnFindSignal.setSelected(false);
            Config.whenAboveHorizon = false;
            Log.errorDialog("NO SPACECRAFT TRACKED", "You have paused the decoder waiting for a spacecraft above the horizon,\nbut no spacecraft are being tracked.  Toggle 'Not Tracked' to 'Tracked'\nby clicking on it, top right of the input tab.\n'Auto Start Decoder when Above Horizon' will be disabled.");
        }
        Log.println("Pass Manager DONE");
        this.done = true;
    }

    private boolean retunedCenterFreqIfNeeded(Spacecraft sat) {
        if (this.pp1 != null && this.pp1.iqSource != null) {
            int range = this.pp1.iqSource.IQ_SAMPLE_RATE / 2;
            double maxFreq1 = this.pp1.iqSource.getCenterFreqkHz() + 0.8 * (double)range / 1000.0;
            double aboveCenter = this.pp1.iqSource.getCenterFreqkHz() + 10.0;
            double belowCenter = this.pp1.iqSource.getCenterFreqkHz() - 10.0;
            double minFreq2 = this.pp1.iqSource.getCenterFreqkHz() - 0.8 * (double)range / 1000.0;
            if (sat.user_telemetryDownlinkFreqkHz < minFreq2 || sat.user_telemetryDownlinkFreqkHz > maxFreq1 || sat.user_telemetryDownlinkFreqkHz > belowCenter && sat.user_telemetryDownlinkFreqkHz < aboveCenter) {
                double newCenterFreq = sat.user_telemetryDownlinkFreqkHz - 0.25 * (double)range / 1000.0;
                if (Config.debugSignalFinder) {
                    Log.println("Retuning for " + sat.user_display_name + " downlink: " + sat.user_telemetryDownlinkFreqkHz + " center: " + newCenterFreq);
                }
                MainWindow.inputTab.setCenterFreqKhz(newCenterFreq);
                return true;
            }
        }
        return false;
    }

    private boolean switchedFormatIfNeeded(Spacecraft sat) {
        if (Config.format != sat.user_format) {
            if (SourceTab.STARTED) {
                MainWindow.inputTab.processStartButtonClick();
            }
            Config.format = sat.user_format;
            MainWindow.inputTab.setupFormat();
            if (Config.format != sat.user_format) {
                sat.user_format = Config.format;
            }
            MainWindow.inputTab.processStartButtonClick();
            return true;
        }
        return false;
    }

    private boolean trackSpacecraft(Spacecraft sat) {
        if (!sat.user_track) {
            return false;
        }
        if (Config.whenAboveHorizon || Config.foxTelemCalcsDoppler) {
            return this.satIsUp(sat);
        }
        return true;
    }

    private boolean satIsUp(Spacecraft sat) {
        if (Config.useDDEforAzEl) {
            String satString = null;
            if (this.satPC32Connected && Config.satPC != null) {
                satString = Config.satPC.getSatellite();
            }
            return satString != null && satString.equalsIgnoreCase(sat.user_keps_name) && Config.satPC.getElevation() > 0.0;
        }
        if (Config.foxTelemCalcsPosition) {
            SatPos pos = null;
            try {
                pos = sat.getCurrentPosition();
            }
            catch (PositionCalcException e) {
                return false;
            }
            return pos != null && sat.aboveHorizon();
        }
        return false;
    }
}

