/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import common.DesktopApi;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JOptionPane;
import telemetry.SatPayloadStore;

public class UpdateManager
implements Runnable {
    private static final long CHECK_PERIOD = 3600000L;
    private static final long SERVER_UPDATE_PERIOD = 14400000L;
    private static final long T0_UPDATE_PERIOD = 3600000L;
    public static final long KEP_UPDATE_PERIOD = 604800000L;
    private boolean server = false;
    boolean worldHasNotEnded = true;

    public UpdateManager(boolean server) {
        this.server = server;
    }

    private void updateServerParams() throws IOException {
        if (Config.newServerParamsUrl != null) {
            Properties serverProperties = new Properties();
            try (BufferedReader in = null;){
                Log.println("Reading server params from: " + Config.newServerParamsUrl);
                URL server = new URL(Config.newServerParamsUrl);
                in = new BufferedReader(new InputStreamReader(server.openStream()));
                serverProperties.load(in);
            }
            try {
                String protocol;
                String port;
                Boolean both;
                String website;
                String secondary;
                Log.println("Setting server params to: ");
                String primary = serverProperties.getProperty("primaryServer");
                if (primary != null) {
                    Config.primaryServer = primary;
                    Log.println("Primary set to: " + Config.primaryServer);
                }
                if ((secondary = serverProperties.getProperty("secondaryServer")) != null) {
                    Config.secondaryServer = secondary;
                    Log.println("Secondary set to: " + Config.secondaryServer);
                }
                if ((website = serverProperties.getProperty("webSiteUrl")) != null) {
                    Config.webSiteUrl = website;
                    Log.println("Website UTL set to: " + Config.webSiteUrl);
                }
                if ((both = Boolean.valueOf(Boolean.parseBoolean(serverProperties.getProperty("sendToBothServers")))) != null) {
                    Config.sendToBothServers = both;
                    Log.println("Sent to both set to: " + Config.sendToBothServers);
                }
                if ((port = serverProperties.getProperty("serverPort")) != null) {
                    Config.serverPort = Integer.parseInt(port);
                    Log.println("Port set to: " + Config.serverPort);
                }
                if ((protocol = serverProperties.getProperty("serverProtocol")) != null) {
                    Config.serverProtocol = Integer.parseInt(protocol);
                    Log.println("Protocol set to: " + Config.serverProtocol);
                }
            }
            catch (NumberFormatException nf) {
                Log.println("Could not load the server paramaters: " + nf.getMessage());
            }
            catch (NullPointerException nf) {
                Log.println("Could not load the server paramaters: " + nf.getMessage());
            }
        }
    }

    public void deleteT0(Spacecraft sat) {
        String file = String.valueOf(sat.series) + sat.foxId + Config.t0UrlFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + file;
        }
        Log.println("Deleting: " + file);
        try {
            SatPayloadStore.remove(file);
            sat.loadTimeZeroSeries(null);
        }
        catch (IOException e) {
            Log.println("Could not delete T0 file: " + file);
            e.printStackTrace(Log.getWriter());
        }
    }

    public void loadT0(Spacecraft sat) {
        String file = String.valueOf(sat.series) + sat.foxId + Config.t0UrlFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + file;
        }
        try {
            File f2 = new File(file);
            if (f2.exists()) {
                Log.println("Loading T0: " + file);
                sat.loadTimeZeroSeries(file);
            } else {
                sat.loadTimeZeroSeries(null);
            }
        }
        catch (IOException e) {
            Log.println("Could not open T0 file: " + file);
        }
        catch (IndexOutOfBoundsException e) {
            Log.println("T0 file is corrupt - likely missing reset in sequence or duplicate reset: " + file);
        }
    }

    public void updateT0(Spacecraft sat) {
        block27: {
            String urlString = String.valueOf(Config.webSiteUrl) + Config.t0UrlPath + sat.series + sat.foxId + Config.t0UrlFile;
            String file = String.valueOf(sat.series) + sat.foxId + Config.t0UrlFile;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                file = String.valueOf(Config.logFileDirectory) + File.separator + file;
            }
            Log.println("Trying to download: " + urlString);
            FileOutputStream fos = null;
            ReadableByteChannel rbc = null;
            try {
                URL website = new URL(urlString);
                rbc = Channels.newChannel(website.openStream());
                fos = new FileOutputStream(String.valueOf(file) + ".tmp");
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                rbc.close();
                File f1 = new File(String.valueOf(file) + ".tmp");
                File f2 = new File(file);
                if (sat.loadTimeZeroSeries(String.valueOf(file) + ".tmp")) {
                    SatPayloadStore.remove(file);
                    SatPayloadStore.copyFile(f1, f2);
                    SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                    return;
                }
                try {
                    SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                    if (f2.exists()) {
                        sat.loadTimeZeroSeries(file);
                        break block27;
                    }
                    sat.loadTimeZeroSeries(null);
                }
                catch (MalformedURLException e) {
                    Log.println("Invalid location for T0 file: " + file);
                }
                catch (IOException e) {
                    Log.println("Could not write T0 file: " + file);
                }
                catch (IndexOutOfBoundsException e) {
                    Log.println("T0 file is corrupt - likely missing reset in sequence or duplicate reset: " + file);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (rbc != null) {
                        rbc.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkVersion() throws IOException {
        URL oracle = new URL(Config.newVersionUrl);
        BufferedReader in = new BufferedReader(new InputStreamReader(oracle.openStream()));
        String availableVersion = in.readLine();
        String notes = "";
        try {
            String line;
            while ((line = in.readLine()) != null) {
                notes = String.valueOf(notes) + line + "\n";
            }
            Log.println("LATEST VERSION: " + availableVersion);
            try {
                int maj = Config.parseVersionMajor(availableVersion);
                int min = Config.parseVersionMinor(availableVersion);
                System.out.println("AVAIL MIN: " + min);
                System.out.println("CURRENT MIN: " + Config.getVersionMinor());
                if (Config.getVersionMajor() < maj) {
                    this.requireUpgrade(availableVersion, notes);
                }
                if (Config.getVersionMajor() == maj && Config.getVersionMinor() < min) {
                    this.recommendUpgrade(availableVersion, notes);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace(Log.getWriter());
                Log.println("Error parsing the latest version information.  Abandoning the check");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void recommendUpgrade(String ver, String notes) {
        String message = "Version " + ver + " of FoxTelem is available!  Do you want to go to https://www.g0kla.com/foxtelem to download it?\n" + "Release information:\n" + notes;
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(MainWindow.frame, message, "New FoxTelem Version Available", 0, 1, null, options, options[1]);
        if (n == 0) {
            this.gotoSite();
        }
    }

    private void requireUpgrade(String ver, String notes) {
        String message = "You must upgrade to FoxTelem Version " + ver + "  Do you want to go to https://www.g0kla.com/foxtelem to download it?\n" + "Release information:\n" + notes;
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(MainWindow.frame, message, "REQUIRED UPGRADE", 0, 0, null, options, options[1]);
        if (n == 1) {
            System.exit(0);
        }
        this.gotoSite();
        System.exit(0);
    }

    private void gotoSite() {
        String url = "https://www.g0kla.com/foxtelem";
        try {
            DesktopApi.browse(new URI(url));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (!this.server) {
            try {
                this.updateServerParams();
            }
            catch (IOException e1) {
                Log.println("Can not read the server paramaters, skipping");
                e1.printStackTrace(Log.getWriter());
            }
        }
        if (!this.server && Config.downloadT0FromServer) {
            ArrayList<Spacecraft> sats = Config.satManager.getSpacecraftList();
            int i = 0;
            while (i < sats.size()) {
                this.updateT0(sats.get(i));
                ++i;
            }
        }
        if (!this.server) {
            try {
                this.checkVersion();
            }
            catch (IOException e1) {
                Log.println("Can not read the latest version, skipping");
                e1.printStackTrace(Log.getWriter());
            }
        }
        long elapsed = 0L;
        while (this.worldHasNotEnded) {
            Spacecraft fox;
            int i;
            ArrayList<Spacecraft> sats;
            try {
                Thread.sleep(3600000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
            if (!this.server && (elapsed += 3600000L) % 14400000L == 0L) {
                try {
                    this.updateServerParams();
                }
                catch (IOException e1) {
                    Log.println("Can not read the server paramaters, skipping");
                    e1.printStackTrace(Log.getWriter());
                }
            }
            if (elapsed % 3600000L == 0L && Config.downloadT0FromServer) {
                sats = Config.satManager.getSpacecraftList();
                i = 0;
                while (i < sats.size()) {
                    fox = sats.get(i);
                    if (!fox.hasFixedReset) {
                        if (!this.server) {
                            this.updateT0(sats.get(i));
                        } else {
                            this.loadT0(sats.get(i));
                        }
                    }
                    ++i;
                }
            }
            if (elapsed % 604800000L != 0L) continue;
            if (!this.server) {
                if (Config.foxTelemCalcsPosition) {
                    Config.satManager.fetchTLEFile();
                }
            } else {
                sats = Config.satManager.getSpacecraftList();
                i = 0;
                while (i < sats.size()) {
                    fox = sats.get(i);
                    fox.loadTleHistory();
                    ++i;
                }
            }
            elapsed = 0L;
        }
    }
}

