/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import common.Performance;
import decoder.CircularBuffer;
import decoder.Decoder;
import java.util.ArrayList;

public class BitStream
extends CircularBuffer {
    protected int PURGE_THRESHOLD = 100000;
    protected int SYNC_WORD_DISTANCE = 0;
    protected ArrayList<Integer> syncWords = new ArrayList();
    protected ArrayList<SyncPair> framesTried = new ArrayList();
    Decoder decoder;
    protected long totalBits = 0L;

    public BitStream(int initialSize, Decoder decoder, int syncWordDistance) {
        super(initialSize);
        this.SYNC_WORD_DISTANCE = syncWordDistance;
        this.decoder = decoder;
    }

    public void addBit(boolean n) {
        this.add(n);
        Performance.startTimer("add:purge");
        this.purgeBits();
        Performance.endTimer("add:purge");
    }

    protected void purgeBits() {
        if (this.size() > this.PURGE_THRESHOLD) {
            this.removeBits(0, this.SYNC_WORD_DISTANCE);
            this.framesTried = new ArrayList();
        }
    }

    public long getStartOfWindowBit() {
        return this.totalBits + (long)this.size() - 1L;
    }

    public void removeBits(int start, int end) {
        int marker;
        if (Config.debugFrames) {
            Log.println("Purging " + (end - start) + " bits");
        }
        this.totalBits += (long)(end - start);
        int distance = end - start;
        this.incStartPointer(distance);
        int j = 0;
        while (j < this.syncWords.size()) {
            marker = this.syncWords.get(j) - distance;
            if (marker < 0) {
                this.syncWords.remove(j);
                --j;
            } else {
                this.syncWords.set(j, marker);
            }
            ++j;
        }
        j = 0;
        while (j < this.framesTried.size()) {
            marker = this.framesTried.get((int)j).word1 - distance;
            if (marker < 0) {
                this.framesTried.remove(j);
                --j;
            } else {
                this.framesTried.set(j, new SyncPair(marker, marker + this.SYNC_WORD_DISTANCE));
            }
            ++j;
        }
    }

    protected class SyncPair {
        int word1;
        int word2;

        SyncPair(int a, int b) {
            this.word1 = a;
            this.word2 = b;
        }

        public boolean equals(int x, int y) {
            if (this.word1 == x && this.word2 == y) {
                return true;
            }
            return this.word2 == x && this.word1 == y;
        }
    }
}

