/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.FmDemodulator;
import decoder.RfData;
import decoder.SourceAudio;
import decoder.SourceUSB;
import filter.Complex;
import filter.ComplexOscillator;
import filter.DcRemoval;
import filter.Delay;
import filter.HilbertTransform;
import filter.IirFilter;
import filter.PolyPhaseFilter;
import javax.sound.sampled.AudioFormat;
import org.jtransforms.fft.DoubleFFT_1D;
import telemetry.Format.TelemFormat;

public class SourceIQ
extends SourceAudio {
    SourceAudio upstreamAudioSource;
    Thread upstreamAudioReadThread;
    private TelemFormat format;
    private int upstreamChannel = 0;
    private int channel = 0;
    public static int AF_SAMPLE_RATE = 0;
    public AudioFormat upstreamAudioFormat;
    public int IQ_SAMPLE_RATE = 0;
    public static int FFT_SAMPLES = 4096;
    public static int samplesToRead = 3840;
    int decimationFactor = 4;
    int decimationFactor2 = 1;
    int decimateCount = 0;
    int decimateCount2 = 0;
    double[] inI;
    double[] inQ;
    double[] in2I;
    double[] in2Q;
    double[] fftData = null;
    double[] newData = null;
    private double[] psdAvg = null;
    int psdAvgCount = 0;
    int PSD_AVG_LEN = 3;
    double[] overlap = null;
    double[] outputData = null;
    double[] fcdData = null;
    double[] audioData = null;
    double[] demodAudio = null;
    double centerFreq;
    double binBandwidth = 0.0;
    int filterWidth = 0;
    int filterWidthHz = 4000;
    double[] blackmanWindow = null;
    double[] blackmanFilterShape;
    double[] tukeyFilterShape;
    DoubleFFT_1D fft;
    FmDemodulator fm;
    private static final int NZEROS = 5;
    private static final int NPOLES = 5;
    private double[] xvi = new double[6];
    private double[] yvi = new double[6];
    private double[] xvq = new double[6];
    private double[] yvq = new double[6];
    DcRemoval audioDcFilter;
    DcRemoval iDcFilter;
    DcRemoval qDcFilter;
    PolyPhaseFilter polyFilterI;
    PolyPhaseFilter polyFilterQ;
    PolyPhaseFilter polyFilter2I;
    PolyPhaseFilter polyFilter2Q;
    HilbertTransform ht;
    Delay delay;
    boolean fftDataFresh = false;
    public boolean offsetFFT = true;
    int dist = 0;
    RfData rfData;
    Thread rfDataThread;
    double[] phasorData;
    double freq;
    ComplexOscillator nco;
    Complex c = new Complex(0.0, 0.0);
    IirFilter iFilter;
    IirFilter qFilter;
    IirFilter loopFilter;
    public static final double LOCK_LEVEL_THRESHOLD = 10.0;
    private int ssbOffset = -1400;
    double gain = 1.0;
    static final double DESIRED_RANGE = 0.7;
    double pfValue;
    double pfValue2;
    double audioI;
    double audioQ;
    double iMixNco;
    double qMixNco;
    double id;
    double qd;
    boolean firstRun = true;
    double psd;

    public SourceIQ(int circularDoubleBufferSize, int chan, TelemFormat format) {
        super("IQ Source", circularDoubleBufferSize, chan, false);
        this.format = format;
        this.channel = chan;
        AF_SAMPLE_RATE = Config.afSampleRate;
        if (AF_SAMPLE_RATE < 48000) {
            AF_SAMPLE_RATE = 48000;
        }
        this.audioFormat = SourceIQ.makeAudioFormat();
    }

    public void setAudioSource(SourceAudio as, int chan) {
        this.upstreamChannel = chan;
        this.upstreamAudioSource = as;
        this.upstreamAudioFormat = as.getAudioFormat();
    }

    public void setFilterWidth(int freq) {
        this.filterWidthHz = freq;
        if (freq == 0 || this.binBandwidth == 0.0) {
            return;
        }
        this.filterWidth = (int)((double)freq / this.binBandwidth);
        this.blackmanFilterShape = this.initBlackmanWindow(this.filterWidth * 2);
        this.tukeyFilterShape = this.initTukeyWindow(this.filterWidth * 2);
    }

    public TelemFormat getFormat() {
        return this.format;
    }

    public String getFormatMode() {
        return this.format.getMode();
    }

    public RfData getRfData() {
        if (this.rfData != null) {
            return this.rfData;
        }
        return null;
    }

    @Override
    public int getAudioBufferCapacity() {
        return this.upstreamAudioSource.circularDoubleBuffer[this.upstreamChannel].getCapacity();
    }

    public int getFilterWidth() {
        return this.filterWidth;
    }

    public void setSSBOffset(int s) {
        this.ssbOffset = s;
    }

    public int getSSBOffset() {
        return this.ssbOffset;
    }

    public int getSSBOffsetInBins() {
        return (int)((double)this.ssbOffset / this.binBandwidth);
    }

    public double getCenterFreqkHz() {
        return this.centerFreq;
    }

    public void setCenterFreqkHz(double freq) {
        this.centerFreq = freq;
    }

    public void setSelectedBin(int bin) {
        double f = this.getOffsetFrequencyFromBin(bin);
        this.setSelectedFrequency(f);
    }

    public int getSelectedBin() {
        return this.getBinFromOffsetFreqHz(this.freq);
    }

    public void incSelectedFrequency() {
        this.setSelectedFrequency(this.freq + 10.0);
    }

    public void decSelectedFrequency() {
        this.setSelectedFrequency(this.freq - 10.0);
    }

    public void setTunedFrequency(double f) {
        double offset = f - this.centerFreq * 1000.0;
        this.setSelectedFrequency(offset);
    }

    public double getTunedFrequency() {
        return this.centerFreq * 1000.0 + this.freq;
    }

    public void setSelectedFrequency(double f) {
        Config.selectedFrequency = this.freq = f;
        if (Config.useCostas) {
            return;
        }
        if (this.nco != null) {
            this.nco.setFrequency(this.freq);
        }
    }

    public double getSelectedFrequency() {
        return this.freq;
    }

    public long getOffsetFrequencyFromBin(int bin) {
        long freq = 0L;
        freq = bin < FFT_SAMPLES / 2 ? (long)((double)bin * this.binBandwidth) : (long)((double)(-1 * (FFT_SAMPLES - bin)) * this.binBandwidth);
        return freq;
    }

    public long getFrequencyFromBin(int bin) {
        long freq = 0L;
        freq = bin < FFT_SAMPLES / 2 ? (long)(this.getCenterFreqkHz() * 1000.0 + (double)bin * this.binBandwidth) : (long)(this.getCenterFreqkHz() * 1000.0 - (double)(FFT_SAMPLES - bin) * this.binBandwidth);
        return freq;
    }

    public int getBinFromFreqHz(long freq) {
        long delta = (long)((double)freq - this.centerFreq * 1000.0);
        return this.getBinFromOffsetFreqHz(delta);
    }

    public int getBinFromOffsetFreqHz(double delta) {
        int bin = 0;
        if (delta >= 0.0) {
            bin = (int)(delta / this.binBandwidth);
            if (bin >= FFT_SAMPLES / 2) {
                bin = FFT_SAMPLES / 2 - 1;
            }
        } else {
            bin = FFT_SAMPLES + (int)(delta / this.binBandwidth);
            if (bin < FFT_SAMPLES / 2) {
                bin = FFT_SAMPLES / 2;
            }
        }
        return bin;
    }

    public void setBinFromFrequencyHz(long freq) {
    }

    public double[] getPowerSpectralDensity() {
        return this.psdAvg;
    }

    protected void startAudioThread() {
        if (this.upstreamChannel == 0) {
            if (this.upstreamAudioReadThread != null) {
                this.upstreamAudioSource.stop("SourceIQ:startAudioThread");
            }
            if (!(this.upstreamAudioSource instanceof SourceUSB)) {
                this.upstreamAudioReadThread = new Thread(this.upstreamAudioSource);
                this.upstreamAudioReadThread.start();
            }
        }
    }

    private void setFFTsize() {
        if (Config.isRasperryPi()) {
            FFT_SAMPLES = 2048;
            samplesToRead = 1920;
            return;
        }
        FFT_SAMPLES = 4096;
        samplesToRead = 1920;
    }

    private void init() {
        this.IQ_SAMPLE_RATE = (int)this.upstreamAudioFormat.getSampleRate();
        this.setFFTsize();
        this.fft = new DoubleFFT_1D(FFT_SAMPLES);
        this.fm = new FmDemodulator();
        this.blackmanWindow = this.initBlackmanWindow(FFT_SAMPLES);
        this.fftData = new double[FFT_SAMPLES * 2];
        this.psdAvg = new double[FFT_SAMPLES * 2 + 1];
        this.newData = new double[this.fftData.length];
        switch (this.IQ_SAMPLE_RATE) {
            case 960000: {
                this.decimationFactor = 4;
                this.decimationFactor2 = 5;
                break;
            }
            case 2304000: {
                this.decimationFactor = 8;
                this.decimationFactor2 = 6;
                break;
            }
            case 1440000: {
                this.decimationFactor = 6;
                this.decimationFactor2 = 5;
                break;
            }
            case 1920000: {
                this.decimationFactor = 8;
                this.decimationFactor2 = 5;
                break;
            }
            case 2208000: {
                this.decimationFactor = 23;
                this.decimationFactor2 = 2;
                break;
            }
            case 2400000: {
                this.decimationFactor = 10;
                this.decimationFactor2 = 5;
                break;
            }
            case 2880000: {
                this.decimationFactor = 10;
                this.decimationFactor2 = 6;
                break;
            }
            default: {
                this.decimationFactor = this.IQ_SAMPLE_RATE / AF_SAMPLE_RATE;
            }
        }
        if (this.decimationFactor == 0) {
            this.decimationFactor = 1;
            this.decimationFactor2 = 1;
        }
        this.binBandwidth = (double)this.IQ_SAMPLE_RATE / (double)FFT_SAMPLES;
        this.setFilterWidth(this.format.getInt("rf_filter_width_hz"));
        if (this.format.isBPSK()) {
            this.setFilterWidth(5000);
            this.ht = new HilbertTransform(AF_SAMPLE_RATE, 255);
            this.delay = new Delay(127);
        }
        if (this.offsetFFT) {
            this.dist = 128 * FFT_SAMPLES / 4096;
        }
        this.overlap = new double[2 * FFT_SAMPLES - samplesToRead];
        this.fcdData = new double[samplesToRead];
        this.demodAudio = new double[samplesToRead / 2];
        this.audioData = new double[samplesToRead / 2 / (this.decimationFactor * this.decimationFactor2)];
        this.phasorData = new double[samplesToRead];
        Log.println("IQDecoder Samples to read: " + samplesToRead);
        Log.println("IQDecoder using FFT sized to: " + FFT_SAMPLES);
        Log.println("Decimation: " + this.decimationFactor * this.decimationFactor2);
        Log.println("Decimation Factor: " + this.decimationFactor);
        Log.println("Decimation Factor2: " + this.decimationFactor2);
        Log.println("IQ Sample Rate: " + this.IQ_SAMPLE_RATE);
        this.polyFilterI = new PolyPhaseFilter(this.IQ_SAMPLE_RATE, this.IQ_SAMPLE_RATE / this.decimationFactor / 2, this.decimationFactor, 13 * this.decimationFactor);
        this.polyFilterQ = new PolyPhaseFilter(this.IQ_SAMPLE_RATE, this.IQ_SAMPLE_RATE / this.decimationFactor / 2, this.decimationFactor, 13 * this.decimationFactor);
        this.polyFilter2I = new PolyPhaseFilter(this.IQ_SAMPLE_RATE / this.decimationFactor, this.filterWidthHz, this.decimationFactor2, 13 * this.decimationFactor2);
        this.polyFilter2Q = new PolyPhaseFilter(this.IQ_SAMPLE_RATE / this.decimationFactor, this.filterWidthHz, this.decimationFactor2, 13 * this.decimationFactor2);
        this.inI = new double[this.decimationFactor];
        this.inQ = new double[this.decimationFactor];
        this.in2I = new double[this.decimationFactor2];
        this.in2Q = new double[this.decimationFactor2];
        this.audioDcFilter = new DcRemoval(0.9999);
        this.iDcFilter = new DcRemoval(0.9999);
        this.qDcFilter = new DcRemoval(0.9999);
        this.freq = Config.selectedFrequency;
        this.nco = new ComplexOscillator(this.IQ_SAMPLE_RATE, (int)this.freq);
        double[] a = new double[]{1.504626E-5, 6.018503E-5, 9.027754E-5, 6.018503E-5, 1.504626E-5};
        double[] b = new double[]{1.0, 3.725385, -5.226004, 3.270902, -0.7705239};
        this.iFilter = new IirFilter(a, b);
        this.qFilter = new IirFilter(a, b);
        double x = 0.1;
        double[] a2 = new double[]{1.0 - x};
        double[] b2 = new double[]{1.0, x};
        this.loopFilter = new IirFilter(a2, b2);
        this.rfData = new RfData(this);
        this.rfDataThread = new Thread(this.rfData);
        this.rfDataThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.rfDataThread.start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SourceIQ");
        this.done = false;
        this.running = true;
        this.startAudioThread();
        Log.println("IQ Source START. Running=" + this.running);
        try {
            this.init();
        }
        catch (IllegalThreadStateException e) {
            Log.errorDialog("ERROR", "Trying to start a second Decoder when not supported by the hardware\nPerhaps DUV and HS were selected for an SDR that can not be opened twice. \nSet the decoder to one mode and restart FoxTelem.");
            this.running = false;
        }
        block4: while (this.running) {
            int nBytesRead = 0;
            if (this.circularDoubleBuffer[this.channel].getCapacity() > this.fcdData.length) {
                nBytesRead = this.upstreamAudioSource.read(this.fcdData, this.upstreamChannel);
                if (nBytesRead != this.fcdData.length && Config.debugAudioGlitches) {
                    Log.println("ERROR: IQ Source could not read sufficient data from audio source");
                }
                this.outputData = this.processNCOBytes(this.fcdData);
                int i = 0;
                while (i < this.outputData.length) {
                    if (i + 2 > this.outputData.length) continue block4;
                    this.circularDoubleBuffer[this.channel].add(this.outputData[i], this.outputData[i + 1]);
                    i += 2;
                }
                continue;
            }
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        this.rfData.stopProcessing();
        Log.println("IQ Source EXIT.  Running=" + this.running);
    }

    @Override
    public void stop(String caller) {
        this.running = false;
        this.upstreamAudioSource.stop("SourceIQ:stop");
        while (!this.upstreamAudioSource.isDone()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.done = true;
    }

    protected double[] processNCOBytes(double[] fcdData) {
        this.zeroFFT();
        int i = 0;
        int j = 0;
        while (j < fcdData.length) {
            this.id = fcdData[j];
            this.qd = fcdData[j + 1];
            this.id = this.iDcFilter.filter(this.id);
            this.qd = this.qDcFilter.filter(this.qd);
            if (this.format.isBPSK()) {
                this.nco.setFrequency(this.freq + (double)this.ssbOffset);
            } else {
                this.nco.setFrequency(this.freq);
            }
            this.c = this.nco.nextSample();
            this.c.normalize();
            this.iMixNco = this.gain * this.id * this.c.geti() + this.gain * this.qd * this.c.getq();
            this.qMixNco = this.gain * this.qd * this.c.geti() - this.gain * this.id * this.c.getq();
            try {
                this.inI[this.decimateCount] = this.iMixNco;
                this.inQ[this.decimateCount] = this.qMixNco;
                ++this.decimateCount;
                if (this.decimateCount >= this.decimationFactor) {
                    this.decimateCount = 0;
                    this.pfValue = this.polyFilterI.filterDouble(this.inI);
                    this.pfValue2 = this.polyFilterQ.filterDouble(this.inQ);
                    if (this.decimationFactor2 > 0) {
                        this.in2I[this.decimateCount2] = this.pfValue;
                        this.in2Q[this.decimateCount2] = this.pfValue2;
                        ++this.decimateCount2;
                        if (this.decimateCount2 >= this.decimationFactor2) {
                            this.decimateCount2 = 0;
                            this.pfValue = this.polyFilter2I.filterDouble(this.in2I);
                            this.pfValue2 = this.polyFilter2Q.filterDouble(this.in2Q);
                            this.demodulate(j);
                        }
                    } else {
                        this.demodulate(j);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.println("ERROR WITH DECIMATION RATE. count:" + this.decimateCount + " rate:" + this.decimationFactor);
                this.decimateCount = 0;
            }
            if (Config.swapIQ) {
                this.fftData[i + this.dist] = this.qd;
                this.fftData[i + 1 + this.dist] = this.id;
            } else {
                this.fftData[i + this.dist] = this.id;
                this.fftData[i + 1 + this.dist] = this.qd;
            }
            i += 2;
            j += 2;
        }
        this.runFFT(this.fftData);
        this.fftDataFresh = false;
        if (!Config.showIF) {
            this.calcPsd();
        }
        this.fftDataFresh = true;
        this.filterFFTWindow(this.fftData);
        if (Config.showIF) {
            this.calcPsd();
        }
        return this.audioData;
    }

    private void demodulate(int j) {
        if (this.format.isBPSK()) {
            this.audioQ = this.ht.filter(this.pfValue);
            this.audioI = this.delay.filter(this.pfValue2);
            this.audioData[j / (2 * this.decimationFactor * this.decimationFactor2)] = this.audioI + this.audioQ;
        } else {
            this.audioData[j / (2 * this.decimationFactor * this.decimationFactor2)] = this.fm.demodulate(this.pfValue, this.pfValue2);
        }
    }

    private void zeroFFT() {
        int i = 0;
        while (i < FFT_SAMPLES * 2) {
            this.fftData[i] = 0.0;
            ++i;
        }
    }

    private void runFFT(double[] fftData) {
        int s = 0;
        while (s < fftData.length - 1) {
            fftData[s] = this.blackmanWindow[s / 2] * fftData[s];
            fftData[s + 1] = this.blackmanWindow[s / 2] * fftData[s + 1];
            s += 2;
        }
        this.fft.complexForward(fftData);
    }

    private void calcPsd() {
        int s = 0;
        while (s < this.fftData.length - 1) {
            this.psd = this.psd(this.fftData[s], this.fftData[s + 1]);
            if (this.firstRun) {
                this.psdAvg[s / 2] = this.psd;
            } else if (this.psd != 0.0) {
                this.psdAvg[s / 2] = SourceIQ.average(this.psdAvg[s / 2], this.psd, this.PSD_AVG_LEN);
            }
            s += 2;
        }
        this.firstRun = false;
    }

    private double psd(double i, double q) {
        return 20.0 * Math.log10(Math.sqrt(i * i + q * q) / this.binBandwidth);
    }

    public static double average(double avg, double new_sample, int N) {
        avg -= avg / (double)N;
        if (Double.isNaN(avg += new_sample / (double)N)) {
            avg = 0.0;
        }
        if (Double.isInfinite(avg)) {
            avg = 0.0;
        }
        return avg;
    }

    private void filterFFTWindow(double[] fftData) {
        int noiseEnd;
        int noiseStart;
        int end;
        int filterBins;
        int binIndex;
        int start;
        int z = 0;
        while (z < fftData.length) {
            this.newData[z] = 0.0;
            ++z;
        }
        int binOfPeakSignalInFilterWidth = 0;
        double peakSignalInFilterWidth = -999999.0;
        double strongestSigInSatBand = -999999.0;
        int binOfStrongestSigInSatBand = 0;
        double noiseOutsideFilterWidth = 0.0;
        double avgSigInFilterWidth = 0.0;
        int noiseReading = 0;
        int sigReading = 0;
        int fromBin = Config.fromBin;
        int toBin = Config.toBin;
        boolean spansDcSpike = false;
        int selectedBin = this.getBinFromOffsetFreqHz(this.freq);
        if (selectedBin * 2 > fftData.length) {
            selectedBin = 3 * fftData.length / 8;
            this.setSelectedBin(selectedBin);
        }
        if ((start = (binIndex = selectedBin * 2) - (filterBins = this.filterWidth * 2)) < 0) {
            start = 0;
        }
        if ((end = binIndex + filterBins) > fftData.length - 2) {
            end = fftData.length - 2;
        }
        if (fromBin == toBin) {
            fromBin = start / 2;
            toBin = end / 2;
        }
        if (toBin < fromBin) {
            spansDcSpike = true;
        }
        if ((noiseStart = start - filterBins) < 0) {
            noiseStart = 0;
        }
        if ((noiseEnd = end + filterBins) > fftData.length - 2) {
            noiseEnd = fftData.length - 2;
        }
        double sig = 0.0;
        int n = 0;
        while (n < noiseStart) {
            if ((fromBin * 2 < n && n < toBin * 2 || spansDcSpike && fromBin * 2 < n && n < fftData.length - 2 || spansDcSpike && n >= 0 && n < toBin * 2) && (sig = this.psd(fftData[n], fftData[n + 1])) > strongestSigInSatBand) {
                strongestSigInSatBand = sig;
                binOfStrongestSigInSatBand = n / 2;
            }
            n += 2;
        }
        n = noiseStart;
        while (n < start) {
            sig = this.psd(fftData[n], fftData[n + 1]);
            if ((fromBin * 2 < n && n < toBin * 2 || spansDcSpike && fromBin * 2 < n && n < fftData.length - 2 || spansDcSpike && n >= 0 && n < toBin * 2) && sig > strongestSigInSatBand) {
                strongestSigInSatBand = sig;
                binOfStrongestSigInSatBand = n / 2;
            }
            noiseOutsideFilterWidth += sig;
            ++noiseReading;
            n += 2;
        }
        int i = start;
        while (i <= end) {
            sig = this.psd(fftData[i], fftData[i + 1]);
            if (fromBin * 2 < i && i < toBin * 2 || spansDcSpike && fromBin * 2 < i && i < fftData.length - 2 || spansDcSpike && i >= 0 && i < toBin * 2) {
                if (sig > strongestSigInSatBand) {
                    strongestSigInSatBand = sig;
                    binOfStrongestSigInSatBand = i / 2;
                }
                if (sig > peakSignalInFilterWidth) {
                    peakSignalInFilterWidth = sig;
                    binOfPeakSignalInFilterWidth = i / 2;
                }
            }
            avgSigInFilterWidth += sig;
            ++sigReading;
            i += 2;
        }
        n = end;
        while (n < noiseEnd) {
            sig = this.psd(fftData[n], fftData[n + 1]);
            if ((fromBin * 2 < n && n < toBin * 2 || spansDcSpike && fromBin * 2 < n && n < fftData.length - 2 || spansDcSpike && n >= 0 && n < toBin * 2) && sig > strongestSigInSatBand) {
                strongestSigInSatBand = sig;
                binOfStrongestSigInSatBand = n / 2;
            }
            noiseOutsideFilterWidth += sig;
            ++noiseReading;
            n += 2;
        }
        n = noiseEnd;
        while (n < fftData.length - 2) {
            if ((fromBin * 2 < n && n < toBin * 2 || spansDcSpike && fromBin * 2 < n && n < fftData.length - 2 || spansDcSpike && n >= 0 && n < toBin * 2) && (sig = this.psd(fftData[n], fftData[n + 1])) > strongestSigInSatBand) {
                strongestSigInSatBand = sig;
                binOfStrongestSigInSatBand = n / 2;
            }
            n += 2;
        }
        this.rfData.setPeakSignalInFilterWidth(peakSignalInFilterWidth, binOfPeakSignalInFilterWidth, avgSigInFilterWidth /= (double)sigReading, noiseOutsideFilterWidth /= (double)noiseReading);
        this.rfData.setStrongestSignal(strongestSigInSatBand, binOfStrongestSigInSatBand);
    }

    private void antiAlias12kHzIIRFilter(double[] rawAudioData) {
        double GAIN = 919.758387;
        int j = 0;
        while (j < rawAudioData.length) {
            this.xvi[0] = this.xvi[1];
            this.xvi[1] = this.xvi[2];
            this.xvi[2] = this.xvi[3];
            this.xvi[3] = this.xvi[4];
            this.xvi[4] = this.xvi[5];
            this.xvi[5] = rawAudioData[j] / GAIN;
            this.yvi[0] = this.yvi[1];
            this.yvi[1] = this.yvi[2];
            this.yvi[2] = this.yvi[3];
            this.yvi[3] = this.yvi[4];
            this.yvi[4] = this.yvi[5];
            this.yvi[5] = this.xvi[0] + this.xvi[5] + 5.0 * (this.xvi[1] + this.xvi[4]) + 10.0 * (this.xvi[2] + this.xvi[3]) + 0.088406719 * this.yvi[0] + -0.6658412244 * this.yvi[1] + 2.0688801399 * this.yvi[2] + -3.3337619982 * this.yvi[3] + 2.8075246179 * this.yvi[4];
            rawAudioData[j] = this.yvi[5];
            this.xvq[0] = this.xvq[1];
            this.xvq[1] = this.xvq[2];
            this.xvq[2] = this.xvq[3];
            this.xvq[3] = this.xvq[4];
            this.xvq[4] = this.xvq[5];
            this.xvq[5] = rawAudioData[j + 1] / GAIN;
            this.yvq[0] = this.yvq[1];
            this.yvq[1] = this.yvq[2];
            this.yvq[2] = this.yvq[3];
            this.yvq[3] = this.yvq[4];
            this.yvq[4] = this.yvq[5];
            this.yvq[5] = this.xvq[0] + this.xvq[5] + 5.0 * (this.xvq[1] + this.xvq[4]) + 10.0 * (this.xvq[2] + this.xvq[3]) + 0.088406719 * this.yvq[0] + -0.6658412244 * this.yvq[1] + 2.0688801399 * this.yvq[2] + -3.3337619982 * this.yvq[3] + 2.8075246179 * this.yvq[4];
            rawAudioData[j + 1] = this.yvq[5];
            j += 2;
        }
    }

    private double[] initBlackmanWindow(int len) {
        double[] blackmanWindow = new double[len + 1];
        int i = 0;
        while (i <= len) {
            blackmanWindow[i] = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)len) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)len);
            if (blackmanWindow[i] < 0.0) {
                blackmanWindow[i] = 0.0;
            }
            ++i;
        }
        return blackmanWindow;
    }

    private double[] initTukeyWindow(int len) {
        double[] window = new double[len + 1];
        double alpha = 0.5;
        int lowerLimit = (int)(alpha * (double)(len - 1) / 2.0);
        int upperLimit = (int)((double)(len - 1) * (1.0 - alpha / 2.0));
        int i = 0;
        while (i < lowerLimit) {
            window[i] = 0.5 * (1.0 + Math.cos(Math.PI * ((double)(2 * i) / (alpha * (double)(len - 1)) - 1.0)));
            ++i;
        }
        i = lowerLimit;
        while (i < upperLimit) {
            window[i] = 1.0;
            ++i;
        }
        i = upperLimit;
        while (i < len) {
            window[i] = 0.5 * (1.0 + Math.cos(Math.PI * ((double)(2 * i) / (alpha * (double)(len - 1)) - 2.0 / alpha + 1.0)));
            ++i;
        }
        return window;
    }

    public static AudioFormat makeAudioFormat() {
        float sampleRate = AF_SAMPLE_RATE;
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        Log.println("IQ Standard output format " + af);
        return af;
    }

    public static double fullwaveRectify(double in) {
        if (in < 0.0) {
            return -1.0 * in;
        }
        return in;
    }

    public double[] getPhasorData() {
        return this.phasorData;
    }
}

