/*
 * Decompiled with CFR 0.152.
 */
package device.airspy;

public class AirspySampleAdapter {
    private static final float SCALE_SIGNED_12_BIT_TO_FLOAT = 4.8828125E-4f;
    private boolean mSamplePacking = false;

    public void setSamplePacking(boolean enabled) {
        this.mSamplePacking = enabled;
    }

    public float[] convert(byte[] samples) {
        if (this.mSamplePacking) {
            return this.convertPacked(samples);
        }
        return this.convertUnpacked(samples);
    }

    private float[] convertUnpacked(byte[] data) {
        float[] samples = new float[data.length / 2];
        int pointer = 0;
        int x = 0;
        while (x < data.length) {
            samples[pointer++] = AirspySampleAdapter.scale(data[x] & 0xFF | data[x + 1] << 8);
            x += 2;
        }
        return samples;
    }

    private float[] convertPacked(byte[] data1) {
        byte[] data = new byte[data1.length];
        int x = 0;
        while (x < data1.length) {
            data[x] = data1[x + 3];
            data[x + 1] = data1[x + 2];
            data[x + 2] = data1[x + 1];
            data[x + 3] = data1[x];
            x += 4;
        }
        int count = (int)((float)data.length / 1.5f);
        if (count % 2 == 1) {
            --count;
        }
        int bytes = (int)((float)count * 1.5f);
        float[] samples = new float[count];
        int pointer = 0;
        int x2 = 0;
        while (x2 < bytes) {
            int first = data[x2] << 4 & 0xFF0 | data[x2 + 1] >> 4 & 0xF;
            samples[pointer++] = AirspySampleAdapter.scale(first);
            int second = data[x2 + 1] << 8 & 0xF00 | data[x2 + 2] & 0xFF;
            samples[pointer++] = AirspySampleAdapter.scale(second);
            x2 += 3;
        }
        return samples;
    }

    public static float scale(int value) {
        return (float)((value & 0xFFF) - 2048) * 4.8828125E-4f;
    }
}

