/*
 * Decompiled with CFR 0.152.
 */
package device.fcd;

import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.fcd.FCDCommand;
import device.fcd.FCDTunerController;
import device.fcd.FcdProPlusPanel;
import device.rtl.RTL2832TunerController;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.LibUsbException;

public class FCD2TunerController
extends FCDTunerController {
    public static final int MINIMUM_TUNABLE_FREQUENCY = 150;
    public static final int MAXIMUM_TUNABLE_FREQUENCY = 2050000;
    public static final int SAMPLE_RATE = 192000;
    int TRFE_0_4 = 0;
    int TRFE_4_8 = 1;
    int TRFE_8_16 = 2;
    int TRFE_16_32 = 3;
    int TRFE_32_75 = 4;
    int TRFE_75_125 = 5;
    int TRFE_125_250 = 6;
    int TRFE_145 = 7;
    int TRFE_410_875 = 8;
    int TRFE_435 = 9;
    int TRFE_875_2000 = 10;
    String[] rfFilterName = new String[]{"0-4MHz", "4-8MHz", "8-18MHz", "16-32MHz", "32-75MHz", "75-125MHz", "125-250MHz", "144-148MHz", "410-875MHz", "430-440MHz", "875-2GHz"};
    int TIFE_200KHZ = 0;
    int TIFE_300KHZ = 1;
    int TIFE_600KHZ = 2;
    int TIFE_1536KHZ = 3;
    int TIFE_5MHZ = 4;
    int TIFE_6MHZ = 5;
    int TIFE_7MHZ = 6;
    int TIFE_8MHZ = 7;
    String[] ifFilterName = new String[]{"200kHz", "300kHz", "600kHz", "1536kHz", "5MHz", "6MHz", "7MHz", "8MHz"};

    public FCD2TunerController(Device device, DeviceDescriptor descriptor) throws DeviceException {
        super("FCDPP", device, descriptor, 192000, 150L, 2050000L);
    }

    @Override
    public void init() throws DeviceException {
        super.init();
        int retried = 0;
        while (retried < 5) {
            try {
                this.setFCDMode(FCDTunerController.Mode.APPLICATION);
                return;
            }
            catch (LibUsbException e) {
                if (e.getErrorCode() == -9 || e.getErrorCode() == -7 || e.getErrorCode() == -10 || e.getErrorCode() == -6 || e.getErrorCode() == -1) {
                    ++retried;
                    Log.println("FCD Error setting mode to APPLICATION, retrying...");
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new DeviceException("Error setting Mode to APPLICATION: " + e.getMessage());
            }
            catch (Exception e) {
                throw new DeviceException("Error setting Mode to APPLICATION: " + e.getMessage());
            }
        }
    }

    @Override
    public int getCurrentSampleRate() {
        return 192000;
    }

    public void setLnaGain(boolean enabled) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_LNA_GAIN, enabled ? 1 : 0);
        }
        catch (Exception e) {
            Log.println("error while setting LNA Gain: " + e.getMessage());
            throw e;
        }
    }

    public boolean getLnaGain() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_LNA_GAIN);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte ret = buffer.get(2);
            return ret > 0;
        }
        catch (Exception e) {
            Log.println("error while getting LNA Gain: " + e.getMessage());
            throw e;
        }
    }

    public void setBiasTee(boolean enabled) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_BIAS_TEE, enabled ? 1 : 0);
        }
        catch (Exception e) {
            Log.println("error while setting Bias Tee: " + e.getMessage());
            throw e;
        }
    }

    public boolean getBiasTee() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_BIAS_TEE);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte ret = buffer.get(2);
            return ret > 0;
        }
        catch (Exception e) {
            Log.println("error while getting Bias Tee: " + e.getMessage());
            throw e;
        }
    }

    public String getRfFilter() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_RF_FILTER);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte ret = buffer.get(2);
            if (ret > -1 && ret < this.rfFilterName.length) {
                return this.rfFilterName[ret];
            }
        }
        catch (Exception e) {
            Log.println("error while getting RF Filter: " + e.getMessage());
            throw e;
        }
        return "";
    }

    public String getIfFilter() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_IF_FILTER);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte ret = buffer.get(2);
            if (ret > -1 && ret < this.ifFilterName.length) {
                return this.ifFilterName[ret];
            }
        }
        catch (Exception e) {
            Log.println("error while getting IF Filter: " + e.getMessage());
            throw e;
        }
        return "";
    }

    public int getDCCorrection() {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_DC_CORRECTION);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2);
        }
        catch (Exception e) {
            Log.println("error getting dc correction value " + e.getMessage());
            throw e;
        }
    }

    public void setDCCorrection(int value) {
        try {
            this.send(FCDCommand.APP_SET_DC_CORRECTION, value);
        }
        catch (Exception e) {
            Log.println("error setting dc correction to [" + value + "] " + e.getMessage());
            throw e;
        }
    }

    public int getIQCorrection() {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_IQ_CORRECTION);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2);
        }
        catch (Exception e) {
            Log.println("error reading IQ correction value " + e.getMessage());
            throw e;
        }
    }

    public void setIQCorrection(int value) {
        try {
            this.send(FCDCommand.APP_SET_IQ_CORRECTION, value);
        }
        catch (Exception e) {
            Log.println("error setting IQ correction to [" + value + "] " + e.getMessage());
            throw e;
        }
    }

    @Override
    public DevicePanel getDevicePanel() throws IOException, DeviceException {
        return new FcdProPlusPanel();
    }

    @Override
    public void setSampleRate(RTL2832TunerController.SampleRate sampleRate) {
    }

    public static enum Block {
        CELLULAR_BAND_BLOCKED("Blocked"),
        NO_BAND_BLOCK("Unblocked"),
        UNKNOWN("Unknown");

        private String mLabel;

        private Block(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static Block getBlock(String block) {
            Block retVal = UNKNOWN;
            if (block.equalsIgnoreCase("No blk")) {
                retVal = NO_BAND_BLOCK;
            } else if (block.equalsIgnoreCase("Cell blk")) {
                retVal = CELLULAR_BAND_BLOCKED;
            }
            return retVal;
        }
    }
}

