/*
 * Decompiled with CFR 0.152.
 */
package device.fcd;

import common.Config;
import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.TunerController;
import device.fcd.FCD1TunerController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FcdProPanel
extends DevicePanel
implements ItemListener,
ActionListener,
Runnable {
    int NUM_OF_PARAMS = 15;
    JComboBox cbMixerGain;
    JComboBox cbLnaGain;
    JTextField rfFilterValue;
    JTextField bandValue;
    JTextField ifFilterValue;

    public FcdProPanel() throws IOException, DeviceException {
        TitledBorder title = new TitledBorder(null, "Funcube Dongle Pro", 4, 2, null, null);
        this.setBorder(title);
        this.initializeGui();
    }

    @Override
    public void setEnabled(boolean b) {
        this.cbMixerGain.setEnabled(b);
        this.cbLnaGain.setEnabled(b);
    }

    public void initializeGui() throws IOException, DeviceException {
        this.setLayout(new BorderLayout(3, 3));
        JPanel center = new JPanel();
        this.add((Component)center, "North");
        center.setLayout(new BoxLayout(center, 0));
        JLabel lblLna = new JLabel("LNA Gain");
        center.add(lblLna);
        this.cbLnaGain = new JComboBox<String>(FCD1TunerController.lnaGain);
        center.add(this.cbLnaGain);
        this.cbLnaGain.addItemListener(this);
        JLabel lblMix = new JLabel("    Mixer Gain");
        center.add(lblMix);
        this.cbMixerGain = new JComboBox<String>(FCD1TunerController.mixerGain);
        center.add(this.cbMixerGain);
        this.cbMixerGain.addItemListener(this);
        JLabel lblband = new JLabel("    Band");
        center.add(lblband);
        this.bandValue = new JTextField();
        this.bandValue.setMinimumSize(new Dimension(40, 10));
        this.bandValue.setEnabled(false);
        center.add(this.bandValue);
        JLabel rfFilter = new JLabel("    RF Filter");
        center.add(rfFilter);
        this.rfFilterValue = new JTextField();
        this.rfFilterValue.setMinimumSize(new Dimension(70, 10));
        this.rfFilterValue.setEnabled(false);
        center.add(this.rfFilterValue);
    }

    @Override
    public void setDevice(TunerController fcd) throws IOException, DeviceException {
        this.setFcd((FCD1TunerController)fcd);
    }

    public void setFcd(FCD1TunerController f) throws IOException, DeviceException {
        this.device = f;
        this.getSettings();
    }

    @Override
    public void updateFilter() throws IOException, DeviceException {
        this.rfFilterValue.setText(((FCD1TunerController)this.device).getRfFilter());
        this.bandValue.setText(((FCD1TunerController)this.device).getBand());
    }

    public void getSettings() throws IOException, DeviceException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.loadParam(this.cbLnaGain, "cbLnaGain");
        this.setLnaGain(this.cbLnaGain.getSelectedIndex());
        this.loadParam(this.cbMixerGain, "cbMixerGain");
        this.setMixerGain(this.cbMixerGain.getSelectedIndex());
        this.rfFilterValue.setText(((FCD1TunerController)this.device).getRfFilter());
        this.bandValue.setText(((FCD1TunerController)this.device).getBand());
    }

    @Override
    public void run() {
        this.done = false;
        this.running = true;
        Thread.currentThread().setName("FCDProPanel");
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: FCD thread interrupted");
            }
            if (this.device == null) continue;
            try {
                this.getSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
            this.repaint();
        }
    }

    private void setLnaGain(int position) {
        try {
            ((FCD1TunerController)this.device).setLnaGain(position);
        }
        catch (DeviceException e1) {
            Log.println("Error setting LNA Gain on FCD");
            e1.printStackTrace(Log.getWriter());
        }
        if (Config.saveFcdParams) {
            this.saveParam(this.cbLnaGain, "cbLnaGain");
            Config.save();
        }
    }

    private void setMixerGain(int position) {
        try {
            if (position == 1) {
                ((FCD1TunerController)this.device).setMixerGain(true);
            } else {
                ((FCD1TunerController)this.device).setMixerGain(false);
            }
        }
        catch (DeviceException e1) {
            Log.println("Error setting LNA Gain on FCD");
            e1.printStackTrace(Log.getWriter());
        }
        if (Config.saveFcdParams) {
            this.saveParam(this.cbMixerGain, "cbMixerGain");
            Config.save();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbMixerGain) {
            this.setMixerGain(this.cbMixerGain.getSelectedIndex());
        }
        if (e.getSource() == this.cbLnaGain) {
            this.setLnaGain(this.cbLnaGain.getSelectedIndex());
        }
    }

    @Override
    public int getSampleRate() {
        return 96000;
    }

    @Override
    public int getDecimationRate() {
        return 1;
    }
}

