/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Log;

public class PolyPhaseFilter {
    double[] xcoeffs;
    double gain = 1.0;
    int M;
    double alpha = 0.5;
    double Fc = 0.0;
    int R = 0;
    SubFilter[] subFilters;

    public PolyPhaseFilter(double sampleRate, double freq, int decimationRate, int len) {
        this.R = decimationRate;
        this.init(sampleRate, freq, len);
        this.M = len - 1;
    }

    private void init(double sampleRate, double freq, int len) {
        this.M = len;
        this.xcoeffs = new double[this.M + 1];
        this.Fc = freq / sampleRate;
        double sumofsquares = 0.0;
        double[] tempCoeffs = new double[this.M + 1];
        int limit = (int)(0.5 / (this.alpha * this.Fc));
        int i = 0;
        while (i <= this.M) {
            double sinc = Math.sin(Math.PI * 2 * this.Fc * (double)(i - this.M / 2)) / (double)(i - this.M / 2);
            double cos = Math.cos(this.alpha * Math.PI * this.Fc * (double)(i - this.M / 2)) / (1.0 - Math.pow(2.0 * this.alpha * this.Fc * (double)(i - this.M / 2), 2.0));
            tempCoeffs[i] = i == this.M / 2 ? Math.PI * 2 * this.Fc * cos : sinc * cos;
            if (i - this.M / 2 == limit || i - this.M / 2 == -limit) {
                tempCoeffs[i] = 0.7853981633974483 * sinc;
            }
            sumofsquares += tempCoeffs[i] * tempCoeffs[i];
            ++i;
        }
        this.gain = Math.sqrt(sumofsquares);
        Log.println("Raised Cosine PolyPhase Filter GAIN: " + this.gain);
        i = 0;
        while (i < tempCoeffs.length) {
            this.xcoeffs[i] = tempCoeffs[tempCoeffs.length - i - 1] / this.gain;
            ++i;
        }
        this.subFilters = new SubFilter[this.R];
        int P = this.R - 1;
        int j = 0;
        while (j < this.R) {
            double[] taps = new double[this.M / this.R];
            int i2 = 0;
            while (i2 < this.M / this.R) {
                taps[i2] = this.xcoeffs[P + i2 * this.R];
                ++i2;
            }
            this.subFilters[j] = new SubFilter(taps);
            if (--P < 0) {
                P = this.R - 1;
            }
            ++j;
        }
    }

    public double filterDouble(double[] in) {
        if (this.subFilters == null) {
            return 0.0;
        }
        int j = in.length - 1;
        double sum = 0.0;
        int i = 0;
        while (i < in.length) {
            sum += this.subFilters[i].filter(in[j--]);
            ++i;
        }
        return sum;
    }

    public static void main(String[] args) {
        PolyPhaseFilter f = new PolyPhaseFilter(48000.0, 12000.0, 4, 12);
        double[] in = new double[]{1.0, 2.0, 3.0, 4.0};
        int j = 0;
        while (j < 12) {
            f.filterDouble(in);
            ++j;
        }
    }

    private class SubFilter {
        int M;
        double[] coeff;
        double[] xv;

        SubFilter(double[] taps) {
            this.coeff = taps;
            this.M = taps.length - 1;
            this.xv = new double[this.M + 1];
        }

        public double filter(double in) {
            int i = 0;
            while (i < this.M) {
                this.xv[i] = this.xv[i + 1];
                ++i;
            }
            this.xv[this.M] = in;
            double sum = 0.0;
            i = 0;
            while (i <= this.M) {
                sum += this.coeff[i] * this.xv[i];
                ++i;
            }
            return sum;
        }
    }
}

