/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.herci.HerciHSTab;
import gui.herci.HerciLSTab;
import gui.legacyTabs.CameraTab;
import gui.legacyTabs.VulcanTab;
import gui.legacyTabs.WodVulcanTab;
import gui.mesat1.MesatCameraTab;
import gui.tabs.CanExperimentTab;
import gui.tabs.FoxTelemTab;
import gui.tabs.HealthTabRt;
import gui.tabs.ModuleTab;
import gui.tabs.MyMeasurementsTab;
import gui.tabs.NamedExperimentTab;
import gui.tabs.WodHealthTab;
import gui.tabs.WodNamedExperimentTab;
import gui.uw.UwExperimentTab;
import gui.uw.WodUwExperimentTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;

public class SpacecraftTab
extends JPanel {
    Spacecraft sat;
    JTabbedPane tabbedPane;
    MyMeasurementsTab measurementsTab;
    Thread healthThread;
    Thread experimentThread;
    Thread cameraThread;
    Thread herciThread;
    Thread measurementThread;
    Thread wodHealthThread;

    public SpacecraftTab(Spacecraft s) {
        this.sat = s;
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.tabbedPane, "Center");
        this.createTabs(this.sat);
    }

    public void showGraphs() {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            FoxTelemTab tab;
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof ModuleTab && (tab = (ModuleTab)comp) != null) {
                ((ModuleTab)tab).showGraphs();
            }
            if (comp instanceof MyMeasurementsTab && (tab = (MyMeasurementsTab)comp) != null) {
                ((MyMeasurementsTab)tab).showGraphs();
            }
            ++i;
        }
    }

    public void refreshTabs(Spacecraft fox, boolean closeGraphs) {
        this.closeTabs(fox, closeGraphs);
        this.createTabs(fox);
    }

    public void closeTabs(Spacecraft fox, boolean closeGraphs) {
        this.sat = fox;
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            FoxTelemTab tab;
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof ModuleTab && (tab = (ModuleTab)comp) != null) {
                if (closeGraphs) {
                    ((ModuleTab)tab).closeGraphs();
                }
                tab.remove(tab);
            }
            if (comp instanceof MyMeasurementsTab && (tab = (MyMeasurementsTab)comp) != null) {
                if (closeGraphs) {
                    ((MyMeasurementsTab)tab).closeGraphs();
                }
                tab.remove(tab);
            }
            ++i;
        }
    }

    public void createTabs(Spacecraft fox) {
        if (fox.hasFOXDB_V3) {
            this.addTabs();
            this.addSpecialV3DBTabs();
        } else {
            this.addLegacyTabs();
        }
        this.addMeasurementsTab(this.sat);
    }

    public void stop() {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            ModuleTab tab;
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof ModuleTab && (tab = (ModuleTab)comp) != null) {
                this.stopThreads(tab);
            }
            ++i;
        }
    }

    private void addTabs() {
        this.stop();
        BitArrayLayout[] bitArrayLayoutArray = this.sat.layout;
        int n = this.sat.layout.length;
        int n2 = 0;
        while (n2 < n) {
            BitArrayLayout lay = bitArrayLayoutArray[n2];
            if (!lay.isSecondaryPayload()) {
                if (lay.isRealTime()) {
                    HealthTabRt healthTab = null;
                    try {
                        healthTab = new HealthTabRt(this.sat);
                    }
                    catch (LayoutLoadException e) {
                        Log.errorDialog("ERROR loading health tab", "" + e);
                        e.printStackTrace(Log.getWriter());
                        System.exit(1);
                    }
                    Thread healthThread = new Thread(healthTab);
                    healthThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                    healthThread.start();
                    String HEALTH = "Health";
                    this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + HEALTH + "</b></body></html>", healthTab);
                }
                if (lay.isWOD()) {
                    WodHealthTab wodHealthTab = null;
                    try {
                        wodHealthTab = new WodHealthTab(this.sat);
                    }
                    catch (LayoutLoadException e) {
                        Log.errorDialog("ERROR loading WOD tab", "" + e);
                        e.printStackTrace(Log.getWriter());
                        System.exit(1);
                    }
                    Thread wodHealthThread = new Thread(wodHealthTab);
                    wodHealthThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                    wodHealthThread.start();
                    String WOD = "WOD";
                    this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + WOD + "</b></body></html>", wodHealthTab);
                }
                if (lay.isExperiment()) {
                    try {
                        this.addNamedExperimentTab(this.sat, lay);
                    }
                    catch (Exception e) {
                        e.printStackTrace(Log.getWriter());
                        Log.errorDialog("Layout Failure", "Failed to setup Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove the experiement if it is not valid\n" + e);
                    }
                }
                if (lay.isWODExperiment()) {
                    try {
                        this.addWodNamedExpTab(this.sat, lay);
                    }
                    catch (Exception e) {
                        e.printStackTrace(Log.getWriter());
                        Log.errorDialog("Layout Failure", "Failed to setup WOD Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove the experiement if it is not valid\n" + e);
                    }
                }
                if (lay.isCanExperiment()) {
                    try {
                        this.addCanExperimentTab(this.sat, lay);
                    }
                    catch (Exception e) {
                        e.printStackTrace(Log.getWriter());
                        Log.errorDialog("Layout Failure", "Failed to setup CAN Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove the experiement if it is not valid\n" + e);
                    }
                }
                if (lay.isCanWodExperiment()) {
                    try {
                        this.addCanWodExperimentTab(this.sat, lay);
                    }
                    catch (Exception e) {
                        e.printStackTrace(Log.getWriter());
                        Log.errorDialog("Layout Failure", "Failed to setup CAN WOD Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove the experiement if it is not valid\n" + e);
                    }
                }
            }
            ++n2;
        }
    }

    private void addSpecialV3DBTabs() {
        int[] nArray = this.sat.experiments;
        int n = this.sat.experiments.length;
        int n2 = 0;
        while (n2 < n) {
            int exp = nArray[n2];
            if (exp == 12) {
                try {
                    this.addMesatCameraTab(this.sat);
                }
                catch (Exception e) {
                    e.printStackTrace(Log.getWriter());
                    Log.errorDialog("Layout Failure", "Failed to setup MESAT1 Camera tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
                }
            }
            ++n2;
        }
    }

    private void addLegacyTabs() {
        this.stop();
        HealthTabRt healthTab = null;
        try {
            healthTab = new HealthTabRt(this.sat);
        }
        catch (LayoutLoadException e1) {
            Log.errorDialog("ERROR loading health tab", "" + e1);
            e1.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.healthThread = new Thread(healthTab);
        this.healthThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.healthThread.start();
        String HEALTH = "Health";
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + HEALTH + "</b></body></html>", healthTab);
        if (this.sat.getLayoutIdxByName("wodtelemetry") != -1) {
            try {
                this.addWodTab(this.sat);
            }
            catch (Exception e) {
                e.printStackTrace(Log.getWriter());
                Log.errorDialog("Layout Failure", "Failed to setup Whole Orbit Data tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this layout if it is not valid\n" + e);
            }
        }
        int[] nArray = this.sat.experiments;
        int n = this.sat.experiments.length;
        int n2 = 0;
        while (n2 < n) {
            int exp = nArray[n2];
            if (exp == 1) {
                try {
                    this.addExperimentTab(this.sat);
                }
                catch (Exception e) {
                    e.printStackTrace(Log.getWriter());
                    Log.errorDialog("Layout Failure", "Failed to setup Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove the experiement if it is not valid\n" + e);
                }
                if (this.sat.getLayoutIdxByName("wodradtelemetry") != -1) {
                    try {
                        this.addWodExpTab(this.sat);
                    }
                    catch (Exception e) {
                        e.printStackTrace(Log.getWriter());
                        Log.errorDialog("Layout Failure", "Failed to setup WOD Experiment tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
                    }
                }
            }
            if (exp == 2 || exp == 5) {
                try {
                    this.addCameraTab(this.sat);
                }
                catch (Exception e) {
                    e.printStackTrace(Log.getWriter());
                    Log.errorDialog("Layout Failure", "Failed to setup VT Camera tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
                }
            }
            if (exp == 3) {
                try {
                    this.addHerciHSTab(this.sat);
                    this.addHerciLSTab(this.sat);
                }
                catch (Exception e) {
                    e.printStackTrace(Log.getWriter());
                    Log.errorDialog("Layout Failure", "Failed to setup IOWA HERCI tabs for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
                }
            }
            if (exp == 9) {
                try {
                    this.addUwExperimentTab(this.sat);
                }
                catch (Exception e) {
                    e.printStackTrace(Log.getWriter());
                    Log.errorDialog("Layout Failure", "Failed to setup UW Experiement tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
                }
            }
            ++n2;
        }
        if (this.sat.getLayoutIdxByName("wodcantelemetry") != -1) {
            try {
                this.addUwWodExperimentTab(this.sat);
            }
            catch (Exception e) {
                e.printStackTrace(Log.getWriter());
                Log.errorDialog("Layout Failure", "Failed to setup UW WOD tab for sat: " + this.sat.user_display_name + "\nCheck the Spacecraft.dat file and remove this experiement if it is not valid\n" + e);
            }
        }
    }

    private void addWodTab(Spacecraft fox) {
        WodHealthTab wodHealthTab = null;
        try {
            wodHealthTab = new WodHealthTab(this.sat);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR loading WOD tab", "" + e);
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.wodHealthThread = new Thread(wodHealthTab);
        this.wodHealthThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.wodHealthThread.start();
        String WOD = "WOD";
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + WOD + "</b></body></html>", wodHealthTab);
    }

    private void addWodExpTab(Spacecraft fox) {
        WodVulcanTab wodExperimentTab = new WodVulcanTab(fox);
        Thread wodExperimentThread = new Thread(wodExperimentTab);
        wodExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        wodExperimentThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>VU Rad WOD</body></html>", wodExperimentTab);
    }

    private void addExperimentTab(Spacecraft fox) {
        VulcanTab experimentTab = new VulcanTab(fox, 5);
        this.experimentThread = new Thread(experimentTab);
        this.experimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.experimentThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1> VU Rad (" + fox.getIdString() + ")</body></html>", experimentTab);
    }

    private void addNamedExperimentTab(Spacecraft fox, BitArrayLayout layout) {
        BitArrayLayout secondaryLayout = fox.getSecondaryLayoutFromPrimaryName(layout.name);
        String title = "Experiment: " + layout.name;
        if (layout.title != null && !layout.title.equalsIgnoreCase("")) {
            title = layout.title;
        }
        NamedExperimentTab ragExperimentTab = new NamedExperimentTab(fox, title, layout, secondaryLayout, 5);
        Thread ragExperimentThread = new Thread(ragExperimentTab);
        ragExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        ragExperimentThread.start();
        String shortTitle = layout.name;
        if (layout.shortTitle != null && !layout.shortTitle.equalsIgnoreCase("")) {
            shortTitle = layout.shortTitle;
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>" + shortTitle + "</body></html>", ragExperimentTab);
    }

    private void addWodNamedExpTab(Spacecraft fox, BitArrayLayout layout) {
        BitArrayLayout secondaryLayout = fox.getSecondaryLayoutFromPrimaryName(layout.name);
        String title = "Experiment: " + layout.name;
        if (layout.title != null && !layout.title.equalsIgnoreCase("")) {
            title = layout.title;
        }
        WodNamedExperimentTab wodExperimentTab = new WodNamedExperimentTab(fox, title, layout, secondaryLayout, 8);
        Thread wodExperimentThread = new Thread(wodExperimentTab);
        wodExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        wodExperimentThread.start();
        String shortTitle = layout.name;
        if (layout.shortTitle != null && !layout.shortTitle.equalsIgnoreCase("")) {
            shortTitle = layout.shortTitle;
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>" + shortTitle + "</body></html>", wodExperimentTab);
    }

    private void addCanExperimentTab(Spacecraft fox, BitArrayLayout layout) {
        String title = "Experiment: " + layout.name;
        if (layout.title != null && !layout.title.equalsIgnoreCase("")) {
            title = layout.title;
        }
        BitArrayLayout canPktLayout = Config.satManager.getLayoutByName(fox.foxId, "canpacket");
        CanExperimentTab canExperimentTab = new CanExperimentTab(fox, title, layout, canPktLayout, 5);
        Thread ragExperimentThread = new Thread(canExperimentTab);
        ragExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        ragExperimentThread.start();
        String shortTitle = layout.name;
        if (layout.shortTitle != null && !layout.shortTitle.equalsIgnoreCase("")) {
            shortTitle = layout.shortTitle;
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>" + shortTitle + "</body></html>", canExperimentTab);
    }

    private void addCanWodExperimentTab(Spacecraft fox, BitArrayLayout layout) {
        String title = "WOD Experiment: " + layout.name;
        if (layout.title != null && !layout.title.equalsIgnoreCase("")) {
            title = layout.title;
        }
        BitArrayLayout canPktLayout = Config.satManager.getLayoutByName(fox.foxId, "wodcanpacket");
        CanExperimentTab canExperimentTab = new CanExperimentTab(fox, title, layout, canPktLayout, 5);
        Thread ragExperimentThread = new Thread(canExperimentTab);
        ragExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        ragExperimentThread.start();
        String shortTitle = layout.name;
        if (layout.shortTitle != null && !layout.shortTitle.equalsIgnoreCase("")) {
            shortTitle = layout.shortTitle;
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>" + shortTitle + "</body></html>", canExperimentTab);
    }

    private void addUwExperimentTab(Spacecraft fox) {
        UwExperimentTab experimentTab = new UwExperimentTab(fox, 11);
        this.experimentThread = new Thread(experimentTab);
        this.experimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.experimentThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>CAN Pkts</body></html>", experimentTab);
    }

    private void addUwWodExperimentTab(Spacecraft fox) {
        WodUwExperimentTab wodExperimentTab = new WodUwExperimentTab(fox);
        Thread wodExperimentThread = new Thread(wodExperimentTab);
        wodExperimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        wodExperimentThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1>CAN Pkt WOD</body></html>", wodExperimentTab);
    }

    private void addHerciLSTab(Spacecraft fox) {
        HerciLSTab experimentTab = new HerciLSTab(fox);
        this.experimentThread = new Thread(experimentTab);
        this.experimentThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.experimentThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1> HERCI HK (" + fox.getIdString() + ")</body></html>", experimentTab);
    }

    private void addHerciHSTab(Spacecraft fox) {
        HerciHSTab herciTab = new HerciHSTab(fox);
        this.herciThread = new Thread(herciTab);
        this.herciThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.herciThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1> HERCI (" + fox.getIdString() + ")</body></html>", herciTab);
    }

    private void addCameraTab(Spacecraft fox) {
        CameraTab cameraTab = new CameraTab(fox);
        this.cameraThread = new Thread(cameraTab);
        this.cameraThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.cameraThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1> Camera (" + fox.getIdString() + ")</body></html>", cameraTab);
    }

    private void addMesatCameraTab(Spacecraft fox) {
        MesatCameraTab cameraTab = new MesatCameraTab(fox);
        this.cameraThread = new Thread(cameraTab);
        this.cameraThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.cameraThread.start();
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1> Multispectral Camera</body></html>", cameraTab);
    }

    private void addMeasurementsTab(Spacecraft fox) {
        if (this.measurementsTab != null) {
            this.measurementsTab.stopProcessing();
            while (!this.measurementsTab.isDone()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
        this.measurementsTab = new MyMeasurementsTab(fox);
        this.measurementsTab.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.addTab("<html><body leftmargin=5 topmargin=8 marginwidth=5 marginheight=5>Measurements</body></html>", this.measurementsTab);
        Thread measurementThread = new Thread(this.measurementsTab);
        measurementThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        measurementThread.start();
    }

    private void stopThreads(FoxTelemTab tab) {
        if (tab != null) {
            tab.stopProcessing();
            while (!tab.isDone()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
    }

    public void closeGraphs() {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            FoxTelemTab tab;
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof ModuleTab && (tab = (ModuleTab)comp) != null) {
                ((ModuleTab)tab).closeGraphs();
            }
            if (comp instanceof MyMeasurementsTab && (tab = (MyMeasurementsTab)comp) != null) {
                ((MyMeasurementsTab)tab).closeGraphs();
            }
            ++i;
        }
    }
}

