/*
 * Decompiled with CFR 0.152.
 */
package gui.legacyTabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.legacyTabs.VulcanTab;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import javax.swing.JTable;
import telemetry.legacyPayloads.RadiationTelemetry;

public class WodVulcanTab
extends VulcanTab {
    private static final long serialVersionUID = 1L;

    public WodVulcanTab(Spacecraft sat) {
        super(sat, 8);
    }

    @Override
    protected void parseExperimentFrames() {
        if (Config.displayRawRadData) {
            String[][] data = Config.payloadStore.getWODRadData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.radTableModel);
            }
        } else if (this.displayTelem) {
            String[][] data = Config.payloadStore.getWodRadTelemData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseTelemetry(data);
            }
            this.topHalfPackets.setVisible(false);
            this.bottomHalfPackets.setVisible(false);
            this.topHalf.setVisible(true);
        } else {
            String[][] data = Config.payloadStore.getRadData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data.length > 0) {
                this.parsePackets(data);
            }
            this.topHalfPackets.setVisible(true);
            this.bottomHalfPackets.setVisible(true);
            this.topHalf.setVisible(false);
            this.bottomHalf.setVisible(false);
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        MainWindow.frame.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodradtelemetry2"), true);
        }
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.updateTab((RadiationTelemetry)Config.payloadStore.getFramePart(this.foxId, reset, uptime, "wodradtelemetry2", false), false);
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("WodVulcanTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: WOD Vulcan Tab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized() || (frames = Config.payloadStore.getNumberOfFrames(this.foxId, "wodradtelemetry")) == currentFrames) continue;
            currentFrames = frames;
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodradtelemetry2"), true);
            this.displayFramesDecoded(frames);
            MainWindow.setTotalDecodes();
            this.parseExperimentFrames();
            Config.payloadStore.setUpdated(this.foxId, "wodradtelemetry", false);
            if (justStarted) {
                this.openGraphs();
                justStarted = false;
            }
            MainWindow.frame.repaint();
        }
        this.done = true;
    }
}

