/*
 * Decompiled with CFR 0.152.
 */
package measure;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import measure.Measurement;
import measure.PassMeasurement;
import measure.RtMeasurement;
import measure.SortedMeasurementArrayList;
import telemetry.SatPayloadTable;

public class SatMeasurementStore {
    private static final int INIT_SIZE = 1000;
    public static final int RT_MEASUREMENT_TYPE = -1;
    public static final int PASS_MEASUREMENT_TYPE = -2;
    public static final int UTC_COL = 3;
    public int foxId;
    public static String PASS_LOG = "passmeasurements2.log";
    public static String OLD_PASS_LOG = "passmeasurements.log";
    public static String RT_LOG = "rtmeasurements.log";
    public String rtFileName;
    public String passFileName;
    SortedMeasurementArrayList rtRecords;
    SortedMeasurementArrayList passRecords;
    boolean updatedRt = false;
    boolean updatedPass = false;

    public SatMeasurementStore(int id) {
        this.foxId = id;
        this.initArrays();
        Spacecraft fox = Config.satManager.getSpacecraft(this.foxId);
        try {
            File aFile;
            if (fox.hasFOXDB_V3) {
                String series = fox.series;
                this.rtFileName = String.valueOf(series) + id + RT_LOG;
                this.passFileName = String.valueOf(series) + id + PASS_LOG;
            } else {
                this.rtFileName = "Fox" + id + RT_LOG;
                this.passFileName = "Fox" + id + PASS_LOG;
            }
            String testFile = this.passFileName;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                testFile = String.valueOf(Config.logFileDirectory) + File.separator + testFile;
            }
            if (!(aFile = new File(testFile)).exists()) {
                try {
                    this.convertPassMeasures();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR converting old pass measurements", 0);
                    e.printStackTrace(Log.getWriter());
                }
            } else {
                this.load(this.passFileName, false);
            }
            this.load(this.rtFileName, false);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR Loading Stored Payload data", 0);
            e.printStackTrace(Log.getWriter());
        }
    }

    private void initArrays() {
        this.rtRecords = new SortedMeasurementArrayList(1000);
        this.passRecords = new SortedMeasurementArrayList(1000);
    }

    public boolean getUpdatedMeasurement() {
        return this.updatedRt;
    }

    public void setUpdatedMeasurement(boolean u) {
        this.updatedRt = u;
    }

    public boolean getUpdatedPassMeasurement() {
        return this.updatedPass;
    }

    public void setUpdatedPassMeasurement(boolean u) {
        this.updatedPass = u;
    }

    public void setUpdatedAll() {
        this.updatedRt = true;
        this.updatedPass = true;
    }

    public int getNumberOfMeasurements() {
        return this.rtRecords.size();
    }

    public int getNumberOfPassMeasurements() {
        return this.passRecords.size();
    }

    public boolean add(int id, Measurement m) throws IOException {
        if (m instanceof RtMeasurement) {
            try {
                this.save(m, this.rtFileName);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            this.rtRecords.add(m);
            this.updatedRt = true;
            return true;
        }
        if (m instanceof PassMeasurement) {
            try {
                this.save(m, this.passFileName);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            this.passRecords.add(m);
            this.updatedPass = true;
            return true;
        }
        return false;
    }

    public RtMeasurement getLatestMeasurement() {
        if (this.rtRecords.size() == 0) {
            return null;
        }
        return (RtMeasurement)this.rtRecords.get(this.rtRecords.size() - 1);
    }

    public PassMeasurement getLatestPassMeasurement() {
        if (this.passRecords.size() == 0) {
            return null;
        }
        return (PassMeasurement)this.passRecords.get(this.passRecords.size() - 1);
    }

    public double[][] getMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        return this.getGraphData(this.rtRecords, name, period, fox, fromReset, fromUptime, reverse);
    }

    public double[][] getPassMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        return this.getGraphData(this.passRecords, name, period, fox, fromReset, fromUptime, reverse);
    }

    public double[][] getGraphData(SortedMeasurementArrayList rtRecords, String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        int start = 0;
        int end = 0;
        if (reverse) {
            start = rtRecords.size() - period;
            end = rtRecords.size();
        } else {
            start = rtRecords.getNearestFrameIndex(fox.foxId, fromUptime, fromReset);
            if (start == -1) {
                start = rtRecords.size() - period;
            }
            end = start + period;
        }
        if (end > rtRecords.size()) {
            end = rtRecords.size();
        }
        if (end < start) {
            end = start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > rtRecords.size()) {
            start = rtRecords.size();
        }
        double[] results = new double[end - start];
        double[] upTime = new double[end - start];
        double[] resets = new double[end - start];
        double[] dates = new double[end - start];
        int validRecords = 0;
        int j = results.length - 1;
        int i = end - 1;
        while (i >= start) {
            Measurement m = (Measurement)rtRecords.get(i);
            double result = m instanceof RtMeasurement ? ((RtMeasurement)rtRecords.get(i)).getRawValue(name) : (double)((PassMeasurement)rtRecords.get(i)).getRawValue(name);
            results[j] = result;
            upTime[j] = ((Measurement)rtRecords.get((int)i)).uptime;
            resets[j] = ((Measurement)rtRecords.get((int)i)).reset;
            dates[j--] = ((Measurement)rtRecords.get((int)i)).date.getTime();
            ++validRecords;
            --i;
        }
        double[][] resultSet = new double[4][validRecords];
        int i2 = j + 1;
        while (i2 < results.length) {
            resultSet[0][i2 - j - 1] = results[i2];
            resultSet[1][i2 - j - 1] = upTime[i2];
            resultSet[2][i2 - j - 1] = resets[i2];
            resultSet[3][i2 - j - 1] = dates[i2];
            ++i2;
        }
        return resultSet;
    }

    /*
     * Loose catch block
     */
    public void load(String log, boolean load103) throws FileNotFoundException {
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        Log.println("Loading: " + log);
        File aFile = new File(log);
        if (!aFile.exists()) {
            try {
                aFile.createNewFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR creating file " + log, 0);
                e.printStackTrace(Log.getWriter());
            }
        }
        BufferedReader dis = new BufferedReader(new FileReader(log));
        try {
            try {
                String line;
                while ((line = dis.readLine()) != null) {
                    Measurement rt;
                    if (line == null) continue;
                    StringTokenizer st = new StringTokenizer(line, ",");
                    String date = st.nextToken();
                    int id = Integer.valueOf(st.nextToken());
                    int reset = Integer.valueOf(st.nextToken());
                    long uptime = Long.valueOf(st.nextToken());
                    int type = Integer.valueOf(st.nextToken());
                    if (Config.satManager.getSpacecraft(id) == null) {
                        Log.errorDialog("FATAL", "Attempting to Load payloads from the Payload store for satellite with Fox Id: " + id + "\n when no sattellite with that FoxId is configured.  Add this spacecraft to the satellite directory and restart FoxTelem." + "\nProgram will now exit");
                        System.exit(1);
                    }
                    if (type == -1 || type == 1) {
                        rt = new RtMeasurement(id, date, reset, uptime, -1, st);
                        this.rtRecords.add(rt);
                        this.updatedRt = true;
                    }
                    if (type != -2 && type != 2) continue;
                    rt = null;
                    if (load103) {
                        rt = new PassMeasurement(id, date, reset, uptime, -2, null);
                        ((PassMeasurement)rt).load103(st);
                    } else {
                        rt = new PassMeasurement(id, date, reset, uptime, -2, st);
                    }
                    this.passRecords.add(rt);
                    this.updatedPass = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                try {
                    dis.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace(Log.getWriter());
                }
            }
            catch (NumberFormatException n) {
                n.printStackTrace(Log.getWriter());
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
            catch (NoSuchElementException n) {
                n.printStackTrace(Log.getWriter());
                Log.errorDialog("ERROR: Corrupted record", "Can not load logfile, it appears to be corrupt. If this is test data \nuse File>Delete Payloads once FoxTelem has started\nThis record will be ignored.");
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    dis.close();
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    public void save(Measurement measurement, String log) throws IOException {
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        boolean appendNewLine = false;
        File aFile = new File(log);
        if (!aFile.exists()) {
            aFile.createNewFile();
        } else if (!SatPayloadTable.newLineExists(log)) {
            appendNewLine = true;
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
        try {
            if (appendNewLine) {
                output.write("\n");
            }
            if (measurement instanceof RtMeasurement) {
                output.write(String.valueOf(((RtMeasurement)measurement).toFile()) + "\n");
            } else {
                output.write(String.valueOf(((PassMeasurement)measurement).toFile()) + "\n");
            }
            ((Writer)output).flush();
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public void deleteAll() {
        String dir = "";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator;
        }
        try {
            SatMeasurementStore.remove(String.valueOf(dir) + this.rtFileName);
            SatMeasurementStore.remove(String.valueOf(dir) + this.passFileName);
            this.initArrays();
            this.setUpdatedAll();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting Measurement Files for FoxId:" + this.foxId + ", check permissions", 0);
        }
    }

    public static void remove(String f) throws IOException {
        block3: {
            try {
                File file = new File(f);
                if (!file.exists()) break block3;
                if (file.delete()) {
                    Log.println(String.valueOf(file.getName()) + " is deleted!");
                    break block3;
                }
                Log.println("Delete operation failed for: " + file.getName());
                throw new IOException("Could not delete file " + file.getName() + " Check the file system and remove it manually.");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting File", 0);
            }
        }
    }

    public void convertPassMeasures() throws IOException {
        String dir = "";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator;
        }
        String oldlog = "Fox" + this.foxId + OLD_PASS_LOG;
        String log = "Fox" + this.foxId + PASS_LOG;
        File aFile = new File(String.valueOf(dir) + oldlog);
        if (aFile.exists()) {
            Log.println("CONVERTING " + oldlog + " to " + log);
            this.load(oldlog, true);
            Log.println("Loaded: " + this.passRecords.size() + " records");
            for (Measurement m : this.passRecords) {
                PassMeasurement p = (PassMeasurement)m;
                this.save(p, log);
            }
        }
    }

    public int getNumberOfPayloadsBetweenTimestamps(int id, int reset, long uptime, int toReset, long toUptime, String payloadType) {
        if (payloadType == "measurements") {
            try {
                return this.rtRecords.getNumberOfPayloadsBetweenTimestamps(reset, uptime, toReset, toUptime);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                return 0;
            }
        }
        if (payloadType == "passmeasurements") {
            try {
                return this.passRecords.getNumberOfPayloadsBetweenTimestamps(reset, uptime, toReset, toUptime);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                return 0;
            }
        }
        return 0;
    }
}

