/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.DesktopApi;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import spacecraftEditor.EditorSettingsFrame;
import spacecraftEditor.SpacecraftEditTab;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;

public class SpacecraftEditorWindow
extends JFrame
implements WindowListener,
ActionListener {
    public static final String VERSION_NUM = "1.02c";
    public static final String VERSION = "1.02c - 24 Jan 2025";
    public static final String MANUAL = "amsat_editor_manual.pdf";
    public static final String HANDBOOK = "amsat_telemetry_designers_handbook.pdf";
    static JFileChooser fc = null;
    static JLabel lblHomeDir;
    static FileDialog fd;
    JMenuBar menuBar;
    JMenuItem mntmExit;
    JMenuItem mntmNewSpacecraftFile;
    JMenuItem mntmAddSpacecraftFile;
    JMenuItem mntmRemoveSpacecraftFile;
    JMenuItem mntmSettings;
    JMenuItem mntmHelpAbout;
    JMenuItem mntmHelpManual;
    JMenuItem mntmHelpHandbook;
    JTabbedPane tabbedPane;
    ArrayList<Spacecraft> sats;
    SpacecraftEditTab[] spacecraftTab;
    private static final long serialVersionUID = 1L;

    static {
        fd = null;
    }

    public SpacecraftEditorWindow() {
        this.initialize();
        JPanel mainPanel = new JPanel();
        this.initMenu();
        this.getContentPane().add(mainPanel);
        this.layoutMainPanel(mainPanel);
    }

    private void initialize() {
        this.loadProperties();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/fox.jpg")));
        this.setTitle("AMSAT Spacecraft Editor");
        fd = new FileDialog((Frame)MainWindow.frame, "Select Spacecraft file", 0);
        fc = new JFileChooser();
    }

    private void initMenu() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu mnFile = new JMenu("File");
        this.menuBar.add(mnFile);
        this.mntmNewSpacecraftFile = new JMenuItem("New Spacecraft");
        mnFile.add(this.mntmNewSpacecraftFile);
        this.mntmNewSpacecraftFile.addActionListener(this);
        this.mntmAddSpacecraftFile = new JMenuItem("Load Spacecraft");
        mnFile.add(this.mntmAddSpacecraftFile);
        this.mntmAddSpacecraftFile.addActionListener(this);
        this.mntmRemoveSpacecraftFile = new JMenuItem("Close Spacecraft");
        mnFile.add(this.mntmRemoveSpacecraftFile);
        this.mntmRemoveSpacecraftFile.addActionListener(this);
        mnFile.addSeparator();
        this.mntmSettings = new JMenuItem("Settings");
        mnFile.add(this.mntmSettings);
        this.mntmSettings.addActionListener(this);
        mnFile.addSeparator();
        this.mntmExit = new JMenuItem("Exit");
        mnFile.add(this.mntmExit);
        this.mntmExit.addActionListener(this);
        JMenu mnHelp = new JMenu("Help");
        this.menuBar.add(mnHelp);
        this.mntmHelpAbout = new JMenuItem("About the Spacecraft Editor");
        mnHelp.add(this.mntmHelpAbout);
        this.mntmHelpAbout.addActionListener(this);
        this.mntmHelpManual = new JMenuItem("Open Manual");
        mnHelp.add(this.mntmHelpManual);
        this.mntmHelpManual.addActionListener(this);
        this.mntmHelpHandbook = new JMenuItem("Open Telemetry Designers Handbook");
        mnHelp.add(this.mntmHelpHandbook);
        this.mntmHelpHandbook.addActionListener(this);
    }

    private void layoutMainPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setTabLayoutPolicy(1);
        panel.add((Component)this.tabbedPane, "Center");
        this.addSpacecraftTabs();
        JPanel footer = new JPanel();
        JLabel lblVersion = new JLabel("Version: 1.02c - 24 Jan 2025");
        footer.add(lblVersion);
        lblHomeDir = new JLabel();
        SpacecraftEditorWindow.displayDirs();
        footer.add(lblHomeDir);
        panel.add((Component)footer, "South");
    }

    public static void displayDirs() {
        lblHomeDir.setText("  |  MASTER: " + Config.spacecraftDir + "  |  Home: " + Config.homeDirectory + "  |  Log files: " + Config.logFileDirectory);
    }

    public void addSpacecraftTabs() {
        this.sats = Config.satManager.getSpacecraftList();
        this.spacecraftTab = new SpacecraftEditTab[this.sats.size()];
        int s = 0;
        while (s < this.sats.size()) {
            this.spacecraftTab[s] = new SpacecraftEditTab(this.sats.get(s));
            this.tabbedPane.setFont(new Font("Dialog", 3, 18));
            this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>" + this.sats.get((int)s).propertiesFile.getName() + "</b></body></html>", this.spacecraftTab[s]);
            ++s;
        }
    }

    public void removeSpacecraftTabs() {
        if (this.spacecraftTab != null) {
            int s = 0;
            while (s < this.spacecraftTab.length) {
                this.tabbedPane.remove(this.spacecraftTab[s]);
                this.spacecraftTab[s] = null;
                ++s;
            }
        }
        this.spacecraftTab = null;
    }

    public static File pickFile(File dir, Component parent, String title, String buttonText, String filterString) {
        File file;
        if (Config.useNativeFileChooser && !Config.isLinuxOs()) {
            fd.setFile("*." + filterString);
            fd.setTitle(title);
            if (dir != null) {
                fd.setDirectory(dir.getAbsolutePath());
            }
            fd.setVisible(true);
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
                file = null;
            } else {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
            fc.setDialogTitle(title);
            fc.resetChoosableFileFilters();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(filterString) + " files", filterString);
            fc.setFileFilter(filter);
            fc.setApproveButtonText(buttonText);
            if (dir != null) {
                fc.setCurrentDirectory(dir);
            }
            int returnVal = fc.showOpenDialog(parent);
            Config.windowFcHeight = fc.getHeight();
            Config.windowFcWidth = fc.getWidth();
            if (returnVal == 0) {
                file = fc.getSelectedFile();
                Log.println("File: " + file.getName());
                Log.println("DIR: " + file.getPath());
            } else {
                file = null;
            }
        }
        return file;
    }

    private void newSpacecraft() {
        File file = null;
        File destinationDir = null;
        File dir = null;
        dir = new File(Config.spacecraftDir);
        destinationDir = !Config.logFileDirectory.equalsIgnoreCase("") ? new File(String.valueOf(Config.logFileDirectory) + "/spacecraft") : dir;
        file = SpacecraftEditorWindow.pickFile(dir, this, "Specify new MASTER spacecraft file to create", "Create", "MASTER");
        Config.save();
        if (file != null) {
            if (file.exists()) {
                Object[] options = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(MainWindow.frame, "This will delete the existing MASTER spacecraft file: " + file.getName() + "\n" + "Select yes to replace this with a new blank file\n" + "Select no to quit", "Replace existing file?", 0, 0, null, options, options[1]);
                if (n == 1) {
                    return;
                }
            }
            Log.println("Creating MASTER File: " + file.getAbsolutePath());
            String targetName = file.getName().replace(".MASTER", ".dat");
            File userFile = new File(String.valueOf(destinationDir.getPath()) + File.separator + targetName);
            Spacecraft satellite = new Spacecraft(Config.satManager, file, userFile, 0);
            satellite.save_master_params();
            this.installSpacecraft(file, destinationDir);
            Config.initSatelliteManager();
            this.removeSpacecraftTabs();
            this.addSpacecraftTabs();
        }
    }

    private void installSpacecraft(File file, File destinationDir) {
        String targetName = file.getName().replace(".MASTER", ".dat");
        File targetFile = new File(String.valueOf(destinationDir.getPath()) + File.separator + targetName);
        Log.println("Opening " + file.getAbsolutePath());
        if (file.exists()) {
            try {
                try {
                    Spacecraft satellite = new Spacecraft(Config.satManager, file, targetFile);
                    satellite.save();
                }
                catch (LayoutLoadException e) {
                    Log.errorDialog("Layout Issue", "Could not fully parse the spacecraft file.  It may not be installed\n" + e.getMessage());
                    e.printStackTrace(Log.getWriter());
                }
            }
            catch (IOException e) {
                Log.errorDialog("ERROR Copy File", "Could not fully install the spacecraft file\n" + e.getMessage());
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    private void addSpacecraft(boolean remove) {
        File file = null;
        File destinationDir = null;
        File dir = null;
        destinationDir = new File(Config.spacecraftDir);
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            destinationDir = new File(String.valueOf(Config.logFileDirectory) + "/spacecraft");
        }
        dir = remove ? destinationDir : new File(Config.spacecraftDir);
        file = remove ? SpacecraftEditorWindow.pickFile(dir, this, "Specify spacecraft (.dat) file to close", "Close Spacecraft", "dat") : SpacecraftEditorWindow.pickFile(dir, this, "Specify MASTER spacecraft file to load", "Load", "MASTER");
        Config.save();
        if (file != null) {
            boolean refresh = false;
            if (remove) {
                int n = Log.optionYNdialog("Remove the loaded spacecraft file?", String.valueOf(file.getName()) + "\n\nYou will be able to load the spacecraft again if you want. The MASTER file\n" + "will not be deleted from the disk.  Remove for now?\n\n");
                if (n == 1) {
                    refresh = false;
                } else {
                    try {
                        SatPayloadStore.remove(file.getAbsolutePath());
                        refresh = true;
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR removing File", "\nCould not remove the spacecraft file\n" + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                }
            } else {
                if (!file.getParent().equalsIgnoreCase(Config.spacecraftDir)) {
                    Log.errorDialog("ERROR Adding File", "\nThis file is not in your current MASTER spacecraft dir\nYour MASTER dir: " + Config.spacecraftDir + "\n" + "This files dir: " + file.getParent() + "\n" + "Copy the file in, along with any files it depends on and then open it again. Or change\n" + "you MASTER dir to this folder using the settings screen.  This is needed because there\n" + "are many files associated with a MASTER spacecraft file and they need to be in the same folder.");
                    return;
                }
                this.installSpacecraft(file, destinationDir);
                refresh = true;
            }
            if (refresh) {
                Config.initSatelliteManager();
                this.removeSpacecraftTabs();
                this.addSpacecraftTabs();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mntmExit) {
            this.windowClosing(null);
        }
        if (e.getSource() == this.mntmNewSpacecraftFile) {
            this.newSpacecraft();
        }
        if (e.getSource() == this.mntmAddSpacecraftFile) {
            this.addSpacecraft(false);
        }
        if (e.getSource() == this.mntmRemoveSpacecraftFile) {
            this.addSpacecraft(true);
        }
        if (e.getSource() == this.mntmSettings) {
            EditorSettingsFrame f = new EditorSettingsFrame(this, true);
            f.setVisible(true);
        }
        if (e.getSource() == this.mntmHelpManual) {
            try {
                DesktopApi.browse(new URI(MANUAL));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.mntmHelpHandbook) {
            try {
                DesktopApi.browse(new URI(HANDBOOK));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorWindow", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorWindow", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorWindow", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorWindow", "windowY", this.getY());
        Config.save();
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorWindow", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorWindow", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorWindow", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorWindow", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 1000, 800);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        Log.close();
        System.exit(0);
        Log.println("Window Closed");
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        Log.println("Closing Window");
        this.saveProperties();
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

