/*
 * Decompiled with CFR 0.152.
 */
package telemetry.Format;

import common.Config;
import decoder.FoxDecoder;
import telemetry.BitArrayLayout;
import telemetry.Format.TelemFormat;
import telemetry.frames.Header;

public class FormatHeader
extends Header {
    int safeMode;
    int healthMode;
    int scienceMode;
    int cameraMode;
    int minorVersion;
    TelemFormat telemFormat;
    public static final String ID_FIELD = "satelliteId";
    public static final String EXTENDED_ID_FIELD = "extendedId";
    public static final String TYPE_FIELD = "type";
    public static final String RESET_FIELD = "resetCnt";
    public static final String UPTIME_FIELD = "uptime";
    public static final String PROTOCOL_VERSION_FIELD = "protocolVersion";
    public static final String SAFE_MODE = "inSafeMode";
    public static final String HEALTH_MODE = "inHealthMode";
    public static final String SCIENCE_MODE = "inScienceMode";

    public FormatHeader(BitArrayLayout layout, TelemFormat telemFormat) {
        super(104, layout);
        this.telemFormat = telemFormat;
        this.MAX_BYTES = telemFormat.getInt("header_length");
        this.rawBits = new boolean[this.MAX_BYTES * 8];
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void copyBitsToFields() {
        if (this.rawBits != null) {
            if (this.layout.fieldName != null) {
                super.copyBitsToFields();
                this.id = this.getRawValue(ID_FIELD);
                if (this.id == 0) {
                    this.id = 8 + this.getRawValue(EXTENDED_ID_FIELD);
                }
                this.resets = this.getRawValue(RESET_FIELD);
                this.uptime = this.getRawValue(UPTIME_FIELD);
                this.type = this.getRawValue(TYPE_FIELD);
                this.minorVersion = this.getRawValue(PROTOCOL_VERSION_FIELD);
                this.safeMode = this.getRawValue(SAFE_MODE);
                this.healthMode = this.getRawValue(HEALTH_MODE);
                this.scienceMode = this.getRawValue(SCIENCE_MODE);
                this.setMode();
            } else {
                super.copyBitsToFields();
                this.type = this.nextbits(4);
                if (this.id == 0) {
                    this.id = this.nextbits(8);
                }
                if (this.id >= 6) {
                    this.safeMode = this.nextbits(1);
                    this.healthMode = this.nextbits(1);
                    this.scienceMode = this.nextbits(1);
                    this.cameraMode = this.nextbits(1);
                    this.minorVersion = this.nextbits(4);
                }
                this.setMode();
            }
        }
    }

    public void setMode() {
        this.newMode = 0;
        if (this.id >= 6) {
            if (this.safeMode != 0) {
                this.newMode = 1;
            }
            if (this.healthMode != 0) {
                this.newMode = 5;
            }
            if (this.scienceMode != 0) {
                this.newMode = 4;
            }
            if (this.cameraMode != 0) {
                this.newMode = 6;
            }
        }
    }

    @Override
    public boolean isValid() {
        this.copyBitsToFields();
        return Config.satManager.validFoxId(this.id);
    }

    @Override
    public boolean isValidType(int t) {
        assert (false);
        return false;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "ID: " + FoxDecoder.dec(this.id) + " RESET COUNT: " + FoxDecoder.dec(this.resets) + " UPTIME: " + FoxDecoder.dec(this.uptime) + " TYPE: " + FoxDecoder.dec(this.type);
        if (this.id >= 6) {
            s = String.valueOf(s) + " - MODE: " + this.newMode;
        }
        return s;
    }
}

