/*
 * Decompiled with CFR 0.152.
 */
package telemetry.Format;

import common.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;

public class TelemFormat {
    public static final String FSK = "FSK";
    public static final String BPSK = "BPSK";
    public static final String NAME = "name";
    public static final String MODE = "mode";
    public static final String BPS = "bps";
    public static final String DATA_LENGTH = "data_length";
    public static final String HEADER_LENGTH = "header_length";
    public static final String HEADER_LAYOUT_FILE = "header_layout_file";
    public static final String RS_WORDS = "rs_words";
    public static final String RS_PADDING = "rs_padding";
    public static final String SYNC_WORD_LENGTH = "sync_word_length";
    public static final String WORD_LENGTH = "word_length";
    public static final String SYMBOLS_PER_CHUNK = "symbols_per_chunk";
    public static final String RF_FILTER_WIDTH_HZ = "rf_filter_width_hz";
    public Properties properties = new Properties();
    public File propertiesFile;
    String fileName;
    public String name;
    BitArrayLayout headerLayout;
    int frameLength;
    int trailerLength;
    int[] rsPaddingArray;

    public TelemFormat(String fileName) throws LayoutLoadException {
        this.fileName = fileName;
        this.propertiesFile = new File(fileName);
        this.load();
        try {
            this.name = this.get(NAME);
        }
        catch (Exception e) {
            throw new LayoutLoadException("Invalid or missing name in Telem Format file: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            String headerLayoutFilename = this.get(HEADER_LAYOUT_FILE);
            this.headerLayout = headerLayoutFilename != null ? new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + headerLayoutFilename) : new BitArrayLayout();
        }
        catch (Exception e) {
            throw new LayoutLoadException("Invalid or missing header_layout_file in Telem Format file: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            this.getInt(RS_WORDS);
        }
        catch (Exception e) {
            throw new LayoutLoadException("Invalid or missing rs_words in Telem Format file: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            this.getInt(SYMBOLS_PER_CHUNK);
        }
        catch (Exception e) {
            throw new LayoutLoadException("Invalid or missing symbols_per_chunk in Telem Format file: " + this.propertiesFile.getAbsolutePath());
        }
        try {
            this.getInt(RF_FILTER_WIDTH_HZ);
        }
        catch (Exception e) {
            throw new LayoutLoadException("Invalid or missing rf_filter_width_hz in Telem Format file: " + this.propertiesFile.getAbsolutePath());
        }
        this.trailerLength = this.getInt(RS_WORDS) * 32;
        this.frameLength = this.getInt(DATA_LENGTH) + this.trailerLength;
    }

    protected void load() throws LayoutLoadException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.propertiesFile);
            this.properties.load(f);
            f.close();
        }
        catch (IOException e) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("Could not load TelemFormat file: " + this.propertiesFile.getAbsolutePath() + "\n" + e.getMessage());
        }
    }

    public boolean isFSK() {
        return this.getMode().equalsIgnoreCase(FSK);
    }

    public boolean isBPSK() {
        return this.getMode().equalsIgnoreCase(BPSK);
    }

    public String getMode() {
        String mode = this.get(MODE);
        return mode;
    }

    public int getSyncWordDistance() {
        int syncWordLength = this.getInt(SYNC_WORD_LENGTH);
        int wordLength = this.getInt(WORD_LENGTH);
        return this.frameLength * wordLength + syncWordLength;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public int getTrailerLength() {
        return this.trailerLength;
    }

    public BitArrayLayout getHeaderLayout() {
        return this.headerLayout;
    }

    public int[] getPaddingArray() {
        String rs_padding = this.get(RS_PADDING);
        String[] pads = rs_padding.split(",");
        int[] sourceRsPadding = new int[pads.length];
        int j = 0;
        String[] stringArray = pads;
        int n = pads.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            sourceRsPadding[j++] = Integer.parseInt(p);
            ++n2;
        }
        return sourceRsPadding;
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.name;
        return s;
    }
}

