/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Spacecraft;
import java.text.DecimalFormat;
import telemetry.conversion.Conversion;

public class ConversionInvalidCheck
extends Conversion {
    public static final String KEYWORD = "invalid_check";
    int pos = -1;
    int ch;
    String str;
    double triggerValue;
    String message;
    int decimalPlaces;

    public ConversionInvalidCheck(String name, Spacecraft fox) {
        super(name, fox);
        this.str = name;
        this.parse();
    }

    void nextChar() {
        this.ch = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    boolean eatWhiteSpace() {
        while (this.ch == 32 || this.ch == 9 || this.ch == 34) {
            this.nextChar();
        }
        return true;
    }

    boolean eat(int charToEat) {
        this.eatWhiteSpace();
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    boolean parse() {
        boolean result = false;
        this.nextChar();
        this.eatWhiteSpace();
        result = this.parseFunction(KEYWORD);
        this.eatWhiteSpace();
        if (!result) {
            throw new RuntimeException("Corrupt invalid check expression: " + this.str + " at position " + this.pos);
        }
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected character: " + (char)this.ch + " at position " + this.pos);
        }
        return result;
    }

    boolean parseFunction(String name) {
        String func = this.parseWord();
        if (func == null || !func.equalsIgnoreCase(name)) {
            throw new RuntimeException("Invalid function name: " + func + " at position " + (this.pos - 1));
        }
        if (this.eat(40)) {
            this.triggerValue = this.parseNumber();
            this.message = this.parseQuotedString();
            if (this.message == null) {
                return false;
            }
            this.decimalPlaces = this.parseInt();
            if (!this.eat(41)) {
                throw new RuntimeException("Missing: ) at position " + (this.pos - 1));
            }
            return true;
        }
        throw new RuntimeException("Missing: ( at position " + (this.pos - 1));
    }

    String parseWord() {
        while (this.ch == 32 || this.ch == 9 || this.ch == 34) {
            this.nextChar();
        }
        int startPos = this.pos;
        while (this.validChar(this.ch) || this.ch >= 48 && this.ch <= 57) {
            this.nextChar();
        }
        String func = this.str.substring(startPos, this.pos);
        return func;
    }

    String parseQuotedString() {
        String s = null;
        if (this.eat(39)) {
            s = this.parseString();
            this.eat(39);
        } else if (this.eat(34)) {
            s = this.parseString();
            this.eat(34);
        } else {
            s = this.parseWord();
        }
        return s;
    }

    String parseString() {
        int startPos = this.pos;
        while (this.validChar(this.ch) || this.ch == 32 || this.ch == 45 || this.ch == 94 || this.ch == 38 || this.ch == 36 || this.ch == 47 || this.ch == 63 || this.ch == 60 || this.ch == 62 || this.ch == 58 || this.ch == 95 || this.ch == 126 || this.ch == 64 || this.ch == 35 || this.ch == 61 || this.ch == 37 || this.ch == 43 || this.ch == 42 || this.ch == 33 || this.ch == 46 || this.ch == 91 || this.ch == 93 || this.ch >= 48 && this.ch <= 57) {
            this.nextChar();
        }
        String func = this.str.substring(startPos, this.pos);
        return func;
    }

    double parseNumber() {
        while (this.ch == 32 || this.ch == 9 || this.ch == 34) {
            this.nextChar();
        }
        int startPos = this.pos;
        if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
            while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                this.nextChar();
            }
            Double x = Double.parseDouble(this.str.substring(startPos, this.pos));
            return x;
        }
        return 0.0;
    }

    int parseInt() {
        while (this.ch == 32 || this.ch == 9 || this.ch == 34) {
            this.nextChar();
        }
        int startPos = this.pos;
        if (this.ch >= 48 && this.ch <= 57) {
            while (this.ch >= 48 && this.ch <= 57) {
                this.nextChar();
            }
            Integer x = Integer.parseInt(this.str.substring(startPos, this.pos));
            return x;
        }
        return 0;
    }

    boolean validChar(int ch) {
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
            return true;
        }
        return ch == 95;
    }

    public String toString() {
        String s = "Invalid Check:\n";
        s = String.valueOf(s) + this.triggerValue + "\n";
        s = String.valueOf(s) + this.message + "\n";
        s = String.valueOf(s) + this.decimalPlaces + "\n";
        return s;
    }

    @Override
    public double calculate(double x) {
        return x;
    }

    @Override
    public String calculateString(double x) {
        String s = "";
        if (ConversionInvalidCheck.almostEqual(x, this.triggerValue, 0.01)) {
            return this.message;
        }
        if (this.decimalPlaces == 0) {
            s = "" + Math.round(x);
            return s;
        }
        String numberSigns = "";
        int i = 0;
        while (i < this.decimalPlaces) {
            numberSigns = String.valueOf(numberSigns) + "0";
            ++i;
        }
        DecimalFormat fmt = new DecimalFormat("0." + numberSigns);
        s = fmt.format(x);
        return s;
    }

    public static boolean almostEqual(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public static void main(String[] args) {
        ConversionInvalidCheck invalid_check = new ConversionInvalidCheck(" invalid_check (123.5 'invalid if < 1.5' 1)", null);
        System.out.println(invalid_check);
        System.out.println(invalid_check.calculateString(120.12345));
        System.out.println(invalid_check.calculateString(123.5));
    }
}

