/*
 * Decompiled with CFR 0.152.
 */
package telemetry.uw;

import common.Config;
import common.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.uw.PcanPacket;
import telemetry.uw.UwCanPacket;

@Deprecated
public class PayloadUwExperiment
extends FramePart {
    public ArrayList<UwCanPacket> canPackets = new ArrayList();
    public ArrayList<UwCanPacket> splitPackets;
    protected UwCanPacket canPacket;
    protected UwCanPacket rawCanPacket;
    int debugCount = 0;

    public PayloadUwExperiment(BitArrayLayout lay, int id, long uptime, int resets) {
        super(13, lay);
        this.splitPackets = new ArrayList();
        this.captureHeaderInfo(id, uptime, resets);
    }

    public PayloadUwExperiment(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 13, date, st, lay);
    }

    @Override
    protected void init() {
    }

    protected void addToCanPackets(byte b) {
        if (this.rawCanPacket == null) {
            this.rawCanPacket = new UwCanPacket(Config.satManager.getLayoutByName(this.id, "canpacket"));
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
        if (this.rawCanPacket.hasEndOfCanPacketsId()) {
            return;
        }
        this.rawCanPacket.addNext8Bits(b);
        if (this.rawCanPacket.isValid()) {
            this.canPackets.add(this.rawCanPacket);
            if (Config.splitCanPackets) {
                byte[] data = this.rawCanPacket.getBytes();
                BitArrayLayout canLayout = Config.satManager.getLayoutByCanId(this.id, this.rawCanPacket.getID());
                if (canLayout == null) {
                    Log.errorDialog("ERROR", "Missing CAN Layout for CAN ID: " + this.rawCanPacket.getID());
                }
                UwCanPacket newPacket = new UwCanPacket(this.id, this.resets, this.uptime, this.reportDate, data, canLayout);
                if (!canLayout.name.equalsIgnoreCase("canpacket")) {
                    newPacket.setType(17);
                    this.splitPackets.add(newPacket);
                }
            }
            this.rawCanPacket = new UwCanPacket(Config.satManager.getLayoutByName(this.id, "canpacket"));
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
    }

    @Override
    public void addNext8Bits(byte b) {
        if (this.numberBytesAdded < 1) {
            super.addNext8Bits(b);
        } else {
            this.addToCanPackets(b);
        }
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "UW EXPERIMENT PAYLOAD - " + this.canPackets.size() + " CAN PACKETS\n";
        s = String.valueOf(s) + "RESET: " + this.resets;
        s = String.valueOf(s) + "  UPTIME: " + this.uptime;
        s = String.valueOf(s) + "  TYPE: " + this.type;
        s = String.valueOf(s) + "  OVERFLOW FLAG: (not printed)" + "\n";
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public boolean savePayloads(FoxPayloadStore payloadStore, int serial, boolean storeMode) {
        int p_type;
        this.type = this.type * 100 + serial;
        if (!payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), this)) {
            return false;
        }
        int j = 0;
        for (UwCanPacket p : this.canPackets) {
            p_type = p.getType();
            p_type = p_type * 100 + serial + j++;
            p.setType(p_type);
            if (storeMode) {
                p.newMode = this.newMode;
            }
            if (!payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), p)) {
                return false;
            }
            p.rawBits = null;
        }
        if (this.splitPackets != null && this.splitPackets.size() > 0) {
            j = 0;
            for (UwCanPacket p : this.splitPackets) {
                p_type = p.getType();
                p_type = p_type * 100 + serial + j++;
                p.setType(p_type);
                if (storeMode) {
                    p.newMode = this.newMode;
                }
                if (!payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), p)) {
                    return false;
                }
                p.rawBits = null;
            }
        }
        return true;
    }

    public byte[][] getCANPacketBytes(Date createDate) {
        return PayloadUwExperiment.getCANPacketBytes(this.canPackets, createDate);
    }

    public static byte[][] getCANPacketBytes(ArrayList<UwCanPacket> canPackets, Date createDate) {
        byte[][] buffers = new byte[canPackets.size()][];
        int i = 0;
        for (UwCanPacket p : canPackets) {
            PcanPacket pc = p.getPCanPacket(createDate);
            buffers[i++] = pc.getBytes();
        }
        return buffers;
    }

    static byte[] concatenateByteArrays(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }
}

