/*
 * Decompiled with CFR 0.152.
 */
package telemetry.uw;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.uw.PcanPacket;

public class UwCanPacket
extends FramePart
implements Comparable<FramePart> {
    public static final int MAX_PACKET_BYTES = 12;
    public static final int ID_FIELD0 = 0;
    public static final int ID_FIELD1 = 1;
    public static final int ID_FIELD2 = 2;
    public static final int ID_FIELD3 = 3;
    public static final int ID_BYTES = 4;
    public int pkt_id = 0;
    public int ihuPacketId = 0;
    public int canId;
    int length = 0;
    byte[] bytes;

    public UwCanPacket(BitArrayLayout lay) {
        super(14, lay);
    }

    public UwCanPacket(int id, int resets, long uptime, String date, byte[] data, BitArrayLayout lay) {
        super(id, resets, uptime, 14, date, data, lay);
    }

    public UwCanPacket(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 14, date, st, lay);
    }

    public UwCanPacket(ResultSet r, BitArrayLayout lay) throws SQLException {
        super(r, 14, lay);
    }

    @Override
    public void init() {
        this.bytes = new byte[12];
    }

    public void initBytes() {
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getLength() {
        return this.length;
    }

    public int getID() {
        return this.canId;
    }

    public byte[] getBytes() {
        if (this.isValid()) {
            byte[] data = new byte[this.getLength() + 4];
            if (this.bytes.length < this.getLength() + 4) {
                return null;
            }
            int i = 0;
            while (i < this.getLength() + 4) {
                data[i] = this.bytes[i];
                ++i;
            }
            return data;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.rawBits == null) {
            return true;
        }
        if (this.numberBytesAdded < 4) {
            return false;
        }
        this.copyBitsToFields();
        return this.ihuPacketId != 0 && this.getLength() > 0 && this.getLength() < 9 && this.numberBytesAdded == this.getLength() + 4;
    }

    public boolean hasEndOfCanPacketsId() {
        return this.numberBytesAdded >= 4 && this.ihuPacketId == 0;
    }

    @Override
    public void addNext8Bits(byte b) {
        try {
            int i = 0;
            while (i < 8) {
                this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
                ++i;
            }
            ++this.numberBytesAdded;
            this.bytes[this.numberBytesAdded - 1] = b;
            if (this.numberBytesAdded == 4) {
                this.copyBitsToFields();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.errorDialog("FATAL ERROR", "Error adding data to layout:\n" + this.layout.name + " layout length: " + (this.layout.getMaxNumberOfBytes() - 4) + " data len: " + this.getLength() + "\n at byte: " + this.numberBytesAdded);
            System.exit(1);
        }
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public static int getIdFromRawBytes(int a, int b, int c, int d) {
        int id = a + 256 * b + 65536 * c + 0x1000000 * d;
        return UwCanPacket.getIdfromRawID(id);
    }

    public static int getLengthFromRawBytes(int a, int b, int c, int d) {
        int id = a + 256 * b + 65536 * c + 0x1000000 * d;
        return UwCanPacket.getLengthfromRawID(id);
    }

    public static int getIdfromRawID(int canPacketId) {
        int id = canPacketId & 0x1FFFFFFF;
        return id;
    }

    public static int getLengthfromRawID(int canPacketId) {
        int length = canPacketId >> 29 & 7;
        return length + 1;
    }

    @Override
    public void copyBitsToFields() {
        this.resetBitPosition();
        super.copyBitsToFields();
        this.ihuPacketId = this.fieldValue[0] + 256 * this.fieldValue[1] + 65536 * this.fieldValue[2] + 0x1000000 * this.fieldValue[3];
        this.length = UwCanPacket.getLengthfromRawID(this.ihuPacketId);
        this.canId = UwCanPacket.getIdfromRawID(this.ihuPacketId);
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "";
        s = String.valueOf(s) + this.resets + ":" + this.uptime;
        s = String.valueOf(s) + "CAN ID:";
        s = String.valueOf(s) + FoxDecoder.hex(this.canId);
        s = String.valueOf(s) + " " + this.canId;
        Spacecraft fox = Config.satManager.getSpacecraft(this.getFoxId());
        s = String.valueOf(s) + ": " + fox.canFrames.getNameByCanId(this.canId);
        s = String.valueOf(s) + ": " + fox.canFrames.getGroundByCanId(this.canId);
        s = String.valueOf(s) + " - " + fox.canFrames.getSenderByCanId(this.canId);
        s = String.valueOf(s) + " Len:" + this.getLength() + " Type:" + this.type;
        int i = 1;
        while (i < this.fieldValue.length) {
            s = String.valueOf(s) + " " + FoxDecoder.hex(this.fieldValue[i]);
            ++i;
        }
        return s;
    }

    public PcanPacket getPCanPacket(Date createDate) {
        this.copyBitsToFields();
        if (!this.isValid()) {
            return null;
        }
        byte[] data = new byte[this.getLength()];
        int i = 0;
        while (i < this.getLength()) {
            data[i] = (byte)this.fieldValue[i + 4];
            ++i;
        }
        PcanPacket pcan = new PcanPacket(createDate, this.id, this.resets, this.uptime, this.type, this.canId, (byte)this.getLength(), data);
        return pcan;
    }

    public String getTableCreateStmt(boolean storeMode) {
        String s = new String();
        s = String.valueOf(s) + "(captureDate varchar(14), id int, resets int, uptime bigint, type int, ";
        if (storeMode) {
            s = String.valueOf(s) + "newMode int,";
        }
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.layout.fieldName[i] + " int,\n";
            ++i;
        }
        s = String.valueOf(s) + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type))";
        return s;
    }
}

