/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SatPassTime
implements Serializable {
    private static final long serialVersionUID = -6408342316986801301L;
    private Date startTime;
    private Date endTime;
    private Date tca;
    private String polePassed;
    private int aos;
    private int los;
    private double maxEl;
    private static final String NEW_LINE = "\n";
    private static final String DEG_NL = " deg.\n";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("h:mm a");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMMMMM d, yyyy");

    public SatPassTime(Date startTime, Date endTime, String polePassed, int aos, int los, double maxEl) {
        new SatPassTime(startTime, endTime, new Date((startTime.getTime() + endTime.getTime()) / 2L), polePassed, aos, los, maxEl);
    }

    public SatPassTime() {
    }

    public SatPassTime(Date startTime, Date endTime, Date tca, String polePassed, int aosAzimuth, int losAzimuth, double maxEl) {
        this.startTime = new Date(startTime.getTime());
        this.endTime = new Date(endTime.getTime());
        this.polePassed = polePassed;
        this.aos = aosAzimuth;
        this.los = losAzimuth;
        this.maxEl = maxEl;
        this.tca = new Date(tca.getTime());
    }

    public final Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    public final Date getEndTime() {
        return new Date(this.endTime.getTime());
    }

    public final Date getTCA() {
        return new Date(this.tca.getTime());
    }

    public final void setTCA(Date theTCA) {
        this.tca = theTCA;
    }

    public final String getPolePassed() {
        return this.polePassed;
    }

    public final int getAosAzimuth() {
        return this.aos;
    }

    public final int getLosAzimuth() {
        return this.los;
    }

    public final double getMaxEl() {
        return this.maxEl;
    }

    public String toString() {
        double duration = (double)(this.endTime.getTime() - this.startTime.getTime()) / 60000.0;
        return "Date: " + DATE_FORMAT.format(this.startTime) + NEW_LINE + "Start Time: " + TIME_FORMAT.format(this.startTime) + NEW_LINE + String.format("Duration: %4.1f min.\n", duration) + "AOS Azimuth: " + this.aos + DEG_NL + String.format("Max Elevation: %4.1f deg.\n", this.maxEl) + "LOS Azimuth: " + this.los + " deg.";
    }
}

