/*
 * Decompiled with CFR 0.152.
 */
package FuncubeDecoder;

import FuncubeDecoder.PayloadFitterMessages;
import FuncubeDecoder.PayloadHighRes;
import FuncubeDecoder.PayloadWholeOrbit;
import common.SatelliteManager;
import common.Spacecraft;
import java.io.File;
import java.io.IOException;
import telemetry.FramePart;
import telemetry.LayoutLoadException;

public class FUNcubeSpacecraft
extends Spacecraft {
    public static final int[] TYPE_WHOLE_ORBIT = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] TYPE_HIGH_RES = new int[]{13, 17, 21};
    public static final int[] TYPE_FITTER = new int[]{14, 15, 16, 18, 19, 20, 22, 23, 24};
    public static final String WHOLE_ORBIT_LAYOUT = "WHOLE_ORBIT";
    public static final String HIGH_RES_LAYOUT = "HIGH_RES";
    public static final String FITTER_LAYOUT = "FITTER";
    public static final int FUNCUBE_ID = 100;

    public FUNcubeSpacecraft(SatelliteManager satManager, File masterfileName, File fileName) throws LayoutLoadException, IOException {
        super(satManager, masterfileName, fileName);
        this.load();
    }

    public FramePart getPayloadByType(int type) {
        int i = 0;
        while (i < TYPE_WHOLE_ORBIT.length) {
            if (type == TYPE_WHOLE_ORBIT[i]) {
                return new PayloadWholeOrbit(this.getLayoutByName(WHOLE_ORBIT_LAYOUT));
            }
            ++i;
        }
        i = 0;
        while (i < TYPE_HIGH_RES.length) {
            if (type == TYPE_HIGH_RES[i]) {
                return new PayloadHighRes(this.getLayoutByName(HIGH_RES_LAYOUT));
            }
            ++i;
        }
        i = 0;
        while (i < TYPE_FITTER.length) {
            if (type == TYPE_FITTER[i]) {
                return new PayloadFitterMessages(this.getLayoutByName(FITTER_LAYOUT));
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void load() throws LayoutLoadException {
        super.load();
    }

    @Override
    public void save() {
    }
}

