/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import decoder.DataMeasure;

public class EyeData
extends DataMeasure {
    protected boolean eyeDataFresh = false;
    int[][] eyeData = null;
    int SAMPLE_WINDOW_LENGTH = 0;
    int bucketSize = 0;
    public double bitSNR;
    public int lastErasureCount;
    public int lastErrorsCount;
    public static final int HIGH = 0;
    public static final int LOW = 1;
    public static final int BIT = 2;
    public int clockOffset = 0;
    public int offsetType = 0;

    public EyeData(int l, int b) {
        this.MEASURES = 3;
        this.AVERAGE_PERIOD = 400L;
        this.init();
        this.SAMPLE_WINDOW_LENGTH = l;
        this.bucketSize = b;
        this.eyeData = new int[this.SAMPLE_WINDOW_LENGTH][];
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            this.eyeData[i] = new int[this.bucketSize];
            ++i;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("EyeData");
    }

    public void calcAverages() {
        if (this.readyToAverage()) {
            this.runAverage();
            double noise = this.sd[1] + this.sd[0];
            double signal = this.avg[0] - this.avg[1];
            if (signal != 0.0 && noise != 0.0) {
                this.bitSNR = signal / noise;
            }
            this.reset();
        }
    }

    public boolean isFresh() {
        return this.eyeDataFresh;
    }

    public void setFreshData(boolean b) {
        this.eyeDataFresh = b;
    }

    public void setData(int window, int j, int value) {
        this.eyeData[window][j] = value;
    }

    public int[][] getData() {
        if (this.clockOffset != 0) {
            int[][] buffer = this.offsetEyeData(this.clockOffset);
            return buffer;
        }
        return this.eyeData;
    }

    public void setHigh(int value) {
        this.setValue(0, value);
        this.setValue(2, value);
    }

    public void setLow(int value) {
        this.setValue(1, value);
        this.setValue(2, value);
    }

    public void setOffsetLow(int i, int width, int offset) {
        int value = 0;
        int w = -width;
        while (w < width) {
            value += this.getOffsetValue(i, this.bucketSize / 2 + w, offset);
            ++w;
        }
        this.setValue(1, value / (width * 2));
        this.setValue(2, value / (width * 2));
    }

    public void setOffsetHigh(int i, int width, int offset) {
        int value = 0;
        int w = -width;
        while (w < width) {
            value += this.getOffsetValue(i, this.bucketSize / 2 + w, offset);
            ++w;
        }
        this.setValue(0, value / (width * 2));
        this.setValue(2, value / (width * 2));
    }

    private int getOffsetValue(int i, int j, int offset) {
        int value = 0;
        if (offset < 0) {
            if (j < Math.abs(offset) && i == 0) {
                value = this.eyeData[this.SAMPLE_WINDOW_LENGTH - 1][j + this.bucketSize + offset];
                this.offsetType = 1;
            } else if (j < Math.abs(offset) && i > 0) {
                value = this.eyeData[i - 1][j + this.bucketSize + offset];
                this.offsetType = 2;
            } else if (j >= Math.abs(offset)) {
                value = this.eyeData[i][j + offset];
                this.offsetType = 5;
            }
        }
        if (offset <= 0) {
            if (offset > 0 && j + offset >= this.bucketSize && i < this.SAMPLE_WINDOW_LENGTH - 1) {
                value = this.eyeData[i + 1][this.bucketSize - 1 - j + offset];
                this.offsetType = 3;
            } else if (offset > 0 && j + offset < this.bucketSize) {
                value = this.eyeData[i][j + offset];
                this.offsetType = 4;
            } else if (offset > 0 && j + offset >= this.bucketSize && i == this.SAMPLE_WINDOW_LENGTH - 1) {
                this.offsetType = 6;
                value = this.eyeData[0][this.bucketSize - 1 - j + offset];
            }
        }
        return value;
    }

    private int[][] offsetEyeData(int offset) {
        this.clockOffset = offset;
        int[][] buffer = new int[this.SAMPLE_WINDOW_LENGTH][];
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            buffer[i] = new int[this.bucketSize];
            ++i;
        }
        int a = 0;
        int b = 0;
        int i2 = 0;
        while (i2 < this.SAMPLE_WINDOW_LENGTH) {
            int j = 0;
            while (j < this.bucketSize) {
                if (this.eyeData != null && a < this.SAMPLE_WINDOW_LENGTH && b < this.bucketSize) {
                    buffer[a][b++] = this.getOffsetValue(i2, j, offset);
                }
                ++j;
            }
            b = 0;
            ++a;
            ++i2;
        }
        return buffer;
    }
}

