/*
 * Decompiled with CFR 0.152.
 */
package decoder.FoxBPSK;

import common.Config;
import common.Log;
import decoder.FoxBPSK.FoxBPSKDecoder;
import decoder.FoxBPSK.PskSearcher;
import decoder.SourceAudio;
import filter.AGCFilter;
import filter.Complex;
import filter.ComplexOscillator;
import filter.CosOscillator;
import filter.DcRemoval;
import filter.DotProduct;
import filter.RootRaisedCosineFilter;
import filter.SinOscillator;
import telemetry.Format.TelemFormat;

public class FoxBPSKDotProdDecoder
extends FoxBPSKDecoder {
    public static final int BITS_PER_SECOND_1200 = 1200;
    public static final int WORD_LENGTH = 10;
    public static final int AUDIO_MODE = 0;
    public static final int PSK_MODE = 1;
    public int mode = 0;
    DcRemoval audioIDcFilter;
    DcRemoval audioQDcFilter;
    RootRaisedCosineFilter dataFilterI;
    RootRaisedCosineFilter dataFilterQ;
    double[] pskAudioData;
    double[] pskQAudioData;
    double gain = 1.0;
    int chunk = 0;
    public int SEARCH_INTERVAL = 0;
    public static final int NSEARCHERS = 4;
    public static final double DEFAULT_CENTER_CARRIER = 1500.0;
    public static final double HIGH_CENTER_CARRIER = 12000.0;
    double CENTER_CARRIER = 0.0;
    static final double CARRIER_SEARCH_RANGE = 300.0;
    int Ftotal = 7;
    int Fperslot = (this.Ftotal + 4 - 1) / 4;
    PskSearcher[] searchers = new PskSearcher[4];
    Thread[] searcherThreads = new Thread[4];
    double phase_inc_start;
    double phase_inc_stop;
    double phase_inc_step;
    DotProduct matchedFilter;
    ComplexOscillator nco;
    CosOscillator ftcos;
    SinOscillator ftsin;
    double carrier = 0.0;
    double cphase_inc;
    double cphase = 0.0;
    int symphase = 0;
    double[] baseband_i = new double[this.BUFFER_SIZE];
    double[] baseband_q = new double[this.BUFFER_SIZE];
    static final int NUM_OF_DEMODS = 5;
    PskDemodState[] demodState = new PskDemodState[5];
    int symbol_count = 0;
    double[] data;
    int Symbols_demodulated;
    public int samples_processed = 0;
    Complex c;
    double[] phasorData;

    public FoxBPSKDotProdDecoder(SourceAudio as, int chan, int mode, TelemFormat telemFormat) {
        super("1200bps BPSK", as, chan, telemFormat);
        this.mode = mode;
        this.init();
    }

    @Override
    protected void init() {
        this.CENTER_CARRIER = !Config.iq && Config.use12kHzIfForBPSK ? 12000.0 : 1500.0;
        Log.println("Initializing 1200bps BPSK Non Coherent Dot Product decoder centered on: " + this.carrier);
        this.nco = new ComplexOscillator(this.currentSampleRate, (int)this.CENTER_CARRIER);
        this.ftcos = new CosOscillator(this.currentSampleRate, (int)this.CENTER_CARRIER);
        this.ftsin = new SinOscillator(this.currentSampleRate, (int)this.CENTER_CARRIER);
        this.BITS_PER_SECOND = 1200;
        this.SAMPLE_WINDOW_LENGTH = 100;
        this.SEARCH_INTERVAL = 8192 / this.SAMPLE_WINDOW_LENGTH;
        this.bucketSize = this.currentSampleRate / this.BITS_PER_SECOND;
        this.symphase = this.bucketSize / 2;
        this.BUFFER_SIZE = this.SAMPLE_WINDOW_LENGTH * this.bucketSize;
        this.initWindowData();
        this.audioIDcFilter = new DcRemoval(0.9999);
        this.audioQDcFilter = new DcRemoval(0.9999);
        this.filter = new AGCFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
        this.filter.init(this.currentSampleRate, 0.0, 0);
        this.filter.setFilterDC(false);
        this.dataFilterI = new RootRaisedCosineFilter(this.audioSource.audioFormat, 1);
        this.dataFilterI.init(this.currentSampleRate, 1200.0, 400);
        this.dataFilterI.setAGC(false);
        this.dataFilterI.setFilterDC(false);
        this.dataFilterQ = new RootRaisedCosineFilter(this.audioSource.audioFormat, 1);
        this.dataFilterQ.init(this.currentSampleRate, 1200.0, 400);
        this.dataFilterQ.setAGC(false);
        this.dataFilterQ.setFilterDC(false);
        this.pskAudioData = new double[this.BUFFER_SIZE];
        this.pskQAudioData = new double[this.BUFFER_SIZE];
        this.phasorData = new double[this.BUFFER_SIZE * 2];
        this.phase_inc_start = (this.CENTER_CARRIER - 300.0) * 2.0 * Math.PI / (double)this.currentSampleRate;
        this.phase_inc_stop = (this.CENTER_CARRIER + 300.0) * 2.0 * Math.PI / (double)this.currentSampleRate;
        this.phase_inc_step = 628.3185307179587 / (double)this.currentSampleRate;
        this.Fperslot = (this.Ftotal + 4 - 1) / 4;
        this.matchedFilter = new DotProduct();
    }

    @Override
    protected void resetWindowData() {
        super.resetWindowData();
    }

    @Override
    public double[] getBasebandData() {
        return this.pskAudioData;
    }

    @Override
    public double[] getBasebandQData() {
        return this.pskQAudioData;
    }

    @Override
    public double[] getPhasorData() {
        return this.phasorData;
    }

    @Override
    protected void sampleBuckets() {
        int offset;
        double maxValue = 0.0;
        double minValue = 0.0;
        double DESIRED_RANGE = 1.2;
        int j = 0;
        while (j < this.BUFFER_SIZE) {
            if (this.abBufferDoubleFiltered[j] > maxValue) {
                maxValue = this.abBufferDoubleFiltered[j];
            }
            if (this.abBufferDoubleFiltered[j] < minValue) {
                minValue = this.abBufferDoubleFiltered[j];
            }
            this.abBufferDoubleFiltered[j] = this.abBufferDoubleFiltered[j] * this.gain;
            this.abBufferDoubleFiltered[j + 1] = this.abBufferDoubleFiltered[j + 1] * this.gain;
            j += 2;
        }
        if (this.chunk % this.SEARCH_INTERVAL == 0) {
            int newSymphase = this.symphase;
            double newCarrier = this.carrier;
            this.cphase_inc = this.phase_inc_start;
            int fleft = this.Ftotal;
            int slot = 0;
            while (fleft > 0 && slot < 4) {
                this.searchers[slot] = new PskSearcher(this.abBufferDoubleFiltered, this.cphase_inc, this.phase_inc_step, this.min(this.Fperslot, fleft), this.BUFFER_SIZE, this.bucketSize, this.currentSampleRate);
                this.cphase_inc += this.phase_inc_step * (double)this.searchers[slot].getNfreq();
                fleft -= this.searchers[slot].getNfreq();
                this.searcherThreads[slot] = new Thread(this.searchers[slot]);
                this.searcherThreads[slot].setName("Searcher Thread:" + slot);
                this.searcherThreads[slot].setUncaughtExceptionHandler(Log.uncaughtExHandler);
                this.searcherThreads[slot].start();
                this.searchers[slot].run();
                ++slot;
            }
            int slots = slot;
            double maxenergy_value = -9.9E100;
            slot = 0;
            while (slot < slots) {
                try {
                    this.searcherThreads[slot].join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.searchers[slot].getEnergy() >= maxenergy_value) {
                    maxenergy_value = this.searchers[slot].getEnergy();
                    newSymphase = this.searchers[slot].getSymphase();
                    newCarrier = this.searchers[slot].getFrequency();
                }
                this.searchers[slot].stop();
                ++slot;
            }
            if (Math.abs(newCarrier - this.carrier) > 75.0) {
                this.carrier = newCarrier;
                this.symphase = newSymphase;
                if (this.symphase < this.bucketSize / 2) {
                    this.symphase += this.bucketSize;
                }
                if (Config.debugClock) {
                    Log.println("   --full search: carrier " + this.carrier + " Hz; best offset " + this.symphase + "; energy " + maxenergy_value);
                }
            } else if (Config.debugClock) {
                Log.println("   NO CHANGE: carrier " + this.carrier + " Hz; best offset " + this.symphase + "; energy " + maxenergy_value);
            }
        }
        if (Double.isNaN(this.carrier)) {
            this.carrier = this.CENTER_CARRIER;
        }
        if (this.carrier > this.CENTER_CARRIER + 300.0) {
            this.carrier = this.CENTER_CARRIER + 300.0;
        }
        if (this.carrier < this.CENTER_CARRIER - 300.0) {
            this.carrier = this.CENTER_CARRIER - 300.0;
        }
        double lower = this.carrier - 75.0;
        double upper = this.carrier + 75.0;
        double lower_phase = lower * 2.0 * Math.PI / (double)this.currentSampleRate;
        double upper_phase = upper * 2.0 * Math.PI / (double)this.currentSampleRate;
        double cpt0 = this.frequencyTracker(this.abBufferDoubleFiltered, this.symphase, lower_phase);
        double cpt1 = this.frequencyTracker(this.abBufferDoubleFiltered, this.symphase, upper_phase);
        if (cpt1 != cpt0) {
            this.carrier = lower - cpt0 * (upper - lower) / (cpt1 - cpt0);
        }
        if (Double.isNaN(this.carrier)) {
            this.carrier = this.CENTER_CARRIER;
        }
        if (this.carrier > this.CENTER_CARRIER + 300.0) {
            this.carrier = this.CENTER_CARRIER + 300.0;
        }
        if (this.carrier < this.CENTER_CARRIER - 300.0) {
            this.carrier = this.CENTER_CARRIER - 300.0;
        }
        this.cphase_inc = this.carrier * 2.0 * Math.PI / (double)this.currentSampleRate;
        this.nco.setPhaseIncrement(this.cphase_inc);
        this.nco.setPhase(this.cphase);
        int eyeValue = 0;
        int i = 0;
        while (i < this.BUFFER_SIZE) {
            this.c = this.nco.nextSample();
            this.c.normalize();
            this.baseband_i[i] = this.abBufferDoubleFiltered[i] * this.c.geti();
            this.baseband_q[i] = this.abBufferDoubleFiltered[i] * -1.0 * this.c.getq();
            this.baseband_i[i] = this.dataFilterI.filterDouble(this.baseband_i[i]);
            this.baseband_q[i] = this.dataFilterQ.filterDouble(this.baseband_q[i]);
            double mag = Math.sqrt(this.baseband_i[i] * this.baseband_i[i] + this.baseband_q[i] * this.baseband_q[i]);
            this.pskAudioData[i] = 1.0 * (mag - 1.0);
            this.pskQAudioData[i] = this.baseband_q[i] * 0.7;
            eyeValue = (int)(this.pskAudioData[i] * 32767.0);
            this.eyeData.setData(i / this.bucketSize, i % this.bucketSize, eyeValue);
            this.phasorData[2 * i] = this.baseband_i[i];
            this.phasorData[2 * i + 1] = this.baseband_q[i];
            ++i;
        }
        int DEFAULT_INDEX = -2;
        int best_index = -1;
        double energy = -9.0E99;
        int i2 = 0;
        while (i2 < 5) {
            this.demodState[i2] = this.demodulate(this.baseband_i, this.baseband_q, this.symphase + i2 + DEFAULT_INDEX);
            if (energy < this.demodState[i2].energy) {
                best_index = i2;
                energy = this.demodState[i2].energy;
            }
            ++i2;
        }
        if (best_index == -1) {
            best_index = 2;
        }
        this.symphase = this.symphase + best_index + DEFAULT_INDEX;
        this.symbol_count = this.demodState[best_index].symbol_count;
        this.data = this.demodState[best_index].data;
        this.Symbols_demodulated += this.symbol_count;
        int cfr_ignored_0 = this.chunk % 1;
        i2 = 1;
        while (i2 < this.symbol_count) {
            boolean thisSample = false;
            if (this.data[i2] > 0.0) {
                thisSample = true;
            }
            this.bitStream.addBit(thisSample);
            if (thisSample) {
                this.eyeData.setHigh((int)this.data[i2] * 256);
            } else {
                this.eyeData.setLow((int)this.data[i2] * 256);
            }
            ++i2;
        }
        this.eyeData.clockOffset = offset = 0;
        this.samples_processed = this.bucketSize * (this.symbol_count - 1);
        int move = this.bucketSize / 2;
        if (this.symphase <= this.bucketSize / 2) {
            this.samples_processed -= move;
            this.symphase += move;
        } else if (this.symphase >= 3 * this.bucketSize / 2) {
            this.samples_processed += move;
            this.symphase -= move;
        }
        int amount = this.BUFFER_SIZE - this.samples_processed;
        this.rewind(amount);
        this.cphase = (this.cphase + (double)this.samples_processed * this.cphase_inc) % (Math.PI * 2);
        ++this.chunk;
        if (maxValue - minValue != 0.0) {
            this.gain = DESIRED_RANGE / (1.0 * (maxValue - minValue));
        }
        if (this.gain < 1.0) {
            this.gain = 1.0;
        }
    }

    private double frequencyTracker(double[] samples, int symphase, double cphase_inc) {
        double[] baseband_i = new double[this.BUFFER_SIZE];
        double[] baseband_q = new double[this.BUFFER_SIZE];
        int Ntaps = this.matchedFilter.getNumOfTaps();
        this.ftcos.setPhaseIncrement(cphase_inc);
        this.ftsin.setPhaseIncrement(cphase_inc);
        this.ftcos.setPhase(0.0);
        this.ftsin.setPhase(0.0);
        int i = 0;
        while (i < this.BUFFER_SIZE) {
            baseband_i[i] = samples[i] * this.ftcos.nextSample();
            baseband_q[i] = samples[i] * this.ftsin.nextSample();
            ++i;
        }
        double cpt = 0.0;
        double tlast_q = 0.0;
        double tlast_i = 0.0;
        int bb_p = symphase;
        while (bb_p + Ntaps < this.BUFFER_SIZE) {
            double fq;
            double fi = this.matchedFilter.dotprod(baseband_i, bb_p);
            double symbol = fi * tlast_i + (fq = this.matchedFilter.dotprod(baseband_q, bb_p)) * tlast_q;
            cpt = symbol < 0.0 ? (cpt -= fi * tlast_q - fq * tlast_i) : (cpt += fi * tlast_q - fq * tlast_i);
            tlast_i = fi;
            tlast_q = fq;
            bb_p += this.bucketSize;
        }
        return cpt;
    }

    private PskDemodState demodulate(double[] baseband_i, double[] baseband_q, int symphase) {
        int symbol_count = 0;
        double tlast_i = 0.0;
        double tlast_q = 0.0;
        int Ntaps = this.matchedFilter.getNumOfTaps();
        double[] data = new double[this.SAMPLE_WINDOW_LENGTH];
        double en_tmp = 0.0;
        int bb_p = symphase;
        while (bb_p + Ntaps < this.BUFFER_SIZE) {
            double fi = this.matchedFilter.dotprod(baseband_i, bb_p);
            double fq = this.matchedFilter.dotprod(baseband_q, bb_p);
            double symbol = fi * tlast_i + fq * tlast_q;
            en_tmp += symbol * symbol;
            assert (symbol_count < this.SAMPLE_WINDOW_LENGTH);
            data[symbol_count++] = symbol;
            tlast_i = fi;
            tlast_q = fq;
            bb_p += this.bucketSize;
        }
        PskDemodState demodState = new PskDemodState(symphase, en_tmp, data, symbol_count);
        return demodState;
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static double average(double avg, double new_sample, int N) {
        avg -= avg / (double)N;
        return avg += new_sample / (double)N;
    }

    public double getFrequency() {
        return this.nco.getFrequency();
    }

    public int getOffset() {
        return this.symphase;
    }

    class PskDemodState {
        int symphase;
        double energy;
        double[] data;
        int symbol_count;

        PskDemodState(int symphase, double energy, double[] data, int symbol_count) {
            this.symphase = symphase;
            this.energy = energy;
            this.data = data;
            this.symbol_count = symbol_count;
        }
    }
}

