/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;
import decoder.FoxBPSK.FormatBitStream;
import decoder.FoxDecoder;
import decoder.SourceAudio;
import filter.RaisedCosineFilter;
import telemetry.Format.TelemFormat;

public class FoxFskDecoder
extends FoxDecoder {
    public static final String HIGHSPEED_FSK = "FSK 9600bps (Fox1)";
    public static final String DUV_FSK = "FSK 200bps (Fox1)";

    public FoxFskDecoder(SourceAudio as, int chan, TelemFormat telemFormat) {
        super("DUV", as, chan, telemFormat);
        this.telemFormat = telemFormat;
    }

    @Override
    public void init() {
        Log.println("Initializing Decoder with Format: " + this.telemFormat.name);
        this.setParameters();
        super.init();
        this.updateFilter();
    }

    private void updateFilter() {
        this.filter = new RaisedCosineFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
        this.filter.init(this.currentSampleRate, this.telemFormat.getInt("bps"), this.bucketSize * 2);
    }

    private void setParameters() {
        this.bitStream = new FormatBitStream(this, this.telemFormat, false);
        this.BITS_PER_SECOND = this.telemFormat.getInt("bps");
        this.bucketSize = this.currentSampleRate / this.BITS_PER_SECOND;
        this.SAMPLE_WIDTH = this.bucketSize * this.SAMPLE_WIDTH_PERCENT / 100;
        if (this.SAMPLE_WIDTH < 1) {
            this.SAMPLE_WIDTH = 1;
        }
        this.SAMPLE_WINDOW_LENGTH = this.telemFormat.getInt("symbols_per_chunk");
        this.CLOCK_TOLERANCE = 10;
        this.CLOCK_REOVERY_ZERO_THRESHOLD = 20;
        if (this.BITS_PER_SECOND == 9600) {
            this.CLOCK_REOVERY_ZERO_THRESHOLD = 10;
        }
    }
}

