/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;
import decoder.CircularDoubleBuffer;
import javax.sound.sampled.AudioFormat;

public abstract class SourceAudio
implements Runnable {
    protected int channels = 0;
    public static final int FILE_SOURCE = 1;
    public static final int AIRSPY_SOURCE = 2;
    public static final int OFFSET = 2;
    public static final String FILE_SOURCE_NAME = "Load Wav File";
    protected String name = "unknown";
    protected boolean done = false;
    protected boolean running = true;
    protected int sampleRate = 48000;
    public AudioFormat audioFormat = null;
    protected CircularDoubleBuffer[] circularDoubleBuffer;
    public boolean storeStereo = false;

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public SourceAudio(String n, int circularBufferSize, int channels, boolean stereo) {
        this.name = n;
        if (circularBufferSize % 2 == 0) {
            ++circularBufferSize;
        }
        if (channels == 0) {
            this.circularDoubleBuffer = new CircularDoubleBuffer[1];
            this.circularDoubleBuffer[0] = new CircularDoubleBuffer(circularBufferSize);
        } else {
            this.circularDoubleBuffer = new CircularDoubleBuffer[channels];
            int i = 0;
            while (i < channels) {
                this.circularDoubleBuffer[i] = new CircularDoubleBuffer(circularBufferSize);
                ++i;
            }
        }
        this.channels = channels;
        this.storeStereo = stereo;
    }

    public void rewind(int amount, int chan) {
        try {
            this.circularDoubleBuffer[chan].decStartPointer(amount);
        }
        catch (IndexOutOfBoundsException e) {
            Log.println("Non Fatal Error.  Rewind before buffer data: " + e.getMessage());
        }
    }

    public int read(double[] abData, int chan) {
        int doublesRead = 0;
        while (this.running && doublesRead < abData.length) {
            if (this.circularDoubleBuffer[chan].size() > 2) {
                try {
                    abData[doublesRead] = this.circularDoubleBuffer[chan].get(0);
                    this.circularDoubleBuffer[chan].incStartPointer(1);
                    ++doublesRead;
                }
                catch (IndexOutOfBoundsException e) {
                    Log.errorDialog(String.valueOf(this.name) + ": AUDIO BUFFER READ ERROR on channel: " + chan, String.valueOf(e.getMessage()) + "\nTry starting the decoder again.");
                    Log.println(String.valueOf(this.name) + ": threw error:");
                    e.printStackTrace(Log.getWriter());
                }
                continue;
            }
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return doublesRead;
    }

    public int getAudioBufferCapacity() {
        return this.circularDoubleBuffer[0].getCapacity();
    }

    public int getAudioBufferCapacity(int chan) {
        return this.circularDoubleBuffer[chan].getCapacity();
    }

    public int getAudioBufferSize() {
        return this.circularDoubleBuffer[0].bufferSize;
    }

    public int getAudioBufferSize(int chan) {
        return this.circularDoubleBuffer[chan].bufferSize;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public abstract void run();

    public abstract void stop(String var1);

    public static void getBytesFromDoubles(double[] audioData, int storedSamples, boolean stereo, byte[] audioDataBytes) {
        int k = 0;
        if (!stereo) {
            int i = 0;
            while (i < storedSamples) {
                byte low;
                audioData[i] = Math.min(1.0, Math.max(-1.0, audioData[i]));
                int sample = (int)Math.round((audioData[i] + 1.0) * 32767.5) - 32768;
                byte high = (byte)(sample >> 8 & 0xFF);
                audioDataBytes[k] = low = (byte)(sample & 0xFF);
                audioDataBytes[k + 1] = high;
                k += 2;
                ++i;
            }
        } else {
            int i = 0;
            while (i < storedSamples) {
                byte low;
                audioData[i] = Math.min(1.0, Math.max(-1.0, audioData[i]));
                int sample = (int)Math.round((audioData[i] + 1.0) * 32767.5) - 32768;
                byte high = (byte)(sample >> 8 & 0xFF);
                audioDataBytes[k] = low = (byte)(sample & 0xFF);
                audioDataBytes[k + 1] = high;
                audioDataBytes[k + 2] = low;
                audioDataBytes[k + 3] = high;
                k += 4;
                ++i;
            }
        }
    }
}

