/*
 * Decompiled with CFR 0.152.
 */
package device.fcd;

import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.fcd.FCDCommand;
import device.fcd.FCDTunerController;
import device.fcd.FcdProPanel;
import device.rtl.RTL2832TunerController;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;

public class FCD1TunerController
extends FCDTunerController {
    public static final int MINIMUM_TUNABLE_FREQUENCY = 64000;
    public static final int MAXIMUM_TUNABLE_FREQUENCY = 1700000;
    public static final int SAMPLE_RATE = 96000;
    public static String[] lnaGain = new String[]{"-5dB", "-2.5dB", "0dB", "2.5dB", "5dB", "7.5dB", "10dB", "12.5dB", "15dB", "17.5dB", "20dB", "25dB", "30dB"};
    public static String[] mixerGain = new String[]{"4dB", "12dB"};
    int TMGE_P4_0DB = 0;
    int TMGE_P12_0DB = 1;
    int TLEE_OFF = 0;
    int TLEE_0 = 1;
    int TLEE_1 = 3;
    int TLEE_2 = 5;
    int TLEE_3 = 7;
    int TBE_VHF2 = 0;
    int TBE_VHF3 = 1;
    int TBE_UHF = 2;
    int TBE_LBAND = 3;
    String[] band = new String[]{"VHF II", "VHF III", "UHF", "LBAND"};
    String[] vhfIIFilterName = new String[]{"268MHz", "299MHz"};
    String[] vhfIIIFilterName = new String[]{"509MHz", "656MHz"};
    String[] uhfFilterName = new String[]{"360MHz", "380MHz", "405MHz", "425MHz", "450MHz", "475MHz", "505MHz", "540MHz", "575MHz", "615MHz", "670MHz", "720MHz", "760MHz", "840MHz", "890MHz", "970MHz"};
    String[] lbandFilterName = new String[]{"1300MHz", "1320MHz", "1360MHz", "1410MHz", "1445MHz", "1460MHz", "1490MHz", "1530MHz", "1560MHz", "1590MHz", "1640MHz", "1660MHz", "1680MHz", "1700MHz", "1720MHz", "1750MHz"};
    int TRFE_LPF268MHZ = 0;
    int TRFE_LPF299MHZ = 8;
    int TRFE_LPF509MHZ = 0;
    int TRFE_LPF656MHZ = 8;
    int TRFE_BPF360MHZ = 0;
    int TRFE_BPF380MHZ = 1;
    int TRFE_BPF405MHZ = 2;
    int TRFE_BPF425MHZ = 3;
    int TRFE_BPF450MHZ = 4;
    int TRFE_BPF475MHZ = 5;
    int TRFE_BPF505MHZ = 6;
    int TRFE_BPF540MHZ = 7;
    int TRFE_BPF575MHZ = 8;
    int TRFE_BPF615MHZ = 9;
    int TRFE_BPF670MHZ = 10;
    int TRFE_BPF720MHZ = 11;
    int TRFE_BPF760MHZ = 12;
    int TRFE_BPF840MHZ = 13;
    int TRFE_BPF890MHZ = 14;
    int TRFE_BPF970MHZ = 15;
    int TRFE_BPF1300MHZ = 0;
    int TRFE_BPF1320MHZ = 1;
    int TRFE_BPF1360MHZ = 2;
    int TRFE_BPF1410MHZ = 3;
    int TRFE_BPF1445MHZ = 4;
    int TRFE_BPF1460MHZ = 5;
    int TRFE_BPF1490MHZ = 6;
    int TRFE_BPF1530MHZ = 7;
    int TRFE_BPF1560MHZ = 8;
    int TRFE_BPF1590MHZ = 9;
    int TRFE_BPF1640MHZ = 10;
    int TRFE_BPF1660MHZ = 11;
    int TRFE_BPF1680MHZ = 12;
    int TRFE_BPF1700MHZ = 13;
    int TRFE_BPF1720MHZ = 14;
    int TRFE_BPF1750MHZ = 15;
    int TBCE_LBAND = 0;
    int TBCE_1 = 1;
    int TBCE_2 = 2;
    int TBCE_VUBAND = 3;
    int TMFE_27_0MHZ = 0;
    int TMFE_4_6MHZ = 8;
    int TMFE_4_2MHZ = 9;
    int TMFE_3_8MHZ = 10;
    int TMFE_3_4MHZ = 11;
    int TMFE_3_0MHZ = 12;
    int TMFE_2_7MHZ = 13;
    int TMFE_2_3MHZ = 14;
    int TMFE_1_9MHZ = 15;
    int TIG1E_N3_0DB = 0;
    int TIG1E_P6_0DB = 1;
    int TIGME_LINEARITY = 0;
    int TIGME_SENSITIVITY = 1;
    int TIRFE_21_4MHZ = 0;
    int TIRFE_21_0MHZ = 1;
    int TIRFE_17_6MHZ = 2;
    int TIRFE_14_7MHZ = 3;
    int TIRFE_12_4MHZ = 4;
    int TIRFE_10_6MHZ = 5;
    int TIRFE_9_0MHZ = 6;
    int TIRFE_7_7MHZ = 7;
    int TIRFE_6_4MHZ = 8;
    int TIRFE_5_3MHZ = 9;
    int TIRFE_4_4MHZ = 10;
    int TIRFE_3_4MHZ = 11;
    int TIRFE_2_6MHZ = 12;
    int TIRFE_1_8MHZ = 13;
    int TIRFE_1_2MHZ = 14;
    int TIRFE_1_0MHZ = 15;
    int TIG2E_P0_0DB = 0;
    int TIG2E_P3_0DB = 1;
    int TIG2E_P6_0DB = 2;
    int TIG2E_P9_0DB = 3;
    int TIG3E_P0_0DB = 0;
    int TIG3E_P3_0DB = 1;
    int TIG3E_P6_0DB = 2;
    int TIG3E_P9_0DB = 3;
    int TIG4E_P0_0DB = 0;
    int TIG4E_P1_0DB = 1;
    int TIG4E_P2_0DB = 2;
    int TIFE_5_50MHZ = 0;
    int TIFE_5_30MHZ = 1;
    int TIFE_5_00MHZ = 2;
    int TIFE_4_80MHZ = 3;
    int TIFE_4_60MHZ = 4;
    int TIFE_4_40MHZ = 5;
    int TIFE_4_30MHZ = 6;
    int TIFE_4_10MHZ = 7;
    int TIFE_3_90MHZ = 8;
    int TIFE_3_80MHZ = 9;
    int TIFE_3_70MHZ = 10;
    int TIFE_3_60MHZ = 11;
    int TIFE_3_40MHZ = 12;
    int TIFE_3_30MHZ = 13;
    int TIFE_3_20MHZ = 14;
    int TIFE_3_10MHZ = 15;
    int TIFE_3_00MHZ = 16;
    int TIFE_2_95MHZ = 17;
    int TIFE_2_90MHZ = 18;
    int TIFE_2_80MHZ = 19;
    int TIFE_2_75MHZ = 20;
    int TIFE_2_70MHZ = 21;
    int TIFE_2_60MHZ = 22;
    int TIFE_2_55MHZ = 23;
    int TIFE_2_50MHZ = 24;
    int TIFE_2_45MHZ = 25;
    int TIFE_2_40MHZ = 26;
    int TIFE_2_30MHZ = 27;
    int TIFE_2_28MHZ = 28;
    int TIFE_2_24MHZ = 29;
    int TIFE_2_20MHZ = 30;
    int TIFE_2_15MHZ = 31;
    int TIG5E_P3_0DB = 0;
    int TIG5E_P6_0DB = 1;
    int TIG5E_P9_0DB = 2;
    int TIG5E_P12_0DB = 3;
    int TIG5E_P15_0DB = 4;
    int TIG6E_P3_0DB = 0;
    int TIG6E_P6_0DB = 1;
    int TIG6E_P9_0DB = 2;
    int TIG6E_P12_0DB = 3;
    int TIG6E_P15_0DB = 4;

    public FCD1TunerController(Device device, DeviceDescriptor descriptor) throws DeviceException {
        super("FCDP", device, descriptor, 96000, 64000L, 1700000L);
    }

    @Override
    public void init() throws DeviceException {
        super.init();
        try {
            this.setFCDMode(FCDTunerController.Mode.APPLICATION);
            this.send(FCDCommand.APP_SET_MIXER_GAIN, 1L);
        }
        catch (Exception e) {
            e.printStackTrace(Log.getWriter());
            throw new DeviceException("FCDTunerController error during construction: " + e.getMessage());
        }
    }

    @Override
    public int getCurrentSampleRate() {
        return 96000;
    }

    public void setLnaGain(int val) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_LNA_GAIN, val);
        }
        catch (Exception e) {
            Log.println("error while setting LNA Gain: " + e.getMessage());
            throw e;
        }
    }

    public int getLnaGain() {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_LNA_GAIN);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int gain = buffer.getInt(2);
        return gain;
    }

    public void setRFFilter(int filter) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_RF_FILTER, filter);
        }
        catch (Exception e) {
            Log.println("error while setting RF Filter: " + e.getMessage());
            throw e;
        }
    }

    public String getRfFilter() throws IOException, DeviceException {
        int band = this.getBandInt();
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_RF_FILTER);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int filter = buffer.getInt(2);
        Log.println("RF FILTER: " + filter);
        if (band == 0) {
            if (filter > -1 && filter < this.vhfIIFilterName.length) {
                return this.vhfIIFilterName[filter];
            }
        } else if (band == 1) {
            if (filter > -1 && filter < this.vhfIIIFilterName.length) {
                return this.vhfIIIFilterName[filter];
            }
        } else if (band == 2) {
            if (filter > -1 && filter < this.uhfFilterName.length) {
                return this.uhfFilterName[filter];
            }
        } else if (band == 3 && filter > -1 && filter < this.lbandFilterName.length) {
            return this.lbandFilterName[filter];
        }
        return "";
    }

    public String getBand() throws IOException, DeviceException {
        int ret = this.getBandInt();
        if (ret > -1 && ret < this.band.length) {
            return this.band[ret];
        }
        return "";
    }

    public int getBandInt() throws IOException, DeviceException {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_BAND);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int bandNum = buffer.getInt(2);
        Log.println("BAND: " + bandNum);
        if (bandNum > -1 && bandNum < this.band.length) {
            return bandNum;
        }
        return 99;
    }

    @Override
    public DevicePanel getDevicePanel() throws IOException, DeviceException {
        return new FcdProPanel();
    }

    @Override
    public void setSampleRate(RTL2832TunerController.SampleRate sampleRate) {
    }

    public static enum Block {
        CELLULAR_BAND_BLOCKED("Blocked"),
        NO_BAND_BLOCK("Unblocked"),
        UNKNOWN("Unknown");

        private String mLabel;

        private Block(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static Block getBlock(String block) {
            Block retVal = UNKNOWN;
            if (block.equalsIgnoreCase("No blk")) {
                retVal = NO_BAND_BLOCK;
            } else if (block.equalsIgnoreCase("Cell blk")) {
                retVal = CELLULAR_BAND_BLOCKED;
            }
            return retVal;
        }
    }
}

