/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Config;
import filter.DcRemoval;
import javax.sound.sampled.AudioFormat;

public abstract class Filter {
    protected String name = "UNDEFINED FILTER";
    protected int SAMPLERATE = 48000;
    protected int length = 0;
    double[] overlapDouble;
    double cutoffFreq = 200.0;
    boolean overlapAdd = true;
    boolean stereo = true;
    boolean useAGC = false;
    boolean filterDC = true;
    DcRemoval dcFilter;
    AudioFormat audioFormat;
    int doubleBufferSize;
    private double gain = 1.0;
    double[] abBufferDouble;
    boolean decimationFilter = false;
    int decimationFactor = 0;
    int decimationCount = 0;

    public Filter(AudioFormat af, int bufferSize) {
        this.audioFormat = af;
        this.doubleBufferSize = bufferSize;
    }

    public double getGain() {
        return this.gain;
    }

    public void setDecimationFactor(int f) {
        this.decimationFactor = f;
        this.decimationCount = f;
        this.decimationFilter = true;
    }

    protected boolean calculateNow() {
        if (this.decimationFilter) {
            if (this.decimationCount == this.decimationFactor) {
                --this.decimationCount;
                return true;
            }
            --this.decimationCount;
            if (this.decimationCount == 0) {
                this.decimationCount = this.decimationFactor;
            }
            return false;
        }
        return true;
    }

    protected void coreInit() {
        if (this.audioFormat.getChannels() == 1) {
            this.stereo = false;
        }
        this.useAGC = Config.useAGC;
    }

    public void setAGC(boolean s) {
        this.useAGC = s;
    }

    public void setFilterDC(boolean s) {
        this.filterDC = s;
    }

    public void init(double sampleRate, double freq, int len) {
        this.coreInit();
        this.SAMPLERATE = (int)sampleRate;
        this.cutoffFreq = freq;
        this.length = len;
        this.dcFilter = new DcRemoval(0.9999f);
        this.overlapDouble = new double[this.getFilterLength()];
        this.abBufferDouble = new double[this.doubleBufferSize + this.getFilterLength()];
    }

    public void filter(double[] inputDouble, double[] outputDouble) {
        int i;
        int samplesRead = inputDouble.length;
        double maxLevel = 0.0;
        double minLevel = 0.0;
        int i2 = 0;
        while (i2 < samplesRead) {
            this.abBufferDouble[i2] = this.filterDC ? this.dcFilter.filter(inputDouble[i2]) : inputDouble[i2];
            ++i2;
        }
        i2 = samplesRead;
        while (i2 < samplesRead + this.getFilterLength()) {
            this.abBufferDouble[i2] = 0.0;
            ++i2;
        }
        i2 = 0;
        while (i2 < samplesRead + this.getFilterLength()) {
            this.abBufferDouble[i2] = this.filterDouble(this.abBufferDouble[i2]);
            if (this.abBufferDouble[i2] > maxLevel) {
                maxLevel = this.abBufferDouble[i2];
            }
            if (this.abBufferDouble[i2] < minLevel) {
                minLevel = this.abBufferDouble[i2];
            }
            ++i2;
        }
        if (this.overlapAdd) {
            this.abBufferDouble = this.overlapAdd(this.abBufferDouble);
        }
        this.storeOverlap(this.abBufferDouble);
        double DESIRED_MAX_LEVEL = 0.5;
        this.gain = DESIRED_MAX_LEVEL / maxLevel;
        if (!this.useAGC) {
            this.gain = 1.0;
        }
        if (this.gain != 1.0 && Config.useAGC) {
            i = 0;
            while (i < samplesRead + this.getFilterLength()) {
                this.abBufferDouble[i] = this.amplify(this.abBufferDouble[i], this.gain);
                ++i;
            }
        }
        i = 0;
        while (i < samplesRead) {
            outputDouble[i] = this.abBufferDouble[i];
            ++i;
        }
    }

    public abstract double filterDouble(double var1);

    protected abstract int getFilterLength();

    public abstract double[] getKernal();

    private double[] overlapAdd(double[] buffer) {
        int i = 0;
        while (i < this.overlapDouble.length) {
            buffer[i] = buffer[i] + this.overlapDouble[i];
            ++i;
        }
        return buffer;
    }

    private void storeOverlap(double[] buffer) {
        if (buffer.length > this.overlapDouble.length + 1) {
            int i = 0;
            while (i < this.overlapDouble.length) {
                this.overlapDouble[i] = buffer[buffer.length - this.overlapDouble.length - 1 + i];
                ++i;
            }
        }
    }

    private double amplify(double in, double gain) {
        if ((in *= gain) > 1.0) {
            in = 1.0;
        }
        if (in < -1.0) {
            in = -1.0;
        }
        return in;
    }

    public String toString() {
        return this.name;
    }
}

