/*
 * Decompiled with CFR 0.152.
 */
package filter;

public abstract class Oscillator {
    protected final int TABLE_SIZE = 9600;
    protected double[] sinTable = new double[9600];
    private int samplesPerSecond = 0;
    private double frequency = 0.0;
    private double phase = 0.0;
    private double phaseIncrement = 0.0;
    double value = 0.0;
    int idx = 0;

    public Oscillator(int samples, int freq) {
        this.samplesPerSecond = samples;
        this.setFrequency(freq);
    }

    public Oscillator(int samples, double phaseInc) {
        this.samplesPerSecond = samples;
        this.setPhaseIncrement(phaseInc);
    }

    public void changePhase(double phaseIncrement) {
        this.incPhase(phaseIncrement);
    }

    public void changePhaseOLD(double phaseIncrement) {
        if (phaseIncrement < Math.PI * 2 && phaseIncrement > Math.PI * -2) {
            this.phase += phaseIncrement;
            if (this.phase >= Math.PI * 2) {
                this.phase -= Math.PI * 2;
                this.frequency += 1.0;
                this.setFrequency(this.frequency);
            }
            if (this.phase <= 0.0) {
                this.phase += Math.PI * 2;
                this.frequency -= 1.0;
                this.setFrequency(this.frequency);
            }
        }
    }

    private void incPhase(double phaseIncrement) {
        if (phaseIncrement < Math.PI * 2 && phaseIncrement > Math.PI * -2) {
            this.phase += phaseIncrement;
            if (this.phase >= Math.PI * 2) {
                this.phase -= Math.PI * 2;
            }
            if (this.phase <= 0.0) {
                this.phase += Math.PI * 2;
            }
        }
    }

    public void setFrequency(double freq) {
        if (this.frequency != freq) {
            this.frequency = freq;
            this.phaseIncrement = Math.PI * 2 * this.frequency / (double)this.samplesPerSecond;
        }
    }

    public void setPhase(double phase) {
        this.phase = phase % 2.0 * Math.PI;
    }

    public void setPhaseIncrement(double phaseInc) {
        if (this.phaseIncrement != phaseInc) {
            this.frequency = phaseInc * (double)this.samplesPerSecond / (Math.PI * 2);
            this.phaseIncrement = phaseInc;
        }
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getPhase() {
        return this.phase;
    }

    public double getPhaseIncrement() {
        return this.phaseIncrement;
    }

    public double nextSample() {
        this.incPhase(this.phaseIncrement);
        this.idx = (int)(this.phase * 9600.0 / (Math.PI * 2)) % 9600;
        try {
            this.value = this.sinTable[this.idx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.value;
    }
}

