/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import gui.graph.LinePlotPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioGraphPanel
extends JPanel
implements Runnable {
    String fileName = null;
    boolean running = true;
    boolean done = false;
    int centerFreqX = 220;
    Decoder foxDecoder;
    double[] audioData = null;
    double[] pskAudioData = null;
    double[] pskQAudioData = null;
    int AUDIO_DATA_SIZE = 1024;
    int currentDataPosition = 0;
    JLabel sample;
    int s = 0;
    JLabel title = new JLabel("Sample rate: ");
    int bitValue = 10;
    boolean showFilteredAudio = false;
    long bufferCapacityAvg;
    int bufferCapacitySample;
    final int BUFFER_CAP_SAMPLE_NO = 100;
    int bufferCapacity;
    boolean firstRun = true;

    public AudioGraphPanel() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        this.add(this.title);
    }

    public void updateFont() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
    }

    public void showFilteredAudio() {
        this.showFilteredAudio = true;
    }

    public void showUnFilteredAudio() {
        this.showFilteredAudio = false;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("AudioGraphPanel");
        this.done = false;
        this.running = true;
        this.currentDataPosition = 0;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: Audiograph thread interrupted");
            }
            if (this.foxDecoder == null) continue;
            double[] buffer = this.showFilteredAudio ? this.foxDecoder.getFilteredData() : this.foxDecoder.getAudioData();
            if (buffer != null) {
                this.audioData = buffer;
                if (this.foxDecoder instanceof FoxBPSKCostasDecoder) {
                    this.pskAudioData = ((FoxBPSKCostasDecoder)this.foxDecoder).getBasebandData();
                    this.pskQAudioData = ((FoxBPSKCostasDecoder)this.foxDecoder).getBasebandQData();
                }
                if (this.foxDecoder instanceof FoxBPSKDotProdDecoder) {
                    this.pskAudioData = ((FoxBPSKDotProdDecoder)this.foxDecoder).getBasebandData();
                    this.pskQAudioData = ((FoxBPSKDotProdDecoder)this.foxDecoder).getBasebandQData();
                }
            }
            this.repaint();
        }
    }

    public void startProcessing(Decoder decoder1) {
        this.foxDecoder = decoder1;
        if (this.foxDecoder != null) {
            this.title.setText("Sample rate: " + Integer.toString(this.foxDecoder.getCurrentSampleRate()) + " | Symbols: " + this.foxDecoder.getSampleWindowLength());
        }
        this.running = true;
    }

    public void stopProcessing() {
        this.running = false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.firstRun) {
            g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            this.firstRun = false;
        }
        int border = 5;
        int graphHeight = this.getHeight() - border;
        int graphWidth = this.getWidth() - border * 2;
        float maxValue = 1.0f;
        float minValue = -1.0f;
        int labelHeight = 14;
        int sideLabel = 3;
        if (Config.debugAudioLevels) {
            int numberOfLabels = graphHeight / labelHeight;
            double[] labels = LinePlotPanel.calcAxisInterval(minValue, maxValue, numberOfLabels, false);
            numberOfLabels = labels.length;
            DecimalFormat f1 = new DecimalFormat("0.0");
            DecimalFormat f2 = new DecimalFormat("0");
            g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            int v = 0;
            while (v < numberOfLabels) {
                int pos = this.getRatioPosition(minValue, maxValue, labels[v], graphHeight);
                pos = graphHeight - pos;
                String s = null;
                s = labels[v] == (double)Math.round(labels[v]) ? f2.format(labels[v]) : f1.format(labels[v]);
                if (v < numberOfLabels - 1 && (v != 0 || pos <= graphHeight)) {
                    g.drawString(s, sideLabel, pos + border + 4);
                    g.drawLine(border - 5, pos + border, graphWidth - border, pos + border);
                }
                ++v;
            }
        }
        int lastx = border * 2 + 1;
        int lasty = graphHeight / 2;
        int x = border * 2 + 1;
        int lastx2 = border * 2 + 1;
        int lasty2 = graphHeight / 2;
        int x2 = border * 2 + 1;
        int lastx3 = border * 2 + 1;
        int lasty3 = graphHeight / 2;
        int x3 = border * 2 + 1;
        int stepSize = 1;
        try {
            if (this.audioData != null && this.audioData.length > 0) {
                if (this.audioData.length > graphWidth) {
                    stepSize = Math.round(this.audioData.length / graphWidth);
                }
                if (stepSize <= 0) {
                    stepSize = 1;
                }
                int bucketPositionCount = 0;
                int bitCount = 0;
                int i = 0;
                while (i < this.audioData.length - stepSize) {
                    if (this.pskAudioData != null && i < this.pskAudioData.length && (this.foxDecoder instanceof FoxBPSKDotProdDecoder || this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1)) {
                        g2.setColor(Color.BLACK);
                    } else {
                        g2.setColor(Color.BLUE);
                    }
                    x = border * 2 + i * (graphWidth - border * 2) / this.audioData.length;
                    if (Config.debugValues && this.foxDecoder != null) {
                        if (this.pskAudioData != null) {
                            if (this.pskAudioData[i] > 1000.0) {
                                this.bitValue = 1;
                            }
                            if (this.pskAudioData[i] < -1000.0) {
                                this.bitValue = 0;
                            }
                        }
                        if ((bucketPositionCount += stepSize) >= this.foxDecoder.getBucketSize()) {
                            g2.setColor(Color.BLACK);
                            g2.drawLine(x, 0, x, graphHeight);
                            g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize - 2));
                            g.drawString("" + (Config.windowStartBit + bitCount), x - 25, graphHeight - 20);
                            this.bitValue = this.foxDecoder.middleSample[bitCount] ? 1 : 0;
                            g2.setColor(Color.RED);
                            g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize * 2));
                            g.drawString("" + this.bitValue, x - 25, graphHeight - 100);
                            g2.setColor(Color.BLACK);
                            g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
                            bucketPositionCount = 0;
                            ++bitCount;
                        }
                    }
                    double y = 0.0;
                    double factor = 2.5;
                    if (Config.debugAudioLevels) {
                        factor = 1.0;
                    }
                    y = this.foxDecoder instanceof FoxBPSKDotProdDecoder || this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1 || Config.debugValues ? (double)(graphHeight / 4) + (double)graphHeight / factor * this.audioData[i] + (double)border : (double)(graphHeight / 2) + (double)graphHeight / factor * this.audioData[i] + (double)border;
                    g2.drawLine(lastx, lasty, x, (int)y);
                    lastx = x;
                    lasty = (int)y;
                    if (this.foxDecoder instanceof FoxBPSKDotProdDecoder || this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1) {
                        if (this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1 && this.pskAudioData != null && i < this.pskAudioData.length) {
                            int lock = (int)Math.round(((FoxBPSKCostasDecoder)this.foxDecoder).getLockLevel());
                            if ((double)lock > 10.0) {
                                g2.setColor(Color.BLUE);
                            } else {
                                g2.setColor(Color.gray);
                            }
                            g.drawString("Carrier: " + Math.round(((FoxBPSKCostasDecoder)this.foxDecoder).getFrequency()), graphWidth - 7 * Config.graphAxisFontSize, graphHeight / 2 + Config.graphAxisFontSize);
                        }
                        if (this.foxDecoder instanceof FoxBPSKDotProdDecoder) {
                            g2.setColor(Color.gray);
                            g.drawString("Carrier: " + Math.round(((FoxBPSKDotProdDecoder)this.foxDecoder).getFrequency()), graphWidth - 7 * Config.graphAxisFontSize, graphHeight / 2 + Config.graphAxisFontSize);
                        }
                        if (this.pskAudioData != null && this.pskAudioData.length > 0) {
                            g2.setColor(Color.BLUE);
                            x2 = border * 2 + i * (graphWidth - border * 2) / this.pskAudioData.length;
                            double y2 = 0.0;
                            try {
                                y2 = (double)(3 * graphHeight / 4) - (double)(graphHeight / 6) * this.pskAudioData[i] + (double)border;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            g2.drawLine(lastx2, lasty2, x2, (int)y2);
                            lastx2 = x2;
                            lasty2 = (int)y2;
                            if ((this.foxDecoder instanceof FoxBPSKDotProdDecoder || this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1) && this.pskQAudioData != null && i < this.pskQAudioData.length) {
                                g2.setColor(Color.RED);
                                x3 = border * 2 + i * (graphWidth - border * 2) / this.pskQAudioData.length;
                                double y3 = (double)(3 * graphHeight / 4) - (double)(graphHeight / 6) * this.pskQAudioData[i] + (double)border;
                                g2.drawLine(lastx3, lasty3, x3, (int)y3);
                                lastx3 = x3;
                                lasty3 = (int)y3;
                            }
                        }
                    }
                    i += stepSize;
                }
            }
            g2.setColor(Color.GRAY);
            if (this.foxDecoder instanceof FoxBPSKDotProdDecoder || this.foxDecoder instanceof FoxBPSKCostasDecoder && ((FoxBPSKCostasDecoder)this.foxDecoder).mode == 1 || Config.debugValues) {
                g2.drawLine(0, graphHeight / 4 + border, graphWidth, graphHeight / 4 + border);
                g2.drawLine(0, 3 * graphHeight / 4 + border, graphWidth, 3 * graphHeight / 4 + border);
            } else {
                g2.drawLine(0, graphHeight / 2 + border, graphWidth, graphHeight / 2 + border);
            }
            if (Config.debugValues && this.foxDecoder != null) {
                g.drawString("Window: " + Config.windowsProcessed, 20, 20);
            }
            if (Config.debugAudioGlitches) {
                Runtime rt = Runtime.getRuntime();
                long usedMB = (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
                g.drawString("Mem: " + usedMB, 10, 20);
                if (this.foxDecoder != null && this.foxDecoder.getFilter() != null) {
                    g.drawString("Gain: " + LinePlotPanel.roundToSignificantFigures(this.foxDecoder.getFilter().getGain(), 4), 70, 20);
                    this.bufferCapacityAvg += (long)this.foxDecoder.getAudioBufferCapacity();
                    ++this.bufferCapacitySample;
                    if (this.bufferCapacitySample == 100) {
                        this.bufferCapacity = (int)(this.bufferCapacityAvg / (long)this.bufferCapacitySample);
                        this.bufferCapacitySample = 0;
                        this.bufferCapacityAvg = 0L;
                    }
                    g.drawString("Size: " + this.foxDecoder.getAudioBufferSize() + " Capacity: " + this.foxDecoder.getAudioBufferCapacity(), this.getWidth() - 200, 20);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private int getRatioPosition(double min, double max, double value, int dimension) {
        double ratio = (max - value) / (max - min);
        int position = (int)Math.round((double)dimension * ratio);
        return dimension - position;
    }
}

