/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class InitalSettings
extends JDialog
implements ActionListener,
WindowListener {
    private JPanel contentPane;
    private JPanel directories;
    private JTextField txtLogFileDirectory;
    JLabel title;
    JLabel lab;
    JLabel lab2;
    JLabel lab3;
    JLabel lab4;
    JButton btnContinue;
    JButton btnCancel;
    JButton btnBrowse;

    public InitalSettings(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Welcome to the Amsat Fox Telemetry Analysis Tool");
        this.setDefaultCloseOperation(0);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel top = new JPanel();
        this.contentPane.add((Component)top, "North");
        JPanel center = new JPanel();
        this.contentPane.add((Component)center, "Center");
        JPanel bottom = new JPanel();
        this.contentPane.add((Component)bottom, "South");
        this.title = new JLabel();
        this.lab = new JLabel();
        this.lab2 = new JLabel();
        this.lab3 = new JLabel();
        this.lab4 = new JLabel();
        this.title.setFont(new Font("SansSerif", 1, 14));
        this.title.setText("AMSAT Fox Satellite Decoder");
        this.lab.setText("It looks like this is the first time you have run the FoxTelem program. You must choose a directory to store the decoded data.");
        this.lab2.setText("Also note that configuration settings will be saved in:  " + Config.homeDirectory);
        this.lab3.setText("If you want to run multiple copies of FoxTelem, using different settings, then hit cancel and rerun passing the ");
        this.lab4.setText("logFile directory name as a paramater.  Otherwise choose a logFile directory below.  See the manual for details.");
        JPanel titlePanel = new JPanel();
        top.setLayout(new BorderLayout(0, 0));
        top.add((Component)titlePanel, "North");
        titlePanel.add(this.title);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        top.add((Component)textPanel, "Center");
        textPanel.add(this.lab);
        textPanel.add(this.lab2);
        textPanel.add(this.lab3);
        textPanel.add(this.lab4);
        this.directories = this.FilesPanel();
        this.directories.setVisible(true);
        center.add(this.directories);
        bottom.setLayout(new FlowLayout(1, 5, 5));
        this.btnContinue = new JButton("Continue");
        this.btnContinue.addActionListener(this);
        bottom.add(this.btnContinue);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        bottom.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel FilesPanel() {
        JPanel northpanel = new JPanel();
        northpanel.setLayout(new BorderLayout());
        JLabel lblDisplayModuleFont = new JLabel("Log files directory");
        lblDisplayModuleFont.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel.add((Component)lblDisplayModuleFont, "West");
        this.txtLogFileDirectory = new JTextField(Config.logFileDirectory);
        northpanel.add((Component)this.txtLogFileDirectory, "Center");
        this.txtLogFileDirectory.setColumns(30);
        this.txtLogFileDirectory.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        northpanel.add((Component)this.btnBrowse, "East");
        return northpanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            System.exit(1);
        }
        if (e.getSource() == this.btnContinue) {
            this.saveAndExit();
        }
        if (e.getSource() == this.btnBrowse) {
            File dir = null;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                dir = new File(Config.logFileDirectory);
            }
            if (Config.isMacOs()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog fd = new FileDialog((Dialog)this, "Choose Directory for Log Files", 0);
                if (dir != null) {
                    fd.setDirectory(dir.getAbsolutePath());
                }
                fd.setVisible(true);
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
                String filename = fd.getFile();
                String dirname = fd.getDirectory();
                if (filename == null) {
                    Log.println("You cancelled the choice");
                } else {
                    Log.println("File: " + filename);
                    Log.println("DIR: " + dirname);
                    File selectedFile = new File(String.valueOf(dirname) + filename);
                    this.txtLogFileDirectory.setText(selectedFile.getAbsolutePath());
                }
            } else {
                JFileChooser fc = new JFileChooser();
                fc.setApproveButtonText("Choose");
                if (dir != null) {
                    fc.setCurrentDirectory(dir);
                }
                fc.setDialogTitle("Choose Directory for Log Files");
                fc.setFileSelectionMode(1);
                fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
                int returnVal = fc.showOpenDialog(this);
                Config.windowFcHeight = fc.getHeight();
                Config.windowFcWidth = fc.getWidth();
                if (returnVal == 0) {
                    this.txtLogFileDirectory.setText(fc.getSelectedFile().getAbsolutePath());
                } else {
                    System.out.println("No Selection ");
                }
            }
        }
    }

    void saveAndExit() {
        Config.FIRST_RUN = false;
        Config.firstRun106 = false;
        if (!Config.logFileDirectory.equalsIgnoreCase(this.txtLogFileDirectory.getText())) {
            File file = new File(this.txtLogFileDirectory.getText());
            if (!file.isDirectory() || file == null || !file.exists()) {
                Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtLogFileDirectory.getText());
            } else {
                Config.logFileDirectory = this.txtLogFileDirectory.getText();
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

