/*
 * Decompiled with CFR 0.152.
 */
package predict;

import common.Log;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import uk.me.g4dpz.satellite.GroundStationPosition;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class PredictEngine
implements Runnable {
    public static final int PREDICT_UPDATE_PERIOD = 1000;
    public SatPos[] satPositions = new SatPos[1];
    boolean running = true;
    private static final String TLE_AO51_2 = "2 28375 098.0551 118.9086 0084159 315.8041 043.6444 14.40638450251959";
    private static final String TLE_AO51_1 = "1 28375U 04025K   09105.66391970  .00000003  00000-0  13761-4 0  3643";
    protected static final String[] LEO_TLE = new String[]{"AO-51 [+]", "1 28375U 04025K   09105.66391970  .00000003  00000-0  13761-4 0  3643", "2 28375 098.0551 118.9086 0084159 315.8041 043.6444 14.40638450251959"};
    protected static final String[] AO85_TLE = new String[]{"AO-85", "1 40967U 15058D   16111.35540844  .00000590  00000-0  79740-4 0 01029", "2 40967 064.7791 061.1881 0209866 223.3946 135.0462 14.74939952014747"};
    static final GroundStationPosition GROUND_STATION = new GroundStationPosition(40.703328, -73.980599, 20.0);
    static final TimeZone TZ = TimeZone.getTimeZone("UTC:UTC");
    private DateTime timeNow;

    private void calculateSatPositions() {
        SatPos satellitePosition;
        this.timeNow = new DateTime(DateTimeZone.UTC);
        TLE tle = new TLE(AO85_TLE);
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        this.satPositions[0] = satellitePosition = satellite.getPosition(GROUND_STATION, this.timeNow.toDate());
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
            this.calculateSatPositions();
        }
    }
}

