/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors;

import common.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import spacecraftEditor.listEditors.CsvFileEditPanel;
import spacecraftEditor.listEditors.CsvTableModel;

public class CsvFileEditorGrid
extends JPanel
implements MouseListener,
TableModelListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    CsvTableModel tableModel;
    public JTable table;
    TableRowSorter<CsvTableModel> sorter;
    JButton resetSort;
    CsvFileEditPanel parent;
    JTextField[] filterFields;
    JTextField filterConversion;

    public CsvFileEditorGrid(CsvTableModel model, CsvFileEditPanel parent) {
        this.setLayout(new BorderLayout());
        this.tableModel = model;
        this.parent = parent;
        this.table = new JTable(model);
        this.table.setAutoCreateRowSorter(false);
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 31);
        scrollPane.setPreferredSize(new Dimension(100, 400));
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "Center");
        int i = 0;
        while (i < this.tableModel.columnWidths.length) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.tableModel.columnWidths[i]);
            ++i;
        }
        this.table.addMouseListener(this);
        this.table.getModel().addTableModelListener(this);
        JPanel filterPanel = new JPanel();
        this.add((Component)filterPanel, "South");
        this.resetSort = new JButton("un-sort");
        filterPanel.add(this.resetSort);
        this.resetSort.addActionListener(this);
        filterPanel.add(new Box.Filler(new Dimension(20, 10), new Dimension(20, 10), new Dimension(20, 10)));
        JLabel lblFilter = new JLabel("Filter: ");
        Font f = lblFilter.getFont();
        lblFilter.setFont(f.deriveFont(f.getStyle() | 1));
        filterPanel.add(lblFilter);
        if (this.tableModel.filterColumns != null) {
            this.filterFields = new JTextField[this.tableModel.filterColumns.length];
            int i2 = 0;
            while (i2 < this.tableModel.filterColumns.length) {
                this.filterFields[i2] = this.addFilterField(filterPanel, this.tableModel.columnNames[this.tableModel.filterColumns[i2]], this.tableModel.filterColumns[i2], 6);
                ++i2;
            }
            this.sorter = new TableRowSorter<CsvTableModel>(this.tableModel);
            this.table.setRowSorter(this.sorter);
        }
        String PASTE = "paste";
        InputMap inMap = this.table.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("control V"), PASTE);
        ActionMap actMap = this.table.getActionMap();
        actMap.put(PASTE, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = CsvFileEditorGrid.this.table.getSelectedRow();
                if (row > 0) {
                    CsvFileEditorGrid.this.table.setRowSelectionInterval(row, row);
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    try {
                        String result = (String)clipboard.getData(DataFlavor.stringFlavor);
                        System.out.println("String from Clipboard:" + result);
                        String[] pasteRows = result.split("\n");
                        if (pasteRows.length == 0) {
                            pasteRows = new String[]{result};
                        }
                        if (pasteRows.length + row > CsvFileEditorGrid.this.tableModel.getRowCount()) {
                            Log.errorDialog("ERROR", "Can't fit " + pasteRows.length + " rows into the table. Perhaps add more empty rows first.");
                            return;
                        }
                        int r = 0;
                        while (r < pasteRows.length) {
                            String[] cellValues = pasteRows[r].split("\t");
                            if (cellValues.length % CsvFileEditorGrid.this.tableModel.getColumnCount() != 0) {
                                Log.infoDialog("Sorry!", "Can only paste whole rows at the moment");
                                return;
                            }
                            int i = 0;
                            while (i < CsvFileEditorGrid.this.tableModel.getColumnCount()) {
                                CsvFileEditorGrid.this.tableModel.setValueAt(cellValues[i], row, i);
                                ++i;
                            }
                            ++row;
                            ++r;
                        }
                    }
                    catch (UnsupportedFlavorException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    private JTextField addFilterField(JPanel filterPanel, String name, final int col, int width) {
        JLabel lblFilter = new JLabel(String.valueOf(name) + ":");
        filterPanel.add((Component)lblFilter, "West");
        final JTextField filterField = new JTextField();
        filterPanel.add((Component)filterField, "Center");
        filterField.setColumns(width);
        filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CsvFileEditorGrid.this.newFilter(filterField, col);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CsvFileEditorGrid.this.newFilter(filterField, col);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CsvFileEditorGrid.this.newFilter(filterField, col);
            }
        });
        return filterField;
    }

    private void newFilter(JTextField field, int col) {
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter(field.getText(), col);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.sorter.setRowFilter(rf);
    }

    public void setData(String titleString, String[][] d) {
        TitledBorder title = new TitledBorder(null, titleString, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        this.setBorder(title);
        this.tableModel.setData(d);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1) {
            return;
        }
        if (e.getFirstRow() == -1) {
            return;
        }
        try {
            this.parent.save();
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Could not save the CSV file\n" + e1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.resetSort) {
            this.table.getRowSorter().setSortKeys(null);
        }
    }
}

