/*
 * Decompiled with CFR 0.152.
 */
package telemetry.Format;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.Crc32;
import decoder.Decoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.Format.FormatHeader;
import telemetry.Format.TelemFormat;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.frames.Frame;
import telemetry.frames.FrameLayout;
import telemetry.frames.Header;
import telemetry.frames.HighSpeedTrailer;
import telemetry.payloads.PayloadCanExperiment;
import telemetry.payloads.PayloadCanWODExperiment;
import telemetry.payloads.PayloadWOD;
import telemetry.uw.PayloadUwExperiment;
import telemetry.uw.PayloadWODUwExperiment;

public class FormatFrame
extends Frame {
    FrameLayout frameLayout;
    TelemFormat telemFormat;
    public FramePart[] payload;
    HighSpeedTrailer trailer = null;
    byte[] headerBytes;
    byte[] dataBytes;
    BitArrayLayout headerLayout;
    int numberBytesAdded = 0;
    int c = 0;
    int crc = 0;
    int crcLength = 4;
    byte[] crcBytes = new byte[this.crcLength];
    int debugCount = 0;

    public FormatFrame(TelemFormat telemFormat) {
        this.telemFormat = telemFormat;
        this.headerLayout = telemFormat.getHeaderLayout();
        this.headerBytes = new byte[telemFormat.getInt("header_length")];
    }

    public FormatFrame(BufferedReader input) throws IOException {
        super(input);
        StringTokenizer st = this.loadStpHeader(input);
        if (st == null) {
            throw new IOException("Could not read Frame line from the file");
        }
        this.telemFormat = Config.satManager.getFormatBySource(this.foxId, this.source);
        this.headerLayout = this.telemFormat.getHeaderLayout();
        this.header = new FormatHeader(this.headerLayout, this.telemFormat);
        this.headerBytes = new byte[this.telemFormat.getInt("header_length")];
        this.loadRestOfFrame(st);
    }

    @Override
    public FormatHeader getHeader() {
        return (FormatHeader)this.header;
    }

    @Override
    public void addNext8Bits(byte b) {
        if (Config.debugBytes) {
            String debug = Decoder.plainhex(b);
            ++this.debugCount;
            Log.print("0x" + debug + ",");
            if (this.debugCount % 20 == 0) {
                Log.println("");
            }
        }
        if (this.corrupt) {
            return;
        }
        if (this.numberBytesAdded < this.telemFormat.getInt("header_length")) {
            if (this.header == null) {
                this.header = new FormatHeader(this.headerLayout, this.telemFormat);
            }
            this.header.addNext8Bits(b);
        } else if (this.numberBytesAdded == this.telemFormat.getInt("header_length")) {
            try {
                this.header.copyBitsToFields();
                this.fox = Config.satManager.getSpacecraft(this.header.id);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (Config.debugFrames) {
                    Log.errorDialog("ERROR", "The header length in the format file may not agree with the header layout.  Decode not possible.\nTurn off Debug Frames to prevent this message in future.");
                } else {
                    Log.println("ERROR: The header length in the format file may not agree with the header layout.  Decode not possible.");
                }
                this.corrupt = true;
                return;
            }
            if (this.fox != null) {
                if (Config.debugFrames) {
                    Log.println(this.header.toString());
                }
                this.frameLayout = Config.satManager.getFrameLayout(this.header.id, this.header.getType());
                if (this.frameLayout == null) {
                    if (Config.debugFrames) {
                        Log.errorDialog("ERROR", "FOX ID: " + this.header.id + " Frame Type: " + this.header.getType() + " has no frame layout defined. Decode not possible.\n" + "Turn off Debug Frames to prevent this message in future.");
                    } else {
                        Log.println("FOX ID: " + this.header.id + " Frame Type: " + this.header.getType() + " has no frame layout defined. Decode not possible.");
                    }
                    this.corrupt = true;
                    return;
                }
                this.bytes = new byte[this.telemFormat.getFrameLength()];
                this.dataBytes = this.fox.hasFrameCrc && Config.calculateBPSKCrc ? new byte[this.telemFormat.getInt("data_length") - this.crcLength] : new byte[this.telemFormat.getInt("data_length")];
                int k = 0;
                while (k < this.telemFormat.getInt("header_length")) {
                    this.bytes[k] = this.headerBytes[k];
                    if (this.fox.hasFrameCrc && Config.calculateBPSKCrc) {
                        this.dataBytes[k] = this.headerBytes[k];
                    }
                    ++k;
                }
                this.initPayloads((FormatHeader)this.header, this.frameLayout);
                if (this.payload[0] == null) {
                    if (Config.debugFrames) {
                        Log.errorDialog("ERROR", "FOX ID: " + this.header.id + " Frame Type: " + this.header.getType() + " not valid. " + "Check that the Payloads defined in the MASTER file correctly match the payload names in the .frame definition file.\nDecode not possible.\n" + "Turn off Debug Frames to prevent this message in future.");
                    } else {
                        Log.println("FOX ID: " + this.header.id + " Frame Type: " + this.header.getType() + " not valid. Check that the Payloads defined in the MASTER file correctly match the payload names in the .frame definition file. Decode not possible.");
                    }
                    this.corrupt = true;
                    return;
                }
            } else {
                if (Config.debugFrames) {
                    Log.errorDialog("ERROR", "FOX ID: " + this.header.id + " is not configured in the spacecraft directory.  Decode not possible.\n" + "Turn off Debug Frames to prevent this message in future.");
                } else {
                    Log.println("FOX ID: " + this.header.id + " is not configured in the spacecraft directory.  Decode not possible.");
                }
                this.corrupt = true;
                return;
            }
            this.payload[0].addNext8Bits(b);
        } else {
            int maxByte = this.telemFormat.getInt("header_length");
            int minByte = this.telemFormat.getInt("header_length");
            int p = 0;
            while (p < this.frameLayout.getNumberOfPayloads()) {
                if (this.numberBytesAdded >= minByte && this.numberBytesAdded < (maxByte += this.frameLayout.getPayloadLength(p))) {
                    try {
                        this.payload[p].addNext8Bits(b);
                    }
                    catch (Exception e) {
                        String stacktrace = Log.makeShortTrace(e.getStackTrace());
                        if (this.payload[p] != null && this.payload[p].getLayout() != null) {
                            Log.errorDialog("ERROR", "Could not add byte number " + this.numberBytesAdded + " to frame: " + this.frameLayout + " for payload number " + p + " : " + this.payload[p].getLayout().name + " at payload byte " + this.payload[p].numberBytesAdded + "\nError is: " + e + "\n" + stacktrace);
                        } else if (this.payload[p] != null && this.payload[p].getLayout() == null) {
                            Log.errorDialog("ERROR", "Could not add byte number " + this.numberBytesAdded + " to frame: " + this.frameLayout + " for payload number " + p + " of type " + this.payload[p].getType() + " at payload byte " + this.payload[p].numberBytesAdded + "\nThis payload's Layout is null and not defined or loaded correctly." + "\nError is: " + e + "\n" + stacktrace);
                        } else if (this.payload[p] == null) {
                            Log.errorDialog("ERROR", "Could not add byte number " + this.numberBytesAdded + " to frame: " + this.frameLayout + " for payload number " + p + " because the payload is null." + "\nThe payload Layout is probablly not defined or loaded correctly." + "\nError is: " + e + "\n" + stacktrace);
                        }
                        this.corrupt = true;
                        return;
                    }
                }
                minByte += this.frameLayout.getPayloadLength(p);
                ++p;
            }
        }
        if (this.fox != null && this.fox.hasFrameCrc && Config.calculateBPSKCrc) {
            if (this.numberBytesAdded > this.telemFormat.getInt("data_length") - this.crcLength - 1 && this.numberBytesAdded <= this.telemFormat.getInt("data_length") - 1) {
                this.crcBytes[this.c++] = b;
            }
            if (this.numberBytesAdded == this.telemFormat.getInt("data_length") - 1) {
                this.crc = Decoder.littleEndian4(this.crcBytes);
                if (Config.debugBytes || Config.debugFrames) {
                    Log.print("=> Frame CRC: " + Decoder.plainhex(this.crc));
                }
                int myCalculatedCrc = Crc32.crc32(this.dataBytes);
                if (Config.debugBytes || Config.debugFrames) {
                    Log.print(" => Calculated CRC: " + Decoder.plainhex(myCalculatedCrc));
                    if (this.crc == myCalculatedCrc) {
                        Log.println(" .. pass");
                    } else {
                        Log.println(" ***** FAIL ***** Frame Rejected");
                        Config.passManager.incCrcFailure();
                        this.corrupt = true;
                        return;
                    }
                }
            }
        }
        if (this.numberBytesAdded >= this.telemFormat.getInt("header_length")) {
            this.bytes[this.numberBytesAdded] = b;
            if (this.fox != null && this.fox.hasFrameCrc && Config.calculateBPSKCrc && this.numberBytesAdded < this.telemFormat.getInt("data_length") - this.crcLength) {
                this.dataBytes[this.numberBytesAdded] = b;
            }
        } else {
            this.headerBytes[this.numberBytesAdded] = b;
        }
        ++this.numberBytesAdded;
    }

    private void initPayloads(FormatHeader header, FrameLayout frameLayout) {
        this.payload = new FramePart[frameLayout.getNumberOfPayloads()];
        int i = 0;
        while (i < frameLayout.getNumberOfPayloads()) {
            BitArrayLayout layout = Config.satManager.getLayoutByName(header.id, frameLayout.getPayloadName(i));
            if (layout == null) {
                this.payload[0] = null;
                return;
            }
            this.payload[i] = this.fox.hasFOXDB_V3 ? FramePart.makePayload((Header)header, layout) : FramePart.makeLegacyPayload((Header)header, layout);
            ++i;
        }
    }

    public boolean savePayloads(FoxPayloadStore payloadStore, boolean storeMode, int newReset) {
        int serial = 0;
        this.header.copyBitsToFields();
        int i = 0;
        while (i < this.payload.length) {
            if (this.payload[i] != null) {
                this.payload[i].copyBitsToFields();
                this.payload[i].resets = newReset;
                if (storeMode) {
                    this.payload[i].newMode = this.header.newMode;
                }
                if (this.payload[i].layout.isCanExperiment() || this.payload[i].layout.isCanWodExperiment()) {
                    ((PayloadCanExperiment)this.payload[i]).savePayloads(payloadStore, serial, storeMode);
                    if (!(this.payload[i] instanceof PayloadCanWODExperiment)) {
                        serial += ((PayloadCanExperiment)this.payload[i]).canPackets.size();
                    }
                } else if (this.payload[i] instanceof PayloadUwExperiment) {
                    ((PayloadUwExperiment)this.payload[i]).savePayloads(payloadStore, serial, storeMode);
                    serial += ((PayloadUwExperiment)this.payload[i]).canPackets.size();
                } else if (this.payload[i] instanceof PayloadWODUwExperiment) {
                    ((PayloadWODUwExperiment)this.payload[i]).savePayloads(payloadStore, serial, storeMode);
                    serial += ((PayloadWODUwExperiment)this.payload[i]).canPackets.size();
                } else if (!payloadStore.add(this.header.getFoxId(), this.header.getUptime(), newReset, this.payload[i])) {
                    this.payload[i].rawBits = null;
                    this.headerBytes = null;
                    this.dataBytes = null;
                    return false;
                }
                if (this.payload[i].layout.hasGPSTime) {
                    this.storeGPSTime(this.payload[i]);
                }
                this.payload[i].rawBits = null;
                this.headerBytes = null;
                this.dataBytes = null;
            }
            ++i;
        }
        return true;
    }

    private void storeGPSTime(FramePart payload) {
        ZonedDateTime timestamp = payload.getGPSTime(this.fox);
        if (timestamp == null) {
            return;
        }
        Log.println(String.valueOf(payload.resets) + "/" + payload.uptime + " GPS TIME: " + timestamp);
        if (this.fox.user_useGPSTimeForT0) {
            this.fox.setT0FromGPSTime(payload.resets, payload.getSecsInEpochAtGPSTimestamp(), timestamp);
        }
    }

    @Override
    public byte[][] getPayloadBytes() {
        byte[][] allBuffers = null;
        Spacecraft sat = Config.satManager.getSpacecraft(this.foxId);
        if (sat.sendToLocalServer()) {
            int totalBuffers = 0;
            int i = 0;
            while (i < this.payload.length) {
                byte[][] buffer;
                if (this.payload[i] instanceof PayloadUwExperiment) {
                    buffer = ((PayloadUwExperiment)this.payload[i]).getCANPacketBytes(this.stpDate);
                    totalBuffers += buffer.length;
                }
                if (this.payload[i] instanceof PayloadWODUwExperiment) {
                    buffer = ((PayloadWODUwExperiment)this.payload[i]).getCANPacketBytes(this.stpDate);
                    totalBuffers += buffer.length;
                }
                ++i;
            }
            allBuffers = new byte[totalBuffers][];
            int startPosition = 0;
            int p = 0;
            while (p < this.payload.length) {
                int j;
                byte[][] buffer;
                if (this.payload[p] instanceof PayloadUwExperiment) {
                    buffer = ((PayloadUwExperiment)this.payload[p]).getCANPacketBytes(this.stpDate);
                    j = 0;
                    while (j < buffer.length) {
                        allBuffers[j + startPosition] = buffer[j];
                        ++j;
                    }
                    startPosition += buffer.length;
                }
                if (this.payload[p] instanceof PayloadWODUwExperiment) {
                    buffer = ((PayloadWODUwExperiment)this.payload[p]).getCANPacketBytes(this.stpDate);
                    j = 0;
                    while (j < buffer.length) {
                        allBuffers[j + startPosition] = buffer[j];
                        ++j;
                    }
                    startPosition += buffer.length;
                }
                ++p;
            }
        }
        return allBuffers;
    }

    @Override
    public String toWodTimestampString(int r, long u) {
        String s = new String();
        if (this.payload != null) {
            int i = 0;
            while (i < this.payload.length) {
                if (this.payload[i] instanceof PayloadWOD) {
                    s = String.valueOf(s) + r + ", " + u + ", ";
                    this.payload[i].copyBitsToFields();
                    s = String.valueOf(s) + this.payload[i].resets + ", " + this.payload[i].uptime + "\n";
                }
                ++i;
            }
        }
        return s;
    }

    public String toString() {
        String s = new String();
        s = String.valueOf(s) + "AMSAT FOXTELEM Telemetry Captured at DATE: " + this.getStpDate() + "\n";
        s = this.header.toString();
        if (this.payload != null) {
            int i = 0;
            while (i < this.payload.length) {
                s = String.valueOf(s) + this.payload[i].toString() + "\n";
                ++i;
            }
        }
        return s;
    }
}

