/*
 * Decompiled with CFR 0.152.
 */
package telemetry.herci;

import common.Log;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;

public class HerciHighSpeedPacket
extends FramePart {
    public static final int MAX_PACKET_BYTES = 128;
    public static final int MAX_PACKET_HEADER_BYTES = 8;
    public static final int NUMBER_OF_HEADER_FIELDS = 7;
    public int NUMBER_OF_FIELDS = 7;
    int[] rawBytes = new int[128];
    int numberOfRawBytes = 0;
    public static final int TYPE_FIELD = 0;
    public static final int LENGTH_FIELD = 1;
    public static final int TIME_FIELD = 2;
    public static final int SEG_FIELD = 3;
    public static final int STATUS_FIELD1 = 4;
    public static final int STATUS_FIELD2 = 5;
    public static final int STATUS_FIELD3 = 6;
    int epoch;
    long headerTime;
    long packetTimestamp;
    public static final int MAX_DELTA = 64;

    HerciHighSpeedPacket(int sat, int r, long u, int e, long t, BitArrayLayout lay) {
        super(9, lay);
        this.resets = r;
        this.uptime = u;
        this.epoch = e;
        this.headerTime = t;
        this.id = sat;
        this.rawBits = new boolean[1088];
        this.initFields();
    }

    public HerciHighSpeedPacket(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(9, new BitArrayLayout());
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.reportDate = date;
        this.epoch = Integer.valueOf(st.nextToken());
        this.headerTime = Long.valueOf(st.nextToken());
        this.packetTimestamp = Long.valueOf(st.nextToken());
        this.init();
        this.rawBits = null;
        this.initFields();
        this.loadFrom(st, 0);
        this.initPacket();
        this.loadFrom(st, 7);
    }

    @Override
    public int[] getFieldValues() {
        int[] f = new int[this.fieldValue.length + 3];
        f[0] = this.epoch;
        f[1] = (int)this.headerTime;
        f[2] = (int)this.packetTimestamp;
        int i = 3;
        while (i < f.length) {
            f[i] = this.fieldValue[i - 3];
            ++i;
        }
        return f;
    }

    protected void loadFrom(StringTokenizer st, int i) {
        String s = null;
        try {
            while (i < this.NUMBER_OF_FIELDS) {
                s = st.nextToken();
                if (s == null) continue;
                if (s.startsWith("0x")) {
                    s = s.replace("0x", "");
                    this.fieldValue[i++] = Integer.valueOf(s, 16);
                    continue;
                }
                this.fieldValue[i++] = Integer.valueOf(s);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.println("ERROR: Too many fields:  Could not load frame " + this.id + " " + this.resets + " " + this.uptime + " " + this.type);
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  Could not load frame " + this.id + " " + this.resets + " " + this.uptime + " " + this.type);
        }
    }

    public String toFile() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + this.reportDate + "," + this.id + "," + this.resets + "," + this.uptime + "," + this.type + "," + this.epoch + "," + this.headerTime + "," + this.packetTimestamp + ",";
        int i = 0;
        while (i < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + FoxDecoder.dec(this.getRawValue(this.layout.fieldName[i])) + ",";
            ++i;
        }
        s = String.valueOf(s) + FoxDecoder.dec(this.getRawValue(this.layout.fieldName[this.layout.fieldName.length - 1]));
        return s;
    }

    @Override
    protected void init() {
        this.type = 9;
        this.fieldValue = new int[this.layout.NUMBER_OF_FIELDS];
    }

    public void initFields() {
        this.layout = new BitArrayLayout();
        this.layout.name = "herciHSpackets";
        this.layout.fieldName = new String[this.NUMBER_OF_FIELDS];
        this.fieldValue = new int[this.layout.fieldName.length];
        this.layout.fieldBitLength = new int[this.NUMBER_OF_FIELDS];
        this.layout.fieldName[0] = "TYPE";
        this.layout.fieldName[1] = "LENGTH";
        this.layout.fieldName[2] = "TIME";
        this.layout.fieldName[3] = "SEG";
        this.layout.fieldName[4] = "STATUS1";
        this.layout.fieldName[5] = "STATUS2";
        this.layout.fieldName[6] = "STATUS3";
        this.layout.fieldBitLength[0] = 4;
        this.layout.fieldBitLength[1] = 12;
        this.layout.fieldBitLength[2] = 16;
        this.layout.fieldBitLength[3] = 8;
        this.layout.fieldBitLength[4] = 8;
        this.layout.fieldBitLength[5] = 8;
        this.layout.fieldBitLength[6] = 8;
    }

    @Override
    public int getType() {
        return this.fieldValue[0];
    }

    public int getLength() {
        return this.fieldValue[1];
    }

    public int getTime() {
        return this.fieldValue[2];
    }

    public int getSeg() {
        return this.fieldValue[3];
    }

    public int getStatus1() {
        return this.fieldValue[4];
    }

    public int getStatus2() {
        return this.fieldValue[5];
    }

    public int getStatus3() {
        return this.fieldValue[6];
    }

    public void initPacket() {
        this.copyBitsToFields();
        int len = this.getLength();
        int type = this.getType();
        int time = this.getTime();
        int seg = this.getSeg();
        int status1 = this.getStatus1();
        int status2 = this.getStatus2();
        int status3 = this.getStatus3();
        this.NUMBER_OF_FIELDS = 7 + this.getLength() + 1;
        this.initFields();
        this.fieldValue[0] = type;
        this.fieldValue[1] = len;
        this.fieldValue[2] = time;
        this.fieldValue[3] = seg;
        this.fieldValue[4] = status1;
        this.fieldValue[5] = status2;
        this.fieldValue[6] = status3;
        int i = 7;
        while (i < this.layout.fieldName.length) {
            this.layout.fieldName[i] = "Byte" + i;
            this.layout.fieldBitLength[i] = 8;
            ++i;
        }
        this.packetTimestamp = this.UTIL_event_time(time, (int)this.headerTime, 0);
        this.copyBitsToFields();
    }

    public void addNext8Bits(int b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public byte[] getMiniPacketBytes() {
        this.copyBitsToFields();
        byte[] b = new byte[this.NUMBER_OF_FIELDS - 7];
        int i = 7;
        while (i < this.NUMBER_OF_FIELDS) {
            b[i - 7] = (byte)this.fieldValue[i];
            ++i;
        }
        return b;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "HERCI Science Mini Packet: " + 8 + this.getLength() + " bytes\n";
        int i = 0;
        while (i < 8) {
            s = String.valueOf(s) + FoxDecoder.hex(this.fieldValue[i]) + " ";
            if ((i + 1) % 32 == 0) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    private int UTIL_event_time(int mp_time_in, int waves_time_in, int epoch) {
        int pkt_time = waves_time_in & 0xFFFFFFFE;
        int mp_time = mp_time_in;
        int delta = (mp_time /= 40) - (pkt_time & 0x3FF);
        if (delta > 64) {
            delta -= 1024;
        }
        return pkt_time + delta + epoch;
    }

    public static String getTableCreateStmt() {
        String s = new String();
        s = String.valueOf(s) + "(date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, id int, resets int, uptime bigint, type int, " + "epoch int," + "headerTime int," + "packetTimestamp int," + "pktType int, " + "length int, " + "truncTime int," + "segmentation int," + "st1 int," + "st2 int," + "st3 int,";
        int i = 7;
        while (i < 128) {
            s = String.valueOf(s) + "byte" + i + " int NOT NULL DEFAULT 0,";
            ++i;
        }
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type))";
        return s;
    }

    @Override
    public String getInsertStmt() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + " (id, resets, uptime, type, \n";
        s = String.valueOf(s) + "epoch,\n";
        s = String.valueOf(s) + "headerTime,\n";
        s = String.valueOf(s) + "packetTimestamp,\n";
        s = String.valueOf(s) + "pktType,\n";
        s = String.valueOf(s) + "length,\n";
        s = String.valueOf(s) + "truncTime,\n";
        s = String.valueOf(s) + "segmentation,\n";
        s = String.valueOf(s) + "st1,\n";
        s = String.valueOf(s) + "st2,\n";
        s = String.valueOf(s) + "st3,\n";
        int i = 7;
        while (i < this.NUMBER_OF_FIELDS - 1) {
            s = String.valueOf(s) + "byte" + i + " ,\n";
            ++i;
        }
        s = String.valueOf(s) + "byte" + (this.NUMBER_OF_FIELDS - 1) + " )\n";
        s = String.valueOf(s) + "values (" + this.id + ", " + this.resets + ", " + this.uptime + ", " + this.type + "," + this.epoch + "," + this.headerTime + "," + this.packetTimestamp + ",\n";
        s = String.valueOf(s) + this.fieldValue[0] + ",\n";
        s = String.valueOf(s) + this.fieldValue[1] + ",\n";
        s = String.valueOf(s) + this.fieldValue[2] + ",\n";
        s = String.valueOf(s) + this.fieldValue[3] + ",\n";
        s = String.valueOf(s) + this.fieldValue[4] + ",\n";
        s = String.valueOf(s) + this.fieldValue[5] + ",\n";
        s = String.valueOf(s) + this.fieldValue[6] + ",\n";
        i = 7;
        while (i < this.NUMBER_OF_FIELDS - 1) {
            s = String.valueOf(s) + this.fieldValue[i] + " ,\n";
            ++i;
        }
        s = String.valueOf(s) + this.fieldValue[this.NUMBER_OF_FIELDS - 1] + " )\n";
        return s;
    }
}

