/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.service;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.service.LockHandler;
import com.install4j.runtime.launcher.service.PidHandler;
import com.install4j.runtime.launcher.service.UnixServiceHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

abstract class CommonHandler
implements UnixServiceHandler {
    protected static final int POLLING_PERIOD = 1000;
    protected static final int RUNNING_MULTIPLIER = 10;
    protected static final int STOP_TIMEOUT_SECONDS = Integer.getInteger("install4j.daemonTimeout", 120);
    protected static final int NO_PID_STARTED = 44;
    protected static final int PID_STARTED = 43;
    private File watcherFile = null;
    private boolean service = false;
    private static FileOutputStream startFileOut;

    CommonHandler() {
    }

    protected abstract boolean isRunning();

    protected abstract void finishStartFileCreation(File var1, DataOutputStream var2, FileOutputStream var3) throws IOException;

    protected abstract void updateWatcherFile(File var1);

    static CommonHandler getDefaultHandler() {
        String daemonHandler = System.getenv("INSTALL4J_DAEMON_HANDLER");
        if (daemonHandler == null && !LauncherUtil.isLinux() && !LauncherUtil.isMacOS()) {
            daemonHandler = "pid";
        }
        return "pid".equals(daemonHandler) ? new PidHandler() : new LockHandler();
    }

    @Override
    public void setStart() {
        this.service = true;
        File watcherFile = this.getWatcherFile();
        if (this.isRunning()) {
            System.out.println(this.getDaemonName() + " seems to be running. Exiting. Id file: " + watcherFile);
            System.exit(1);
        }
        if (watcherFile.exists() && !watcherFile.delete()) {
            System.out.println("Could not delete id file " + watcherFile + ". Aborting.");
            System.exit(1);
        }
        boolean hasPid = this.createStartFile(watcherFile, true);
        new StopWatcherThread(hasPid).start();
    }

    @Override
    public void setStop() {
        if (!this.isRunning()) {
            System.out.println(this.getDaemonName() + " is not running.");
            System.exit(0);
        }
        File watcherFile = this.getWatcherFile();
        try {
            FileOutputStream out = new FileOutputStream(watcherFile, true);
            for (int i = 0; i < 20; ++i) {
                out.write(33);
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Could not stop daemon.");
            System.exit(1);
        }
        for (int i = 0; i < 2 * STOP_TIMEOUT_SECONDS && this.isRunning(); ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isRunning()) {
            System.out.println("Timeout. Daemon did not shutdown yet.");
            System.exit(1);
        } else {
            if (!watcherFile.delete() && watcherFile.exists()) {
                watcherFile.deleteOnExit();
            }
            System.out.println("Stopped.");
            System.exit(0);
        }
    }

    protected boolean createStartFile(File watcherFile, boolean startup) {
        boolean hasPid = false;
        try {
            FileOutputStream fout;
            startFileOut = fout = new FileOutputStream(watcherFile);
            DataOutputStream out = new DataOutputStream(fout);
            int pid = (int)LauncherHelper.INSTANCE.getPid();
            if (pid == 0) {
                out.write(44);
            } else {
                out.write(43);
                out.writeInt(pid);
                hasPid = true;
            }
            this.finishStartFileCreation(watcherFile, out, fout);
        }
        catch (IOException e) {
            if (startup) {
                System.out.println("Could not create id file " + watcherFile + ". Aborting.");
                System.exit(1);
            }
            e.printStackTrace();
        }
        return hasPid;
    }

    @Override
    public boolean isService() {
        return this.service;
    }

    protected File getWatcherFile() {
        if (this.watcherFile == null) {
            String moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                File runtimeDir = ResourceHelper.getRuntimeDir();
                if (runtimeDir == null) {
                    runtimeDir = new File(System.getProperty("user.dir"));
                }
                moduleName = runtimeDir.getAbsolutePath();
            } else {
                try {
                    moduleName = new File(moduleName).getCanonicalFile().getAbsolutePath();
                }
                catch (IOException runtimeDir) {
                    // empty catch block
                }
            }
            String watcherFileName = System.getProperty("install4j.pidDir", "/tmp") + "/i4jdaemon_" + moduleName.replace('/', '_');
            this.watcherFile = new File(watcherFileName);
        }
        return this.watcherFile;
    }

    @Override
    public void reportStatus() {
        if (this.isRunning()) {
            System.out.println(this.getDaemonName() + " is running.");
            System.exit(0);
        } else {
            System.out.println(this.getDaemonName() + " is stopped.");
            System.exit(3);
        }
    }

    protected String getDaemonName() {
        String moduleName = System.getProperty("exe4j.moduleName");
        if (moduleName != null) {
            try {
                return new File(moduleName).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "The daemon";
    }

    private class StopWatcherThread
    extends Thread {
        private final boolean hasPid;
        private volatile boolean deleteInHook = true;
        private volatile boolean recreate = true;

        public StopWatcherThread(boolean hasPid) {
            this.hasPid = hasPid;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            final File watcherFile = CommonHandler.this.getWatcherFile();
            Runtime.getRuntime().addShutdownHook(new Thread("i4j_daemon_delete"){

                @Override
                public void run() {
                    StopWatcherThread.this.recreate = false;
                    if (StopWatcherThread.this.deleteInHook) {
                        watcherFile.delete();
                    }
                }
            });
            while (true) {
                try {
                    StopWatcherThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.recreate && !watcherFile.exists()) {
                    CommonHandler.this.createStartFile(watcherFile, false);
                }
                if (watcherFile.length() > 10L) {
                    if (this.hasPid) {
                        this.deleteInHook = false;
                    }
                    System.exit(0);
                    continue;
                }
                CommonHandler.this.updateWatcherFile(watcherFile);
            }
        }
    }
}

