/*
 * Decompiled with CFR 0.152.
 */
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.segDb.DataTable;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.telem.LogFileWE;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LoadWe {
    static final String usage = "LoadWe <dir-containing-we-files>\n";
    static String dirName;

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            dirName = args[0];
        } else {
            System.out.println(usage);
            System.exit(1);
        }
        Config.init("PacSatServer.properties");
        File current = new File(System.getProperty("user.dir"));
        Config.currentDir = current.getAbsolutePath();
        Config.set("logfile_dir", Config.currentDir);
        Config.homeDir = Config.currentDir;
        SpacecraftSettings spacecraftSettings = Config.getSatSettingsByName("FalconSat-3");
        Config.load();
        Log.init(String.valueOf(Config.get("logfile_dir")) + File.separator + "PacSatServer");
        Log.showGuiDialogs = false;
        try {
            Config.simpleStart();
        }
        catch (LayoutLoadException e) {
            Log.println("ERROR - Could not load the layout, telem DB has not been initiailized.  No telemetry can be stored.\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            Log.println("ERROR - Could not load the layout, telem DB has not been initiailized.  No telemetry can be stored.\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        LoadWe.importWE(spacecraftSettings, dirName);
    }

    private static void importWE(SpacecraftSettings spacecraftSettings, String stpDir) {
        String dir = stpDir;
        int n = 0;
        Log.println("IMPORT WE files from " + dir);
        File folder = new File(dir);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            int i2 = 0;
            while (i2 < listOfFiles.length) {
                if (listOfFiles[i2].isFile() && listOfFiles[i2].getName().startsWith("we")) {
                    Log.println("Loading data from: " + listOfFiles[i2].getName());
                    File destFile = new File(String.valueOf(spacecraftSettings.directory.dirFolder) + File.separator + listOfFiles[i2].getName());
                    RandomAccessFile saveFile = null;
                    try {
                        DataTable.copyFile(listOfFiles[i2], destFile);
                        saveFile = new RandomAccessFile(destFile, "rw");
                        LogFileWE we = new LogFileWE(spacecraftSettings, destFile.getPath());
                        if (we.records != null) {
                            for (DataRecord d : we.records) {
                                spacecraftSettings.db.add(d);
                            }
                        }
                        ++n;
                    }
                    catch (MalformedPfhException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (LayoutLoadException e) {
                        e.printStackTrace();
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (DataLoadException e) {
                        e.printStackTrace();
                    }
                    if (saveFile != null) {
                        try {
                            saveFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (i2 % 100 == 0) {
                        Log.println("Loaded: " + Math.round(100.0 * (double)i2 / (double)listOfFiles.length) + "%");
                    }
                }
                ++i2;
            }
        }
        Log.println("Files Processed: " + n);
    }
}

