/*
 * Decompiled with CFR 0.152.
 */
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.gui.ProgressPanel;
import common.Config;
import common.Log;
import gui.InitalSettings;
import gui.MainWindow;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class PacSatGround {
    static int REQUIRED_JAVA_VERSION = 8;
    public static String HELP = "AMSAT PacSat Ground Station. Version " + Config.VERSION + "\n\n" + "Usage: PacSatGround [-version][-s] \n";
    static String seriousErrorMsg;
    static String logFileDir;

    static {
        logFileDir = null;
    }

    public static void main(String[] args) {
        try {
            String javaVersion = System.getProperty("java.specification.version");
            int release = Integer.parseInt(javaVersion.split("\\.")[1]);
            if (release < REQUIRED_JAVA_VERSION) {
                Log.errorDialog("Java Version Error", "PacsatGround needs Java Version " + REQUIRED_JAVA_VERSION + " or higher.  You are using Java Version: " + release + "\n" + "Please install a later version of Java.");
                System.exit(1);
            }
        }
        catch (Exception javaVersion) {
            // empty catch block
        }
        ProgressPanel initProgress = new ProgressPanel(MainWindow.frame, "Initializing AMSAT Pacsat Ground station, please wait ...", false);
        initProgress.setVisible(true);
        int arg = 0;
        while (arg < args.length) {
            if (args[arg].startsWith("-")) {
                if (args[arg].equalsIgnoreCase("-h") || args[arg].equalsIgnoreCase("-help") || args[arg].equalsIgnoreCase("--help")) {
                    System.out.println(HELP);
                    System.exit(0);
                }
                if (args[arg].equalsIgnoreCase("-v") || args[arg].equalsIgnoreCase("-version")) {
                    System.out.println("AMSAT PacSat Ground Station. Version " + Config.VERSION);
                    System.exit(0);
                }
            } else {
                logFileDir = args[arg];
            }
            ++arg;
        }
        Config.init("PacSatGround.properties");
        File current = new File(System.getProperty("user.dir"));
        Config.currentDir = current.getAbsolutePath();
        if (logFileDir == null) {
            File home = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "PacsatGroundConfig");
            Config.homeDir = home.getAbsolutePath();
        } else {
            Config.logDirFromPassedParam = true;
            File log = new File(logFileDir);
            Config.set("logfile_dir", logFileDir);
            Config.homeDir = log.getAbsolutePath();
        }
        PacSatGround pg = new PacSatGround();
        if (Config.missing()) {
            Config.setHome();
            pg.initialRun();
        }
        Config.load();
        Log.init(String.valueOf(Config.get("logfile_dir")) + File.separator + "PacSatGround");
        try {
            Config.start();
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Could not load the layout, telem DB has not been initiailized.  No telemetry can be stored.\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "File error during initialization:\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        PacSatGround.invokeGUI();
        initProgress.updateProgress(100);
    }

    public void initialRun() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JFrame window = new JFrame();
            window.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/pacsat.jpg")));
            InitalSettings f = new InitalSettings(window, true);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.errorDialog("SERIOUS ERROR - Uncaught and thrown from Initial Setup", e.getMessage());
        }
    }

    public static void invokeGUI() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Config.mainWindow = new MainWindow();
                    try {
                        Config.mainWindow.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/pacsat.jpg")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Config.mainWindow.setVisible(true);
                }
                catch (Exception e) {
                    Log.println("SERIOUS ERROR - Uncaught and thrown from GUI");
                    seriousErrorMsg = "Something is preventing the AMSAT Ground Station from running: " + e.getMessage() + "\n" + "If you recently changed something\n" + "try reverting to an older version, or install the standard files.  \n" + "If that does not work then you can try deleting the PacSatGround.properties\n" + "file in your home directory though this will delete your settings\n";
                    e.printStackTrace();
                    e.printStackTrace(Log.getWriter());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Frame frm = new Frame();
                            JOptionPane.showMessageDialog(frm, seriousErrorMsg, "SERIOUS ERROR - Uncaught and thrown from GUI", 0);
                            System.exit(99);
                        }
                    });
                }
            }
        });
    }

    public static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public void handle(Throwable thrown) {
            this.handleException(Thread.currentThread().getName(), thrown);
        }

        @Override
        public void uncaughtException(Thread thread, Throwable thrown) {
            this.handleException(thread.getName(), thrown);
        }

        protected void handleException(String tname, Throwable thrown) {
            thrown.printStackTrace(Log.getWriter());
            String stacktrace = Log.makeShortTrace(thrown.getStackTrace());
            Log.errorDialog("SERIOUS EDT ERROR", "Error: " + thrown + "\n" + "Exception on " + tname + "\n" + stacktrace);
        }
    }
}

