/*
 * Decompiled with CFR 0.152.
 */
package ax25;

import ax25.Ax25Frame;
import ax25.Ax25Primitive;
import ax25.Ax25Request;
import ax25.Iframe;
import ax25.KissFrame;
import ax25.Sframe;
import ax25.Uframe;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import gui.MainWindow;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import pacSat.TncDecoder;
import pacSat.frames.FTL0Frame;
import pacSat.frames.FrameException;
import pacSat.frames.PacSatEvent;

public class DataLinkStateMachine
implements Runnable {
    public static final int DISCONNECTED = 0;
    public static final int AWAITING_CONNECTION = 1;
    public static final int AWAITING_RELEASE = 2;
    public static final int CONNECTED = 3;
    public static final int TIMER_RECOVERY = 4;
    public int modulo = 8;
    public static final String ERROR_A = "F=1 received but P=1 not outstanding.";
    public static final String ERROR_B = "Unexpected DM with F=1 in states 3, 4 or 5.";
    public static final String ERROR_C = "Unexpected UA in states 3, 4 or 5.";
    public static final String ERROR_D = "UA received without F=1 when SABM or DISC was sent P=1.";
    public static final String ERROR_E = "DM received in states 3, 4 or 5.";
    public static final String ERROR_F = "Data link reset; i.e., SABM received in state 3, 4 or 5.";
    public static final String ERROR_I = "N2 timeouts: unacknowledged data.";
    public static final String ERROR_J = "N(r) sequence ERROR_.";
    public static final String ERROR_L = "Control field invalid or not implemented.";
    public static final String ERROR_M = "Information field was received in a U or S-type frame.";
    public static final String ERROR_N = "Length of frame incorrect for frame type.";
    public static final String ERROR_O = "I frame exceeded maximum allowed length.";
    public static final String ERROR_P = "N(s) out of the window.";
    public static final String ERROR_Q = "UI response received, or UI command with P=1 received.";
    public static final String ERROR_R = "UI frame exceeded maximum allowed length.";
    public static final String ERROR_S = "I response received.";
    public static final String ERROR_T = "N2 timeouts: no response to enquiry.";
    public static final String ERROR_U = "N2 timeouts: extended peer busy condition.";
    public static final String ERROR_V = "No DL machines available to establish connection.";
    public static final int LOOP_TIME = 1;
    int SRT;
    int T1V = this.SRT = 3000;
    public static final int TIMER_T1 = 3000;
    int t1_timer = 0;
    public static final int TIMER_T3 = 60000;
    int t3_timer = 0;
    public static final int RETRIES_N2 = 10;
    int VS = 0;
    int VA = 0;
    int VR = 0;
    int RC = 0;
    int K = 4;
    boolean peerReceiverBusy = false;
    boolean rejectException = false;
    int sRejException = 0;
    boolean ackPending = false;
    boolean sRejEnabled = false;
    Ax25Frame lastCommand = null;
    public static final String[] states = new String[]{"Disc", "Wait Conn", "Wait Rel", "Connected", "Timer Rec"};
    protected int state;
    protected TncDecoder tncDecoder;
    protected ConcurrentLinkedQueue<Ax25Primitive> frameEventQueue;
    protected ConcurrentLinkedDeque<Iframe> iFrameQueue;
    protected Iframe[] iFramesSent = new Iframe[this.modulo];
    protected boolean running = true;
    MainWindow ta;
    boolean readyForMoreIframes = true;
    static final int IFRAME_QUEUE_LIMIT = 2;
    SpacecraftSettings spacecraft;

    public DataLinkStateMachine(SpacecraftSettings sat) {
        this.spacecraft = sat;
        this.iFrameQueue = new ConcurrentLinkedDeque();
        this.frameEventQueue = new ConcurrentLinkedQueue();
        this.state = 0;
    }

    public boolean isConnected() {
        return this.state == 3 || this.state == 4;
    }

    public boolean isWaitingConnection() {
        return this.state == 1;
    }

    public boolean isWaitingRelease() {
        return this.state == 2;
    }

    public boolean isDisconnected() {
        return this.state == 0;
    }

    public boolean isReadyForData() {
        return this.readyForMoreIframes;
    }

    public void processEvent(Ax25Primitive frame) {
        if (frame instanceof Ax25Frame) {
            Ax25Frame f = (Ax25Frame)frame;
            String call = f.toCallsign.trim();
            if (call.equalsIgnoreCase(Config.get("callsign").trim())) {
                if (Config.getBoolean("DEBUG_EVENTS")) {
                    this.DEBUG("Adding Frame: " + frame.toString());
                }
                this.frameEventQueue.add(frame);
            }
        } else {
            if (Config.getBoolean("DEBUG_EVENTS")) {
                this.DEBUG("Adding Event: " + frame.toString());
            }
            this.frameEventQueue.add(frame);
        }
    }

    protected void nextState(Ax25Primitive prim) {
        if (!Config.getBoolean("uplink_enabled")) {
            this.state = 0;
            return;
        }
        switch (this.state) {
            case 0: {
                this.stateDisc(prim);
                break;
            }
            case 1: {
                this.stateWaitConn(prim);
                break;
            }
            case 2: {
                this.stateWaitRelease(prim);
                break;
            }
            case 3: {
                this.stateConnected(prim);
                break;
            }
            case 4: {
                this.stateTimerRec(prim);
                break;
            }
        }
        this.readyForMoreIframes = this.iFrameQueue.size() < 2;
    }

    private void sendFrame(Ax25Frame frame, boolean expedited) {
        KissFrame kss = new KissFrame(0, 0, frame.getBytes());
        this.DEBUG("SENDING: " + frame.toString() + " ...");
        if (this.tncDecoder != null) {
            this.lastCommand = frame;
            this.tncDecoder.sendFrame(kss.getDataBytes(), expedited);
        } else {
            this.PRINT("ERROR: Nothing was transmitted as no TNC is connected");
        }
    }

    private void stateDisc(Ax25Primitive prim) {
        if (prim instanceof Ax25Request) {
            Ax25Request req = (Ax25Request)prim;
            switch (req.type) {
                case 2: {
                    this.establishDataLink(req.fromCall, req.toCall);
                    this.state = 1;
                    break;
                }
                case 3: {
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.state = 0;
                    break;
                }
            }
        } else {
            Ax25Frame frame = (Ax25Frame)prim;
            switch (frame.type) {
                case 99: {
                    this.PRINT("ERROR: Unexpected UA in Disconnected State");
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink == null) break;
                    this.spacecraft.uplink.processEvent(pse);
                    break;
                }
                case 67: {
                    int F = frame.PF;
                    Uframe dmframe = new Uframe(frame.toCallsign, frame.fromCallsign, F, 15, 0);
                    this.sendFrame(dmframe, false);
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink == null) break;
                    this.spacecraft.uplink.processEvent(pse);
                    break;
                }
                default: {
                    int F = frame.PF;
                    Uframe dm = new Uframe(frame.toCallsign, frame.fromCallsign, F, 15, 0);
                    this.sendFrame(dm, false);
                }
            }
        }
    }

    private void stateWaitConn(Ax25Primitive prim) {
        if (prim instanceof Ax25Request) {
            Ax25Request req = (Ax25Request)prim;
            switch (req.type) {
                case 2: {
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 1;
                    break;
                }
                case 4: {
                    this.iFrameQueue.add(((Ax25Request)prim).iFrame);
                    break;
                }
                case 0: {
                    if (this.RC == 10 || this.lastCommand == null) {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                        this.PRINT("ERROR (g): Max T1 Retries");
                        this.state = 0;
                        PacSatEvent pse = new PacSatEvent(1);
                        if (this.spacecraft.uplink != null) {
                            this.spacecraft.uplink.processEvent(pse);
                        }
                        this.RC = 0;
                        this.t1_timer = 0;
                        break;
                    }
                    ++this.RC;
                    int P = 1;
                    Uframe sambframe = new Uframe(this.lastCommand.fromCallsign, this.lastCommand.toCallsign, P, 47, 1);
                    this.sendFrame(sambframe, false);
                    this.t1_timer = 1;
                    this.state = 1;
                    break;
                }
            }
        } else {
            Ax25Frame frame = (Ax25Frame)prim;
            switch (frame.type) {
                case 67: {
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.t1_timer = 0;
                    this.RC = 0;
                    break;
                }
                case 15: {
                    if (frame.PF != 1) break;
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.t1_timer = 0;
                    this.RC = 0;
                    break;
                }
                case 99: {
                    if (this.iFrameQueue.size() > 0 && this.VS != this.VA) {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                    }
                    this.VS = 0;
                    this.VA = 0;
                    this.VR = 0;
                    this.t1_timer = 0;
                    this.t3_timer = 0;
                    this.RC = 0;
                    this.state = 3;
                    PacSatEvent pse = new PacSatEvent(0);
                    if (this.spacecraft.uplink == null) break;
                    this.spacecraft.uplink.processEvent(pse);
                    break;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stateWaitRelease(Ax25Primitive prim) {
        if (prim instanceof Ax25Request) {
            Ax25Request req = (Ax25Request)prim;
            switch (req.type) {
                case 3: {
                    int F = 1;
                    Uframe frame = new Uframe(req.fromCall, req.toCall, F, 15, 0);
                    this.t1_timer = 0;
                    this.sendFrame(frame, true);
                    this.state = 2;
                    return;
                }
                case 0: {
                    if (this.RC >= 10 || this.lastCommand == null) {
                        this.state = 0;
                        PacSatEvent pse = new PacSatEvent(1);
                        if (this.spacecraft.uplink == null) return;
                        this.spacecraft.uplink.processEvent(pse);
                        return;
                    }
                    ++this.RC;
                    int P = 1;
                    Uframe uframe = new Uframe(this.lastCommand.fromCallsign, this.lastCommand.toCallsign, P, 67, 1);
                    this.t1_timer = 1;
                    this.sendFrame(uframe, false);
                    this.state = 2;
                    return;
                }
                default: {
                    return;
                }
            }
        } else {
            Ax25Frame frame = (Ax25Frame)prim;
            switch (frame.type) {
                case 67: {
                    int F = frame.PF;
                    Uframe uframe = new Uframe(frame.toCallsign, frame.fromCallsign, F, 99, 0);
                    this.sendFrame(uframe, true);
                    this.state = 2;
                    return;
                }
                case 15: {
                    if (frame.PF == 1) {
                        this.state = 0;
                        PacSatEvent pse = new PacSatEvent(1);
                        if (this.spacecraft.uplink != null) {
                            this.spacecraft.uplink.processEvent(pse);
                        }
                        this.t1_timer = 0;
                        this.RC = 0;
                        return;
                    }
                    this.state = 2;
                    return;
                }
                case 99: {
                    if (frame.PF == 1) {
                        this.t1_timer = 0;
                        this.state = 0;
                        PacSatEvent pse = new PacSatEvent(1);
                        if (this.spacecraft.uplink == null) return;
                        this.spacecraft.uplink.processEvent(pse);
                        return;
                    }
                    this.PRINT("ERROR: UA received without F=1 when SABM or DISC was sent P=1.");
                    return;
                }
                case 0: 
                case 1: {
                    if (frame.PF == 1) {
                        Uframe dmframe = new Uframe(frame.toCallsign, frame.fromCallsign, 1, 15, 0);
                        this.sendFrame(dmframe, false);
                    }
                    this.state = 2;
                    return;
                }
            }
        }
    }

    private void stateConnected(Ax25Primitive prim) {
        block34: {
            block33: {
                if (!(prim instanceof Ax25Request)) break block33;
                Ax25Request req = (Ax25Request)prim;
                switch (req.type) {
                    case 2: {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                        this.establishDataLink(req.fromCall, req.toCall);
                        this.state = 1;
                        break;
                    }
                    case 3: {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                        this.RC = 0;
                        int P = 1;
                        Uframe frame = new Uframe(req.fromCall, req.toCall, P, 67, 1);
                        this.t1_timer = 1;
                        this.t3_timer = 0;
                        this.sendFrame(frame, false);
                        this.state = 2;
                        break;
                    }
                    case 0: {
                        this.RC = 1;
                        if (this.lastCommand != null) {
                            this.transmitInquiry(this.lastCommand.fromCallsign, this.lastCommand.toCallsign);
                        }
                        this.state = 4;
                        break;
                    }
                    case 1: {
                        this.RC = 0;
                        if (this.lastCommand != null) {
                            this.transmitInquiry(this.lastCommand.fromCallsign, this.lastCommand.toCallsign);
                        }
                        this.state = 4;
                        break;
                    }
                    case 4: {
                        if (prim != null && ((Ax25Request)prim).iFrame != null) {
                            this.iFrameQueue.add(((Ax25Request)prim).iFrame);
                            break;
                        }
                        break block34;
                    }
                    case 5: {
                        if (!this.peerReceiverBusy && this.VS != (this.VA + this.K) % this.modulo) {
                            Iframe iFrame = this.iFrameQueue.pop();
                            int P = 0;
                            iFrame.setControlByte(this.VR, this.VS, P);
                            this.sendFrame(iFrame, false);
                            this.iFramesSent[this.VS] = iFrame;
                            this.VS = (this.VS + 1) % this.modulo;
                            this.ackPending = false;
                            if (this.t1_timer <= 0) {
                                this.t1_timer = 1;
                                this.t3_timer = 0;
                            }
                            this.state = 3;
                            break;
                        }
                        break block34;
                    }
                }
                break block34;
            }
            Ax25Frame frame = (Ax25Frame)prim;
            switch (frame.type) {
                case 15: {
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.t1_timer = 0;
                    this.t3_timer = 0;
                    this.RC = 0;
                    break;
                }
                case 1: {
                    this.DEBUG("VS: " + this.VS + " VA: " + this.VA + " VR: " + this.VR + " RX NR: " + frame.NR + " RX NS: " + frame.NS);
                    switch (frame.SS) {
                        case 0: {
                            this.peerReceiverBusy = false;
                            this.checkNeedForResponse(frame.toCallsign, frame.fromCallsign, frame.isCommandFrame(), frame.PF);
                            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                this.checkIframeAckd(frame);
                                this.state = 3;
                                break;
                            }
                            this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                            this.state = 1;
                            break;
                        }
                        case 1: {
                            this.peerReceiverBusy = true;
                            this.checkNeedForResponse(frame.toCallsign, frame.fromCallsign, frame.isCommandFrame(), frame.PF);
                            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                this.checkIframeAckd(frame);
                                this.state = 3;
                                break;
                            }
                            this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                            this.state = 1;
                            break;
                        }
                        case 3: {
                            this.peerReceiverBusy = false;
                            this.checkNeedForResponse(frame.toCallsign, frame.fromCallsign, frame.isCommandFrame(), frame.PF);
                            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                if (frame.PF == 1) {
                                    this.VA = frame.NR;
                                }
                                this.t1_timer = 0;
                                this.t3_timer = 1;
                                this.checkIframeAckd(frame);
                                this.iFrameQueue.push(this.iFramesSent[frame.NR]);
                                this.state = 3;
                                break;
                            }
                            this.state = 1;
                            break;
                        }
                        case 2: {
                            this.peerReceiverBusy = false;
                            this.checkNeedForResponse(frame.toCallsign, frame.fromCallsign, frame.isCommandFrame(), frame.PF);
                            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                this.VA = frame.NR;
                                this.t1_timer = 0;
                                this.t3_timer = 0;
                                this.invokeRetransmission(frame.NR);
                                this.state = 3;
                                break;
                            }
                            this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                            this.state = 1;
                            break;
                        }
                    }
                    this.DEBUG(" After Processing S Frame => VS: " + this.VS + " VA: " + this.VA + " VR: " + this.VR + "\n");
                    break;
                }
                case 99: {
                    this.PRINT("ERROR:Unexpected UA in states 3, 4 or 5.\n");
                    break;
                }
                case 67: {
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    int F = frame.PF;
                    Uframe uaframe = new Uframe(frame.toCallsign, frame.fromCallsign, F, 99, 0);
                    this.t1_timer = 0;
                    this.t3_timer = 0;
                    this.sendFrame(uaframe, false);
                    this.state = 0;
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink == null) break;
                    this.spacecraft.uplink.processEvent(pse);
                    break;
                }
                case 135: {
                    this.PRINT("ERROR: (k) Frame Rejected");
                    this.establishDataLink(frame.toCallsign, frame.fromCallsign);
                    this.state = 1;
                    break;
                }
                case 0: {
                    this.processIFrame(frame, 3);
                    break;
                }
            }
        }
    }

    private void processIFrame(Ax25Frame frame, int finalState) {
        this.DEBUG(frame + "\n");
        if (!frame.isCommandFrame()) {
            this.PRINT("ERROR: I response received.");
        } else {
            try {
                FTL0Frame ftl = new FTL0Frame(frame);
                if (this.VA_lte_NR_lte_VS(frame.NR)) {
                    this.checkIframeAckd(frame);
                    if (frame.NS == this.VR) {
                        this.VR = (this.VR + 1) % this.modulo;
                        this.rejectException = false;
                        if (this.sRejException > 0) {
                            --this.sRejException;
                        }
                        if (this.spacecraft.uplink != null) {
                            this.spacecraft.uplink.processEvent(ftl);
                        }
                        if (frame.PF == 1) {
                            this.sendRR(frame);
                        } else if (!this.ackPending) {
                            this.ackPending = true;
                        }
                    } else if (this.rejectException) {
                        if (frame.PF == 1) {
                            this.sendRR(frame);
                        }
                    } else if (this.sRejEnabled) {
                        if (this.sRejException > 0) {
                            int NR = frame.NS;
                            int F = 0;
                            this.sendSREJ(frame, NR, F);
                        } else {
                            int shiftedVR;
                            int shiftedNS = this.shiftByVr(frame.NS);
                            if (shiftedNS > (shiftedVR = this.shiftByVr(this.VR + 1))) {
                                this.sendREJ(frame);
                            } else {
                                int NR = this.VR;
                                int F = 1;
                                this.sendSREJ(frame, NR, F);
                            }
                        }
                    } else {
                        this.sendREJ(frame);
                    }
                    this.state = finalState;
                } else {
                    this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                    this.state = 1;
                }
            }
            catch (FrameException e) {
                this.PRINT("ERROR: I frame exceeded maximum allowed length.");
                this.establishDataLink(frame.toCallsign, frame.fromCallsign);
                this.state = 1;
            }
        }
    }

    private void sendRR(Ax25Frame frame) {
        int F = 1;
        int NR = this.VR;
        Sframe sframe = new Sframe(frame.toCallsign, frame.fromCallsign, NR, F, 0, 0);
        this.sendFrame(sframe, false);
        this.ackPending = false;
    }

    private void sendREJ(Ax25Frame frame) {
        this.rejectException = true;
        int F = frame.PF;
        int NR = this.VR;
        Sframe sframe = new Sframe(frame.toCallsign, frame.fromCallsign, NR, F, 2, 0);
        this.sendFrame(sframe, false);
        this.ackPending = false;
    }

    private void sendSREJ(Ax25Frame frame, int NR, int F) {
        ++this.sRejException;
        Sframe sframe = new Sframe(frame.toCallsign, frame.fromCallsign, NR, F, 3, 0);
        this.sendFrame(sframe, false);
        this.ackPending = false;
    }

    private void stateTimerRec(Ax25Primitive prim) {
        block38: {
            block37: {
                if (!(prim instanceof Ax25Request)) break block37;
                Ax25Request req = (Ax25Request)prim;
                switch (req.type) {
                    case 0: {
                        if (this.RC >= 10 || this.lastCommand == null) {
                            if (this.VA == this.VS) {
                                if (this.peerReceiverBusy) {
                                    this.PRINT("DL ERROR: N2 timeouts: extended peer busy condition.");
                                } else {
                                    this.PRINT("DL ERROR: N2 timeouts: no response to enquiry.");
                                }
                            } else {
                                this.PRINT("DL ERROR: N2 timeouts: unacknowledged data.");
                            }
                            PacSatEvent pse = new PacSatEvent(1);
                            if (this.spacecraft.uplink != null) {
                                this.spacecraft.uplink.processEvent(pse);
                            }
                            this.iFrameQueue = new ConcurrentLinkedDeque();
                            int F = 0;
                            Uframe frame = new Uframe(this.lastCommand.fromCallsign, this.lastCommand.toCallsign, F, 15, 0);
                            this.sendFrame(frame, false);
                            this.state = 0;
                            break;
                        }
                        ++this.RC;
                        if (this.lastCommand != null) {
                            this.transmitInquiry(this.lastCommand.fromCallsign, this.lastCommand.toCallsign);
                        }
                        this.state = 4;
                        break;
                    }
                    case 2: {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                        this.establishDataLink(req.fromCall, req.toCall);
                        this.state = 1;
                        break;
                    }
                    case 3: {
                        this.iFrameQueue = new ConcurrentLinkedDeque();
                        this.RC = 0;
                        int P = 1;
                        Uframe frame = new Uframe(req.fromCall, req.toCall, P, 67, 1);
                        this.sendFrame(frame, false);
                        this.t3_timer = 0;
                        this.t1_timer = 1;
                        this.state = 2;
                        break;
                    }
                    case 4: {
                        this.iFrameQueue.add(((Ax25Request)prim).iFrame);
                        this.state = 4;
                        break;
                    }
                    case 5: {
                        if (!this.peerReceiverBusy && this.VS != (this.VA + this.K) % this.modulo) {
                            Iframe iFrame = this.iFrameQueue.pop();
                            int P = 0;
                            iFrame.setControlByte(this.VR, this.VS, P);
                            this.sendFrame(iFrame, false);
                            this.iFramesSent[this.VS] = iFrame;
                            this.VS = (this.VS + 1) % this.modulo;
                            this.ackPending = false;
                            if (this.t1_timer <= 0) {
                                this.t1_timer = 1;
                                this.t3_timer = 0;
                            }
                            this.state = 4;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block38;
            }
            Ax25Frame frame = (Ax25Frame)prim;
            switch (frame.type) {
                case 1: {
                    this.DEBUG("VS: " + this.VS + " VA: " + this.VA + " VR: " + this.VR + " RX NR: " + frame.NR + " RX NS: " + frame.NS);
                    switch (frame.SS) {
                        case 0: {
                            this.peerReceiverBusy = false;
                            this.processTimerRecoveryRR(frame);
                            break;
                        }
                        case 1: {
                            this.peerReceiverBusy = true;
                            this.processTimerRecoveryRR(frame);
                            break;
                        }
                        case 2: {
                            this.peerReceiverBusy = false;
                            if (!frame.isCommandFrame() && frame.PF == 1) {
                                this.t1_timer = 0;
                                if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                    this.VA = frame.NR;
                                    if (this.VS == this.VA) {
                                        this.t3_timer = 1;
                                        this.state = 3;
                                        break;
                                    }
                                    this.invokeRetransmission(frame.NR);
                                    this.state = 4;
                                    break;
                                }
                                this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                                this.state = 1;
                                break;
                            }
                            if (frame.isCommandFrame() && frame.PF == 1) {
                                int F = 1;
                                this.enquiryResponse(frame.toCallsign, frame.fromCallsign, F, 0);
                            }
                            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                                this.VA = frame.NR;
                                if (this.VS == this.VA) {
                                    this.state = 4;
                                    break;
                                }
                                this.invokeRetransmission(frame.NR);
                                this.state = 4;
                                break;
                            }
                            this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                            this.state = 1;
                            break;
                        }
                    }
                    this.DEBUG(" After S frame timer rec => VS: " + this.VS + " VA: " + this.VA + " VR: " + this.VR + "\n");
                    break;
                }
                case 15: {
                    if (frame.PF != 1) break;
                    this.PRINT("ERROR:DM received in states 3, 4 or 5.");
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    this.t1_timer = 0;
                    this.t3_timer = 0;
                    this.state = 0;
                    break;
                }
                case 67: {
                    this.iFrameQueue = new ConcurrentLinkedDeque();
                    int F = frame.PF;
                    Uframe uaframe = new Uframe(frame.toCallsign, frame.fromCallsign, F, 99, 0);
                    this.t1_timer = 0;
                    this.t3_timer = 0;
                    this.sendFrame(uaframe, false);
                    PacSatEvent pse = new PacSatEvent(1);
                    if (this.spacecraft.uplink != null) {
                        this.spacecraft.uplink.processEvent(pse);
                    }
                    this.state = 0;
                    break;
                }
                case 99: {
                    this.PRINT(ERROR_C);
                    this.establishDataLink(frame.toCallsign, frame.fromCallsign);
                    this.state = 1;
                    break;
                }
                case 135: {
                    this.PRINT("ERROR: (k) Frame Rejected");
                    this.establishDataLink(frame.toCallsign, frame.fromCallsign);
                    this.state = 1;
                    break;
                }
                case 0: {
                    this.processIFrame(frame, 3);
                    break;
                }
            }
        }
    }

    private void processTimerRecoveryRR(Ax25Frame frame) {
        if (!frame.isCommandFrame() && frame.PF == 1) {
            this.t1_timer = 0;
            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                this.VA = frame.NR;
                if (this.VS == this.VA) {
                    this.t3_timer = 1;
                    this.state = 3;
                } else {
                    this.invokeRetransmission(frame.NR);
                    this.state = 4;
                }
            } else {
                this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                this.state = 1;
            }
        } else {
            if (frame.isCommandFrame() && frame.PF == 1) {
                int F = 1;
                this.enquiryResponse(frame.toCallsign, frame.fromCallsign, F, 0);
            }
            if (this.VA_lte_NR_lte_VS(frame.NR)) {
                this.VA = frame.NR;
                this.state = 4;
            } else {
                this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
                this.state = 1;
            }
        }
        if (this.VA_lte_NR_lte_VS(frame.NR)) {
            this.checkIframeAckd(frame);
            this.state = 3;
        } else {
            this.NRErrorRecovery(frame.toCallsign, frame.fromCallsign, "VA=" + this.VA + " NR=" + frame.NR + " VS=" + this.VS);
            this.state = 1;
        }
    }

    private void invokeRetransmission(int NR) {
        this.DEBUG("BACKTRACK: VS: " + this.VS + " to NEW NR:" + NR);
        int vs = this.VS;
        do {
            if (this.iFramesSent[vs = this.MODULO(vs - 1)] == null) continue;
            Iframe frame = this.iFramesSent[vs];
            if (frame.NS != vs) {
                this.DEBUG("ERROR: iFramesSent corrupt? Wrong I frame being retransmitted VS: " + this.VS + " - NS:" + frame.NS);
            }
            this.iFrameQueue.push(this.iFramesSent[vs]);
        } while (vs != NR);
        this.VS = NR;
    }

    private void checkNeedForResponse(String fromCallsign, String toCallsign, boolean command, int PF) {
        int P = 1;
        if (command && PF == 1) {
            this.enquiryResponse(fromCallsign, toCallsign, P, 0);
        }
    }

    private void enquiryResponse(String fromCallsign, String toCallsign, int F, int command) {
        int NR = this.VR;
        this.ackPending = false;
        Sframe frame = new Sframe(fromCallsign, toCallsign, NR, F, 0, command);
        this.sendFrame(frame, false);
    }

    private void transmitInquiry(String fromCallsign, String toCallsign) {
        int P = 1;
        int NR = this.VR;
        Sframe frame = new Sframe(fromCallsign, toCallsign, NR, P, 0, 1);
        this.sendFrame(frame, false);
        this.ackPending = false;
        this.t1_timer = 1;
    }

    private void NRErrorRecovery(String fromCall, String toCall, String msg) {
        this.PRINT("ERROR: N(r) sequence ERROR_. " + msg + "\n");
        this.establishDataLink(fromCall, toCall);
    }

    private void clearExceptionConditions() {
        this.peerReceiverBusy = false;
        this.rejectException = false;
        this.ackPending = false;
    }

    private void establishDataLink(String fromCall, String toCall) {
        this.clearExceptionConditions();
        this.RC = 0;
        int PF = 1;
        int controlByte = 0x2F | PF << 4;
        Ax25Frame frame = new Ax25Frame(fromCall, toCall, controlByte, 1);
        this.sendFrame(frame, false);
        this.RC = 0;
        this.t3_timer = 0;
        this.t1_timer = 1;
    }

    private void checkIframeAckd(Ax25Frame frame) {
        if (this.peerReceiverBusy) {
            this.DEBUG("Peer Receiver BUSY.  Setting VA = NR and starting T1 and T3");
            this.VA = frame.NR;
            this.t3_timer = 1;
            if (this.t1_timer == 0) {
                this.t1_timer = 1;
                this.RC = 0;
            }
        } else if (frame.NR == this.VS) {
            this.VA = frame.NR;
            this.t1_timer = 0;
            this.t3_timer = 1;
        } else if (frame.NR != this.VA) {
            this.VA = frame.NR;
            this.t1_timer = 1;
            this.RC = 0;
        }
    }

    private boolean VA_lte_NR_lte_VS(int nr) {
        int shiftedVa = this.shiftByVa(this.VA);
        int shiftedNr = this.shiftByVa(nr);
        int shiftedVs = this.shiftByVa(this.VS);
        this.DEBUG("DEBUG: V(a) <= N(r) <= V(s) VA:" + this.VA + " NR:" + nr + " VS:" + this.VS);
        return shiftedVa <= shiftedNr && shiftedNr <= shiftedVs;
    }

    private int shiftByVa(int x) {
        return x - this.VA & this.modulo - 1;
    }

    private int shiftByVr(int x) {
        return x - this.VR & this.modulo - 1;
    }

    private int MODULO(int vs) {
        return vs & this.modulo - 1;
    }

    private void DEBUG(String s) {
        s = "DEBUG 2: " + states[this.state] + ": " + s;
        if (Config.getBoolean("DEBUG_LAYER2")) {
            if (this.ta != null) {
                this.ta.append(String.valueOf(s) + "\n");
            }
            Log.println(s);
        }
    }

    private void PRINT(String s) {
        if (this.ta != null) {
            this.ta.append(String.valueOf(s) + "\n");
        }
        Log.println(s);
    }

    public void setTncDecoder(TncDecoder tnc, MainWindow ta) {
        this.tncDecoder = tnc;
        this.ta = ta;
    }

    public void stopRunning() {
        this.running = false;
    }

    @Override
    public void run() {
        Log.println("STARTING Layer 2 Data Link Thread");
        while (this.running) {
            if (this.t1_timer > 0) {
                ++this.t1_timer;
                if (this.t1_timer > 3000) {
                    this.t1_timer = 0;
                    this.DEBUG("T1 expired");
                    if (!Config.getBoolean("tx_inhibit")) {
                        this.nextState(new Ax25Request(0));
                    }
                }
            }
            if (this.t3_timer > 0) {
                ++this.t3_timer;
                if (this.t3_timer > 60000) {
                    this.t3_timer = 0;
                    this.DEBUG("T3 expired");
                    if (!Config.getBoolean("tx_inhibit")) {
                        this.nextState(new Ax25Request(1));
                    }
                }
            }
            if (this.frameEventQueue.size() > 0 && !Config.getBoolean("tx_inhibit")) {
                this.nextState(this.frameEventQueue.poll());
            }
            if (this.t1_timer == 0 && !this.iFrameQueue.isEmpty() && !Config.getBoolean("tx_inhibit")) {
                this.nextState(new Ax25Request(5));
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Config.mainWindow == null) continue;
            MainWindow.setLayer2Status(this.spacecraft.name, String.valueOf(states[this.state]) + "  I:" + this.iFrameQueue.size());
        }
        Log.println("EXIT Layer 2 Thread");
    }
}

