/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.data;

import com.g0kla.telem.data.BitArrayLayout;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import java.io.IOException;

public class BitDataRecord
extends DataRecord {
    protected static final String PAD = "pad";
    public boolean[] rawBits = null;
    protected int bitPosition = 0;
    public int numberBytesAdded = 0;
    public static final boolean BIG_ENDIAN = false;
    public static final boolean LITTLE_ENDIAN = true;

    public BitDataRecord(BitArrayLayout layout, int id, int resets, long uptime, int type, int[] data, boolean littleEndian) throws LayoutLoadException, IOException {
        super(layout, id, resets, uptime, type, data, littleEndian);
    }

    @Override
    public void parseData(int[] data) {
        this.rawBits = new boolean[((BitArrayLayout)this.layout).getMaxNumberOfBits()];
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            this.addNext8Bits((byte)(b & 0xFF));
            ++n2;
        }
        this.copyBitsToFields();
    }

    public void resetBitPosition() {
        this.bitPosition = 0;
    }

    public void addNext8Bits(byte b) {
        this.littleEndianAddNext8Bits(b);
    }

    public void littleEndianAddNext8Bits(byte b) {
        int i2 = 0;
        while (i2 < 8) {
            this.rawBits[i2 + this.numberBytesAdded * 8] = (b >> i2 & 1) == 1;
            ++i2;
        }
        ++this.numberBytesAdded;
    }

    public void bigEndianAddNext8Bits(byte b) {
        int i2 = 0;
        while (i2 < 8) {
            this.rawBits[7 - i2 + this.numberBytesAdded * 8] = (b >> i2 & 1) == 1;
            ++i2;
        }
        ++this.numberBytesAdded;
    }

    public void copyBitsToFields() {
        if (this.rawBits != null) {
            this.resetBitPosition();
            int i2 = 0;
            while (i2 < this.layout.fieldName.length) {
                if (this.layout.fieldName[i2] == null || this.layout.fieldName[i2].startsWith(PAD)) {
                    this.nextbits(this.layout.fieldLength[i2]);
                    this.fieldValue[i2] = 0;
                } else {
                    this.fieldValue[i2] = this.nextbits(this.layout.fieldLength[i2]);
                }
                ++i2;
            }
        }
    }

    protected int nextbits(int n) {
        return this.littleEndianNextbits(n);
    }

    protected int littleEndianNextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i2 = 0;
        while (i2 < n) {
            b[i2] = this.rawBits[this.bitPosition + n - i2 - 1];
            ++i2;
        }
        this.bitPosition += n;
        field = BitDataRecord.binToInt(b);
        return field;
    }

    protected int bigEndianNextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i2 = 0;
        while (i2 < n) {
            b[i2] = this.rawBits[this.bitPosition + i2];
            ++i2;
        }
        this.bitPosition += n;
        field = BitDataRecord.binToInt(b);
        return field;
    }

    public static int binToInt(boolean[] word10) {
        int d = 0;
        int i2 = 0;
        while (i2 < word10.length) {
            int value = 0;
            if (word10[word10.length - 1 - i2]) {
                value = 1;
            }
            d += value << i2;
            ++i2;
        }
        return d;
    }

    public static boolean[] intToBin8(int word) {
        boolean[] b = new boolean[8];
        int i2 = 0;
        while (i2 < 8) {
            b[7 - i2] = (word >> i2 & 1) == 1;
            ++i2;
        }
        return b;
    }
}

