/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.data;

import com.g0kla.telem.data.ConversionTable;
import com.g0kla.telem.data.LayoutLoadException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ByteArrayLayout {
    public int NUMBER_OF_FIELDS = 0;
    public static int ERROR_POSITION = -1;
    public String fileName;
    public String name;
    public String parentLayout = null;
    public static final String NONE = "NONE";
    public String[] fieldName = null;
    public String[] type = null;
    public int[] conversion = null;
    public String[] fieldUnits = null;
    public int[] fieldLength = null;
    public String[] module = null;
    public int[] moduleNum = null;
    public int[] moduleLinePosition = null;
    public int[] moduleDisplayType = null;
    public String[] shortName = null;
    public String[] description = null;
    protected int numberOfBytes = 0;
    public static final int CONVERT_NONE = 0;
    ConversionTable conversions = null;

    public ByteArrayLayout(String name, String fileName) throws LayoutLoadException, IOException, NoSuchElementException {
        this.name = name;
        this.load(fileName);
    }

    public int getMaxNumberOfBytes() {
        return this.numberOfBytes;
    }

    public boolean isSecondaryPayload() {
        return this.parentLayout != null;
    }

    public void setConversionTable(ConversionTable ct) {
        this.conversions = ct;
    }

    public ConversionTable getConversionTable() {
        return this.conversions;
    }

    public boolean hasFieldName(String name) {
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int getConversionByName(String name) {
        int pos = ERROR_POSITION;
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                pos = i2;
            }
            ++i2;
        }
        if (pos == ERROR_POSITION) {
            return 0;
        }
        return this.conversion[pos];
    }

    public String getUnitsByName(String name) {
        int pos = ERROR_POSITION;
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                pos = i2;
            }
            ++i2;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.fieldUnits[pos];
    }

    public int getPositionByName(String name) {
        int pos = ERROR_POSITION;
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                pos = i2;
            }
            ++i2;
        }
        if (pos == ERROR_POSITION) {
            return ERROR_POSITION;
        }
        return pos;
    }

    public String getShortNameByName(String name) {
        int pos = ERROR_POSITION;
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                pos = i2;
            }
            ++i2;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.shortName[pos];
    }

    public String getModuleByName(String name) {
        int pos = ERROR_POSITION;
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i2])) {
                pos = i2;
            }
            ++i2;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.module[pos];
    }

    protected void load(String fileName) throws LayoutLoadException, IOException, NoSuchElementException {
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        int field = 0;
        String line = dis.readLine();
        StringTokenizer header = new StringTokenizer(line, ",");
        this.NUMBER_OF_FIELDS = Integer.valueOf(header.nextToken());
        this.fieldName = new String[this.NUMBER_OF_FIELDS];
        this.type = new String[this.NUMBER_OF_FIELDS];
        this.conversion = new int[this.NUMBER_OF_FIELDS];
        this.fieldLength = new int[this.NUMBER_OF_FIELDS];
        this.fieldUnits = new String[this.NUMBER_OF_FIELDS];
        this.module = new String[this.NUMBER_OF_FIELDS];
        this.moduleLinePosition = new int[this.NUMBER_OF_FIELDS];
        this.moduleNum = new int[this.NUMBER_OF_FIELDS];
        this.moduleDisplayType = new int[this.NUMBER_OF_FIELDS];
        this.shortName = new String[this.NUMBER_OF_FIELDS];
        this.description = new String[this.NUMBER_OF_FIELDS];
        while ((line = dis.readLine()) != null) {
            if (line == null) continue;
            StringTokenizer st = new StringTokenizer(line, ",");
            int fieldId = Integer.valueOf(st.nextToken());
            this.type[field] = st.nextToken();
            this.fieldName[field] = st.nextToken();
            this.fieldLength[field] = Integer.valueOf(st.nextToken());
            this.fieldUnits[field] = st.nextToken();
            this.conversion[field] = Integer.valueOf(st.nextToken());
            this.module[field] = st.nextToken();
            this.moduleNum[field] = Integer.valueOf(st.nextToken());
            this.moduleLinePosition[field] = Integer.valueOf(st.nextToken());
            this.moduleDisplayType[field] = Integer.valueOf(st.nextToken());
            this.shortName[field] = st.nextToken();
            try {
                this.description[field] = st.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            ++field;
        }
        dis.close();
        if (this.NUMBER_OF_FIELDS != field) {
            throw new LayoutLoadException("Error loading fields from " + fileName + ". Expected " + this.NUMBER_OF_FIELDS + " fields , but loaded " + field);
        }
        if (this.fieldLength != null) {
            this.numberOfBytes = 0;
            int i2 = 0;
            while (i2 < this.fieldLength.length) {
                this.numberOfBytes += this.fieldLength[i2];
                ++i2;
            }
        }
    }

    public String getTableCreateStmt(boolean storeMode) {
        String s = new String();
        s = String.valueOf(s) + "(captureDate varchar(14), id int, resets int, uptime bigint, type int, ";
        if (storeMode) {
            s = String.valueOf(s) + "newMode int,";
        }
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            s = String.valueOf(s) + this.fieldName[i2] + " int,\n";
            ++i2;
        }
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type))";
        return s;
    }
}

