/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.data;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.ConversionTable;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.data.Tools;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DataRecord
implements Comparable<DataRecord> {
    public static final int ERROR_VALUE = 999999999;
    public static final double NO_POSITION_DATA = -999.0;
    public static final double NO_TLE = -998.0;
    public static final double NO_T0 = -997.0;
    public ByteArrayLayout layout;
    public int[] fieldValue = null;
    boolean littleEndian = true;
    public int id;
    public int resets;
    public long uptime;
    public int type;
    public double satLatitude;
    public double satLongitude;

    public DataRecord(ByteArrayLayout layout, String line) throws IOException, DataLoadException {
        if (layout == null) {
            throw new DataLoadException("Missing layout");
        }
        this.layout = layout;
        this.fieldValue = new int[layout.fieldName.length];
        this.load(line);
    }

    public DataRecord(ByteArrayLayout layout, int id, int resets, long uptime, int type, int[] data, boolean littleEndian) throws LayoutLoadException, IOException {
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.type = type;
        this.layout = layout;
        this.littleEndian = littleEndian;
        this.fieldValue = new int[layout.fieldName.length];
        this.parseData(data);
    }

    public void parseData(int[] data) {
        int i2 = 0;
        int k = 0;
        while (k < this.layout.fieldName.length && i2 < data.length) {
            if (this.layout.type[k].equalsIgnoreCase("LONG")) {
                this.fieldValue[k] = (int)DataRecord.getLongValue(i2, data);
            }
            if (this.layout.type[k].equalsIgnoreCase("INT")) {
                this.fieldValue[k] = DataRecord.getIntValue(i2, data);
            }
            if (this.layout.type[k].equalsIgnoreCase("BYTE")) {
                this.fieldValue[k] = data[i2];
            }
            i2 += this.layout.fieldLength[k];
            ++k;
        }
    }

    public boolean hasFieldName(String name) {
        return this.layout.hasFieldName(name);
    }

    public int getRawValue(String name) {
        int i2 = 0;
        while (i2 < this.layout.fieldName.length) {
            if (this.layout.fieldName[i2].equalsIgnoreCase(name)) {
                return this.fieldValue[i2];
            }
            ++i2;
        }
        return 0;
    }

    public double getDoubleValue(String name) {
        int i2 = 0;
        while (i2 < this.layout.fieldName.length) {
            if (this.layout.fieldName[i2].equalsIgnoreCase(name)) {
                ConversionTable ct = this.layout.getConversionTable();
                return ct.convertRawValue(this.layout.conversion[i2], this.fieldValue[i2]);
            }
            ++i2;
        }
        return 0.0;
    }

    public String getStringValue(String name) {
        int i2 = 0;
        while (i2 < this.layout.fieldName.length) {
            if (this.layout.fieldName[i2].equalsIgnoreCase(name)) {
                ConversionTable ct = this.layout.getConversionTable();
                return ct.getStringValue(this.layout.conversion[i2], this.fieldValue[i2]);
            }
            ++i2;
        }
        return null;
    }

    public static long getLongValue(int offset, int[] data) {
        int[] by2 = new int[]{data[offset], data[offset + 1], data[offset + 2], data[offset + 3]};
        long value = Tools.getLongFromBytes(by2);
        return value;
    }

    public static int getIntValue(int offset, int[] data) {
        int[] by2 = new int[]{data[offset], data[offset + 1]};
        int value = Tools.getIntFromBytes(by2);
        return value;
    }

    public static int getByteValue(int offset, int[] data) {
        int value = data[offset];
        return value;
    }

    @Override
    public int compareTo(DataRecord p) {
        if (this.resets == p.resets && this.uptime == p.uptime && this.type == p.type) {
            return 0;
        }
        if (this.resets < p.resets) {
            return -1;
        }
        if (this.resets > p.resets) {
            return 1;
        }
        if (this.resets == p.resets && this.uptime == p.uptime) {
            if (this.type < p.type) {
                return -1;
            }
            if (this.type > p.type) {
                return 1;
            }
        } else if (this.resets == p.resets) {
            if (this.uptime < p.uptime) {
                return -1;
            }
            if (this.uptime > p.uptime) {
                return 1;
            }
        }
        return 1;
    }

    protected void load(String line) throws DataLoadException {
        int i2 = 0;
        String s = null;
        StringTokenizer st = null;
        try {
            st = new StringTokenizer(line, ",");
            this.id = Integer.valueOf(st.nextToken());
            this.resets = Integer.valueOf(st.nextToken());
            this.uptime = Long.valueOf(st.nextToken());
            this.type = Integer.valueOf(st.nextToken());
            while ((s = st.nextToken()) != null) {
                if (s.startsWith("0x")) {
                    s = s.replace("0x", "");
                    this.fieldValue[i2++] = Integer.valueOf(s, 16);
                    continue;
                }
                this.fieldValue[i2++] = Integer.valueOf(s);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataLoadException("ERROR: Too many fields: Index out of bounds Could not load field " + i2 + " SAT: " + this.id + " Reset:" + this.resets + " Up:" + this.uptime + " Type:" + this.type);
        }
        catch (NumberFormatException n) {
            throw new DataLoadException("ERROR: Invalid number:  " + n.getMessage() + " Could not load frame " + this.id + " " + this.resets + " " + this.uptime + " " + this.type);
        }
    }

    public String toFile() {
        String s = new String();
        s = String.valueOf(s) + this.id + "," + this.resets + "," + this.uptime + "," + this.type + ",";
        int i2 = 0;
        while (i2 < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + this.fieldValue[i2] + ",";
            ++i2;
        }
        s = String.valueOf(s) + this.fieldValue[this.layout.fieldName.length - 1];
        return s;
    }

    public String getInsertStmt() {
        String s = new String();
        s = String.valueOf(s) + " (id, resets, uptime, type, \n";
        int i2 = 0;
        while (i2 < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + this.layout.fieldName[i2] + ",\n";
            ++i2;
        }
        s = String.valueOf(s) + this.layout.fieldName[this.layout.fieldName.length - 1] + ")\n";
        s = String.valueOf(s) + "values (" + this.id + ", " + this.resets + ", " + this.uptime + ", " + this.type + ",\n";
        i2 = 0;
        while (i2 < this.fieldValue.length - 1) {
            s = String.valueOf(s) + this.fieldValue[i2] + ",\n";
            ++i2;
        }
        s = String.valueOf(s) + this.fieldValue[this.fieldValue.length - 1] + ")\n";
        return s;
    }

    public String toHeaderString() {
        String s = new String();
        int i2 = 0;
        while (i2 < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + this.layout.shortName[i2] + ", ";
            ++i2;
        }
        s = String.valueOf(s) + this.layout.shortName[this.layout.fieldName.length - 1];
        return s;
    }

    public String toString() {
        String s = new String();
        ConversionTable ct = this.layout.getConversionTable();
        int i2 = 0;
        while (i2 < this.layout.fieldName.length - 1) {
            s = ct != null ? String.valueOf(s) + this.layout.fieldName[i2] + ":" + ct.getStringValue(this.layout.conversion[i2], this.fieldValue[i2]) + ", " : String.valueOf(s) + this.layout.fieldName[i2] + ":" + this.fieldValue[i2] + ", ";
            ++i2;
        }
        s = ct != null ? String.valueOf(s) + this.layout.fieldName[this.layout.fieldName.length - 1] + ":" + ct.getStringValue(this.layout.conversion[this.layout.fieldName.length - 1], this.fieldValue[this.layout.fieldName.length - 1]) : String.valueOf(s) + this.layout.fieldName[this.layout.fieldName.length - 1] + ":" + this.fieldValue[this.layout.fieldName.length - 1];
        return s;
    }
}

