/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.data;

public class Tools {
    public static long getLongFromBytes(int[] by) {
        long value = 0L;
        int i2 = 0;
        while (i2 < by.length) {
            value += ((long)by[i2] & 0xFFL) << 8 * i2;
            ++i2;
        }
        return value;
    }

    public static int getIntFromBytes(int[] by) {
        int value = 0;
        int i2 = 0;
        while (i2 < by.length) {
            value += (by[i2] & 0xFF) << 8 * i2;
            ++i2;
        }
        return value;
    }

    public static int[] littleEndian2(long in) {
        int[] b = new int[2];
        b[1] = (int)(in >> 8 & 0xFFL);
        b[0] = (int)(in >> 0 & 0xFFL);
        return b;
    }

    public static int[] littleEndian4(long in) {
        int[] b = new int[4];
        b[3] = (int)(in >> 24 & 0xFFL);
        b[2] = (int)(in >> 16 & 0xFFL);
        b[1] = (int)(in >> 8 & 0xFFL);
        b[0] = (int)(in >> 0 & 0xFFL);
        return b;
    }

    public static boolean[] intToBin8(int word) {
        return Tools.intToBin(word, 8);
    }

    public static boolean[] intToBin(int word, int bits) {
        boolean[] b = new boolean[bits];
        int i2 = 0;
        while (i2 < bits) {
            b[i2] = (word >> i2 & 1) == 1;
            ++i2;
        }
        return b;
    }

    public static String printBin(int word, int bits) {
        boolean[] b = Tools.intToBin(word, bits);
        String s = Tools.printBin(b);
        return s;
    }

    public static String printBin(boolean[] bits) {
        String s = "";
        int i2 = 7;
        while (i2 >= 0) {
            s = String.valueOf(s) + (bits[i2] ? 1 : 0);
            --i2;
        }
        return s;
    }
}

