/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.gui.GraphFrame;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DisplayModule
extends JPanel
implements ActionListener,
MouseListener {
    int size = 0;
    int satId;
    Spacecraft sat;
    SatTelemStore db;
    double scale;
    String[] fieldName = null;
    JLabel[] rtValue = null;
    JLabel[] maxValue = null;
    JComponent[] minValue = null;
    JLabel[] label = null;
    JPanel[] row = null;
    int[] display;
    String title = null;
    GraphFrame[][] graph = null;
    String noValue = "0000";
    ByteArrayLayout layout;
    DataRecord rtPayload;
    int displayModuleFontSize;
    boolean displayRawValues = false;
    private static final int DEFAULT_FONT_SIZE = 11;
    private int VAL_WIDTH = 40;
    private int SINGLE_VAL_WIDTH = 120;
    private int VULCAN_WIDTH = 70;
    private int VULCAN_NAME_WIDTH = 140;
    private int MEASUREMENT_WIDTH = 80;
    private int MEASUREMENT_NAME_WIDTH = 140;
    private int HERCI_MICRO_PKT_NAME_WIDTH = 80;
    private int HERCI_MICRO_PKT_VALUE_WIDTH = 310;
    private int NAME_WIDTH = 110;
    private int ROW_HEIGHT = 16;
    private static final int MAC_VAL_WIDTH = 44;
    private static final int MAC_SINGLE_VAL_WIDTH = 132;
    private static final int MAC_VULCAN_WIDTH = 55;
    private static final int MAC_VULCAN_NAME_WIDTH = 154;
    private static final int MAC_NAME_WIDTH = 121;
    private static final int MAC_ROW_HEIGHT = 16;
    private static final int MAC_HERCI_MICRO_PKT_NAME_WIDTH = 88;
    private static final int MAC_HERCI_MICRO_PKT_VALUE_WIDTH = 341;
    private static final int MAC_MEASUREMENT_WIDTH = 88;
    private static final int MAC_MEASUREMENT_NAME_WIDTH = 154;
    private static final int LIN_VAL_WIDTH = 48;
    private static final int LIN_SINGLE_VAL_WIDTH = 144;
    private static final int LIN_VULCAN_WIDTH = 60;
    private static final int LIN_VULCAN_NAME_WIDTH = 168;
    private static final int LIN_NAME_WIDTH = 132;
    private static final int LIN_ROW_HEIGHT = 16;
    private static final int LIN_HERCI_MICRO_PKT_NAME_WIDTH = 92;
    private static final int LIN_HERCI_MICRO_PKT_VALUE_WIDTH = 382;
    private static final int LIN_MEASUREMENT_WIDTH = 96;
    private static final int LIN_MEASUREMENT_NAME_WIDTH = 168;
    public static final int DISPLAY_RT_ONLY = 0;
    public static final int DISPLAY_MAX_ONLY = 1;
    public static final int DISPLAY_MIN_ONLY = 2;
    public static final int DISPLAY_ALL = 3;
    public static final int DISPLAY_ALL_SWAP_MINMAX = 4;
    public static final int DISPLAY_VULCAN = 5;
    public static final int DISPLAY_LEP = 6;
    public static final int DISPLAY_LEP_EXPOSURE = 7;
    public static final int DISPLAY_WOD_VULCAN = 8;
    public static final int DISPLAY_MEASURES = 9;
    public static final int DISPLAY_PASS_MEASURES = 10;
    public static final int DISPLAY_MIN_AND_MAX_ONLY = 15;
    public static final int DISPLAY_HERCI = 20;
    public static final int DISPLAY_HERCI_HK = 21;
    public static final int DISPLAY_HERCI_MICRO_PKT = 22;
    public static final int DISPLAY_WOD = 23;
    public static final int DISPLAY_UW = 24;
    public static Color vulcanFontColor = new Color(153, 0, 0);
    public static Color herciFontColor = new Color(240, 154, 21);
    public static Color wodFontColor = new Color(70, 146, 32);
    int moduleType = 3;

    public DisplayModule(ByteArrayLayout layout, String title, int size, int modType, int displayModuleFontSize, Spacecraft sat, SatTelemStore db) {
        this.displayModuleFontSize = displayModuleFontSize;
        this.db = db;
        this.sat = sat;
        this.satId = sat.satId;
        this.layout = layout;
        this.size = size;
        this.title = title;
        TitledBorder border = new TitledBorder(null, title, 4, 2, null, null);
        this.scale = (double)displayModuleFontSize / 11.0;
        this.setDefaultSizes();
        this.moduleType = modType;
        if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            border.setTitleFont(new Font("SansSerif", 1, displayModuleFontSize * 12 / 11));
            border.setTitleColor(herciFontColor);
        } else if (this.moduleType == 9) {
            border.setTitleFont(new Font("SansSerif", 1, displayModuleFontSize * 12 / 10));
            border.setTitleColor(vulcanFontColor);
            this.minValue = new JButton[size];
        } else if (this.moduleType >= 23) {
            border.setTitleFont(new Font("SansSerif", 1, displayModuleFontSize * 12 / 10));
            border.setTitleColor(wodFontColor);
            this.minValue = new JButton[size];
        } else if (this.moduleType >= 5) {
            border.setTitleFont(new Font("SansSerif", 1, displayModuleFontSize * 12 / 10));
            border.setTitleColor(vulcanFontColor);
        } else {
            border.setTitleFont(new Font("SansSerif", 1, displayModuleFontSize * 12 / 11));
            border.setTitleColor(Color.BLUE);
            this.maxValue = new JLabel[size];
            this.minValue = new JLabel[size];
        }
        this.setBorder(border);
        this.fieldName = new String[size];
        this.rtValue = new JLabel[size];
        this.label = new JLabel[size];
        this.row = new JPanel[size];
        this.graph = new GraphFrame[3][size];
        this.display = new int[size];
        this.initGui();
    }

    public void setDisplayRawValues(boolean b) {
        this.displayRawValues = b;
    }

    public void addName(int i2, String name, String fieldName, int display) {
        String desc = null;
        this.addName(i2, name, fieldName, desc, display);
    }

    public void addName(int i2, String name, String fieldName, String desc, int display) {
        this.label[i2].setText(name);
        if (desc != null) {
            this.row[i2].setToolTipText(String.valueOf(desc) + " | click for graph | right-click for EarthPlot");
        }
        this.label[i2].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
        this.fieldName[i2] = fieldName;
        this.display[i2] = display;
        int w = this.SINGLE_VAL_WIDTH;
        if (display == 0) {
            w = this.SINGLE_VAL_WIDTH;
        } else if (display == 1 || display == 2 || display == 15) {
            w = 0;
        } else if (display == 9 || display == 23) {
            w = this.MEASUREMENT_WIDTH;
        } else if (display == 3 || display == 4) {
            w = this.VAL_WIDTH;
        } else if (display >= 5 && display < 22) {
            w = this.VULCAN_WIDTH;
        } else if (display == 20 || display == 21 || display == 22) {
            w = this.HERCI_MICRO_PKT_NAME_WIDTH;
            this.label[i2].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i2].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i2].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            w = this.HERCI_MICRO_PKT_VALUE_WIDTH;
        }
        this.rtValue[i2].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
        this.rtValue[i2].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
        this.rtValue[i2].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        if (display < 5 && this.minValue != null && this.maxValue != null) {
            w = 0;
            if (display == 2 || display == 15) {
                w = this.SINGLE_VAL_WIDTH;
            } else if (display == 1) {
                w = 0;
            } else if (display == 3 || display == 4) {
                w = this.VAL_WIDTH;
            }
            this.minValue[i2].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.minValue[i2].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.minValue[i2].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            w = 0;
            if (display == 1 || display == 15) {
                w = this.SINGLE_VAL_WIDTH;
            } else if (display == 2) {
                w = 0;
            } else if (display == 3 || display == 4) {
                w = this.VAL_WIDTH;
            }
            this.maxValue[i2].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.maxValue[i2].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.maxValue[i2].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        }
    }

    public void updateValues(DataRecord rt) throws NumberFormatException, IOException, DataLoadException {
        this.rtPayload = rt;
        int i2 = 0;
        while (i2 < this.size) {
            if (this.fieldName[i2] != null) {
                this.rtValue[i2].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
                if (rt.hasFieldName(this.fieldName[i2])) {
                    if (this.displayRawValues) {
                        this.rtValue[i2].setText(Integer.toString(rt.getRawValue(this.fieldName[i2])));
                    } else {
                        this.rtValue[i2].setText(rt.getStringValue(this.fieldName[i2]));
                    }
                    int p = 0;
                    while (p < 3) {
                        if (this.graph[p][i2] != null) {
                            this.graph[p][i2].updateGraphData("DisplayModule.updateRtValues");
                        }
                        ++p;
                    }
                }
            }
            ++i2;
        }
    }

    public void updateSingleValue(int line, String value) throws NumberFormatException, IOException, DataLoadException {
        this.rtValue[line].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
        this.rtValue[line].setText(value);
        int p = 0;
        while (p < 3) {
            if (this.graph[p][line] != null) {
                this.graph[p][line].updateGraphData("DisplayModule.updateSingleValue");
            }
            ++p;
        }
    }

    private void initGui() {
        JLabel rtTitle;
        this.setLayout(new BoxLayout(this, 1));
        int i2 = 0;
        while (i2 < this.size) {
            JPanel r = new JPanel();
            r.setLayout(new BorderLayout());
            this.row[i2] = new JPanel();
            this.row[i2].setLayout(new BoxLayout(this.row[i2], 0));
            r.add((Component)this.row[i2], "Center");
            this.add(r);
            this.row[i2].addMouseListener(this);
            this.row[i2].setBackground(Color.lightGray);
            ++i2;
        }
        int w = this.NAME_WIDTH;
        if (this.moduleType == 9 || this.moduleType == 23) {
            w = this.MEASUREMENT_NAME_WIDTH;
        } else if (this.moduleType >= 5 && this.moduleType < 22) {
            w = this.VULCAN_NAME_WIDTH;
        } else if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            w = this.HERCI_MICRO_PKT_NAME_WIDTH;
        }
        int i3 = 0;
        while (i3 < this.size) {
            this.label[i3] = new JLabel();
            this.label[i3].setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i3].setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            this.label[i3].setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            this.row[i3].add(this.label[i3]);
            ++i3;
        }
        w = this.VAL_WIDTH;
        if (this.moduleType == 9 || this.moduleType == 23) {
            w = this.MEASUREMENT_WIDTH;
        } else if (this.moduleType >= 5 && this.moduleType < 22) {
            w = this.VULCAN_WIDTH;
        } else if (this.moduleType == 20 || this.moduleType == 21 || this.moduleType == 22) {
            w = this.HERCI_MICRO_PKT_VALUE_WIDTH;
        }
        if (this.moduleType < 5) {
            rtTitle = new JLabel("  RT");
            rtTitle.setToolTipText("The most current realtime value of the telemetry is in this column");
        } else {
            rtTitle = new JLabel("Last");
            rtTitle.setToolTipText("The most current value of the telemetry is in this column");
        }
        rtTitle.setFont(new Font("SansSerif", 1, this.displayModuleFontSize));
        rtTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
        rtTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
        rtTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
        this.row[0].add(rtTitle);
        int i4 = 1;
        while (i4 < this.size) {
            this.rtValue[i4] = new JLabel(this.noValue);
            this.rtValue[i4].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
            this.row[i4].add(this.rtValue[i4]);
            ++i4;
        }
        if (this.moduleType == 9) {
            i4 = 1;
            while (i4 < this.size) {
                this.minValue[i4] = this.createIconButton("/images/skyPlot.png", "Sky", "Plot sky chart");
                this.minValue[i4].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
                this.row[i4].add(this.minValue[i4]);
                ++i4;
            }
        }
        if (this.moduleType == 23) {
            i4 = 1;
            while (i4 < this.size) {
                this.minValue[i4] = new JButton();
                ((JButton)this.minValue[i4]).addActionListener(this);
                ((JButton)this.minValue[i4]).setBackground(wodFontColor);
                this.row[i4].add(this.minValue[i4]);
                ++i4;
            }
        }
        if (this.moduleType < 5) {
            JLabel minTitle = new JLabel("MIN");
            minTitle.setToolTipText("The minimum realtime value since the min telemetry was reset is in this column");
            minTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            minTitle.setFont(new Font("SansSerif", 1, this.displayModuleFontSize));
            this.row[0].add(minTitle);
            int i5 = 1;
            while (i5 < this.size) {
                this.minValue[i5] = new JLabel(this.noValue);
                this.minValue[i5].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
                this.row[i5].add(this.minValue[i5]);
                ++i5;
            }
            JLabel maxTitle = new JLabel("MAX");
            maxTitle.setToolTipText("The maximum realtime value since the max telemetry was reset is in this column");
            maxTitle.setFont(new Font("SansSerif", 1, this.displayModuleFontSize));
            maxTitle.setMinimumSize(new Dimension(w, this.ROW_HEIGHT));
            maxTitle.setMaximumSize(new Dimension(w, this.ROW_HEIGHT));
            maxTitle.setPreferredSize(new Dimension(w, this.ROW_HEIGHT));
            this.row[0].add(maxTitle);
            int i6 = 1;
            while (i6 < this.size) {
                this.maxValue[i6] = new JLabel(this.noValue);
                this.maxValue[i6].setFont(new Font("SansSerif", 0, this.displayModuleFontSize));
                this.row[i6].add(this.maxValue[i6]);
                ++i6;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i2 = 1;
        while (i2 < this.size) {
            if (!this.rtValue[i2].getText().equalsIgnoreCase(this.noValue)) {
                if (this.moduleType == 9 && e.getSource() == this.minValue[i2]) {
                    this.displayGraph(i2, 1);
                } else if (this.moduleType == 23 && e.getSource() == this.minValue[i2]) {
                    this.displayGraph(i2, 2);
                }
            }
            ++i2;
        }
    }

    public void displayGraph(int i2, int plotType) {
        try {
            this.graph[plotType][i2] = new GraphFrame(String.valueOf(this.title) + " - " + this.label[i2].getText(), this.sat, this.fieldName[i2], this.layout, plotType, this.db);
            this.graph[plotType][i2].setVisible(true);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataLoadException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i2 = 1;
        while (i2 < this.size) {
            if (e.getSource() == this.row[i2] && !this.rtValue[i2].getText().equalsIgnoreCase(this.noValue)) {
                if (e.isControlDown() || e.getButton() == 3) {
                    this.displayGraph(i2, 2);
                } else {
                    this.displayGraph(i2, 0);
                }
            }
            ++i2;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int i2 = 1;
        while (i2 < this.size) {
            if (e.getSource() == this.row[i2]) {
                this.row[i2].setBackground(Color.BLUE);
                if (this.label[i2] != null) {
                    this.label[i2].setForeground(Color.WHITE);
                }
                if (this.rtValue[i2] != null) {
                    this.rtValue[i2].setForeground(Color.WHITE);
                }
                if (this.maxValue != null && this.maxValue[i2] != null) {
                    this.maxValue[i2].setForeground(Color.WHITE);
                }
                if (this.minValue != null && this.minValue[i2] != null) {
                    this.minValue[i2].setForeground(Color.WHITE);
                }
            }
            ++i2;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int i2 = 0;
        while (i2 < this.size) {
            if (e.getSource() == this.row[i2]) {
                this.row[i2].setBackground(Color.lightGray);
                if (this.label[i2] != null) {
                    this.label[i2].setForeground(Color.BLACK);
                }
                if (this.rtValue[i2] != null) {
                    this.rtValue[i2].setForeground(Color.BLACK);
                }
                if (this.maxValue != null && this.maxValue[i2] != null) {
                    this.maxValue[i2].setForeground(Color.BLACK);
                }
                if (this.minValue != null && this.minValue[i2] != null) {
                    this.minValue[i2].setForeground(Color.BLACK);
                }
                this.repaint();
            }
            ++i2;
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void closeGraphs() {
        int p = 0;
        while (p < 3) {
            int i2 = 0;
            while (i2 < this.graph[p].length) {
                if (this.graph[p][i2] != null) {
                    if (this.graph[p][i2].isVisible()) {
                        this.graph[p][i2].saveProperties(true);
                    }
                    this.graph[p][i2].dispose();
                }
                ++i2;
            }
            ++p;
        }
    }

    public void showGraphs() {
        int p = 0;
        while (p < 3) {
            int i2 = 0;
            while (i2 < this.graph[p].length) {
                if (this.graph[p][i2] != null && this.graph[p][i2].isVisible()) {
                    this.graph[p][i2].toFront();
                }
                ++i2;
            }
            ++p;
        }
    }

    public void openGraphs(int payloadType) {
        int i2 = 0;
        while (i2 < this.fieldName.length) {
            this.openPlot(i2, 0, payloadType);
            this.openPlot(i2, 1, payloadType);
            this.openPlot(i2, 2, payloadType);
            ++i2;
        }
    }

    private void openPlot(int i2, int plotType, int payloadType) {
        this.displayGraph(i2, plotType);
    }

    private void setDefaultSizes() {
    }

    public JButton createIconButton(String icon, String name, String toolTip) {
        JButton btn;
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource(icon));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (wPic != null) {
            btn = new JButton(new ImageIcon(wPic));
            btn.setMargin(new Insets(0, 0, 0, 0));
        } else {
            btn = new JButton(name);
        }
        btn.setToolTipText(toolTip);
        btn.addActionListener(this);
        return btn;
    }
}

