/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.gui.GraphCanvas;
import com.g0kla.telem.gui.GraphFrame;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;

public class EarthPlotPanel
extends GraphCanvas {
    public static final double MAX_LATITUDE = 81.0;
    public static final double MIN_LATITUDE = 85.0;
    public static final int RECTANGULAR_PROJECTION = 0;
    public static final int MERCATOR_PROJECTION = 1;
    public int mapProjection = 0;
    int maxVertBoxes = 90;
    int maxHorBoxes = 180;

    EarthPlotPanel(String t, Spacecraft sat, ByteArrayLayout layout, GraphFrame gf, SatTelemStore db) {
        super(t, sat, layout, gf, db);
        this.sideBorder += 20;
        this.sideLabelOffset += 30;
        this.getPostionData = true;
        this.updateGraphData("EarthPlotPanel.new");
    }

    private void setImage() throws IOException {
        try {
            if (this.graphFrame.mapType == 3) {
                this.mapProjection = 0;
                this.image = ImageIO.read(this.getClass().getResource("/images/Equirectangular_projection_SW.jpg"));
            } else if (this.graphFrame.mapType == 2) {
                this.mapProjection = 0;
                this.image = ImageIO.read(this.getClass().getResource("/images/map_outline.jpg"));
            }
        }
        catch (IOException e) {
            throw new IOException("Could not set map image: \n" + e.getMessage());
        }
    }

    private void drawLegend(int graphHeight, int graphWidth, double minValue, double maxValue, String units) {
        int verticalOffset = 60;
        int leftOffset = 15;
        int legendHeight = graphHeight - verticalOffset * 2;
        int font = 9 * graphAxisFontSize / 11;
        int fonth = 12 * font / 9;
        int legendWidth = font * 4;
        int numberOfLabels = legendHeight / labelHeight;
        double[] labels = EarthPlotPanel.calcAxisInterval(minValue, maxValue, numberOfLabels, false);
        if (labels.length > 0) {
            int rows = labels.length;
            int boxHeight = legendHeight / rows;
            legendHeight = boxHeight * rows;
            this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
            this.g2.drawString("Key", this.sideBorder + graphWidth + leftOffset + 5, verticalOffset - fonth * 2);
            this.g2.drawString("(" + units + ")", this.sideBorder + graphWidth + leftOffset + 5, verticalOffset - fonth);
            this.g.setFont(new Font("SansSerif", 0, font));
            int i2 = 0;
            while (i2 < rows) {
                int shade = EarthPlotPanel.getRatioPosition(minValue, maxValue, labels[i2], 255);
                this.g2.setColor(this.getColorGradient(minValue, maxValue, labels[i2], 255));
                this.g2.fillRect(this.sideBorder + graphWidth + leftOffset, verticalOffset + (rows - 1 - i2) * boxHeight, legendWidth, boxHeight);
                if (shade > 127) {
                    this.g2.setColor(Color.BLACK);
                } else {
                    this.g2.setColor(Color.WHITE);
                }
                this.g2.drawString("" + labels[i2], this.sideBorder + graphWidth + leftOffset + 5, verticalOffset + (rows - 1 - i2) * boxHeight + (int)((double)boxHeight * 0.8));
                ++i2;
            }
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        this.topBorder = 0;
        this.bottomBorder = 0;
        int graphHeight = this.getHeight() - this.topBorder - this.bottomBorder;
        int graphWidth = this.getWidth() - this.sideBorder * 2;
        if (!this.checkDataExists()) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("No Data Available for plot", graphWidth / 2 - 50, graphHeight / 3);
            return;
        }
        boolean noLatLonReadings = true;
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        double maxVert = 90.0;
        double minVert = -90.0;
        double maxHor = 180.0;
        double minHor = -180.0;
        int boxHeight = graphHeight / this.maxVertBoxes;
        graphHeight = boxHeight * this.maxVertBoxes;
        int boxWidth = 2 * boxHeight;
        graphWidth = 2 * graphHeight;
        if (this.graphFrame.mapType > 1) {
            try {
                this.setImage();
            }
            catch (IOException e) {
                System.err.println("ERROR: " + e.getMessage());
                e.printStackTrace();
            }
            this.paintMap(gr, this.sideBorder, 0, graphHeight, graphWidth);
        }
        double[][] dataGrid = new double[this.maxVertBoxes][this.maxHorBoxes];
        int[][] dataGridCount = new int[this.maxVertBoxes][this.maxHorBoxes];
        double vertStep = (maxVert - minVert) / (double)this.maxVertBoxes;
        double horStep = (maxHor - minHor) / (double)this.maxHorBoxes;
        int i2 = 1;
        while (i2 < this.graphData[0][2].length) {
            double lat = this.graphData[0][3][i2];
            if (lat != -999.0 && lat != -997.0 && lat != -998.0) {
                double value;
                double lon;
                noLatLonReadings = false;
                if (lat > maxVert) {
                    lat = maxVert;
                }
                if (lat < minVert) {
                    lat = minVert;
                }
                if ((lon = this.graphData[0][4][i2]) > maxHor) {
                    lon = maxHor;
                }
                if (lon < minHor) {
                    lon = minHor;
                }
                if (Double.isNaN(value = this.graphData[0][2][i2])) {
                    value = 0.0;
                }
                int vertBox = (int)Math.round((lat += 90.0) / vertStep);
                int horBox = (int)Math.round((lon += 180.0) / horStep);
                if (vertBox >= this.maxVertBoxes) {
                    vertBox = this.maxVertBoxes - 1;
                }
                if (horBox >= this.maxHorBoxes) {
                    horBox = this.maxHorBoxes - 1;
                }
                double[] dArray = dataGrid[vertBox];
                int n = horBox;
                dArray[n] = dArray[n] + value;
                int[] nArray = dataGridCount[vertBox];
                int n2 = horBox;
                nArray[n2] = nArray[n2] + 1;
            }
            ++i2;
        }
        double maxValue = -9.99999999E8;
        double minValue = 9.99999999E8;
        int h = 0;
        while (h < this.maxHorBoxes) {
            int v = 0;
            while (v < this.maxVertBoxes) {
                dataGrid[v][h] = dataGridCount[v][h] == 0 ? 0.0 : dataGrid[v][h] / (double)dataGridCount[v][h];
                if (dataGrid[v][h] != 0.0) {
                    if (dataGrid[v][h] > maxValue) {
                        maxValue = dataGrid[v][h];
                    }
                    if (dataGrid[v][h] < minValue) {
                        minValue = dataGrid[v][h];
                    }
                }
                ++v;
            }
            ++h;
        }
        this.drawLegend(graphHeight, graphWidth, minValue, maxValue, this.graphFrame.fieldUnits);
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        this.g2.setColor(this.graphAxisColor);
        this.g2.drawLine(this.sideBorder, this.getHeight() - this.bottomBorder, this.sideBorder, this.topBorder);
        int numberOfLabels = graphHeight / labelHeight;
        double[] labels = EarthPlotPanel.calcAxisInterval(minVert, maxVert, numberOfLabels, false);
        numberOfLabels = labels.length;
        this.g2.setColor(this.graphTextColor);
        int zeroPoint = this.getHeight() - this.topBorder - this.bottomBorder;
        DecimalFormat f2 = new DecimalFormat("0");
        int v = 1;
        while (v < numberOfLabels) {
            int pos = this.latToY(labels[v], graphWidth, graphHeight);
            pos = graphHeight - pos + this.topBorder;
            if (labels[v] == 0.0) {
                zeroPoint = pos + this.topBorder;
            }
            String s = f2.format(labels[v]);
            this.g2.drawString(s, this.sideLabelOffset, pos + graphAxisFontSize / 2);
            if (this.graphFrame.showHorizontalLines) {
                this.g2.setColor(Color.GRAY);
                this.g2.drawLine(this.sideBorder - 5, pos + this.topBorder, graphWidth + this.sideBorder, pos + this.topBorder);
                this.g2.setColor(this.graphTextColor);
            } else {
                this.g.drawLine(this.sideBorder - 5, pos + this.topBorder, this.sideBorder + 5, pos + this.topBorder);
            }
            ++v;
        }
        this.g2.setColor(this.graphAxisColor);
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        int titleHeight = graphAxisFontSize + 10;
        if (zeroPoint < graphAxisFontSize * 3) {
            titleHeight = graphHeight + this.topBorder;
        }
        this.g2.setColor(Color.BLACK);
        this.g.setFont(new Font("SansSerif", 1, graphAxisFontSize + 3));
        String title = String.valueOf(this.graphFrame.displayTitle) + " (Equirectangular Projection)";
        this.g2.drawString(title, this.sideBorder / 2 + graphWidth / 2 - this.graphFrame.displayTitle.length() / 2 * graphAxisFontSize / 2, titleHeight - graphAxisFontSize / 2);
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        this.g2.setColor(this.graphAxisColor);
        this.g2.drawLine(this.sideLabelOffset + this.sideBorder, zeroPoint, graphWidth + this.sideBorder, zeroPoint);
        this.g2.setColor(this.graphTextColor);
        int offset = 0;
        int numberOfTimeLabels = graphWidth / (labelWidth / 2);
        double[] timelabels = EarthPlotPanel.calcAxisInterval(minHor, maxHor, numberOfTimeLabels, true);
        numberOfTimeLabels = timelabels.length;
        int h2 = 0;
        while (h2 < numberOfTimeLabels) {
            int timepos = EarthPlotPanel.getRatioPosition(minHor, maxHor, timelabels[h2], graphWidth);
            this.g2.setColor(this.graphTextColor);
            this.g2.drawString("" + (long)timelabels[h2], timepos + this.sideBorder + 2, zeroPoint + 1 * graphAxisFontSize + offset);
            if (this.graphFrame.showVerticalLines) {
                this.g2.setColor(Color.GRAY);
                this.g.drawLine(timepos + this.sideBorder, graphHeight + this.topBorder + 5, timepos + this.sideBorder, this.topBorder);
            }
            ++h2;
        }
        if (noLatLonReadings) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("No Latitude and Longitude Data Available for plot", graphWidth / 2 - 50, graphHeight / 3);
            return;
        }
        int v2 = 0;
        while (v2 < this.maxVertBoxes) {
            int h3 = 0;
            while (h3 < this.maxHorBoxes) {
                double lat = 180.0 * (double)v2 / (double)this.maxVertBoxes - 90.0;
                double lon = 360.0 * (double)h3 / (double)this.maxHorBoxes;
                int x = this.lonToX(lon, graphWidth) + this.sideBorder + 1;
                int y = this.latToY(lat, graphWidth, graphHeight);
                double val = dataGrid[v2][h3];
                if (val != 0.0) {
                    this.g2.setColor(this.getColorGradient(minValue, maxValue, val, 255));
                    this.g2.fillRect(x, graphHeight - y + this.topBorder - boxHeight, boxWidth, boxHeight);
                }
                ++h3;
            }
            ++v2;
        }
    }

    private Color getColorGradient(double minValue, double maxValue, double val, int range) {
        int alpha = 160;
        int shade = EarthPlotPanel.getRatioPosition(minValue, maxValue, val, 255);
        if (shade > 255) {
            shade = 255;
        }
        if (shade < 0) {
            shade = 0;
        }
        shade = 255 - shade;
        return new Color(255 - shade, 0, shade, alpha);
    }

    int lonToX(double lon, int mapWidth) {
        return this.mercatorLonToX(lon, mapWidth);
    }

    int latToY(double lat, int mapWidth, int mapHeight) {
        if (this.mapProjection == 0) {
            return this.rectangularLatToY(lat, mapWidth, mapHeight);
        }
        return this.mercatorLatToY(lat, mapWidth, mapHeight);
    }

    int rectangularLatToY(double lat, int mapWidth, int mapHeight) {
        int y = (int)(lat * (double)mapHeight / 180.0);
        return mapHeight / 2 + y;
    }

    int mercatorLonToX(double lon, int mapWidth) {
        int x = 0;
        x = (int)(lon * (double)mapWidth / 360.0);
        return x;
    }

    int mercatorLatToY(double lat, int mapWidth, int mapHeight) {
        double latRad = lat * (Math.PI / 180);
        double mercN = Math.log(Math.tan(0.7853981633974483 + latRad / 2.0));
        int y = (int)((double)mapWidth / (Math.PI * 2) * mercN);
        return mapHeight / 2 + y;
    }
}

