/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.gui.GraphFrame;
import com.g0kla.telem.gui.MapPanel;
import com.g0kla.telem.gui.ProgressPanel;
import com.g0kla.telem.predict.PositionCalcException;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.text.DecimalFormat;
import uk.me.g4dpz.satellite.SatPos;

public abstract class GraphCanvas
extends MapPanel {
    double[][][] graphData = null;
    double[][][] graphData2 = null;
    String title = "Test Graph";
    GraphFrame graphFrame;
    boolean drawGraph2 = false;
    Color graphAxisColor = Color.BLACK;
    Color graphTextColor = Color.DARK_GRAY;
    static int graphAxisFontSize = 11;
    int topBorder = graphAxisFontSize * 2;
    int bottomBorder = (int)((double)graphAxisFontSize * 2.5);
    int sideBorder = graphAxisFontSize * 5;
    int sideLabelOffset = (int)((double)graphAxisFontSize * 0.5);
    static int labelWidth = 6 * graphAxisFontSize;
    static int labelHeight = (int)((double)graphAxisFontSize * 1.4);
    protected static int MAX_TICKS = 4096 / labelWidth;
    int freqOffset = 0;
    Graphics2D g2;
    Graphics g;
    SatTelemStore db;
    int satId;
    Spacecraft sat;
    ByteArrayLayout layout;
    boolean getPostionData = false;

    GraphCanvas(String title, Spacecraft sat, ByteArrayLayout layout, GraphFrame gf, SatTelemStore db) {
        this.title = title;
        this.graphFrame = gf;
        this.db = db;
        this.sat = sat;
        this.satId = sat.satId;
        this.layout = layout;
    }

    public void updateGraphData(String by) {
        int showDialogThreshold = 999999;
        ProgressPanel fileProgress = null;
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress = new ProgressPanel(this.graphFrame, "Loading Spacecraft data, please wait ...", false);
            fileProgress.setVisible(true);
        }
        int totalFields = this.graphFrame.fieldName.length;
        if (this.graphFrame.fieldName2 != null) {
            totalFields += this.graphFrame.fieldName2.length;
        }
        boolean reverse = false;
        this.graphData = new double[this.graphFrame.fieldName.length][][];
        int i2 = 0;
        while (i2 < this.graphFrame.fieldName.length) {
            if (this.graphFrame.SAMPLES > showDialogThreshold) {
                fileProgress.updateProgress(100 * i2 / totalFields);
            }
            if (this.graphFrame.showLatest == 0) {
                reverse = true;
            }
            try {
                this.graphData[i2] = this.db.getGraphData(this.graphFrame.fieldName[i2], this.graphFrame.SAMPLES, this.satId, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.layout.name, false, this.getPostionData, reverse);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DataLoadException e) {
                e.printStackTrace();
            }
            if (this.graphFrame.plotType == 2) {
                this.graphData[i2] = this.addPositionData(this.graphData[i2]);
            }
            ++i2;
        }
        this.graphData2 = null;
        if (this.graphFrame.fieldName2 != null && this.graphFrame.fieldName2.length > 0) {
            this.graphData2 = new double[this.graphFrame.fieldName2.length][][];
            i2 = 0;
            while (i2 < this.graphFrame.fieldName2.length) {
                if (this.graphFrame.SAMPLES > showDialogThreshold) {
                    fileProgress.updateProgress(100 * i2 + this.graphFrame.fieldName.length / totalFields);
                }
                try {
                    this.graphData2[i2] = this.db.getGraphData(this.graphFrame.fieldName2[i2], this.graphFrame.SAMPLES, this.satId, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.layout.name, false, false, reverse);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (DataLoadException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress.updateProgress(100);
        }
        if (this.graphData != null && this.graphData[0] != null) {
            this.repaint();
        }
    }

    private double[][] addPositionData(double[][] coreGraphData) {
        int showDialogThreshold = 9999;
        ProgressPanel fileProgress = null;
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress = new ProgressPanel(this.graphFrame, "Calculating Spacecraft positions, please wait ...", false);
            fileProgress.setVisible(true);
        }
        double[][] newGraphData = new double[][]{coreGraphData[0], coreGraphData[1], coreGraphData[2], new double[coreGraphData[0].length], new double[coreGraphData[0].length]};
        int i2 = 0;
        while (i2 < coreGraphData[0].length) {
            if (this.graphFrame.SAMPLES > showDialogThreshold) {
                fileProgress.updateProgress(100 * i2 / coreGraphData[0].length);
            }
            SatPos pos = null;
            double satLatitude = -998.0;
            double satLongitude = -998.0;
            try {
                pos = this.sat.getSatellitePosition((int)newGraphData[0][i2], (long)newGraphData[1][i2]);
                if (pos != null) {
                    satLatitude = Spacecraft.latRadToDeg(pos.getLatitude());
                    satLongitude = Spacecraft.lonRadToDeg(pos.getLongitude());
                }
            }
            catch (PositionCalcException e) {
                double cfr_ignored_0 = e.errorCode;
            }
            newGraphData[3][i2] = satLatitude;
            newGraphData[4][i2] = satLongitude;
            ++i2;
        }
        if (this.graphFrame.SAMPLES > showDialogThreshold) {
            fileProgress.updateProgress(100);
        }
        return newGraphData;
    }

    public boolean checkDataExists() {
        if (this.graphData == null) {
            return false;
        }
        if (this.graphData[0] == null) {
            return false;
        }
        if (this.graphData[0][0] == null) {
            return false;
        }
        if (this.graphData[0][0].length == 0) {
            return false;
        }
        if (this.graphData[0][0] == null) {
            return false;
        }
        if (this.graphData[0][1] == null) {
            return false;
        }
        this.drawGraph2 = true;
        if (this.graphData2 == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0] == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0][0] == null) {
            this.drawGraph2 = false;
        } else if (this.graphData2[0][0].length == 0) {
            this.drawGraph2 = false;
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        this.bottomBorder = this.graphFrame.showUTCtime && !this.graphFrame.hideUptime ? (int)((double)graphAxisFontSize * 3.5) : (int)((double)graphAxisFontSize * 2.5);
        this.g2 = (Graphics2D)gr;
        this.g = gr;
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
    }

    protected double[] plotVerticalAxis(int axisPosition, int graphHeight, int graphWidth, double[][][] graphData, boolean showHorizontalLines, String units) {
        this.g2.drawLine(this.sideBorder + axisPosition, this.getHeight() - this.bottomBorder, this.sideBorder + axisPosition, this.topBorder);
        double maxValue = 0.0;
        double minValue = 9.9E100;
        int j = 0;
        while (j < graphData.length) {
            int i2 = 0;
            while (i2 < graphData[j][0].length) {
                if (graphData[j][2][i2] >= maxValue) {
                    maxValue = graphData[j][2][i2];
                }
                if (graphData[j][2][i2] <= minValue) {
                    minValue = graphData[j][2][i2];
                }
                ++i2;
            }
            ++j;
        }
        if (this.graphFrame.plotDerivative) {
            if (minValue > 0.0) {
                minValue = maxValue * -0.1;
            }
            if (maxValue < 0.0) {
                maxValue = minValue * -0.1;
            }
        }
        maxValue = maxValue < 0.0 ? (maxValue -= maxValue * 0.2) : (maxValue += maxValue * 0.2);
        minValue = minValue < 0.0 ? (minValue += minValue * 0.2) : (minValue -= minValue * 0.2);
        int numberOfLabels = graphHeight / labelHeight;
        boolean intStep = false;
        double[] labels = GraphCanvas.calcAxisInterval(minValue, maxValue, numberOfLabels, intStep);
        numberOfLabels = labels.length;
        boolean foundZeroPoint = false;
        int zeroPoint = graphHeight + this.topBorder;
        DecimalFormat f1 = new DecimalFormat("0.0");
        DecimalFormat f2 = new DecimalFormat("0");
        int fudge = 0;
        if (axisPosition > 0) {
            fudge = this.sideBorder + graphAxisFontSize;
        }
        this.g2.setColor(this.graphTextColor);
        this.g2.drawString("(" + units + ")", fudge + axisPosition + this.sideLabelOffset, this.topBorder - graphAxisFontSize / 2);
        int v = 0;
        while (v < numberOfLabels) {
            int pos = GraphCanvas.getRatioPosition(minValue, maxValue, labels[v], graphHeight);
            pos = graphHeight - pos;
            String s = null;
            s = labels[v] == (double)Math.round(labels[v]) ? f2.format(labels[v]) : f1.format(labels[v]);
            boolean drawLabel = true;
            if (!(v >= numberOfLabels || axisPosition == 0 && (labels[v] == 0.0 || v < numberOfLabels - 1 && labels[v + 1] == 0.0) || v == 0 && pos > graphHeight || !drawLabel || pos <= 0 || pos >= graphHeight - graphAxisFontSize / 2)) {
                this.g2.setColor(this.graphTextColor);
                this.g2.drawString(s, fudge + axisPosition + this.sideLabelOffset, pos + this.topBorder + graphAxisFontSize / 2);
                this.g2.setColor(this.graphAxisColor);
                if (showHorizontalLines) {
                    this.g2.setColor(Color.GRAY);
                    this.g2.drawLine(this.sideBorder - 5, pos + this.topBorder, graphWidth + this.sideBorder, pos + this.topBorder);
                    this.g2.setColor(this.graphTextColor);
                } else {
                    this.g.drawLine(this.sideBorder + axisPosition - 5, pos + this.topBorder, this.sideBorder + axisPosition + 5, pos + this.topBorder);
                }
            }
            if (!foundZeroPoint && labels[v] >= 0.0) {
                foundZeroPoint = true;
                zeroPoint = v == 0 ? graphHeight + this.topBorder : pos + this.topBorder;
            }
            ++v;
        }
        double[] axisPoint = new double[]{zeroPoint, minValue, maxValue};
        return axisPoint;
    }

    public static double[] calcAxisInterval(double min, double max, int ticks, boolean intStep) {
        double range = max - min;
        if (ticks == 0) {
            ticks = 1;
        }
        double step = 0.0;
        step = GraphCanvas.getStep(range, ticks, intStep);
        ticks = (int)Math.ceil(range / step);
        double startValue = GraphCanvas.roundToSignificantFigures((double)Math.round(min / step) * step, 12);
        if (ticks > MAX_TICKS) {
            ticks = MAX_TICKS;
            step = GraphCanvas.getStep(range, ticks, intStep);
        }
        if (ticks < 0) {
            ticks = 1;
            step = GraphCanvas.getStep(range, ticks, intStep);
        }
        double[] tickList = new double[ticks];
        if (ticks == 1) {
            tickList[0] = startValue;
        } else if (ticks == 2) {
            double midValue = GraphCanvas.roundToSignificantFigures(startValue + step, 12);
            tickList[0] = startValue;
            tickList[1] = midValue;
        } else if (ticks > 0) {
            tickList[0] = startValue;
        }
        int i2 = 1;
        while (i2 < ticks) {
            tickList[i2] = startValue = GraphCanvas.roundToSignificantFigures(startValue + step, 12);
            ++i2;
        }
        return tickList;
    }

    private static double getStep(double range, int ticks, boolean intStep) {
        double step = 0.0;
        if (!intStep && range / (double)ticks <= 0.01) {
            step = 0.01;
        } else if (!intStep && range / (double)ticks <= 0.1) {
            step = 0.1;
        } else if (!intStep && range / (double)ticks <= 0.2) {
            step = 0.2;
        } else if (!intStep && range / (double)ticks <= 0.25) {
            step = 0.25;
        } else if (!intStep && range / (double)ticks <= 0.33) {
            step = 0.33;
        } else if (!intStep && range / (double)ticks <= 0.5) {
            step = 0.5;
        } else if (range / (double)ticks <= 1.0) {
            step = 1.0;
        } else if (range / (double)ticks <= 2.0) {
            step = 2.0;
        } else if (!intStep && range / (double)ticks <= 2.5) {
            step = 2.5;
        } else if (!intStep && range / (double)ticks <= 3.3) {
            step = 3.33;
        } else if (range / (double)ticks <= 5.0) {
            step = 5.0;
        } else if (range / (double)ticks <= 10.0) {
            step = 10.0;
        } else if (range / (double)ticks <= 25.0) {
            step = 25.0;
        } else if (!intStep && range / (double)ticks <= 33.0) {
            step = 33.33;
        } else if (range / (double)ticks <= 50.0) {
            step = 50.0;
        } else if (range / (double)ticks <= 100.0) {
            step = 100.0;
        } else if (range / (double)ticks <= 200.0) {
            step = 200.0;
        } else if (range / (double)ticks <= 250.0) {
            step = 250.0;
        } else if (!intStep && range / (double)ticks <= 333.0) {
            step = 333.33;
        } else if (range / (double)ticks <= 500.0) {
            step = 500.0;
        } else if (range / (double)ticks <= 1000.0) {
            step = 1000.0;
        } else if (range / (double)ticks <= 2000.0) {
            step = 2000.0;
        } else if (range / (double)ticks <= 2500.0) {
            step = 2500.0;
        } else if (!intStep && range / (double)ticks <= 3333.0) {
            step = 3333.33;
        } else if (range / (double)ticks <= 5000.0) {
            step = 5000.0;
        } else if (range / (double)ticks <= 10000.0) {
            step = 10000.0;
        } else if (range / (double)ticks <= 20000.0) {
            step = 20000.0;
        } else if (range / (double)ticks <= 25000.0) {
            step = 25000.0;
        } else if (!intStep && range / (double)ticks <= 33333.0) {
            step = 33333.33;
        } else if (range / (double)ticks <= 50000.0) {
            step = 50000.0;
        } else if (range / (double)ticks <= 100000.0) {
            step = 100000.0;
        } else if (range / (double)ticks <= 250000.0) {
            step = 250000.0;
        } else if (!intStep && range / (double)ticks <= 333333.0) {
            step = 333333.33;
        } else if (range / (double)ticks <= 500000.0) {
            step = 500000.0;
        } else if (range / (double)ticks <= 1000000.0) {
            step = 1000000.0;
        } else if (range / (double)ticks <= 2000000.0) {
            step = 2000000.0;
        } else if (range / (double)ticks <= 2500000.0) {
            step = 2500000.0;
        } else if (!intStep && range / (double)ticks <= 3333333.0) {
            step = 3333333.33;
        } else if (range / (double)ticks <= 5000000.0) {
            step = 5000000.0;
        } else if (range / (double)ticks <= 1.0E7) {
            step = 1.0E7;
        }
        return step;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static int getRatioPosition(double min, double max, double value, int dimension) {
        if (max == min) {
            return 0;
        }
        double ratio = (max - value) / (max - min);
        int position = (int)Math.round((double)dimension * ratio);
        return dimension - position;
    }
}

