/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.ConversionTable;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.EpochTime;
import com.g0kla.telem.gui.EarthPlotPanel;
import com.g0kla.telem.gui.GraphCanvas;
import com.g0kla.telem.gui.GraphPanel;
import com.g0kla.telem.gui.Tools;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class GraphFrame
extends JFrame
implements WindowListener,
ActionListener,
ItemListener,
FocusListener,
ComponentListener {
    int satId;
    public String[] fieldName;
    public String[] fieldName2;
    String fieldUnits = "";
    String fieldUnits2 = "";
    String displayTitle;
    String title;
    ByteArrayLayout layout;
    private int payloadType;
    int conversionType;
    int conversionType2;
    private JPanel contentPane;
    private GraphCanvas panel;
    private JPanel titlePanel;
    private JPanel footerPanel;
    private JButton btnDefault;
    private JButton btnVerticalLines;
    private JButton btnHorizontalLines;
    private JButton btnCSV;
    private JButton btnCopy;
    private JButton btnDerivative;
    private JButton btnMain;
    private JButton btnAvg;
    private JButton btnLines;
    private JButton btnPoints;
    private JButton btnLatest;
    private JButton btnMapType;
    private JButton cbUTC;
    private JButton cbUptime;
    private JCheckBox cbRoundLabels;
    private JCheckBox cbShowSun;
    private JComboBox cbAddVariable;
    private ArrayList<String> variables;
    public Spacecraft sat;
    public static final String LIVE_TEXT = "Live";
    public static final String RANGE_TEXT = "Range";
    public static final String NEXT_TEXT = "Next";
    public static String NOW = "now";
    public static String YESTERDAY = "yesterday";
    public static String LAUNCH = "launch";
    public String dateFormatsToolTip = "formats:YYYYMMDD HHMMSS, YYYY/MM/DD HH:MM:SS, dd MMM yy HH:mm:ss, now, yesterday, launch";
    public static int DEFAULT_SAMPLES = 180;
    public int SAMPLES = DEFAULT_SAMPLES;
    public static long DEFAULT_START_UPTIME = 0L;
    public static int DEFAULT_START_RESET = 0;
    public long START_UPTIME = DEFAULT_START_UPTIME;
    public int START_RESET = DEFAULT_START_RESET;
    public int END_RESET = DEFAULT_START_RESET;
    public long END_UPTIME = DEFAULT_START_UPTIME;
    public static String DEFAULT_START_UTC = NOW;
    public static String DEFAULT_END_UTC = NOW;
    public String START_UTC = DEFAULT_START_UTC;
    public String END_UTC = DEFAULT_END_UTC;
    public static final int MAX_SAMPLES = 999999;
    public static final int MAX_AVG_SAMPLES = 999;
    public static int DEFAULT_AVG_PERIOD = 12;
    public int AVG_PERIOD = DEFAULT_AVG_PERIOD;
    public Date fromUtcDate;
    public Date toUtcDate;
    public static final int DEFAULT_UPTIME_THRESHOLD = 3600;
    public static final int CONTINUOUS_UPTIME_THRESHOLD = -1;
    public double UPTIME_THRESHOLD = 3600.0;
    private JButton chckbxPlotAllUptime;
    private JLabel lblFromUptime;
    private JTextField textFromUptime;
    JLabel lblSamplePeriod;
    private JTextField txtSamplePeriod;
    private JLabel lblAvg;
    JLabel lblAvgPeriod;
    private JTextField txtAvgPeriod;
    private JLabel lblFromReset;
    private JTextField textFromReset;
    private JLabel lblToReset;
    private JLabel lblToUptime;
    private JTextField textToReset;
    private JTextField textToUptime;
    JLabel lblFromUTC;
    JLabel lblToUTC;
    public static final String FROM_RESET = "From Reset";
    public static final String BEFORE_RESET = " before Reset";
    public static final String FROM_UTC = "From UTC";
    public static final String BEFORE_UTC = " before UTC";
    private JTextField textFromUtc;
    private JTextField textToUtc;
    JPanel footerPanel2uptime = new JPanel();
    JPanel footerPanel2utc = new JPanel();
    JButton btnAdd;
    public boolean plotDerivative = false;
    public boolean dspAvg = false;
    public boolean showVerticalLines = false;
    public boolean showHorizontalLines = false;
    public boolean hideMain = false;
    public boolean showUTCtime = true;
    public boolean hideUptime = true;
    public boolean roundLabels = false;
    public boolean showSun = false;
    public boolean hidePoints = false;
    public boolean hideLines = false;
    public boolean showContinuous = false;
    public int showLatest = 0;
    public static final int SHOW_LIVE = 0;
    public static final int SHOW_RANGE = 2;
    public static final int SHOW_NEXT = 1;
    public boolean add = false;
    public static final int GRAPH_PLOT = 0;
    public static final int SKY_PLOT = 1;
    public static final int EARTH_PLOT = 2;
    public static final int SAVED_PLOT = 99;
    public static final int MAX_PLOT_TYPES = 3;
    public int plotType = 99;
    public static final int NO_MAP_EQUIRECTANGULAR = 1;
    public static final int LINE_MAP_EQUIRECTANGULAR = 2;
    public static final int COLOR_MAP_EQUIRECTANGULAR = 3;
    public int mapType = 2;
    boolean textDisplay = false;
    ConversionTable ct;
    SatTelemStore db;
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
    public static final DateFormat dateFormat2 = new SimpleDateFormat("yyyyMMdd HHmmss", Locale.ENGLISH);
    public static final DateFormat dateFormat3 = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);

    public GraphFrame(String title, Spacecraft sat, String fieldName, ByteArrayLayout layout, int plot, SatTelemStore db) throws NumberFormatException, IOException, DataLoadException {
        this.satId = sat.satId;
        this.sat = sat;
        this.db = db;
        this.fieldName = new String[1];
        this.fieldName[0] = fieldName;
        this.ct = layout.getConversionTable();
        this.fieldUnits = layout.getUnitsByName(fieldName);
        this.title = title;
        this.conversionType = this.conversionType;
        this.layout = layout;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.addComponentListener(this);
        if (plot != 99) {
            this.plotType = plot;
        }
        this.loadProperties();
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.titlePanel = new JPanel();
        this.contentPane.add((Component)this.titlePanel, "North");
        this.titlePanel.setLayout(new BorderLayout(0, 0));
        JPanel titlePanelRight = new JPanel();
        JPanel titlePanelcenter = new JPanel();
        JPanel titlePanelLeft = new JPanel();
        this.titlePanel.add((Component)titlePanelRight, "East");
        this.titlePanel.add((Component)titlePanelcenter, "Center");
        this.titlePanel.add((Component)titlePanelLeft, "West");
        this.calcTitle();
        if (this.plotType == 1) {
            this.initSkyPlotFields();
        } else if (this.plotType == 2) {
            this.panel = new EarthPlotPanel(title, sat, layout, this, db);
            this.contentPane.add((Component)this.panel, "Center");
        } else {
            this.panel = new GraphPanel(title, sat, layout, this, db);
            this.contentPane.add((Component)this.panel, "Center");
        }
        if (!this.textDisplay && this.plotType != 1 && this.plotType != 2) {
            this.btnAdd = new JButton("+ ");
            titlePanelLeft.add(this.btnAdd);
            this.btnAdd.addActionListener(this);
            this.btnAdd.setToolTipText("Add another trace to this graph");
            this.cbAddVariable = new JComboBox();
            this.initVarlist();
            titlePanelLeft.add(this.cbAddVariable);
            this.cbAddVariable.addActionListener(this);
            this.cbAddVariable.setVisible(this.add);
        }
        this.cbUTC = new JButton("UTC");
        this.cbUTC.setMargin(new Insets(0, 0, 0, 0));
        this.cbUTC.addActionListener(this);
        this.cbUTC.setToolTipText("Toggle between UTC time and spacecraft reset/uptime");
        titlePanelRight.add(this.cbUTC);
        if (this.plotType != 1 && this.plotType != 2) {
            this.cbUptime = new JButton("Uptime");
            this.cbUptime.setMargin(new Insets(0, 0, 0, 0));
            this.cbUptime.setToolTipText("Toggle display of uptime on the horizontal axis");
            this.cbUptime.addActionListener(this);
            titlePanelRight.add(this.cbUptime);
        }
        if (this.plotType != 1 && !this.textDisplay && this.plotType != 2) {
            this.chckbxPlotAllUptime = new JButton("Continuous");
            this.chckbxPlotAllUptime.setMargin(new Insets(0, 0, 0, 0));
            titlePanelRight.add(this.chckbxPlotAllUptime);
            this.chckbxPlotAllUptime.addActionListener(this);
            this.chckbxPlotAllUptime.setToolTipText("Show all uptime values, even if there is no data to plot");
        }
        this.btnLines = new JButton("Lines");
        this.btnLines.setMargin(new Insets(0, 0, 0, 0));
        this.btnLines.setToolTipText("Draw lines between data points");
        this.btnLines.addActionListener(this);
        titlePanelRight.add(this.btnLines);
        if (this.textDisplay || this.plotType == 1 || this.plotType == 2) {
            this.btnLines.setVisible(false);
        }
        this.btnPoints = new JButton("Points");
        this.btnPoints.setMargin(new Insets(0, 0, 0, 0));
        this.btnPoints.setToolTipText("Show data points");
        this.btnPoints.addActionListener(this);
        titlePanelRight.add(this.btnPoints);
        if (this.textDisplay || this.plotType == 1 || this.plotType == 2) {
            this.btnPoints.setVisible(false);
        }
        this.btnMapType = this.createIconButton("/images/mapButton.jpg", "Map Type", "Toggle background map type and projection");
        titlePanelRight.add(this.btnMapType);
        if (this.plotType != 2) {
            this.btnMapType.setVisible(false);
        }
        this.btnHorizontalLines = this.createIconButton("/images/horizontalLines.png", "Horizontal", "Show Horizontal Lines");
        titlePanelRight.add(this.btnHorizontalLines);
        if (this.textDisplay || this.plotType == 1) {
            this.btnHorizontalLines.setVisible(false);
        }
        this.btnVerticalLines = this.createIconButton("/images/verticalLines.png", "Verrtical", "Show Vertical Lines");
        titlePanelRight.add(this.btnVerticalLines);
        if (this.textDisplay || this.plotType == 1) {
            this.btnVerticalLines.setVisible(false);
        }
        this.btnMain = new JButton("Hide");
        this.btnMain.setMargin(new Insets(0, 0, 0, 0));
        this.btnMain.setToolTipText("Hide the first trace (useful if the derivative or average has been plotted)");
        this.btnMain.addActionListener(this);
        titlePanelRight.add(this.btnMain);
        if (this.textDisplay || this.plotType == 1 || this.plotType == 2) {
            this.btnMain.setVisible(false);
        }
        this.btnDerivative = this.createIconButton("/images/derivSmall.png", "Deriv", "Plot 1st Derivative (1st difference)");
        titlePanelRight.add(this.btnDerivative);
        if (this.textDisplay || this.plotType == 1 || this.plotType == 2) {
            this.btnDerivative.setVisible(false);
        }
        this.btnAvg = new JButton("AVG");
        this.btnAvg.setMargin(new Insets(0, 0, 0, 0));
        this.btnAvg.setToolTipText("Running Average / Low Pass Filter");
        this.btnAvg.addActionListener(this);
        titlePanelRight.add(this.btnAvg);
        if (this.textDisplay || this.plotType == 1 || this.plotType == 2) {
            this.btnAvg.setVisible(false);
        }
        this.setRedOutline(this.btnMain, this.hideMain);
        this.setRedOutline(this.btnLines, !this.hideLines);
        this.setRedOutline(this.btnPoints, !this.hidePoints);
        this.setRedOutline(this.btnDerivative, this.plotDerivative);
        this.setRedOutline(this.btnAvg, this.dspAvg);
        this.setRedOutline(this.btnHorizontalLines, this.showHorizontalLines);
        this.setRedOutline(this.btnVerticalLines, this.showVerticalLines);
        this.setRedOutline(this.cbUTC, this.showUTCtime);
        if (this.chckbxPlotAllUptime != null) {
            this.setRedOutline(this.chckbxPlotAllUptime, this.showContinuous);
        }
        if (this.cbUptime != null) {
            this.setRedOutline(this.cbUptime, !this.hideUptime);
        }
        this.btnDefault = this.createIconButton("/images/refreshSmall.png", "Reset", "Reset to default range and show latest data");
        titlePanelRight.add(this.btnDefault);
        this.btnCSV = this.createIconButton("/images/saveSmall.png", "CSV", "Save this data to a CSV file");
        titlePanelRight.add(this.btnCSV);
        if (this.textDisplay) {
            this.btnCSV.setEnabled(false);
        }
        this.btnCopy = this.createIconButton("/images/copySmall.png", "Copy", "Copy graph to clipboard");
        titlePanelRight.add(this.btnCopy);
        if (this.textDisplay) {
            this.btnCopy.setEnabled(false);
        }
        this.footerPanel = new JPanel();
        this.contentPane.add((Component)this.footerPanel, "South");
        this.footerPanel.setLayout(new BorderLayout(0, 0));
        JPanel footerPanelRight = new JPanel();
        JPanel footerPanel1 = new JPanel();
        JPanel footerPanel2 = new JPanel();
        JPanel footerPanel3 = new JPanel();
        this.footerPanel.add((Component)footerPanelRight, "East");
        footerPanelRight.setLayout(new BorderLayout(0, 0));
        footerPanelRight.add((Component)footerPanel1, "West");
        footerPanelRight.add((Component)footerPanel2, "Center");
        footerPanel2.setLayout(new BorderLayout(0, 0));
        footerPanel2.add((Component)this.footerPanel2uptime, "East");
        footerPanel2.add((Component)this.footerPanel2utc, "West");
        footerPanelRight.add((Component)footerPanel3, "East");
        if (this.plotType != 1 && this.plotType != 2) {
            this.cbRoundLabels = new JCheckBox("Round Labels");
            this.cbRoundLabels.setSelected(this.roundLabels);
            this.cbRoundLabels.addItemListener(this);
            footerPanel1.add(this.cbRoundLabels);
            this.cbShowSun = new JCheckBox("Show Sun");
            this.cbShowSun.setEnabled(false);
            this.cbShowSun.addItemListener(this);
            footerPanel1.add(this.cbShowSun);
        }
        if (this.plotType != 1 && this.plotType != 2) {
            this.lblAvg = new JLabel("Avg");
            this.txtAvgPeriod = new JTextField();
            this.txtAvgPeriod.addActionListener(this);
            this.txtAvgPeriod.addFocusListener(this);
            this.lblAvgPeriod = new JLabel("samples  ");
            this.setAvgVisible(this.dspAvg);
            footerPanel1.add(this.lblAvg);
            footerPanel1.add(this.txtAvgPeriod);
            footerPanel1.add(this.lblAvgPeriod);
            this.txtAvgPeriod.setText(Integer.toString(this.AVG_PERIOD));
            this.txtAvgPeriod.setColumns(3);
        }
        this.lblFromReset = new JLabel(FROM_RESET);
        this.footerPanel2uptime.add(this.lblFromReset);
        this.textFromReset = new JTextField();
        this.footerPanel2uptime.add(this.textFromReset);
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromReset.setColumns(8);
        this.textFromReset.addActionListener(this);
        this.textFromReset.addFocusListener(this);
        this.lblFromUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblFromUptime);
        this.textFromUptime = new JTextField();
        this.footerPanel2uptime.add(this.textFromUptime);
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textFromUptime.setColumns(8);
        this.textFromUptime.addActionListener(this);
        this.textFromUptime.addFocusListener(this);
        this.lblToReset = new JLabel("  to Reset");
        this.footerPanel2uptime.add(this.lblToReset);
        this.textToReset = new JTextField();
        this.footerPanel2uptime.add(this.textToReset);
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToReset.setColumns(8);
        this.textToReset.addActionListener(this);
        this.textToReset.addFocusListener(this);
        this.lblToUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblToUptime);
        this.textToUptime = new JTextField();
        this.footerPanel2uptime.add(this.textToUptime);
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        this.textToUptime.setColumns(8);
        this.textToUptime.addActionListener(this);
        this.textToUptime.addFocusListener(this);
        this.lblFromUTC = new JLabel(FROM_UTC);
        this.lblFromUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblFromUTC);
        this.textFromUtc = new JTextField();
        this.footerPanel2utc.add(this.textFromUtc);
        this.textFromUtc.setText(this.START_UTC);
        this.textFromUtc.setToolTipText(this.dateFormatsToolTip);
        this.textFromUtc.setColumns(16);
        this.textFromUtc.addActionListener(this);
        this.textFromUtc.addFocusListener(this);
        this.lblToUTC = new JLabel(" to UTC");
        this.lblToUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblToUTC);
        this.textToUtc = new JTextField();
        this.footerPanel2utc.add(this.textToUtc);
        this.textToUtc.setText(this.END_UTC);
        this.textToUtc.setColumns(16);
        this.textToUtc.setToolTipText(this.dateFormatsToolTip);
        this.textToUtc.addActionListener(this);
        this.textToUtc.addFocusListener(this);
        this.btnLatest = new JButton(LIVE_TEXT);
        this.btnLatest.setForeground(Tools.AMSAT_RED);
        this.btnLatest.setMargin(new Insets(0, 0, 0, 0));
        this.btnLatest.setToolTipText("Toggle between showing the live samples, the next samples from a date/uptime or a range of samples");
        this.btnLatest.addActionListener(this);
        footerPanel3.add(this.btnLatest);
        this.txtSamplePeriod = new JTextField();
        this.txtSamplePeriod.addActionListener(this);
        this.txtSamplePeriod.addFocusListener(this);
        this.txtSamplePeriod.setToolTipText("The number of data samples to plot.  The latest samples are returned unless a from reset/uptime is specified");
        footerPanel3.add(this.txtSamplePeriod);
        this.lblSamplePeriod = new JLabel("samples");
        footerPanel3.add(this.lblSamplePeriod);
        this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        this.txtSamplePeriod.setColumns(6);
        this.showRangeSearch(this.showLatest);
        this.showUptimeQuery(!this.showUTCtime);
    }

    private void showRangeSearch(int showLive) {
        boolean show = false;
        if (showLive == 2) {
            this.btnLatest.setText(RANGE_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            show = true;
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
            this.lblToUTC.setVisible(show);
        }
        if (showLive == 0) {
            this.lblFromUTC.setText(BEFORE_UTC);
            this.lblFromReset.setText(BEFORE_RESET);
            this.btnLatest.setText(LIVE_TEXT);
            this.btnLatest.setForeground(Tools.AMSAT_RED);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
        }
        if (showLive == 1) {
            this.btnLatest.setText(NEXT_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(!show);
            this.textFromReset.setVisible(!show);
            this.lblFromUptime.setVisible(!show);
            this.textFromUptime.setVisible(!show);
            this.textFromUtc.setVisible(!show);
            this.lblFromUTC.setVisible(!show);
        }
        this.lblToReset.setVisible(show);
        this.textToReset.setVisible(show);
        this.lblToUptime.setVisible(show);
        this.textToUptime.setVisible(show);
        this.txtSamplePeriod.setEnabled(!show);
        this.lblToUTC.setVisible(show);
        this.textToUtc.setVisible(show);
    }

    private void showUptimeQuery(boolean up) {
        if (up) {
            this.footerPanel2uptime.setVisible(true);
            this.footerPanel2utc.setVisible(false);
        } else {
            this.footerPanel2uptime.setVisible(false);
            this.footerPanel2utc.setVisible(true);
        }
    }

    private void initSkyPlotFields() {
        String s = this.fieldName[0];
        this.fieldName2 = new String[2];
        this.fieldName2[0] = "EL";
        this.fieldName2[1] = "AZ";
        this.fieldName[0] = s;
    }

    private void initEarthPlotFields() {
        String s = this.fieldName[0];
        this.fieldName2 = new String[2];
        this.fieldName2[0] = "LAT";
        this.fieldName2[1] = "LONG";
        this.fieldName[0] = s;
    }

    private boolean textDisplay(int conversionType) {
        return false;
    }

    private void initVarlist() {
        this.variables = new ArrayList();
        ArrayList<String> labels = new ArrayList<String>();
        int v = 0;
        while (v < this.layout.fieldName.length) {
            if (!this.layout.module[v].equalsIgnoreCase("NONE")) {
                labels.add(String.valueOf(this.layout.module[v]) + "-" + this.layout.shortName[v]);
                this.variables.add(this.layout.fieldName[v]);
            }
            ++v;
        }
        Object[] fields = labels.toArray();
        this.cbAddVariable.removeAllItems();
        this.cbAddVariable.setModel(new DefaultComboBoxModel<Object>(fields));
    }

    private void calcTitle() {
        this.displayTitle = this.plotType != 1 && (this.fieldName.length > 1 || this.fieldName2 != null) ? "Sat: " + this.sat.name : this.title;
    }

    private void setAvgVisible(boolean f) {
        this.lblAvg.setVisible(f);
        this.txtAvgPeriod.setVisible(f);
        this.lblAvgPeriod.setVisible(f);
    }

    public JButton createIconButton(String icon, String name, String toolTip) throws IOException {
        JButton btn;
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource(icon));
        }
        catch (IOException e) {
            throw new IOException("Could not create icon on button in Graph");
        }
        if (wPic != null) {
            btn = new JButton(new ImageIcon(wPic));
            btn.setMargin(new Insets(0, 0, 0, 0));
        } else {
            btn = new JButton(name);
        }
        btn.setToolTipText(toolTip);
        btn.addActionListener(this);
        return btn;
    }

    public void updateGraphData(String by) throws NumberFormatException, IOException, DataLoadException {
        this.panel.updateGraphData("GraphFrame.updateGraphData");
    }

    public void saveProperties(boolean open) {
    }

    public boolean loadProperties() {
        if (this.plotType == 2) {
            this.setBounds(100, 100, 1000, 500);
        } else {
            this.setBounds(100, 100, 740, 400);
        }
        if (this.SAMPLES == 0) {
            this.SAMPLES = DEFAULT_SAMPLES;
        }
        if (this.SAMPLES > 999999) {
            this.SAMPLES = 999999;
        }
        if (this.START_UTC == null) {
            this.START_UTC = DEFAULT_START_UTC;
        }
        if (this.END_UTC == null) {
            this.END_UTC = DEFAULT_END_UTC;
        }
        if (this.AVG_PERIOD == 0) {
            this.AVG_PERIOD = DEFAULT_AVG_PERIOD;
        }
        this.UPTIME_THRESHOLD = this.showContinuous ? -1.0 : 3600.0;
        if (this.mapType == 0) {
            this.mapType = 2;
        }
        return false;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.saveProperties(false);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void parseAvgPeriod() {
        String text = this.txtAvgPeriod.getText();
        try {
            this.AVG_PERIOD = Integer.parseInt(text);
            if (this.AVG_PERIOD > 999) {
                this.AVG_PERIOD = 999;
                text = Integer.toString(999);
                this.txtAvgPeriod.setText(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.panel.updateGraphData("GraphFrame.parseAvgPeriod");
    }

    private Date parseDate(String strDate) {
        Date date = null;
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            try {
                date = dateFormat2.parse(strDate);
            }
            catch (ParseException e2) {
                try {
                    date = dateFormat3.parse(strDate);
                }
                catch (ParseException e3) {
                    date = null;
                }
            }
        }
        return date;
    }

    private EpochTime parseUTCField(JTextField field, String strDate) {
        if (strDate.equalsIgnoreCase(NOW)) {
            Date currentDate = new Date();
            EpochTime foxTime = this.sat.getUptimeForUtcDate(currentDate);
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(currentDate);
            field.setText(time);
            return foxTime;
        }
        if (strDate.equalsIgnoreCase(YESTERDAY)) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            Date currentDate = new Date(cal.getTimeInMillis());
            EpochTime foxTime = this.sat.getUptimeForUtcDate(currentDate);
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(currentDate);
            field.setText(time);
            return foxTime;
        }
        if (strDate.equalsIgnoreCase(LAUNCH)) {
            Date date = this.sat.getUtcForReset(0, 0L);
            if (date != null) {
                dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                String time = dateFormat2.format(date);
                field.setText(time);
            }
            return new EpochTime(0, 0L);
        }
        Date dateFrom = this.parseDate(strDate);
        if (dateFrom != null) {
            EpochTime foxTime = this.sat.getUptimeForUtcDate(dateFrom);
            return foxTime;
        }
        return null;
    }

    private void parseUTCFields() {
        EpochTime foxTime2;
        String strDate = this.textFromUtc.getText();
        EpochTime foxTime = this.parseUTCField(this.textFromUtc, strDate);
        if (foxTime != null) {
            this.START_RESET = foxTime.getReset();
            this.START_UPTIME = foxTime.getUptime();
        }
        if ((foxTime2 = this.parseUTCField(this.textToUtc, strDate = this.textToUtc.getText())) != null) {
            this.END_RESET = foxTime2.getReset();
            this.END_UPTIME = foxTime2.getUptime();
        }
    }

    private void parseTextFields() {
        block15: {
            String text;
            block14: {
                block13: {
                    block12: {
                        text = this.textFromReset.getText();
                        try {
                            this.START_RESET = Integer.parseInt(text);
                            if (this.START_RESET < 0) {
                                this.START_RESET = 0;
                            }
                        }
                        catch (NumberFormatException ex) {
                            if (!text.equals("")) break block12;
                            this.START_RESET = DEFAULT_START_RESET;
                        }
                    }
                    text = this.textFromUptime.getText();
                    try {
                        this.START_UPTIME = Integer.parseInt(text);
                        if (this.START_UPTIME < 0L) {
                            this.START_UPTIME = 0L;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (!text.equals("")) break block13;
                        this.START_UPTIME = DEFAULT_START_UPTIME;
                    }
                }
                text = this.textToReset.getText();
                try {
                    this.END_RESET = Integer.parseInt(text);
                    if (this.END_RESET < 0) {
                        this.END_RESET = 0;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!text.equals("")) break block14;
                    this.END_RESET = DEFAULT_START_RESET;
                }
            }
            text = this.textToUptime.getText();
            try {
                this.END_UPTIME = Integer.parseInt(text);
                if (this.END_UPTIME < 0L) {
                    this.END_UPTIME = 0L;
                }
            }
            catch (NumberFormatException ex) {
                if (!text.equals("")) break block15;
                this.END_UPTIME = DEFAULT_START_UPTIME;
            }
        }
    }

    private void parseFields() {
        String text = null;
        if (this.showUTCtime) {
            this.convertToUptime();
        } else {
            this.convertToUtc();
        }
        text = this.txtSamplePeriod.getText();
        try {
            this.SAMPLES = Integer.parseInt(text);
            if (this.SAMPLES > 999999) {
                this.SAMPLES = 999999;
                text = Integer.toString(999999);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.panel.updateGraphData("GraphFrame:parseTextFields");
    }

    private void toggleSunCheckBox() {
        if (!this.textDisplay && this.plotType != 1 && this.plotType != 2 && this.cbShowSun != null) {
            this.cbShowSun.setSelected(false);
            this.cbShowSun.setEnabled(false);
        }
    }

    private void setRedOutline(JButton but, boolean red) {
        if (red) {
            but.setForeground(Color.BLACK);
            but.setBackground(Color.GRAY);
        } else {
            but.setForeground(Color.GRAY);
        }
        but.setBackground(Color.WHITE);
    }

    private void convertToUtc() {
        Date date2;
        this.parseTextFields();
        Date date = this.sat.getUtcForReset(this.START_RESET, this.START_UPTIME);
        if (date != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(date);
            this.textFromUtc.setText(time);
            this.START_UTC = time;
            this.textFromUtc.setText(time);
        }
        if ((date2 = this.sat.getUtcForReset(this.END_RESET, this.END_UPTIME)) != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time2 = dateFormat2.format(date2);
            this.textToUtc.setText(time2);
            this.END_UTC = time2;
            this.textToUtc.setText(time2);
        }
        if (this.showLatest == 2) {
            this.SAMPLES = 0;
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    private void convertToUptime() {
        this.parseUTCFields();
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        if (this.showLatest == 2) {
            this.SAMPLES = 0;
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnAdd) {
            this.add = !this.add;
            this.cbAddVariable.setVisible(this.add);
        } else if (e.getSource() == this.cbAddVariable) {
            String[] stringArray;
            int position = this.cbAddVariable.getSelectedIndex();
            if (position == -1) {
                return;
            }
            if (this.fieldName[0].equalsIgnoreCase(this.variables.get(position))) {
                return;
            }
            int fields = this.fieldName.length;
            int fields2 = 0;
            String[] temp = new String[fields];
            String[] temp2 = null;
            int i2 = 0;
            boolean toggle = false;
            boolean toggle2 = false;
            int totalVariables = this.fieldName.length;
            String[] stringArray2 = this.fieldName;
            int n = this.fieldName.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray2[n2];
                temp[i2++] = s;
                if (s.equalsIgnoreCase(this.variables.get(position))) {
                    toggle = true;
                }
                ++n2;
            }
            int j = 0;
            if (this.fieldName2 != null && this.fieldName2.length > 0) {
                fields2 = this.fieldName2.length;
                temp2 = new String[fields2];
                stringArray = this.fieldName2;
                int n3 = this.fieldName2.length;
                n = 0;
                while (n < n3) {
                    String s = stringArray[n];
                    temp2[j++] = s;
                    if (s.equalsIgnoreCase(this.variables.get(position))) {
                        toggle2 = true;
                    }
                    ++n;
                }
                totalVariables += this.fieldName2.length;
            }
            if (toggle && this.fieldName.length > 1) {
                this.fieldName = new String[fields - 1];
                i2 = 0;
                stringArray = temp;
                int n4 = temp.length;
                n = 0;
                while (n < n4) {
                    String s = stringArray[n];
                    if (!s.equalsIgnoreCase(this.variables.get(position))) {
                        this.fieldName[i2++] = s;
                    }
                    ++n;
                }
            } else if (toggle2 && this.fieldName2.length > 0) {
                if (this.fieldName2.length == 1) {
                    this.fieldName2 = null;
                    this.fieldUnits2 = "";
                    fields2 = 0;
                } else {
                    this.fieldName2 = new String[fields2 - 1];
                    i2 = 0;
                    stringArray = temp2;
                    int n5 = temp2.length;
                    n = 0;
                    while (n < n5) {
                        String s = stringArray[n];
                        if (!s.equalsIgnoreCase(this.variables.get(position))) {
                            this.fieldName2[i2++] = s;
                        }
                        ++n;
                    }
                }
            } else {
                String[] stringArray3;
                if (totalVariables == 13) {
                    return;
                }
                String unit = this.layout.getUnitsByName(this.variables.get(position));
                if (!unit.equalsIgnoreCase(this.fieldUnits)) {
                    this.fieldUnits2 = unit;
                    this.conversionType2 = this.layout.getConversionByName(this.variables.get(position));
                    this.fieldName2 = new String[fields2 + 1];
                    i2 = 0;
                    if (temp2 != null) {
                        stringArray3 = temp2;
                        int n6 = temp2.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String s = stringArray3[n7];
                            this.fieldName2[i2++] = s;
                            ++n7;
                        }
                    }
                    this.fieldName2[i2] = this.variables.get(position);
                } else {
                    this.fieldName = new String[fields + 1];
                    i2 = 0;
                    stringArray3 = temp;
                    int n8 = temp.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String s = stringArray3[n9];
                        this.fieldName[i2++] = s;
                        ++n9;
                    }
                    this.fieldName[i2] = this.variables.get(position);
                }
            }
            ArrayList<String> labels = new ArrayList<String>();
            this.variables = new ArrayList();
            int v = 0;
            while (v < this.layout.fieldName.length) {
                if (!this.layout.module[v].equalsIgnoreCase("NONE") && (this.layout.fieldUnits[v].equalsIgnoreCase(this.fieldUnits) || this.layout.fieldUnits[v].equalsIgnoreCase(this.fieldUnits2) || this.fieldUnits2.equalsIgnoreCase(""))) {
                    this.variables.add(this.layout.fieldName[v]);
                    labels.add(String.valueOf(this.layout.module[v]) + "-" + this.layout.shortName[v]);
                }
                ++v;
            }
            this.cbAddVariable.removeAllItems();
            for (String s : labels) {
                this.cbAddVariable.addItem(s);
            }
            if (this.fieldName.length <= 1 && this.fieldName2 == null) {
                this.add = false;
                this.cbAddVariable.setVisible(this.add);
            }
            this.calcTitle();
            this.panel.updateGraphData("GraphFrame:stateChange:addVariable");
        } else if (e.getSource() == this.txtSamplePeriod) {
            this.parseFields();
        } else if (e.getSource() == this.textFromReset) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textToReset) {
            this.parseFields();
        } else if (e.getSource() == this.textToUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUtc) {
            this.parseFields();
        } else if (e.getSource() == this.textToUtc) {
            this.parseFields();
        } else if (e.getSource() == this.txtAvgPeriod) {
            this.parseAvgPeriod();
        } else if (e.getSource() == this.btnLatest) {
            ++this.showLatest;
            if (this.showLatest > 2) {
                this.showLatest = 0;
            }
            this.showRangeSearch(this.showLatest);
            this.parseFields();
        } else if (e.getSource() == this.btnDefault) {
            if (!this.textDisplay) {
                if (this.plotType == 1) {
                    this.initSkyPlotFields();
                } else if (this.plotType == 2) {
                    this.initEarthPlotFields();
                } else {
                    this.fieldUnits2 = "";
                    this.fieldName2 = null;
                    String name = this.fieldName[0];
                    this.fieldName = new String[1];
                    this.fieldName[0] = name;
                }
                if (this.plotType != 1 && this.plotType != 2) {
                    this.initVarlist();
                    this.add = false;
                    this.cbAddVariable.setVisible(this.add);
                }
                this.calcTitle();
            }
            this.showLatest = 0;
            this.showRangeSearch(this.showLatest);
            this.textFromUtc.setText(DEFAULT_START_UTC);
            this.textToUtc.setText(DEFAULT_END_UTC);
            this.txtSamplePeriod.setText(Integer.toString(DEFAULT_SAMPLES));
            this.parseFields();
            if (this.plotType != 1 && this.plotType != 2) {
                this.txtAvgPeriod.setText(Integer.toString(DEFAULT_AVG_PERIOD));
                this.parseAvgPeriod();
            }
        } else if (e.getSource() != this.btnCSV) {
            if (e.getSource() == this.btnCopy) {
                this.copyToClipboard();
            } else if (e.getSource() == this.btnHorizontalLines) {
                this.showHorizontalLines = !this.showHorizontalLines;
                this.setRedOutline(this.btnHorizontalLines, this.showHorizontalLines);
                this.panel.updateGraphData("GraphFrame.actionPerformed:horizontal");
            } else if (e.getSource() == this.btnVerticalLines) {
                this.showVerticalLines = !this.showVerticalLines;
                this.setRedOutline(this.btnVerticalLines, this.showVerticalLines);
                this.panel.updateGraphData("GraphFrame.actionPerformed:vertical");
            } else if (e.getSource() == this.btnDerivative) {
                this.plotDerivative = !this.plotDerivative;
                this.setRedOutline(this.btnDerivative, this.plotDerivative);
                this.panel.updateGraphData("GraphFrame.actionPerformed:derivative");
            } else if (e.getSource() == this.btnAvg) {
                this.dspAvg = !this.dspAvg;
                this.setRedOutline(this.btnAvg, this.dspAvg);
                this.setAvgVisible(this.dspAvg);
                this.panel.updateGraphData("GraphFrame.actionPerformed:avg");
            } else if (e.getSource() == this.btnMain) {
                this.hideMain = !this.hideMain;
                this.setRedOutline(this.btnMain, this.hideMain);
                this.panel.updateGraphData("GraphFrame.actionPerformed:main");
            } else if (e.getSource() == this.btnLines) {
                this.hideLines = !this.hideLines;
                this.setRedOutline(this.btnLines, !this.hideLines);
                this.panel.updateGraphData("GraphFrame.actionPerformed:hideLines");
            } else if (e.getSource() == this.btnPoints) {
                this.hidePoints = !this.hidePoints;
                this.setRedOutline(this.btnPoints, !this.hidePoints);
                this.panel.updateGraphData("GraphFrame.actionPerformed:points");
            } else if (e.getSource() == this.btnMapType) {
                ++this.mapType;
                if (this.mapType > 3) {
                    this.mapType = 1;
                }
                this.panel.updateGraphData("GraphFrame.actionPerformed:points");
            }
        }
        if (e.getSource() == this.cbUptime) {
            this.hideUptime = !this.hideUptime;
            this.panel.updateGraphData("GraphFrame:stateChange:Uptime");
            this.setRedOutline(this.cbUptime, !this.hideUptime);
        }
        if (e.getSource() == this.chckbxPlotAllUptime) {
            this.showContinuous = !this.showContinuous;
            this.UPTIME_THRESHOLD = this.showContinuous ? -1.0 : 3600.0;
            this.setRedOutline(this.chckbxPlotAllUptime, this.showContinuous);
            this.panel.updateGraphData("GraphFrame:stateChange:plotAllUptime");
        }
        if (e.getSource() == this.cbUTC) {
            boolean bl = this.showUTCtime = !this.showUTCtime;
            if (this.showUTCtime) {
                this.parseTextFields();
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            } else {
                this.parseUTCFields();
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            }
            this.showUptimeQuery(!this.showUTCtime);
            this.setRedOutline(this.cbUTC, this.showUTCtime);
            this.panel.updateGraphData("GraphFrame:stateChange:UTC");
        }
        this.toggleSunCheckBox();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cbRoundLabels) {
            this.roundLabels = e.getStateChange() != 2;
            this.panel.updateGraphData("GraphFrame:stateChange:altLabels");
        }
        if (e.getSource() == this.cbShowSun) {
            this.showSun = e.getStateChange() != 2;
            this.panel.updateGraphData("GraphFrame:stateChange:altLabels");
        }
        if (e.getSource() == this.cbUptime) {
            this.hideUptime = e.getStateChange() == 2;
            this.panel.updateGraphData("GraphFrame:stateChange:Uptime");
        }
        this.toggleSunCheckBox();
    }

    private void saveToCSV(File aFile) throws IOException {
    }

    public void copyToClipboard() {
        BufferedImage img = new BufferedImage(this.panel.getWidth(), this.panel.getHeight(), 2);
        Graphics imgGraphics = img.getGraphics();
        this.panel.printAll(imgGraphics);
        GraphFrame.write(img);
    }

    public static void write(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image can't be null");
        }
        ImageTransferable transferable = new ImageTransferable(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() != this.txtSamplePeriod && e.getSource() != this.textFromReset && e.getSource() != this.textFromUptime) {
            e.getSource();
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        int MAX_WIDTH = 1486;
        if (this.plotType == 2) {
            int W = 4;
            int H = 2;
            int width = 0;
            Rectangle b = arg0.getComponent().getBounds();
            width = b.width;
            if (width > MAX_WIDTH) {
                width = MAX_WIDTH;
            }
            arg0.getComponent().setBounds(b.x, b.y, width, width * H / W);
        }
        this.toggleSunCheckBox();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    static class ImageTransferable
    implements Transferable {
        private Image image;

        public ImageTransferable(Image image) {
            this.image = image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DataFlavor.imageFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }
    }
}

