/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.gui.GraphCanvas;
import com.g0kla.telem.gui.GraphFrame;
import com.g0kla.telem.gui.Tools;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import uk.me.g4dpz.satellite.SatPos;

public class GraphPanel
extends GraphCanvas {
    public static final int NO_TIME_VALUE = -999;
    double[] firstDifference = null;
    double[] dspData = null;
    int[] plottedXreset;
    long[] plottedXuptime;
    int zeroPoint;
    Spacecraft sat;
    public static final int MAX_VARIABLES = 13;
    Color[] graphColor = new Color[]{Tools.AMSAT_BLUE, Tools.GRAPH1, Tools.GRAPH2, Tools.GRAPH3, Tools.GRAPH4, Tools.GRAPH5, Tools.GRAPH6, Tools.GRAPH7, Tools.GRAPH8, Tools.GRAPH9, Tools.GRAPH10, Tools.GRAPH11, Tools.GRAPH12};
    HashMap<Integer, Long> maxPlottedUptimeForReset;
    int sideLabel = 0;
    int bottomLabelOffset = 5;

    GraphPanel(String title, Spacecraft sat, ByteArrayLayout layout, GraphFrame gf, SatTelemStore db) throws NumberFormatException, IOException, DataLoadException {
        super(title, sat, layout, gf, db);
        this.sat = sat;
        this.updateGraphData("GrapPanel.new");
    }

    private void drawLegend(int graphHeight, int graphWidth) {
        String name;
        if (this.graphFrame.fieldName.length == 1 && this.graphFrame.fieldName2 == null) {
            return;
        }
        int titleHeight = this.topBorder;
        int verticalOffset = 15;
        if (this.zeroPoint < graphAxisFontSize * 3) {
            titleHeight = graphHeight - 15;
        }
        int lineLength = 15;
        int rows = this.graphFrame.fieldName.length;
        int font = graphAxisFontSize;
        int leftLineOffset = 50;
        int fonth = 12 * font / 9;
        int fontw = 9 * font / 10;
        if (this.graphFrame.fieldName2 != null) {
            rows += this.graphFrame.fieldName2.length;
        }
        if (this.graphFrame.plotDerivative) {
            ++rows;
        }
        if (this.graphFrame.dspAvg) {
            ++rows;
        }
        int longestWord = 20;
        int i2 = 0;
        while (i2 < this.graphFrame.fieldName.length) {
            if (this.graphFrame.fieldName[i2].length() > longestWord) {
                longestWord = this.graphFrame.fieldName[i2].length();
            }
            ++i2;
        }
        if (this.graphFrame.fieldName2 != null) {
            i2 = 0;
            while (i2 < this.graphFrame.fieldName2.length) {
                if (this.graphFrame.fieldName2[i2].length() > longestWord) {
                    longestWord = this.graphFrame.fieldName2[i2].length();
                }
                ++i2;
            }
        }
        int leftOffset = longestWord * fontw + 20;
        this.g.setFont(new Font("SansSerif", 0, font));
        this.g2.drawRect(this.sideBorder + graphWidth - leftOffset - 1, titleHeight + 4, longestWord * fontw + 1, 9 + fonth * rows + 1);
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(this.sideBorder + graphWidth - leftOffset, titleHeight + 5, longestWord * fontw, 9 + fonth * rows);
        int i3 = 0;
        while (i3 < this.graphFrame.fieldName.length) {
            this.g2.setColor(Color.BLACK);
            name = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName[i3])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName[i3]);
            this.g2.drawString(String.valueOf(name) + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + i3 * fonth);
            this.g2.setColor(this.graphColor[i3]);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + i3 * fonth, lineLength + 5, 2);
            ++i3;
        }
        verticalOffset += this.graphFrame.fieldName.length * fonth;
        if (this.graphFrame.fieldName2 != null) {
            i3 = 0;
            while (i3 < this.graphFrame.fieldName2.length) {
                this.g2.setColor(Color.BLACK);
                name = String.valueOf(this.graphFrame.layout.getModuleByName(this.graphFrame.fieldName2[i3])) + "-" + this.graphFrame.layout.getShortNameByName(this.graphFrame.fieldName2[i3]);
                this.g2.drawString(String.valueOf(name) + " (" + this.graphFrame.fieldUnits2 + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + i3 * fonth);
                this.g2.setColor(this.graphColor[this.graphFrame.fieldName.length + i3]);
                this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + i3 * fonth, lineLength + 5, 2);
                ++i3;
            }
            verticalOffset += this.graphFrame.fieldName2.length * fonth;
        }
        int x = 0;
        if (this.graphFrame.plotDerivative) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("Der:" + this.graphFrame.fieldName[0] + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5);
            this.g2.setColor(Tools.AMSAT_RED);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset, lineLength + 5, 2);
            x = 1;
        }
        if (this.graphFrame.dspAvg) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("Avg:" + this.graphFrame.fieldName[0] + " (" + this.graphFrame.fieldUnits + ")", this.sideBorder + graphWidth - leftOffset + 2, titleHeight + verticalOffset + 5 + x * fonth);
            this.g2.setColor(Tools.AMSAT_GREEN);
            this.g2.fillRect(this.sideBorder + graphWidth - leftLineOffset, titleHeight + verticalOffset + x * fonth, lineLength + 5, 2);
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        if (!this.checkDataExists()) {
            return;
        }
        this.maxPlottedUptimeForReset = new HashMap();
        int graphHeight = this.getHeight() - this.topBorder - this.bottomBorder;
        int graphWidth = this.getWidth() - this.sideBorder * 2;
        if (graphWidth < 1) {
            return;
        }
        if (graphHeight < 1) {
            return;
        }
        this.plottedXreset = new int[graphWidth + 1];
        this.plottedXuptime = new long[graphWidth + 1];
        int j = 0;
        while (j < graphWidth + 1) {
            this.plottedXreset[j] = -999;
            this.plottedXuptime[j] = -999L;
            ++j;
        }
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        if (this.graphFrame.plotDerivative) {
            this.firstDifference = new double[this.graphData[0][0].length];
        }
        double[] axisPoints2 = new double[]{0.0, 0.0, 0.0};
        if (this.drawGraph2) {
            axisPoints2 = this.plotVerticalAxis(graphWidth, graphHeight, graphWidth, this.graphData2, false, this.graphFrame.fieldUnits2);
        }
        double[] axisPoints = this.plotVerticalAxis(0, graphHeight, graphWidth, this.graphData, this.graphFrame.showHorizontalLines, this.graphFrame.fieldUnits);
        this.zeroPoint = (int)axisPoints[0];
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        ArrayList<Integer> resetPosition = new ArrayList<Integer>();
        resetPosition.add(0);
        double currentReset = this.graphData[0][0][0];
        double lastUptime = this.graphData[0][1][0];
        int i2 = 1;
        while (i2 < this.graphData[0][0].length) {
            if (this.graphData[0][0][i2] != currentReset) {
                resetPosition.add(i2);
                currentReset = this.graphData[0][0][i2];
            } else if (this.graphFrame.UPTIME_THRESHOLD != -1.0 && this.graphData[0][1][i2] - lastUptime > this.graphFrame.UPTIME_THRESHOLD) {
                resetPosition.add(i2);
                currentReset = this.graphData[0][0][i2];
            }
            lastUptime = this.graphData[0][1][i2];
            ++i2;
        }
        int titleHeight = graphAxisFontSize + 10;
        if (this.zeroPoint < graphAxisFontSize * 3) {
            titleHeight = graphHeight + this.topBorder;
        }
        this.g2.setColor(Color.BLACK);
        this.g.setFont(new Font("SansSerif", 1, graphAxisFontSize + 3));
        this.g2.drawString(this.graphFrame.displayTitle, this.sideBorder / 2 + graphWidth / 2 - this.graphFrame.displayTitle.length() / 2 * graphAxisFontSize / 2, titleHeight);
        this.drawLegend(graphHeight, graphWidth);
        this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        this.g2.setColor(this.graphAxisColor);
        this.g2.drawLine(this.sideLabelOffset, this.zeroPoint, graphWidth + this.sideBorder, this.zeroPoint);
        this.g2.setColor(this.graphTextColor);
        int offset = 0;
        if (!this.graphFrame.hideUptime) {
            this.g2.drawString("Uptime", this.sideLabelOffset, this.zeroPoint + graphAxisFontSize);
            offset = graphAxisFontSize;
        }
        if (!this.graphFrame.showUTCtime) {
            this.g2.drawString("Resets", this.sideLabelOffset, this.zeroPoint + 1 * graphAxisFontSize + offset);
        } else {
            this.g2.drawString("UTC", this.sideLabelOffset, this.zeroPoint + (int)(1.5 * (double)graphAxisFontSize) + offset);
            this.g.setFont(new Font("SansSerif", 0, (int)((double)graphAxisFontSize * 0.9)));
            this.g2.drawString("(Spacecraft UTC is approximate)", graphWidth - graphAxisFontSize * 10, titleHeight);
            this.g.setFont(new Font("SansSerif", 0, graphAxisFontSize));
        }
        int maxLabels = graphWidth / (labelWidth * 2);
        int resetLabelFreq = (int)Math.ceil((double)resetPosition.size() / (double)maxLabels);
        int resetLabelCount = 0;
        boolean drawLabels = false;
        int r = 0;
        while (r < resetPosition.size()) {
            int startScreenPos = 0;
            int width = 0;
            int start = (Integer)resetPosition.get(r);
            int end = 0;
            int len = this.graphData[0][2].length;
            startScreenPos = this.sideBorder + graphWidth * start / len;
            end = r == resetPosition.size() - 1 ? len : (Integer)resetPosition.get(r + 1);
            width = graphWidth * (end - start) / len;
            if (width < 1) {
                width = 1;
            }
            if (this.graphFrame.showContinuous || ++resetLabelCount == resetLabelFreq) {
                drawLabels = true;
                resetLabelCount = 0;
            } else {
                drawLabels = false;
            }
            if (!this.graphFrame.roundLabels) {
                drawLabels = false;
            }
            this.drawGraphForSingleReset(start, end, width, graphHeight, startScreenPos, this.zeroPoint, axisPoints[1], axisPoints[2], axisPoints2[1], axisPoints2[2], drawLabels);
            ++r;
        }
        if (!this.graphFrame.roundLabels) {
            this.plotAlternateLabels(this.zeroPoint, graphHeight);
        }
    }

    private void plotAlternateLabels(int zeroPoint, int graphHeight) {
        int prevReset = -1;
        boolean firstLabel = true;
        DecimalFormat d = new DecimalFormat("0");
        int w = 0;
        int v = 0;
        while (v < this.plottedXuptime.length) {
            int resets = this.plottedXreset[v];
            long uptime = this.plottedXuptime[v];
            if (firstLabel || w++ >= labelWidth && this.plottedXuptime[v] != -999L) {
                firstLabel = false;
                w = 0;
                int timepos = v;
                String s = d.format(uptime);
                int offset = 0;
                if (!this.graphFrame.hideUptime) {
                    offset = graphAxisFontSize;
                }
                if (resets != prevReset) {
                    this.g2.setColor(this.graphTextColor);
                    if (!this.graphFrame.showUTCtime && resets != -999) {
                        this.g2.drawString("" + resets, timepos + this.sideBorder + 2, zeroPoint + 1 * graphAxisFontSize + offset);
                    }
                }
                this.g2.setColor(this.graphTextColor);
                if (!this.graphFrame.hideUptime && uptime != -999L) {
                    this.g2.drawString(s, timepos + this.sideBorder + 2, zeroPoint + graphAxisFontSize);
                }
                if (this.graphFrame.showUTCtime) {
                    this.g2.drawString(this.sat.getUtcTimeForReset(resets, uptime), timepos + this.sideBorder + 2, zeroPoint + 1 * graphAxisFontSize + offset);
                    this.g2.drawString(this.sat.getUtcDateForReset(resets, uptime), timepos + this.sideBorder + 2, zeroPoint + 2 * graphAxisFontSize + offset);
                }
                this.g2.setColor(this.graphAxisColor);
                if (this.graphFrame.showVerticalLines) {
                    this.g2.setColor(Color.GRAY);
                    this.g.drawLine(timepos + this.sideBorder, graphHeight + this.topBorder + 5, timepos + this.sideBorder, this.topBorder);
                } else {
                    this.g.drawLine(timepos + this.sideBorder, zeroPoint - 5, timepos + this.sideBorder, zeroPoint + 5);
                }
                prevReset = resets;
            }
            ++v;
        }
    }

    private void drawGraphForSingleReset(int start, int end, int graphWidth, int graphHeight, int sideBorder, int zeroPoint, double minValue, double maxValue, double minValue2, double maxValue2, boolean drawLabels) {
        if (this.graphFrame.dspAvg) {
            if (this.graphFrame.AVG_PERIOD > this.graphData[0][0].length / 2) {
                this.graphFrame.AVG_PERIOD = this.graphData[0][0].length / 2;
            }
            double sum = 0.0;
            boolean first = true;
            this.dspData = new double[this.graphData[0][0].length];
            int i2 = this.graphFrame.AVG_PERIOD / 2;
            while (i2 < this.graphData[0][0].length - this.graphFrame.AVG_PERIOD / 2) {
                sum = 0.0;
                int j = 0;
                while (j < this.graphFrame.AVG_PERIOD) {
                    sum += this.graphData[0][2][i2 + j - this.graphFrame.AVG_PERIOD / 2];
                    ++j;
                }
                this.dspData[i2] = sum /= (double)this.graphFrame.AVG_PERIOD;
                if (first) {
                    j = 0;
                    while (j < this.graphFrame.AVG_PERIOD / 2) {
                        this.dspData[j] = sum;
                        ++j;
                    }
                    first = false;
                }
                ++i2;
            }
            int j = this.graphData[0][0].length - this.graphFrame.AVG_PERIOD;
            while (j < this.graphData[0][0].length) {
                this.dspData[j] = sum;
                ++j;
            }
        }
        double maxTimeValue = 0.0;
        double minTimeValue = 9.9E100;
        int i3 = start;
        while (i3 < end) {
            if (this.graphData[0][1][i3] >= maxTimeValue) {
                maxTimeValue = this.graphData[0][1][i3];
            }
            if (this.graphData[0][1][i3] <= minTimeValue) {
                minTimeValue = this.graphData[0][1][i3];
            }
            if (this.graphFrame.plotDerivative && i3 > 0) {
                double value = this.graphData[0][2][i3];
                double value2 = this.graphData[0][2][i3 - 1];
                this.firstDifference[i3] = 5.0 * ((value - value2) / (this.graphData[0][1][i3] - this.graphData[0][1][i3 - 1]));
            }
            ++i3;
        }
        int numberOfTimeLabels = graphWidth / labelWidth;
        if (!(!drawLabels || numberOfTimeLabels <= 0 && this.graphFrame.showContinuous || numberOfTimeLabels <= 0 && start >= this.graphData[0][0].length - 1)) {
            double[] timelabels = GraphPanel.calcAxisInterval(minTimeValue, maxTimeValue, numberOfTimeLabels, true);
            numberOfTimeLabels = timelabels.length;
            int resets = (int)this.graphData[0][0][start];
            boolean firstLabel = true;
            DecimalFormat d = new DecimalFormat("0");
            int v = 0;
            while (v < numberOfTimeLabels) {
                if (!this.maxPlottedUptimeForReset.containsKey(resets) || !((double)this.maxPlottedUptimeForReset.get(resets).longValue() > timelabels[v])) {
                    this.maxPlottedUptimeForReset.put(resets, (long)timelabels[v]);
                    int timepos = GraphPanel.getRatioPosition(minTimeValue, maxTimeValue, timelabels[v], graphWidth) + 2;
                    if (!this.graphFrame.showContinuous && numberOfTimeLabels == 1) {
                        timepos = 1;
                    }
                    if (this.graphFrame.showContinuous && timepos > 0 && graphWidth > timepos && graphWidth - timepos > labelWidth / 2 || !this.graphFrame.showContinuous && timepos > 0 && graphWidth > timepos || !this.graphFrame.showContinuous && numberOfTimeLabels == 1) {
                        String s = d.format(timelabels[v]);
                        int offset = 0;
                        if (!this.graphFrame.hideUptime) {
                            offset = graphAxisFontSize;
                        }
                        if (firstLabel) {
                            this.g2.setColor(this.graphTextColor);
                            if (!this.graphFrame.showUTCtime) {
                                this.g2.drawString("" + resets, timepos + sideBorder + 2, zeroPoint + 1 * graphAxisFontSize + offset);
                            }
                        }
                        this.g2.setColor(this.graphTextColor);
                        if (!this.graphFrame.hideUptime) {
                            this.g2.drawString(s, timepos + sideBorder + 2, zeroPoint + graphAxisFontSize);
                        }
                        if (this.graphFrame.showUTCtime) {
                            this.g2.drawString(this.sat.getUtcTimeForReset(resets, (long)timelabels[v]), timepos + sideBorder + 2, zeroPoint + 1 * graphAxisFontSize + offset);
                            this.g2.drawString(this.sat.getUtcDateForReset(resets, (long)timelabels[v]), timepos + sideBorder + 2, zeroPoint + 2 * graphAxisFontSize + offset);
                        }
                        this.g2.setColor(this.graphAxisColor);
                        if (this.graphFrame.showVerticalLines) {
                            this.g2.setColor(Color.GRAY);
                            this.g.drawLine(timepos + sideBorder, graphHeight + this.topBorder + 5, timepos + sideBorder, this.topBorder);
                        } else {
                            this.g.drawLine(timepos + sideBorder, zeroPoint - 5, timepos + sideBorder, zeroPoint + 5);
                        }
                        firstLabel = false;
                    }
                }
                ++v;
            }
        }
        int stepSize = 1;
        if (end - start > graphWidth && graphWidth != 0) {
            stepSize = Math.round((end - start) / graphWidth);
        }
        this.plotGraph(this.graphData, graphHeight, graphWidth, start, end, stepSize, sideBorder, minTimeValue, maxTimeValue, minValue, maxValue, 0, true);
        if (this.drawGraph2) {
            this.plotGraph(this.graphData2, graphHeight, graphWidth, start, end, stepSize, sideBorder, minTimeValue, maxTimeValue, minValue2, maxValue2, this.graphFrame.fieldName.length, false);
        }
    }

    private void plotGraph(double[][][] graphData, int graphHeight, int graphWidth, int start, int end, int stepSize, int sideBorder, double minTimeValue, double maxTimeValue, double minValue, double maxValue, int colorIdx, boolean plotDsp) {
        if (graphData != null) {
            int j = 0;
            while (j < graphData.length) {
                int lastx = sideBorder + 1;
                int nextx = 0;
                int lastMidPoint = 0;
                int lastx2 = sideBorder + 1;
                int lasty = graphHeight / 2;
                int lasty2 = graphHeight / 2;
                int lasty3 = graphHeight / 2;
                int x = 0;
                int x2 = 0;
                int y = 0;
                int y2 = 0;
                int y3 = 0;
                int i2 = start;
                while (i2 < end) {
                    double p = graphData[j][1][i2];
                    x = GraphPanel.getRatioPosition(minTimeValue, maxTimeValue, p, graphWidth);
                    if (i2 < end - stepSize) {
                        double q = graphData[j][1][i2 + stepSize];
                        nextx = GraphPanel.getRatioPosition(minTimeValue, maxTimeValue, q, graphWidth);
                        nextx += sideBorder;
                    } else {
                        nextx = 0;
                    }
                    this.plottedXreset[(x += sideBorder) - this.sideBorder] = (int)graphData[j][0][i2];
                    this.plottedXuptime[x - this.sideBorder] = (long)graphData[j][1][i2];
                    long up = (long)graphData[j][1][i2];
                    int res = (int)graphData[j][0][i2];
                    SatPos pos = null;
                    x2 = (x + lastx) / 2;
                    y = GraphPanel.getRatioPosition(minValue, maxValue, graphData[j][2][i2], graphHeight);
                    if (this.graphFrame.plotDerivative && plotDsp && j == 0) {
                        y2 = GraphPanel.getRatioPosition(minValue, maxValue, this.firstDifference[i2], graphHeight);
                    }
                    if (this.graphFrame.dspAvg && plotDsp && j == 0) {
                        y3 = GraphPanel.getRatioPosition(minValue, maxValue, this.dspData[i2], graphHeight);
                    }
                    y = graphHeight - y + this.topBorder;
                    y2 = graphHeight - y2 + this.topBorder;
                    y3 = graphHeight - y3 + this.topBorder;
                    if (i2 == start) {
                        lastx = x;
                        lastMidPoint = x;
                        lastx2 = x2;
                        lasty = y;
                        lasty2 = y2;
                        lasty3 = y3;
                    }
                    if (this.graphFrame.showSun) {
                        if (pos != null && pos.isEclipsed()) {
                            this.g2.setColor(new Color(204, 204, 204));
                        } else {
                            this.g2.setColor(new Color(255, 204, 0));
                        }
                        int midPoint = 0;
                        int w = 0;
                        if (nextx == 0) {
                            nextx = x;
                        }
                        midPoint = x + (nextx - x) / 2;
                        w = midPoint - lastMidPoint;
                        if (lastx == x) {
                            this.g2.fillRect(lastx, this.topBorder + 5, w, graphHeight - 5);
                        } else if (w == 0) {
                            midPoint = x;
                            this.g2.drawLine(x, this.topBorder + 5, x, graphHeight + this.topBorder - 5);
                        } else {
                            this.g2.fillRect(lastMidPoint, this.topBorder + 5, w, graphHeight - 5);
                        }
                        lastMidPoint = midPoint;
                    }
                    if (!this.graphFrame.hideMain || this.graphFrame.hideMain && plotDsp && j > 0 || this.graphFrame.hideMain && !plotDsp) {
                        this.g2.setColor(this.graphColor[j + colorIdx]);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx, lasty, x, y);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x - 1, y - 1, 2.0, 2.0));
                        }
                    }
                    if (this.graphFrame.plotDerivative && plotDsp && j == 0) {
                        this.g2.setColor(Tools.AMSAT_RED);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx2, lasty2, x2, y2);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x2, y2, 2.0, 2.0));
                        }
                    }
                    if (this.graphFrame.dspAvg && plotDsp && j == 0) {
                        this.g2.setColor(Tools.AMSAT_GREEN);
                        if (!this.graphFrame.hideLines) {
                            this.g2.drawLine(lastx, lasty3, x, y3);
                        }
                        if (!this.graphFrame.hidePoints) {
                            this.g2.draw(new Ellipse2D.Double(x, y3, 2.0, 2.0));
                        }
                    }
                    lastx = x;
                    lastx2 = x2;
                    lasty = y;
                    lasty2 = y2;
                    lasty3 = y3;
                    i2 += stepSize;
                }
                ++j;
            }
        }
    }
}

