/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.gui;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.EpochTime;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.gui.DataRecordTableModel;
import com.g0kla.telem.gui.DisplayModule;
import com.g0kla.telem.gui.Tools;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public abstract class ModuleTab
extends JPanel
implements Runnable,
FocusListener,
ActionListener,
ItemListener,
MouseListener {
    protected boolean running = false;
    protected boolean done = false;
    Spacecraft fox;
    int displayModuleFontSize = 11;
    Color textLblColor = Color.BLACK;
    Color textColor = Color.DARK_GRAY;
    protected static final String CAPTURE_DATE = " |  Captured: ";
    public static final int SHOW_LIVE = 0;
    public static final int SHOW_RANGE = 2;
    public static final int SHOW_NEXT = 1;
    public int showLatest = 0;
    public static final String LIVE_TEXT = "Live";
    public static final String RANGE_TEXT = "Range";
    public static final String NEXT_TEXT = "Next";
    public static String NOW = "now";
    public static String YESTERDAY = "yesterday";
    public static String LAUNCH = "launch";
    public String dateFormatsToolTip = "formats:YYYYMMDD HHMMSS, YYYY/MM/DD HH:MM:SS, dd MMM yy HH:mm:ss, now, yesterday, launch";
    public boolean reverse = true;
    public int MIN_SAMPLES = 1;
    public static int DEFAULT_SAMPLES = 180;
    public int SAMPLES = DEFAULT_SAMPLES;
    public static long DEFAULT_START_UPTIME = 0L;
    public static int DEFAULT_START_RESET = 0;
    public long START_UPTIME = DEFAULT_START_UPTIME;
    public int START_RESET = DEFAULT_START_RESET;
    public int END_RESET = DEFAULT_START_RESET;
    public long END_UPTIME = DEFAULT_START_UPTIME;
    public static String DEFAULT_START_UTC = NOW;
    public static String DEFAULT_END_UTC = NOW;
    public String START_UTC = DEFAULT_START_UTC;
    public String END_UTC = DEFAULT_END_UTC;
    public static final int MAX_SAMPLES = 99999;
    protected int fonth = 0;
    private JLabel lblFromUptime;
    private JTextField textFromUptime;
    JLabel lblSamplePeriod;
    protected JTextField txtSamplePeriod;
    private JLabel lblFromReset;
    private JTextField textFromReset;
    private JLabel lblToReset;
    private JLabel lblToUptime;
    private JTextField textToReset;
    private JTextField textToUptime;
    JLabel lblFromUTC;
    JLabel lblToUTC;
    JLabel lblCaptureDate;
    JLabel lblCaptureDateValue;
    public static final String FROM_RESET = "From Epoch";
    public static final String BEFORE_RESET = " before Epoch";
    public static final String FROM_UTC = "From UTC";
    public static final String BEFORE_UTC = " before UTC";
    private JTextField textFromUtc;
    private JTextField textToUtc;
    protected JCheckBox cbUTC;
    JPanel footerPanel2uptime = new JPanel();
    JPanel footerPanel2utc = new JPanel();
    public boolean showUTCtime = false;
    int satId = 0;
    protected DisplayModule[] topModules;
    protected DisplayModule[] bottomModules;
    JPanel topHalf;
    JPanel bottomHalf;
    JScrollPane scrollPane;
    JPanel bottomPanel;
    JButton btnLatest;
    protected JCheckBox showRawValues;
    JPanel centerPanel;
    int splitPaneHeight = 0;
    JSplitPane splitPane;
    public static final int DEFAULT_DIVIDER_LOCATION = 300;
    protected DataRecordTableModel recordTableModel;
    protected JTable table;
    protected ByteArrayLayout layout;
    Spacecraft sat;
    protected SatTelemStore db;
    public static final int NO_ROW_SELECTED = -1;
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
    public static final DateFormat dateFormat2 = new SimpleDateFormat("yyyyMMdd HHmmss", Locale.ENGLISH);
    public static final DateFormat dateFormat3 = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);

    public ModuleTab(ByteArrayLayout layout, Spacecraft sat, SatTelemStore db) {
        this.sat = sat;
        this.db = db;
        this.layout = layout;
        this.setLayout(new BorderLayout(0, 0));
        JLabel l = new JLabel();
        this.displayModuleFontSize = l.getFont().getSize();
        this.centerPanel = new JPanel();
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.centerPanel.setBackground(Color.DARK_GRAY);
        JPanel healthPanel = new JPanel();
        healthPanel.setLayout(new BoxLayout(healthPanel, 0));
        this.initDisplayHalves(this.centerPanel);
        this.splitPaneHeight = 300;
        this.splitPane = new JSplitPane(0, this.centerPanel, healthPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(300);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ModuleTab.this.splitPaneHeight = ModuleTab.this.splitPane.getDividerLocation();
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.addBottomFilter();
        this.lblCaptureDate = new JLabel(CAPTURE_DATE);
        this.lblCaptureDate.setBorder(new EmptyBorder(5, 2, 5, 10));
        this.lblCaptureDate.setForeground(this.textLblColor);
        this.bottomPanel.add(this.lblCaptureDate);
        if (layout != null) {
            try {
                this.analyzeModules(layout, 5);
            }
            catch (LayoutLoadException e) {
                System.err.println("FATAL - Health Tab Load Aborted: " + e.getMessage());
            }
        }
        this.addTable(healthPanel, layout);
    }

    public void displayCaptureDate(long uptime) {
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
        Date result = null;
        String reportDate = null;
        try {
            result = new Date(uptime * 1000L);
            if (this.showUTCtime) {
                df2.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                df2.setTimeZone(TimeZone.getDefault());
            }
            reportDate = df2.format(result);
        }
        catch (NumberFormatException e) {
            reportDate = "unknown";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            reportDate = "unknown";
        }
        this.lblCaptureDate.setText(CAPTURE_DATE + reportDate);
    }

    public void stopProcessing() {
        this.running = false;
    }

    public boolean isDone() {
        return this.done;
    }

    protected abstract void displayRow(int var1, int var2);

    private void addTable(JPanel centerPanel, ByteArrayLayout rt) {
        this.recordTableModel = new DataRecordTableModel(rt);
        this.table = new JTable(this.recordTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.addMouseListener(this);
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.table.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.table.getActionMap();
        actMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ModuleTab.this.table.getSelectedRow();
                if (row > 0) {
                    ModuleTab.this.displayRow(-1, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ModuleTab.this.table.getSelectedRow();
                if (row < ModuleTab.this.table.getRowCount() - 1) {
                    ModuleTab.this.displayRow(-1, row + 1);
                }
            }
        });
        centerPanel.add(this.scrollPane);
    }

    protected void addBottomFilter() {
        JPanel footerPanel = new JPanel();
        this.bottomPanel.add(footerPanel);
        footerPanel.setLayout(new BorderLayout(0, 0));
        JPanel footerPanelRight = new JPanel();
        JPanel footerPanelLeft = new JPanel();
        JPanel footerPanel1 = new JPanel();
        JPanel footerPanel2 = new JPanel();
        JPanel footerPanel3 = new JPanel();
        footerPanel.add((Component)footerPanelRight, "East");
        footerPanelRight.setLayout(new BorderLayout(0, 0));
        footerPanelRight.add((Component)footerPanel1, "West");
        footerPanelRight.add((Component)footerPanel2, "Center");
        footerPanel2.setLayout(new BorderLayout(0, 0));
        footerPanel2.add((Component)this.footerPanel2uptime, "East");
        footerPanel2.add((Component)this.footerPanel2utc, "West");
        footerPanelRight.add((Component)footerPanel3, "East");
        footerPanel.add((Component)footerPanelLeft, "West");
        footerPanelLeft.setLayout(new BoxLayout(footerPanelLeft, 0));
        this.showRawValues = new JCheckBox("Display Raw Values", false);
        this.showRawValues.setMinimumSize(new Dimension(100, this.fonth));
        footerPanelLeft.add(this.showRawValues);
        this.showRawValues.addItemListener(this);
        this.cbUTC = new JCheckBox("Display UTC Time", true);
        footerPanelLeft.add(this.cbUTC);
        this.cbUTC.addItemListener(this);
        footerPanelLeft.add(new Box.Filler(new Dimension(14, this.fonth), new Dimension(400, this.fonth), new Dimension(1600, this.fonth)));
        this.lblFromReset = new JLabel(FROM_RESET);
        this.footerPanel2uptime.add(this.lblFromReset);
        this.textFromReset = new JTextField();
        this.footerPanel2uptime.add(this.textFromReset);
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromReset.setColumns(8);
        this.textFromReset.addActionListener(this);
        this.textFromReset.addFocusListener(this);
        this.lblFromUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblFromUptime);
        this.textFromUptime = new JTextField();
        this.footerPanel2uptime.add(this.textFromUptime);
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textFromUptime.setColumns(8);
        this.textFromUptime.addActionListener(this);
        this.textFromUptime.addFocusListener(this);
        this.lblToReset = new JLabel("  to Reset");
        this.footerPanel2uptime.add(this.lblToReset);
        this.textToReset = new JTextField();
        this.footerPanel2uptime.add(this.textToReset);
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToReset.setColumns(8);
        this.textToReset.addActionListener(this);
        this.textToReset.addFocusListener(this);
        this.lblToUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblToUptime);
        this.textToUptime = new JTextField();
        this.footerPanel2uptime.add(this.textToUptime);
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        this.textToUptime.setColumns(8);
        this.textToUptime.addActionListener(this);
        this.textToUptime.addFocusListener(this);
        this.lblFromUTC = new JLabel(FROM_UTC);
        this.lblFromUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblFromUTC);
        this.textFromUtc = new JTextField();
        this.footerPanel2utc.add(this.textFromUtc);
        this.textFromUtc.setText(this.START_UTC);
        this.textFromUtc.setToolTipText(this.dateFormatsToolTip);
        this.textFromUtc.setColumns(16);
        this.textFromUtc.addActionListener(this);
        this.textFromUtc.addFocusListener(this);
        this.lblToUTC = new JLabel(" to UTC");
        this.lblToUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblToUTC);
        this.textToUtc = new JTextField();
        this.footerPanel2utc.add(this.textToUtc);
        this.textToUtc.setText(this.END_UTC);
        this.textToUtc.setColumns(16);
        this.textToUtc.setToolTipText(this.dateFormatsToolTip);
        this.textToUtc.addActionListener(this);
        this.textToUtc.addFocusListener(this);
        this.btnLatest = new JButton(LIVE_TEXT);
        this.btnLatest.setForeground(Tools.AMSAT_RED);
        this.btnLatest.setMargin(new Insets(0, 0, 0, 0));
        this.btnLatest.setToolTipText("Toggle between showing the live samples, the next samples from a date/uptime or a range of samples");
        this.btnLatest.addActionListener(this);
        footerPanel3.add(this.btnLatest);
        this.txtSamplePeriod = new JTextField();
        this.txtSamplePeriod.addActionListener(this);
        this.txtSamplePeriod.addFocusListener(this);
        this.txtSamplePeriod.setToolTipText("The number of data samples to plot.  The latest samples are returned unless a from reset/uptime is specified");
        footerPanel3.add(this.txtSamplePeriod);
        this.lblSamplePeriod = new JLabel("samples");
        footerPanel3.add(this.lblSamplePeriod);
        this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        this.txtSamplePeriod.setColumns(6);
        this.showRangeSearch(0);
        this.showUTCtime = true;
        this.showUptimeQuery(!this.showUTCtime);
    }

    protected void initDisplayHalves(JPanel centerPanel) {
        this.topHalf = new JPanel();
        this.topHalf.setBackground(Color.DARK_GRAY);
        centerPanel.add(this.topHalf);
    }

    protected void analyzeModules(ByteArrayLayout rt, int moduleType) throws LayoutLoadException {
        String[] topModuleNames = new String[20];
        int[] topModuleLines = new int[20];
        String[] bottomModuleNames = new String[10];
        int[] bottomModuleLines = new int[10];
        int numOfTopModules = 1;
        int numOfBottomModules = 0;
        int i2 = 0;
        while (i2 < rt.NUMBER_OF_FIELDS) {
            if (!rt.module[i2].equalsIgnoreCase("NONE")) {
                if (!this.containedIn(topModuleNames, rt.module[i2])) {
                    topModuleNames[rt.moduleNum[i2]] = rt.module[i2];
                    ++numOfTopModules;
                }
                int n = rt.moduleNum[i2];
                topModuleLines[n] = topModuleLines[n] + 1;
            }
            ++i2;
        }
        this.topModules = new DisplayModule[numOfTopModules];
        if (numOfBottomModules > 0) {
            this.bottomModules = new DisplayModule[numOfBottomModules];
        }
        i2 = 1;
        while (i2 < numOfTopModules) {
            this.topModules[i2] = new DisplayModule(rt, topModuleNames[i2], topModuleLines[i2] + 1, moduleType, this.displayModuleFontSize, this.sat, this.db);
            this.addModuleLines(this.topModules[i2], topModuleNames[i2], topModuleLines[i2], rt);
            this.topHalf.add(this.topModules[i2]);
            ++i2;
        }
        i2 = 1;
        while (i2 < numOfBottomModules) {
            this.bottomModules[i2] = new DisplayModule(rt, bottomModuleNames[i2], bottomModuleLines[i2] + 1, moduleType, this.displayModuleFontSize, this.sat, this.db);
            this.addModuleLines(this.bottomModules[i2], bottomModuleNames[i2], bottomModuleLines[i2], rt);
            this.bottomHalf.add(this.bottomModules[i2]);
            ++i2;
        }
    }

    private void addModuleLines(DisplayModule displayModule, String topModuleName, int topModuleLine, ByteArrayLayout rt) throws LayoutLoadException {
        int j = 0;
        while (j < rt.NUMBER_OF_FIELDS) {
            if (rt.module[j].equals(topModuleName)) {
                if (rt.moduleLinePosition[j] > topModuleLine) {
                    throw new LayoutLoadException("Found error in Layout File: " + rt.fileName + " field: " + j + ".\nModule: " + topModuleName + " has " + topModuleLine + " lines, so we can not add " + rt.shortName[j] + " on line " + rt.moduleLinePosition[j]);
                }
                try {
                    displayModule.addName(rt.moduleLinePosition[j], String.valueOf(rt.shortName[j]) + this.formatUnits(rt.fieldUnits[j]), rt.fieldName[j], rt.description[j], rt.moduleDisplayType[j]);
                }
                catch (NullPointerException e) {
                    throw new LayoutLoadException("Found NULL item error in Layout File: " + rt.fileName + ".\nModule: " + topModuleName + " has " + topModuleLine + " lines, but error adding " + rt.shortName[j] + " on line " + rt.moduleLinePosition[j]);
                }
            }
            ++j;
        }
    }

    private String formatUnits(String unit) {
        if (unit.equals("-") || unit.equalsIgnoreCase("NONE")) {
            return "";
        }
        unit = " (" + unit + ")";
        return unit;
    }

    private boolean containedIn(String[] array, String item) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void showGraphs() {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.showGraphs();
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.showGraphs();
                }
                ++n;
            }
        }
    }

    public void closeGraphs() {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.closeGraphs();
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.closeGraphs();
                }
                ++n;
            }
        }
    }

    public void openGraphs(int payloadType) {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.openGraphs(payloadType);
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.openGraphs(payloadType);
                }
                ++n;
            }
        }
    }

    private void showRangeSearch(int showLive) {
        boolean show = false;
        if (showLive == 2) {
            this.btnLatest.setText(RANGE_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            show = true;
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
            this.lblToUTC.setVisible(show);
            this.reverse = false;
        }
        if (showLive == 0) {
            this.lblFromUTC.setText(BEFORE_UTC);
            this.lblFromReset.setText(BEFORE_RESET);
            this.btnLatest.setText(LIVE_TEXT);
            this.btnLatest.setForeground(Tools.AMSAT_RED);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
            this.reverse = true;
        }
        if (showLive == 1) {
            this.btnLatest.setText(NEXT_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(!show);
            this.textFromReset.setVisible(!show);
            this.lblFromUptime.setVisible(!show);
            this.textFromUptime.setVisible(!show);
            this.textFromUtc.setVisible(!show);
            this.lblFromUTC.setVisible(!show);
            this.reverse = false;
        }
        this.lblToReset.setVisible(show);
        this.textToReset.setVisible(show);
        this.lblToUptime.setVisible(show);
        this.textToUptime.setVisible(show);
        this.txtSamplePeriod.setEnabled(!show);
        this.lblToUTC.setVisible(show);
        this.textToUtc.setVisible(show);
    }

    protected void showUptimeQuery(boolean up) {
        if (up) {
            this.footerPanel2uptime.setVisible(true);
            this.footerPanel2utc.setVisible(false);
        } else {
            this.footerPanel2uptime.setVisible(false);
            this.footerPanel2utc.setVisible(true);
        }
    }

    private Date parseDate(String strDate) {
        Date date = null;
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            try {
                date = dateFormat2.parse(strDate);
            }
            catch (ParseException e2) {
                try {
                    date = dateFormat3.parse(strDate);
                }
                catch (ParseException e3) {
                    date = null;
                }
            }
        }
        return date;
    }

    private EpochTime parseUTCField(JTextField field, String strDate) {
        return null;
    }

    protected void parseUTCFields() {
        EpochTime foxTime2;
        String strDate = this.textFromUtc.getText();
        EpochTime foxTime = this.parseUTCField(this.textFromUtc, strDate);
        if (foxTime != null) {
            this.START_RESET = foxTime.getReset();
            this.START_UPTIME = foxTime.getUptime();
        }
        if ((foxTime2 = this.parseUTCField(this.textToUtc, strDate = this.textToUtc.getText())) != null) {
            this.END_RESET = foxTime2.getReset();
            this.END_UPTIME = foxTime2.getUptime();
        }
    }

    protected void parseTextFields() {
        block15: {
            String text;
            block14: {
                block13: {
                    block12: {
                        text = this.textFromReset.getText();
                        try {
                            this.START_RESET = Integer.parseInt(text);
                            if (this.START_RESET < 0) {
                                this.START_RESET = 0;
                            }
                        }
                        catch (NumberFormatException ex) {
                            if (!text.equals("")) break block12;
                            this.START_RESET = DEFAULT_START_RESET;
                        }
                    }
                    text = this.textFromUptime.getText();
                    try {
                        this.START_UPTIME = Integer.parseInt(text);
                        if (this.START_UPTIME < 0L) {
                            this.START_UPTIME = 0L;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (!text.equals("")) break block13;
                        this.START_UPTIME = DEFAULT_START_UPTIME;
                    }
                }
                text = this.textToReset.getText();
                try {
                    this.END_RESET = Integer.parseInt(text);
                    if (this.END_RESET < 0) {
                        this.END_RESET = 0;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!text.equals("")) break block14;
                    this.END_RESET = DEFAULT_START_RESET;
                }
            }
            text = this.textToUptime.getText();
            try {
                this.END_UPTIME = Integer.parseInt(text);
                if (this.END_UPTIME < 0L) {
                    this.END_UPTIME = 0L;
                }
            }
            catch (NumberFormatException ex) {
                if (!text.equals("")) break block15;
                this.END_UPTIME = DEFAULT_START_UPTIME;
            }
        }
    }

    private void convertToUtc() {
        Date date2;
        this.parseTextFields();
        Date date = this.fox.getUtcForReset(this.START_RESET, this.START_UPTIME);
        if (date != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(date);
            this.textFromUtc.setText(time);
            this.START_UTC = time;
            this.textFromUtc.setText(time);
        }
        if ((date2 = this.fox.getUtcForReset(this.END_RESET, this.END_UPTIME)) != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time2 = dateFormat2.format(date2);
            this.textToUtc.setText(time2);
            this.END_UTC = time2;
            this.textToUtc.setText(time2);
        }
        if (this.showLatest == 2) {
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    private void convertToUptime() {
        this.parseUTCFields();
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        if (this.showLatest == 2) {
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    private void parseFields() {
        String text = null;
        if (this.showUTCtime) {
            this.convertToUptime();
        } else {
            this.convertToUtc();
        }
        text = this.txtSamplePeriod.getText();
        try {
            this.SAMPLES = Integer.parseInt(text);
            if (this.SAMPLES > 99999) {
                this.SAMPLES = 99999;
                text = Integer.toString(99999);
                this.txtSamplePeriod.setText(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.parseFrames();
    }

    public abstract void parseFrames();

    protected void parseTelemetry(String[][] data) {
        long[][] packetData = new long[data.length][data[0].length];
        int i2 = 0;
        while (i2 < data.length) {
            packetData[data.length - i2 - 1][0] = Long.parseLong(data[i2][0]);
            packetData[data.length - i2 - 1][1] = Long.parseLong(data[i2][1]);
            int j = 2;
            while (j < data[0].length) {
                if (data[i2][j] != null) {
                    packetData[data.length - i2 - 1][j] = this.showRawValues.isSelected() ? Long.parseLong(data[i2][j]) : Long.parseLong(data[i2][j]);
                }
                ++j;
            }
            ++i2;
        }
        if (data.length > 0) {
            this.recordTableModel.setData(packetData);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.txtSamplePeriod) {
            this.parseFields();
        } else if (e.getSource() == this.textFromReset) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textToReset) {
            this.parseFields();
        } else if (e.getSource() == this.textToUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUtc) {
            this.parseFields();
        } else if (e.getSource() == this.textToUtc) {
            this.parseFields();
        } else if (e.getSource() == this.btnLatest) {
            ++this.showLatest;
            if (this.showLatest > 2) {
                this.showLatest = 0;
            }
            this.showRangeSearch(this.showLatest);
            this.parseFrames();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbUTC) {
            boolean bl = this.showUTCtime = !this.showUTCtime;
            if (this.showUTCtime) {
                this.parseTextFields();
                if (this.SAMPLES > 99999) {
                    this.SAMPLES = 99999;
                }
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            } else {
                this.parseUTCFields();
                if (this.SAMPLES > 99999) {
                    this.SAMPLES = 99999;
                }
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            }
            this.showUptimeQuery(!this.showUTCtime);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() != this.txtSamplePeriod && e.getSource() != this.textFromReset) {
            e.getSource();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int fromRow = -1;
        int row = this.table.rowAtPoint(e.getPoint());
        int col = this.table.columnAtPoint(e.getPoint());
        if (e.isShiftDown()) {
            fromRow = this.table.getSelectedRow();
            int n = this.table.getSelectedRowCount();
            if (row == fromRow) {
                fromRow = fromRow + n - 1;
            }
        }
        if (row >= 0 && col >= 0) {
            this.displayRow(fromRow, row);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

