/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.predict;

import com.g0kla.telem.predict.SortedTleList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import uk.me.g4dpz.satellite.TLE;

public class FoxTLE
extends TLE
implements Comparable<FoxTLE> {
    String[] tleText = new String[3];

    public FoxTLE(String[] tle) throws IllegalArgumentException, StringIndexOutOfBoundsException, NumberFormatException {
        super(tle);
        int i2 = 0;
        while (i2 < 3) {
            this.tleText[i2] = new String(tle[i2]);
            ++i2;
        }
        Date today = Calendar.getInstance().getTime();
        this.setCreateddate(today);
    }

    public FoxTLE(TLE tle) throws IllegalArgumentException {
        super(tle);
        Date today = Calendar.getInstance().getTime();
        this.setCreateddate(today);
    }

    public static SortedTleList importFoxSat(InputStream fileIS) throws IOException {
        String readString;
        SortedTleList importedSats = new SortedTleList(10);
        BufferedReader buf = new BufferedReader(new InputStreamReader(fileIS));
        int j = 0;
        String[] lines = new String[3];
        block4: while ((readString = buf.readLine()) != null) {
            switch (j) {
                case 0: 
                case 1: {
                    lines[j] = readString;
                    ++j;
                    break;
                }
                case 2: {
                    lines[j] = readString;
                    j = 0;
                    if (lines[0].isEmpty() || lines[1].isEmpty() || lines[2].isEmpty()) continue block4;
                    importedSats.add(new FoxTLE(lines));
                    break;
                }
            }
        }
        return importedSats;
    }

    public String toFileString() {
        String s = "";
        s = String.valueOf(s) + this.tleText[0] + "\n";
        s = String.valueOf(s) + this.tleText[1] + "\n";
        s = String.valueOf(s) + this.tleText[2] + "\n";
        return s;
    }

    @Override
    public int compareTo(FoxTLE p) {
        if (this.getName().equalsIgnoreCase(p.getName()) && this.getEpoch() == p.getEpoch()) {
            return 0;
        }
        if (this.getEpoch() < p.getEpoch()) {
            return -1;
        }
        if (this.getEpoch() > p.getEpoch()) {
            return 1;
        }
        return 1;
    }
}

