/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.server.STP;
import com.g0kla.telem.server.StpFileProcessException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SatDbStore {
    public static final String ERR_TABLE_DOES_NOT_EXIST = "42S02";
    public static final String ERR_DUPLICATE = "23000";
    public static final String ERR_OPEN_RESULT_SET = "X0X95";
    public Connection conn;
    static String url = "jdbc:mysql://localhost:3306/";
    static String db = "FOXDB";
    static String user = "g0kla";
    static String password = "";

    public SatDbStore(String u, String pw, String database) throws SQLException {
        db = database;
        user = u;
        password = pw;
        Statement st = null;
        ResultSet rs = null;
        try {
            this.conn = this.getConnection();
            st = this.conn.createStatement();
            rs = st.executeQuery("SELECT VERSION()");
            rs.next();
            this.initStpHeaderTable();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null || !this.conn.isValid(2)) {
            this.conn = DriverManager.getConnection(String.valueOf(url) + db + "?autoReconnect=true", user, password);
        }
        return this.conn;
    }

    public void closeConnection() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private void initStpHeaderTable() throws SQLException {
        String table = "STP_HEADER";
        Statement stmt = null;
        ResultSet select = null;
        try {
            try {
                this.conn = this.getConnection();
                stmt = this.conn.createStatement();
                select = stmt.executeQuery("select 1 from " + table + " LIMIT 1");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_TABLE_DOES_NOT_EXIST)) {
                    String createString = "CREATE TABLE " + table + " ";
                    createString = String.valueOf(createString) + STP.getTableCreateStmt();
                    try {
                        stmt.execute(createString);
                    }
                    catch (SQLException ex) {
                        throw new SQLException("initStpHeaderTable", ex);
                    }
                } else {
                    throw new SQLException("initStpHeaderTable", e);
                }
                try {
                    if (select != null) {
                        select.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (select != null) {
                    select.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public boolean addStpHeader(STP f) throws SQLException {
        Statement ps = null;
        try {
            try {
                this.conn = this.getConnection();
                ps = f.getPreparedInsertStmt(this.conn);
                int n = ps.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_DUPLICATE)) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return true;
                }
                throw new SQLException("addStpHeader", e);
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    public boolean updateStpHeader(STP f) throws StpFileProcessException, SQLException {
        Statement stmt = null;
        String update = "update STP_HEADER ";
        update = String.valueOf(update) + "set rx_location='" + f.rx_location + "', ";
        update = String.valueOf(update) + "receiver_rf='" + f.receiver_rf + "' ";
        update = String.valueOf(update) + " where receiver='" + f.receiver + "' ";
        update = String.valueOf(update) + " and sequenceNumber=" + f.sequenceNumber;
        update = String.valueOf(update) + " and resets=" + f.resets;
        update = String.valueOf(update) + " and uptime=" + f.uptime;
        update = String.valueOf(update) + " and id=" + f.id;
        try {
            try {
                this.conn = this.getConnection();
                stmt = this.conn.createStatement();
                int r = stmt.executeUpdate(update);
                if (r > 1) {
                    throw new StpFileProcessException("FOXDB", "MULTIPLE ROWS UPDATED!");
                }
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_DUPLICATE)) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return true;
                }
                throw new SQLException("updateStpHeader", e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    public static String errorPrint(String cause, Throwable e) {
        if (e instanceof SQLException) {
            return SatDbStore.SQLExceptionPrint(cause, (SQLException)e);
        }
        return "ERROR: " + cause + " A NON SQLException error occured while accessing the DB";
    }

    static String SQLExceptionPrint(String cause, SQLException sqle) {
        String s = "";
        while (sqle != null) {
            s = String.valueOf(s) + "\n---SQLException Caught--- Caused by: " + cause + "\n";
            s = String.valueOf(s) + "SQLState: " + sqle.getSQLState();
            s = String.valueOf(s) + "Severity: " + sqle.getErrorCode();
            s = String.valueOf(s) + "Message: " + sqle.getMessage();
            sqle = sqle.getNextException();
        }
        return s;
    }
}

