/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.data.ByteArrayLayout;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.segDb.DataTable;
import java.io.File;
import java.io.IOException;

public class SatTelemStore {
    String dbDir;
    DataTable[] records;
    ByteArrayLayout[] layouts;
    private static final int INIT_SIZE = 1000;
    private static final int ERROR_IDX = -999;

    public SatTelemStore(int id, String dbDir, ByteArrayLayout[] layouts) throws IOException, LayoutLoadException {
        this.dbDir = dbDir;
        this.makeDir(dbDir);
        this.layouts = layouts;
        this.records = new DataTable[layouts.length];
        int i2 = 0;
        while (i2 < layouts.length) {
            this.records[i2] = new DataTable(1000, dbDir, layouts[i2], layouts[i2].name);
            ++i2;
        }
    }

    private boolean makeDir(String dir) throws LayoutLoadException {
        File aFile = new File(dir);
        if (!aFile.isDirectory()) {
            aFile.mkdir();
            if (!aFile.isDirectory()) {
                throw new LayoutLoadException("ERROR can't create the directory: " + aFile.getAbsolutePath() + "\nAny decoded payloads will not be saved to disk\n");
            }
            return true;
        }
        return false;
    }

    public int getLayoutIdxByName(String name) {
        int i2 = 0;
        while (i2 < this.layouts.length) {
            if (this.layouts[i2].name.equalsIgnoreCase(name)) {
                return i2;
            }
            ++i2;
        }
        return -999;
    }

    public ByteArrayLayout getLayoutByName(String name) {
        int i2 = 0;
        while (i2 < this.layouts.length) {
            if (this.layouts[i2].name.equalsIgnoreCase(name)) {
                return this.layouts[i2];
            }
            ++i2;
        }
        return null;
    }

    public boolean add(DataRecord f) throws IOException, NumberFormatException, DataLoadException {
        boolean ret = false;
        int i2 = this.getLayoutIdxByName(f.layout.name);
        if (i2 != -999) {
            ret = this.records[i2].save(f);
        }
        return ret;
    }

    public void setUpdatedAll() {
        int i2 = 0;
        while (i2 < this.layouts.length) {
            this.records[i2].setUpdated(true);
            ++i2;
        }
    }

    public boolean getUpdated(String layout) {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            return this.records[i2].getUpdated();
        }
        return false;
    }

    public void setUpdated(String layout, boolean u) {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            this.records[i2].setUpdated(u);
        }
    }

    public int getNumberOfFrames() {
        int total = 0;
        int i2 = 0;
        while (i2 < this.records.length) {
            total += this.records[i2].getSize();
            ++i2;
        }
        return total;
    }

    public int getNumberOfFrames(String layout) {
        int i2 = 0;
        while (i2 < this.layouts.length) {
            if (this.layouts[i2].name.equalsIgnoreCase(layout)) {
                return this.records[i2].getSize();
            }
            ++i2;
        }
        return 0;
    }

    public DataRecord getLatest(int id, int reset, long uptime, int type, String layout, boolean prev) throws IOException, NumberFormatException, DataLoadException {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            return this.records[i2].getFrame(id, uptime, reset, type, prev);
        }
        return null;
    }

    public DataRecord getLatest(String layout) throws IOException, NumberFormatException, DataLoadException {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            return this.records[i2].getLatest();
        }
        return null;
    }

    public double[][] getGraphData(String name, int period, int id, int fromReset, long fromUptime, String layout, boolean raw, boolean positionData, boolean reverse) throws IOException, NumberFormatException, DataLoadException {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            return this.records[i2].getGraphData(name, period, id, fromReset, fromUptime, raw, positionData, reverse);
        }
        return null;
    }

    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean returnType, boolean reverse, String layout) throws IOException, NumberFormatException, LayoutLoadException, DataLoadException {
        int i2 = this.getLayoutIdxByName(layout);
        if (i2 != -999) {
            return this.records[i2].getPayloadData(period, id, fromReset, fromUptime, this.layouts[i2].fieldName.length, returnType, reverse);
        }
        return null;
    }
}

