/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.segDb;

import com.g0kla.telem.gui.ProgressPanel;
import com.g0kla.telem.predict.FoxTLE;
import com.g0kla.telem.predict.SortedTleList;
import com.g0kla.telem.segDb.DataTable;
import com.g0kla.telem.segDb.Spacecraft;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Date;

public class SatelliteManager
implements Runnable {
    public static final String AMSAT_NASA_ALL = "http://lansing182.amsat.org/tle/current/nasabare.txt";
    public boolean updated = true;
    boolean server = false;
    public ArrayList<Spacecraft> spacecraftList = new ArrayList();
    boolean running = true;
    boolean done = false;

    public SatelliteManager(boolean server, String logSpacecraftDir) throws IOException {
    }

    public boolean add(Spacecraft sat) {
        return this.spacecraftList.add(sat);
    }

    public boolean haveSpacecraft(String name) {
        int i2 = 0;
        while (i2 < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i2).name.equalsIgnoreCase(name)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Spacecraft getSpacecraftByName(String name) {
        int i2 = 0;
        while (i2 < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i2).name.equalsIgnoreCase(name)) {
                return this.spacecraftList.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public Spacecraft getSpacecraft(int sat) {
        int i2 = 0;
        while (i2 < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i2).satId == sat) {
                return this.spacecraftList.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public void fetchTLEFile(String logSpacecraftDir) throws IOException {
        String urlString = AMSAT_NASA_ALL;
        String file = String.valueOf(logSpacecraftDir) + File.separator + "nasabare.txt";
        String filetmp = String.valueOf(file) + ".tmp";
        File f1 = new File(filetmp);
        File f2 = new File(file);
        Date lm = new Date(f2.lastModified());
        String msg = "Downloading new keps ...                 ";
        ProgressPanel initProgress = null;
        FileOutputStream fos = null;
        Channel rbc = null;
        try {
            URL website = new URL(urlString);
            HttpURLConnection httpCon = (HttpURLConnection)website.openConnection();
            long date = httpCon.getLastModified();
            httpCon.disconnect();
            Date kepsDate = new Date(date);
            if (kepsDate.getTime() <= lm.getTime()) {
                filetmp = file;
            } else {
                rbc = Channels.newChannel(website.openStream());
                fos = new FileOutputStream(filetmp);
                fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
                fos.close();
                rbc.close();
            }
            this.parseTleFile(filetmp);
            if (!file.equalsIgnoreCase(filetmp)) {
                DataTable.remove(file);
                DataTable.copyFile(f1, f2);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!file.equalsIgnoreCase(filetmp)) {
                DataTable.remove(String.valueOf(file) + ".tmp");
            }
            return;
        }
        catch (MalformedURLException e) {
            try {
                DataTable.remove(String.valueOf(file) + ".tmp");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new MalformedURLException("Invalid location for Keps file: " + file);
        }
        catch (IOException e) {
            try {
                DataTable.remove(String.valueOf(file) + ".tmp");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new IOException("Could not fetch Keps file and write it to:\n" + file);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                DataTable.remove(String.valueOf(file) + ".tmp");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new IndexOutOfBoundsException("Keps file is corrupt: " + file);
        }
        finally {
            if (!this.server && initProgress != null) {
                initProgress.updateProgress(100);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                if (rbc != null) {
                    rbc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private SortedTleList parseTleFile(String filename) throws IOException {
        File f = new File(filename);
        try (FileInputStream is = new FileInputStream(f);){
            SortedTleList tles = FoxTLE.importFoxSat(is);
            ((InputStream)is).close();
            for (FoxTLE ftle : tles) {
                String name = ftle.getName();
                Spacecraft spacecraft = this.getSpacecraftByName(name);
                if (spacecraft == null) continue;
                spacecraft.addTLE(ftle);
            }
            SortedTleList sortedTleList = tles;
            return sortedTleList;
        }
    }

    public void stop() {
        this.running = false;
        while (!this.done) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.done = true;
    }
}

